<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models;

interface ModelInterface
{
    /**
     * Create model instance from API response data
     */
    public static function fromArray(array $data): static;

    /**
     * Convert model to array
     */
    public function toArray(): array;

    /**
     * Get raw response data
     */
    public function getRawData(): array;

    /**
     * Get the Salesforce SObject type name
     * By default, returns the short class name (e.g., "Account", "Contact")
     * Override this method if the SObject type differs from the class name
     */
    public static function getSObjectType(): string;
}
