<?php

declare(strict_types=1);

namespace SalesforceRestApi\Exceptions;

use Psr\Http\Message\ResponseInterface;

class ApiException extends SalesforceException
{
    public function __construct(
        string $message,
        private readonly ?ResponseInterface $response = null,
        private readonly ?array $errorData = null,
        int $code = 0,
        ?\Throwable $previous = null
    ) {
        parent::__construct($message, $code, $previous);
    }

    public function getResponse(): ?ResponseInterface
    {
        return $this->response;
    }

    public function getErrorData(): ?array
    {
        return $this->errorData;
    }
}
