<?php

declare(strict_types=1);

require_once __DIR__ . '/../vendor/autoload.php';

use SalesforceRestApi\Salesforce;
use SalesforceRestApi\Models\Standard\Account;

// Initialize with username/password authentication
$salesforce = Salesforce::withPassword(
    clientId: 'your_client_id',
    clientSecret: 'your_client_secret',
    username: 'your_username@example.com',
    password: 'your_password',
    securityToken: 'your_security_token' // Optional if IP is whitelisted
);

// Create a new Account record using the model class
$accountResource = $salesforce->sobject(Account::class);
$result = $accountResource->createFromArray([
    'Name' => 'Acme Corporation',
    'Industry' => 'Technology',
    'Phone' => '555-1234',
]);

echo "Created Account with ID: " . $result['id'] . "\n";

// Alternative: Create using a model object (recommended for type safety)
$newAccount = new Account();
$newAccount->name = 'Tech Innovations Inc';
$newAccount->industry = 'Technology';
$newAccount->phone = '555-9999';
$newAccount->website = 'https://techinnovations.example';
$newAccount->annualRevenue = 5000000.00;

$modelResult = $accountResource->create($newAccount);
echo "Created Account from model with ID: " . $modelResult['id'] . "\n\n";

// Read the account with type-safe model
$accountRecord = $accountResource->get($result['id'], Account::class);
echo "Account Name: " . $accountRecord->name . "\n";
echo "Industry: " . $accountRecord->industry . "\n";

// Update the account
$accountResource->update($result['id'], [
    'Phone' => '555-5678',
]);

echo "Updated Account phone number\n";

// Query accounts with typed models
$queryResult = $salesforce->query()->execute(
    "SELECT Id, Name, Industry FROM Account WHERE Industry = 'Technology'",
    Account::class
);

echo "Found {$queryResult->getTotalSize()} accounts\n";

foreach ($queryResult->getRecords() as $account) {
    echo "- {$account->name} (ID: {$account->id})\n";
}

// Delete the accounts
$accountResource->delete($result['id']);
echo "Deleted first Account\n";

$accountResource->delete($modelResult['id']);
echo "Deleted second Account\n";
