<?php

declare(strict_types=1);

require_once __DIR__ . '/../vendor/autoload.php';

use SalesforceRestApi\Salesforce;
use SalesforceRestApi\Auth\OAuthClient;
use GuzzleHttp\Client;

// Method 1: Username/Password Flow
$sf1 = Salesforce::withPassword(
    clientId: 'your_client_id',
    clientSecret: 'your_client_secret',
    username: 'your_username@example.com',
    password: 'your_password',
    securityToken: 'your_security_token'
);

// Method 2: Client Credentials Flow
$sf2 = Salesforce::withClientCredentials(
    clientId: 'your_client_id',
    clientSecret: 'your_client_secret'
);

// Method 3: Using existing access token
$sf3 = Salesforce::withAccessToken([
    'access_token' => 'your_access_token',
    'instance_url' => 'https://yourinstance.salesforce.com',
    'token_type' => 'Bearer',
]);

// Method 4: Manual authentication with token refresh
$httpClient = new Client();
$oauthClient = new OAuthClient($httpClient, 'https://login.salesforce.com');

// Get initial token
$accessToken = $oauthClient->authenticateWithPassword(
    'your_client_id',
    'your_client_secret',
    'your_username@example.com',
    'your_password',
    'your_security_token'
);

// Save refresh token for later use
$refreshToken = $accessToken->getRefreshToken();
file_put_contents('refresh_token.txt', $refreshToken);

// Create Salesforce instance
$sf4 = new Salesforce($accessToken);

// Later, refresh the token
$refreshToken = file_get_contents('refresh_token.txt');
$newAccessToken = $oauthClient->refreshToken(
    'your_client_id',
    'your_client_secret',
    $refreshToken
);

$sf5 = new Salesforce($newAccessToken);

// Method 5: For sandbox environment
$sfSandbox = Salesforce::withPassword(
    clientId: 'your_client_id',
    clientSecret: 'your_client_secret',
    username: 'your_username@example.com.sandbox',
    password: 'your_password',
    securityToken: 'your_security_token',
    loginUrl: 'https://test.salesforce.com' // Sandbox URL
);

echo "All authentication methods demonstrated\n";
