<?php

declare(strict_types=1);

require_once __DIR__ . '/../vendor/autoload.php';

use SalesforceRestApi\Salesforce;
use SalesforceRestApi\Models\Standard\Account;
use SalesforceRestApi\Models\Standard\Contact;
use SalesforceRestApi\Models\Standard\Opportunity;

$salesforce = Salesforce::withPassword(
    clientId: 'your_client_id',
    clientSecret: 'your_client_secret',
    username: 'your_username@example.com',
    password: 'your_password'
);

// Simple query with typed model
$result = $salesforce->query()->execute(
    "SELECT Id, Name, Email FROM Contact WHERE LastName = 'Smith'",
    Contact::class
);

echo "Found {$result->getTotalSize()} contacts\n";

foreach ($result->getRecords() as $contact) {
    echo "  - {$contact->name} ({$contact->email})\n";
}

// Query with pagination - get all results automatically
$allResults = $salesforce->query()->all(
    "SELECT Id, Name, Amount FROM Opportunity WHERE Amount > 10000",
    Opportunity::class
);

$totalRecords = 0;
foreach ($allResults as $batchResult) {
    $totalRecords += count($batchResult->getRecords());
    foreach ($batchResult->getRecords() as $opp) {
        echo "  - {$opp->name}: \${$opp->amount}\n";
    }
}

echo "Retrieved {$totalRecords} total opportunity records across all pages\n";

// Query including deleted/archived records
$allRecords = $salesforce->query()->queryAll(
    "SELECT Id, Name, IsDeleted FROM Account WHERE Name LIKE 'Test%'",
    Account::class
);

echo "Including deleted: {$allRecords->getTotalSize()} accounts\n";

// SOSL Search
$searchResult = $salesforce->search()->execute(
    "FIND {John} IN NAME FIELDS RETURNING Contact(Id, Name, Email), Lead(Id, Name, Email)"
);

echo "Search results:\n";
print_r($searchResult);

// Describe global - list all SObjects
$global = $salesforce->describeGlobal();
echo "\nAvailable SObjects: " . count($global['sobjects']) . "\n";

// Describe specific object using model class
$accountMetadata = $salesforce->sobject(Account::class)->describe();
echo "Account has " . count($accountMetadata['fields']) . " fields\n";
