<?php
/**
 * TaxRate
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * TaxRate Class Doc Comment
 *
 * @category Class
 * @description Updates a Tax Rate (US only)
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TaxRate implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TaxRate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Base',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'name' => 'string',
        'agency' => 'string',
        'percentage' => 'double',
        'percentages' => '\SageOne\Model\TaxRatePercentage[]',
        'is_visible' => 'bool',
        'retailer' => 'bool',
        'editable' => 'bool',
        'deletable' => 'bool',
        'is_combined_rate' => 'bool',
        'component_tax_rates' => '\SageOne\Model\ComponentTaxRate[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'name' => null,
        'agency' => null,
        'percentage' => 'double',
        'percentages' => null,
        'is_visible' => null,
        'retailer' => null,
        'editable' => null,
        'deletable' => null,
        'is_combined_rate' => null,
        'component_tax_rates' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'name' => 'name',
        'agency' => 'agency',
        'percentage' => 'percentage',
        'percentages' => 'percentages',
        'is_visible' => 'is_visible',
        'retailer' => 'retailer',
        'editable' => 'editable',
        'deletable' => 'deletable',
        'is_combined_rate' => 'is_combined_rate',
        'component_tax_rates' => 'component_tax_rates'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'name' => 'setName',
        'agency' => 'setAgency',
        'percentage' => 'setPercentage',
        'percentages' => 'setPercentages',
        'is_visible' => 'setIsVisible',
        'retailer' => 'setRetailer',
        'editable' => 'setEditable',
        'deletable' => 'setDeletable',
        'is_combined_rate' => 'setIsCombinedRate',
        'component_tax_rates' => 'setComponentTaxRates'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'name' => 'getName',
        'agency' => 'getAgency',
        'percentage' => 'getPercentage',
        'percentages' => 'getPercentages',
        'is_visible' => 'getIsVisible',
        'retailer' => 'getRetailer',
        'editable' => 'getEditable',
        'deletable' => 'getDeletable',
        'is_combined_rate' => 'getIsCombinedRate',
        'component_tax_rates' => 'getComponentTaxRates'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['agency'] = $data['agency'] ?? null;
        $this->container['percentage'] = $data['percentage'] ?? null;
        $this->container['percentages'] = $data['percentages'] ?? null;
        $this->container['is_visible'] = $data['is_visible'] ?? null;
        $this->container['retailer'] = $data['retailer'] ?? null;
        $this->container['editable'] = $data['editable'] ?? null;
        $this->container['deletable'] = $data['deletable'] ?? null;
        $this->container['is_combined_rate'] = $data['is_combined_rate'] ?? null;
        $this->container['component_tax_rates'] = $data['component_tax_rates'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Base|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the tax rate
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets agency
     *
     * @return string|null
     */
    public function getAgency()
    {
        return $this->container['agency'];
    }

    /**
     * Sets agency
     *
     * @param string|null $agency The agency name (US Only)
     *
     * @return self
     */
    public function setAgency($agency)
    {
        $this->container['agency'] = $agency;

        return $this;
    }

    /**
     * Gets percentage
     *
     * @return double|null
     */
    public function getPercentage()
    {
        return $this->container['percentage'];
    }

    /**
     * Sets percentage
     *
     * @param double|null $percentage The current tax rate percentage
     *
     * @return self
     */
    public function setPercentage($percentage)
    {
        $this->container['percentage'] = $percentage;

        return $this;
    }

    /**
     * Gets percentages
     *
     * @return \SageOne\Model\TaxRatePercentage[]|null
     */
    public function getPercentages()
    {
        return $this->container['percentages'];
    }

    /**
     * Sets percentages
     *
     * @param \SageOne\Model\TaxRatePercentage[]|null $percentages The tax rate percentage and date ranges they apply to
     *
     * @return self
     */
    public function setPercentages($percentages)
    {
        $this->container['percentages'] = $percentages;

        return $this;
    }

    /**
     * Gets is_visible
     *
     * @return bool|null
     */
    public function getIsVisible()
    {
        return $this->container['is_visible'];
    }

    /**
     * Sets is_visible
     *
     * @param bool|null $is_visible Indicates whether the tax rate is displayed in the application
     *
     * @return self
     */
    public function setIsVisible($is_visible)
    {
        $this->container['is_visible'] = $is_visible;

        return $this;
    }

    /**
     * Gets retailer
     *
     * @return bool|null
     */
    public function getRetailer()
    {
        return $this->container['retailer'];
    }

    /**
     * Sets retailer
     *
     * @param bool|null $retailer Indicates if tax rate is a retailer rate or not
     *
     * @return self
     */
    public function setRetailer($retailer)
    {
        $this->container['retailer'] = $retailer;

        return $this;
    }

    /**
     * Gets editable
     *
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->container['editable'];
    }

    /**
     * Sets editable
     *
     * @param bool|null $editable Indicates whether a tax rate can be edited
     *
     * @return self
     */
    public function setEditable($editable)
    {
        $this->container['editable'] = $editable;

        return $this;
    }

    /**
     * Gets deletable
     *
     * @return bool|null
     */
    public function getDeletable()
    {
        return $this->container['deletable'];
    }

    /**
     * Sets deletable
     *
     * @param bool|null $deletable Indicates whether a tax rate can be deleted
     *
     * @return self
     */
    public function setDeletable($deletable)
    {
        $this->container['deletable'] = $deletable;

        return $this;
    }

    /**
     * Gets is_combined_rate
     *
     * @return bool|null
     */
    public function getIsCombinedRate()
    {
        return $this->container['is_combined_rate'];
    }

    /**
     * Sets is_combined_rate
     *
     * @param bool|null $is_combined_rate Indicates whether the tax rate is made up of component tax rates
     *
     * @return self
     */
    public function setIsCombinedRate($is_combined_rate)
    {
        $this->container['is_combined_rate'] = $is_combined_rate;

        return $this;
    }

    /**
     * Gets component_tax_rates
     *
     * @return \SageOne\Model\ComponentTaxRate[]|null
     */
    public function getComponentTaxRates()
    {
        return $this->container['component_tax_rates'];
    }

    /**
     * Sets component_tax_rates
     *
     * @param \SageOne\Model\ComponentTaxRate[]|null $component_tax_rates The component tax rates which make up a combined rate
     *
     * @return self
     */
    public function setComponentTaxRates($component_tax_rates)
    {
        $this->container['component_tax_rates'] = $component_tax_rates;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


