<?php
/**
 * StockItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * StockItem Class Doc Comment
 *
 * @category Class
 * @description Updates a Stock Item
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class StockItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Base',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'deleted_at' => '\DateTime',
        'item_code' => 'string',
        'description' => 'string',
        'notes' => 'string',
        'sales_ledger_account' => '\SageOne\Model\Base',
        'sales_tax_rate' => '\SageOne\Model\Base',
        'purchase_ledger_account' => '\SageOne\Model\Base',
        'usual_supplier' => '\SageOne\Model\Contact',
        'purchase_tax_rate' => '\SageOne\Model\Base',
        'cost_price' => 'double',
        'sales_prices' => '\SageOne\Model\ProductSalesPriceType[]',
        'source_guid' => 'string',
        'purchase_description' => 'string',
        'reorder_level' => 'double',
        'reorder_quantity' => 'double',
        'location' => 'string',
        'barcode' => 'string',
        'supplier_part_number' => 'string',
        'weight' => 'double',
        'measurement_unit' => 'string',
        'weight_converted' => 'double',
        'active' => 'bool',
        'quantity_in_stock' => 'double',
        'last_cost_price' => 'double',
        'last_cost_price_stock_value' => 'double',
        'average_cost_price' => 'double',
        'average_cost_price_stock_value' => 'double',
        'cost_price_last_updated' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'deleted_at' => 'date-time',
        'item_code' => null,
        'description' => null,
        'notes' => null,
        'sales_ledger_account' => null,
        'sales_tax_rate' => null,
        'purchase_ledger_account' => null,
        'usual_supplier' => null,
        'purchase_tax_rate' => null,
        'cost_price' => 'double',
        'sales_prices' => null,
        'source_guid' => null,
        'purchase_description' => null,
        'reorder_level' => 'double',
        'reorder_quantity' => 'double',
        'location' => null,
        'barcode' => null,
        'supplier_part_number' => null,
        'weight' => 'double',
        'measurement_unit' => null,
        'weight_converted' => 'double',
        'active' => null,
        'quantity_in_stock' => 'double',
        'last_cost_price' => 'double',
        'last_cost_price_stock_value' => 'double',
        'average_cost_price' => 'double',
        'average_cost_price_stock_value' => 'double',
        'cost_price_last_updated' => 'date'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'item_code' => 'item_code',
        'description' => 'description',
        'notes' => 'notes',
        'sales_ledger_account' => 'sales_ledger_account',
        'sales_tax_rate' => 'sales_tax_rate',
        'purchase_ledger_account' => 'purchase_ledger_account',
        'usual_supplier' => 'usual_supplier',
        'purchase_tax_rate' => 'purchase_tax_rate',
        'cost_price' => 'cost_price',
        'sales_prices' => 'sales_prices',
        'source_guid' => 'source_guid',
        'purchase_description' => 'purchase_description',
        'reorder_level' => 'reorder_level',
        'reorder_quantity' => 'reorder_quantity',
        'location' => 'location',
        'barcode' => 'barcode',
        'supplier_part_number' => 'supplier_part_number',
        'weight' => 'weight',
        'measurement_unit' => 'measurement_unit',
        'weight_converted' => 'weight_converted',
        'active' => 'active',
        'quantity_in_stock' => 'quantity_in_stock',
        'last_cost_price' => 'last_cost_price',
        'last_cost_price_stock_value' => 'last_cost_price_stock_value',
        'average_cost_price' => 'average_cost_price',
        'average_cost_price_stock_value' => 'average_cost_price_stock_value',
        'cost_price_last_updated' => 'cost_price_last_updated'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'item_code' => 'setItemCode',
        'description' => 'setDescription',
        'notes' => 'setNotes',
        'sales_ledger_account' => 'setSalesLedgerAccount',
        'sales_tax_rate' => 'setSalesTaxRate',
        'purchase_ledger_account' => 'setPurchaseLedgerAccount',
        'usual_supplier' => 'setUsualSupplier',
        'purchase_tax_rate' => 'setPurchaseTaxRate',
        'cost_price' => 'setCostPrice',
        'sales_prices' => 'setSalesPrices',
        'source_guid' => 'setSourceGuid',
        'purchase_description' => 'setPurchaseDescription',
        'reorder_level' => 'setReorderLevel',
        'reorder_quantity' => 'setReorderQuantity',
        'location' => 'setLocation',
        'barcode' => 'setBarcode',
        'supplier_part_number' => 'setSupplierPartNumber',
        'weight' => 'setWeight',
        'measurement_unit' => 'setMeasurementUnit',
        'weight_converted' => 'setWeightConverted',
        'active' => 'setActive',
        'quantity_in_stock' => 'setQuantityInStock',
        'last_cost_price' => 'setLastCostPrice',
        'last_cost_price_stock_value' => 'setLastCostPriceStockValue',
        'average_cost_price' => 'setAverageCostPrice',
        'average_cost_price_stock_value' => 'setAverageCostPriceStockValue',
        'cost_price_last_updated' => 'setCostPriceLastUpdated'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'item_code' => 'getItemCode',
        'description' => 'getDescription',
        'notes' => 'getNotes',
        'sales_ledger_account' => 'getSalesLedgerAccount',
        'sales_tax_rate' => 'getSalesTaxRate',
        'purchase_ledger_account' => 'getPurchaseLedgerAccount',
        'usual_supplier' => 'getUsualSupplier',
        'purchase_tax_rate' => 'getPurchaseTaxRate',
        'cost_price' => 'getCostPrice',
        'sales_prices' => 'getSalesPrices',
        'source_guid' => 'getSourceGuid',
        'purchase_description' => 'getPurchaseDescription',
        'reorder_level' => 'getReorderLevel',
        'reorder_quantity' => 'getReorderQuantity',
        'location' => 'getLocation',
        'barcode' => 'getBarcode',
        'supplier_part_number' => 'getSupplierPartNumber',
        'weight' => 'getWeight',
        'measurement_unit' => 'getMeasurementUnit',
        'weight_converted' => 'getWeightConverted',
        'active' => 'getActive',
        'quantity_in_stock' => 'getQuantityInStock',
        'last_cost_price' => 'getLastCostPrice',
        'last_cost_price_stock_value' => 'getLastCostPriceStockValue',
        'average_cost_price' => 'getAverageCostPrice',
        'average_cost_price_stock_value' => 'getAverageCostPriceStockValue',
        'cost_price_last_updated' => 'getCostPriceLastUpdated'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['item_code'] = $data['item_code'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['sales_ledger_account'] = $data['sales_ledger_account'] ?? null;
        $this->container['sales_tax_rate'] = $data['sales_tax_rate'] ?? null;
        $this->container['purchase_ledger_account'] = $data['purchase_ledger_account'] ?? null;
        $this->container['usual_supplier'] = $data['usual_supplier'] ?? null;
        $this->container['purchase_tax_rate'] = $data['purchase_tax_rate'] ?? null;
        $this->container['cost_price'] = $data['cost_price'] ?? null;
        $this->container['sales_prices'] = $data['sales_prices'] ?? null;
        $this->container['source_guid'] = $data['source_guid'] ?? null;
        $this->container['purchase_description'] = $data['purchase_description'] ?? null;
        $this->container['reorder_level'] = $data['reorder_level'] ?? null;
        $this->container['reorder_quantity'] = $data['reorder_quantity'] ?? null;
        $this->container['location'] = $data['location'] ?? null;
        $this->container['barcode'] = $data['barcode'] ?? null;
        $this->container['supplier_part_number'] = $data['supplier_part_number'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['measurement_unit'] = $data['measurement_unit'] ?? null;
        $this->container['weight_converted'] = $data['weight_converted'] ?? null;
        $this->container['active'] = $data['active'] ?? null;
        $this->container['quantity_in_stock'] = $data['quantity_in_stock'] ?? null;
        $this->container['last_cost_price'] = $data['last_cost_price'] ?? null;
        $this->container['last_cost_price_stock_value'] = $data['last_cost_price_stock_value'] ?? null;
        $this->container['average_cost_price'] = $data['average_cost_price'] ?? null;
        $this->container['average_cost_price_stock_value'] = $data['average_cost_price_stock_value'] ?? null;
        $this->container['cost_price_last_updated'] = $data['cost_price_last_updated'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Base|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets item_code
     *
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->container['item_code'];
    }

    /**
     * Sets item_code
     *
     * @param string|null $item_code The item code for the stock item
     *
     * @return self
     */
    public function setItemCode($item_code)
    {
        $this->container['item_code'] = $item_code;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The stock item description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes The notes for the stock item
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets sales_ledger_account
     *
     * @return \SageOne\Model\Base|null
     */
    public function getSalesLedgerAccount()
    {
        return $this->container['sales_ledger_account'];
    }

    /**
     * Sets sales_ledger_account
     *
     * @param \SageOne\Model\Base|null $sales_ledger_account sales_ledger_account
     *
     * @return self
     */
    public function setSalesLedgerAccount($sales_ledger_account)
    {
        $this->container['sales_ledger_account'] = $sales_ledger_account;

        return $this;
    }

    /**
     * Gets sales_tax_rate
     *
     * @return \SageOne\Model\Base|null
     */
    public function getSalesTaxRate()
    {
        return $this->container['sales_tax_rate'];
    }

    /**
     * Sets sales_tax_rate
     *
     * @param \SageOne\Model\Base|null $sales_tax_rate sales_tax_rate
     *
     * @return self
     */
    public function setSalesTaxRate($sales_tax_rate)
    {
        $this->container['sales_tax_rate'] = $sales_tax_rate;

        return $this;
    }

    /**
     * Gets purchase_ledger_account
     *
     * @return \SageOne\Model\Base|null
     */
    public function getPurchaseLedgerAccount()
    {
        return $this->container['purchase_ledger_account'];
    }

    /**
     * Sets purchase_ledger_account
     *
     * @param \SageOne\Model\Base|null $purchase_ledger_account purchase_ledger_account
     *
     * @return self
     */
    public function setPurchaseLedgerAccount($purchase_ledger_account)
    {
        $this->container['purchase_ledger_account'] = $purchase_ledger_account;

        return $this;
    }

    /**
     * Gets usual_supplier
     *
     * @return \SageOne\Model\Contact|null
     */
    public function getUsualSupplier()
    {
        return $this->container['usual_supplier'];
    }

    /**
     * Sets usual_supplier
     *
     * @param \SageOne\Model\Contact|null $usual_supplier usual_supplier
     *
     * @return self
     */
    public function setUsualSupplier($usual_supplier)
    {
        $this->container['usual_supplier'] = $usual_supplier;

        return $this;
    }

    /**
     * Gets purchase_tax_rate
     *
     * @return \SageOne\Model\Base|null
     */
    public function getPurchaseTaxRate()
    {
        return $this->container['purchase_tax_rate'];
    }

    /**
     * Sets purchase_tax_rate
     *
     * @param \SageOne\Model\Base|null $purchase_tax_rate purchase_tax_rate
     *
     * @return self
     */
    public function setPurchaseTaxRate($purchase_tax_rate)
    {
        $this->container['purchase_tax_rate'] = $purchase_tax_rate;

        return $this;
    }

    /**
     * Gets cost_price
     *
     * @return double|null
     */
    public function getCostPrice()
    {
        return $this->container['cost_price'];
    }

    /**
     * Sets cost_price
     *
     * @param double|null $cost_price The cost price of the stock item
     *
     * @return self
     */
    public function setCostPrice($cost_price)
    {
        $this->container['cost_price'] = $cost_price;

        return $this;
    }

    /**
     * Gets sales_prices
     *
     * @return \SageOne\Model\ProductSalesPriceType[]|null
     */
    public function getSalesPrices()
    {
        return $this->container['sales_prices'];
    }

    /**
     * Sets sales_prices
     *
     * @param \SageOne\Model\ProductSalesPriceType[]|null $sales_prices The sales prices for the stock item
     *
     * @return self
     */
    public function setSalesPrices($sales_prices)
    {
        $this->container['sales_prices'] = $sales_prices;

        return $this;
    }

    /**
     * Gets source_guid
     *
     * @return string|null
     */
    public function getSourceGuid()
    {
        return $this->container['source_guid'];
    }

    /**
     * Sets source_guid
     *
     * @param string|null $source_guid Used when importing stock items from external sources
     *
     * @return self
     */
    public function setSourceGuid($source_guid)
    {
        $this->container['source_guid'] = $source_guid;

        return $this;
    }

    /**
     * Gets purchase_description
     *
     * @return string|null
     */
    public function getPurchaseDescription()
    {
        return $this->container['purchase_description'];
    }

    /**
     * Sets purchase_description
     *
     * @param string|null $purchase_description The stock item purchase description
     *
     * @return self
     */
    public function setPurchaseDescription($purchase_description)
    {
        $this->container['purchase_description'] = $purchase_description;

        return $this;
    }

    /**
     * Gets reorder_level
     *
     * @return double|null
     */
    public function getReorderLevel()
    {
        return $this->container['reorder_level'];
    }

    /**
     * Sets reorder_level
     *
     * @param double|null $reorder_level The reorder level for the stock item
     *
     * @return self
     */
    public function setReorderLevel($reorder_level)
    {
        $this->container['reorder_level'] = $reorder_level;

        return $this;
    }

    /**
     * Gets reorder_quantity
     *
     * @return double|null
     */
    public function getReorderQuantity()
    {
        return $this->container['reorder_quantity'];
    }

    /**
     * Sets reorder_quantity
     *
     * @param double|null $reorder_quantity The reorder quantity for the stock item
     *
     * @return self
     */
    public function setReorderQuantity($reorder_quantity)
    {
        $this->container['reorder_quantity'] = $reorder_quantity;

        return $this;
    }

    /**
     * Gets location
     *
     * @return string|null
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param string|null $location The location for the stock item
     *
     * @return self
     */
    public function setLocation($location)
    {
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets barcode
     *
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->container['barcode'];
    }

    /**
     * Sets barcode
     *
     * @param string|null $barcode The barcode for the stock item
     *
     * @return self
     */
    public function setBarcode($barcode)
    {
        $this->container['barcode'] = $barcode;

        return $this;
    }

    /**
     * Gets supplier_part_number
     *
     * @return string|null
     */
    public function getSupplierPartNumber()
    {
        return $this->container['supplier_part_number'];
    }

    /**
     * Sets supplier_part_number
     *
     * @param string|null $supplier_part_number The supplier part number for stock item
     *
     * @return self
     */
    public function setSupplierPartNumber($supplier_part_number)
    {
        $this->container['supplier_part_number'] = $supplier_part_number;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return double|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param double|null $weight The weight of stock item
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets measurement_unit
     *
     * @return string|null
     */
    public function getMeasurementUnit()
    {
        return $this->container['measurement_unit'];
    }

    /**
     * Sets measurement_unit
     *
     * @param string|null $measurement_unit The unit of measure of weight for stock item
     *
     * @return self
     */
    public function setMeasurementUnit($measurement_unit)
    {
        $this->container['measurement_unit'] = $measurement_unit;

        return $this;
    }

    /**
     * Gets weight_converted
     *
     * @return double|null
     */
    public function getWeightConverted()
    {
        return $this->container['weight_converted'];
    }

    /**
     * Sets weight_converted
     *
     * @param double|null $weight_converted The weight of stock item converted to the lowest unit of measurement
     *
     * @return self
     */
    public function setWeightConverted($weight_converted)
    {
        $this->container['weight_converted'] = $weight_converted;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Indicates whether the stock item is active
     *
     * @return self
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets quantity_in_stock
     *
     * @return double|null
     */
    public function getQuantityInStock()
    {
        return $this->container['quantity_in_stock'];
    }

    /**
     * Sets quantity_in_stock
     *
     * @param double|null $quantity_in_stock The current quantity of the stock item held by the business
     *
     * @return self
     */
    public function setQuantityInStock($quantity_in_stock)
    {
        $this->container['quantity_in_stock'] = $quantity_in_stock;

        return $this;
    }

    /**
     * Gets last_cost_price
     *
     * @return double|null
     */
    public function getLastCostPrice()
    {
        return $this->container['last_cost_price'];
    }

    /**
     * Sets last_cost_price
     *
     * @param double|null $last_cost_price The most recent 'purchase invoice' or 'adjustment in' price
     *
     * @return self
     */
    public function setLastCostPrice($last_cost_price)
    {
        $this->container['last_cost_price'] = $last_cost_price;

        return $this;
    }

    /**
     * Gets last_cost_price_stock_value
     *
     * @return double|null
     */
    public function getLastCostPriceStockValue()
    {
        return $this->container['last_cost_price_stock_value'];
    }

    /**
     * Sets last_cost_price_stock_value
     *
     * @param double|null $last_cost_price_stock_value The value of the current stock in terms of the last cost price
     *
     * @return self
     */
    public function setLastCostPriceStockValue($last_cost_price_stock_value)
    {
        $this->container['last_cost_price_stock_value'] = $last_cost_price_stock_value;

        return $this;
    }

    /**
     * Gets average_cost_price
     *
     * @return double|null
     */
    public function getAverageCostPrice()
    {
        return $this->container['average_cost_price'];
    }

    /**
     * Sets average_cost_price
     *
     * @param double|null $average_cost_price The average price across all purchases of this stock item
     *
     * @return self
     */
    public function setAverageCostPrice($average_cost_price)
    {
        $this->container['average_cost_price'] = $average_cost_price;

        return $this;
    }

    /**
     * Gets average_cost_price_stock_value
     *
     * @return double|null
     */
    public function getAverageCostPriceStockValue()
    {
        return $this->container['average_cost_price_stock_value'];
    }

    /**
     * Sets average_cost_price_stock_value
     *
     * @param double|null $average_cost_price_stock_value The value of the current stock in terms of the average cost price
     *
     * @return self
     */
    public function setAverageCostPriceStockValue($average_cost_price_stock_value)
    {
        $this->container['average_cost_price_stock_value'] = $average_cost_price_stock_value;

        return $this;
    }

    /**
     * Gets cost_price_last_updated
     *
     * @return \DateTime|null
     */
    public function getCostPriceLastUpdated()
    {
        return $this->container['cost_price_last_updated'];
    }

    /**
     * Sets cost_price_last_updated
     *
     * @param \DateTime|null $cost_price_last_updated The date on which the last cost price was last updated
     *
     * @return self
     */
    public function setCostPriceLastUpdated($cost_price_last_updated)
    {
        $this->container['cost_price_last_updated'] = $cost_price_last_updated;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


