<?php
/**
 * SalesInvoiceLineItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * SalesInvoiceLineItem Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesInvoiceLineItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SalesInvoiceLineItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'description' => 'string',
        'product' => '\SageOne\Model\Product',
        'service' => '\SageOne\Model\Service',
        'ledger_account' => '\SageOne\Model\Base',
        'trade_of_asset' => 'bool',
        'quantity' => 'double',
        'unit_price' => 'double',
        'net_amount' => 'double',
        'tax_rate' => '\SageOne\Model\Base',
        'tax_amount' => 'double',
        'tax_breakdown' => '\SageOne\Model\TaxBreakdown[]',
        'total_amount' => 'double',
        'base_currency_unit_price' => 'double',
        'unit_price_includes_tax' => 'bool',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_tax_breakdown' => '\SageOne\Model\TaxBreakdown[]',
        'base_currency_total_amount' => 'double',
        'eu_goods_services_type' => '\SageOne\Model\Base',
        'discount_amount' => 'double',
        'base_currency_discount_amount' => 'double',
        'discount_percentage' => 'double',
        'eu_sales_description' => '\SageOne\Model\EuSalesDescription'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'description' => null,
        'product' => null,
        'service' => null,
        'ledger_account' => null,
        'trade_of_asset' => null,
        'quantity' => 'double',
        'unit_price' => 'double',
        'net_amount' => 'double',
        'tax_rate' => null,
        'tax_amount' => 'double',
        'tax_breakdown' => null,
        'total_amount' => 'double',
        'base_currency_unit_price' => 'double',
        'unit_price_includes_tax' => null,
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_tax_breakdown' => null,
        'base_currency_total_amount' => 'double',
        'eu_goods_services_type' => null,
        'discount_amount' => 'double',
        'base_currency_discount_amount' => 'double',
        'discount_percentage' => 'double',
        'eu_sales_description' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'description' => 'description',
        'product' => 'product',
        'service' => 'service',
        'ledger_account' => 'ledger_account',
        'trade_of_asset' => 'trade_of_asset',
        'quantity' => 'quantity',
        'unit_price' => 'unit_price',
        'net_amount' => 'net_amount',
        'tax_rate' => 'tax_rate',
        'tax_amount' => 'tax_amount',
        'tax_breakdown' => 'tax_breakdown',
        'total_amount' => 'total_amount',
        'base_currency_unit_price' => 'base_currency_unit_price',
        'unit_price_includes_tax' => 'unit_price_includes_tax',
        'base_currency_net_amount' => 'base_currency_net_amount',
        'base_currency_tax_amount' => 'base_currency_tax_amount',
        'base_currency_tax_breakdown' => 'base_currency_tax_breakdown',
        'base_currency_total_amount' => 'base_currency_total_amount',
        'eu_goods_services_type' => 'eu_goods_services_type',
        'discount_amount' => 'discount_amount',
        'base_currency_discount_amount' => 'base_currency_discount_amount',
        'discount_percentage' => 'discount_percentage',
        'eu_sales_description' => 'eu_sales_description'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'description' => 'setDescription',
        'product' => 'setProduct',
        'service' => 'setService',
        'ledger_account' => 'setLedgerAccount',
        'trade_of_asset' => 'setTradeOfAsset',
        'quantity' => 'setQuantity',
        'unit_price' => 'setUnitPrice',
        'net_amount' => 'setNetAmount',
        'tax_rate' => 'setTaxRate',
        'tax_amount' => 'setTaxAmount',
        'tax_breakdown' => 'setTaxBreakdown',
        'total_amount' => 'setTotalAmount',
        'base_currency_unit_price' => 'setBaseCurrencyUnitPrice',
        'unit_price_includes_tax' => 'setUnitPriceIncludesTax',
        'base_currency_net_amount' => 'setBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'setBaseCurrencyTaxAmount',
        'base_currency_tax_breakdown' => 'setBaseCurrencyTaxBreakdown',
        'base_currency_total_amount' => 'setBaseCurrencyTotalAmount',
        'eu_goods_services_type' => 'setEuGoodsServicesType',
        'discount_amount' => 'setDiscountAmount',
        'base_currency_discount_amount' => 'setBaseCurrencyDiscountAmount',
        'discount_percentage' => 'setDiscountPercentage',
        'eu_sales_description' => 'setEuSalesDescription'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'description' => 'getDescription',
        'product' => 'getProduct',
        'service' => 'getService',
        'ledger_account' => 'getLedgerAccount',
        'trade_of_asset' => 'getTradeOfAsset',
        'quantity' => 'getQuantity',
        'unit_price' => 'getUnitPrice',
        'net_amount' => 'getNetAmount',
        'tax_rate' => 'getTaxRate',
        'tax_amount' => 'getTaxAmount',
        'tax_breakdown' => 'getTaxBreakdown',
        'total_amount' => 'getTotalAmount',
        'base_currency_unit_price' => 'getBaseCurrencyUnitPrice',
        'unit_price_includes_tax' => 'getUnitPriceIncludesTax',
        'base_currency_net_amount' => 'getBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'getBaseCurrencyTaxAmount',
        'base_currency_tax_breakdown' => 'getBaseCurrencyTaxBreakdown',
        'base_currency_total_amount' => 'getBaseCurrencyTotalAmount',
        'eu_goods_services_type' => 'getEuGoodsServicesType',
        'discount_amount' => 'getDiscountAmount',
        'base_currency_discount_amount' => 'getBaseCurrencyDiscountAmount',
        'discount_percentage' => 'getDiscountPercentage',
        'eu_sales_description' => 'getEuSalesDescription'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['product'] = $data['product'] ?? null;
        $this->container['service'] = $data['service'] ?? null;
        $this->container['ledger_account'] = $data['ledger_account'] ?? null;
        $this->container['trade_of_asset'] = $data['trade_of_asset'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['unit_price'] = $data['unit_price'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_rate'] = $data['tax_rate'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['tax_breakdown'] = $data['tax_breakdown'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['base_currency_unit_price'] = $data['base_currency_unit_price'] ?? null;
        $this->container['unit_price_includes_tax'] = $data['unit_price_includes_tax'] ?? null;
        $this->container['base_currency_net_amount'] = $data['base_currency_net_amount'] ?? null;
        $this->container['base_currency_tax_amount'] = $data['base_currency_tax_amount'] ?? null;
        $this->container['base_currency_tax_breakdown'] = $data['base_currency_tax_breakdown'] ?? null;
        $this->container['base_currency_total_amount'] = $data['base_currency_total_amount'] ?? null;
        $this->container['eu_goods_services_type'] = $data['eu_goods_services_type'] ?? null;
        $this->container['discount_amount'] = $data['discount_amount'] ?? null;
        $this->container['base_currency_discount_amount'] = $data['base_currency_discount_amount'] ?? null;
        $this->container['discount_percentage'] = $data['discount_percentage'] ?? null;
        $this->container['eu_sales_description'] = $data['eu_sales_description'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The description for the invoice line
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets product
     *
     * @return \SageOne\Model\Product|null
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param \SageOne\Model\Product|null $product product
     *
     * @return self
     */
    public function setProduct($product)
    {
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets service
     *
     * @return \SageOne\Model\Service|null
     */
    public function getService()
    {
        return $this->container['service'];
    }

    /**
     * Sets service
     *
     * @param \SageOne\Model\Service|null $service service
     *
     * @return self
     */
    public function setService($service)
    {
        $this->container['service'] = $service;

        return $this;
    }

    /**
     * Gets ledger_account
     *
     * @return \SageOne\Model\Base|null
     */
    public function getLedgerAccount()
    {
        return $this->container['ledger_account'];
    }

    /**
     * Sets ledger_account
     *
     * @param \SageOne\Model\Base|null $ledger_account ledger_account
     *
     * @return self
     */
    public function setLedgerAccount($ledger_account)
    {
        $this->container['ledger_account'] = $ledger_account;

        return $this;
    }

    /**
     * Gets trade_of_asset
     *
     * @return bool|null
     */
    public function getTradeOfAsset()
    {
        return $this->container['trade_of_asset'];
    }

    /**
     * Sets trade_of_asset
     *
     * @param bool|null $trade_of_asset Whether the line item is marked as trade of asset.
     *
     * @return self
     */
    public function setTradeOfAsset($trade_of_asset)
    {
        $this->container['trade_of_asset'] = $trade_of_asset;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return double|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param double|null $quantity The quantity for the invoice line
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets unit_price
     *
     * @return double|null
     */
    public function getUnitPrice()
    {
        return $this->container['unit_price'];
    }

    /**
     * Sets unit_price
     *
     * @param double|null $unit_price The unit price for the invoice line
     *
     * @return self
     */
    public function setUnitPrice($unit_price)
    {
        $this->container['unit_price'] = $unit_price;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double|null $net_amount The net amount for the invoice line
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param \SageOne\Model\Base|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double|null $tax_amount The tax amount for the invoice line
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets tax_breakdown
     *
     * @return \SageOne\Model\TaxBreakdown[]|null
     */
    public function getTaxBreakdown()
    {
        return $this->container['tax_breakdown'];
    }

    /**
     * Sets tax_breakdown
     *
     * @param \SageOne\Model\TaxBreakdown[]|null $tax_breakdown The tax breakdown for the invoice line
     *
     * @return self
     */
    public function setTaxBreakdown($tax_breakdown)
    {
        $this->container['tax_breakdown'] = $tax_breakdown;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount The total amount for the invoice line
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets base_currency_unit_price
     *
     * @return double|null
     */
    public function getBaseCurrencyUnitPrice()
    {
        return $this->container['base_currency_unit_price'];
    }

    /**
     * Sets base_currency_unit_price
     *
     * @param double|null $base_currency_unit_price The unit price for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyUnitPrice($base_currency_unit_price)
    {
        $this->container['base_currency_unit_price'] = $base_currency_unit_price;

        return $this;
    }

    /**
     * Gets unit_price_includes_tax
     *
     * @return bool|null
     */
    public function getUnitPriceIncludesTax()
    {
        return $this->container['unit_price_includes_tax'];
    }

    /**
     * Sets unit_price_includes_tax
     *
     * @param bool|null $unit_price_includes_tax Defines whether the unit price includes tax
     *
     * @return self
     */
    public function setUnitPriceIncludesTax($unit_price_includes_tax)
    {
        $this->container['unit_price_includes_tax'] = $unit_price_includes_tax;

        return $this;
    }

    /**
     * Gets base_currency_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyNetAmount()
    {
        return $this->container['base_currency_net_amount'];
    }

    /**
     * Sets base_currency_net_amount
     *
     * @param double|null $base_currency_net_amount The net amount for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyNetAmount($base_currency_net_amount)
    {
        $this->container['base_currency_net_amount'] = $base_currency_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTaxAmount()
    {
        return $this->container['base_currency_tax_amount'];
    }

    /**
     * Sets base_currency_tax_amount
     *
     * @param double|null $base_currency_tax_amount The tax amount for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxAmount($base_currency_tax_amount)
    {
        $this->container['base_currency_tax_amount'] = $base_currency_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_breakdown
     *
     * @return \SageOne\Model\TaxBreakdown[]|null
     */
    public function getBaseCurrencyTaxBreakdown()
    {
        return $this->container['base_currency_tax_breakdown'];
    }

    /**
     * Sets base_currency_tax_breakdown
     *
     * @param \SageOne\Model\TaxBreakdown[]|null $base_currency_tax_breakdown The tax breakdown for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxBreakdown($base_currency_tax_breakdown)
    {
        $this->container['base_currency_tax_breakdown'] = $base_currency_tax_breakdown;

        return $this;
    }

    /**
     * Gets base_currency_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalAmount()
    {
        return $this->container['base_currency_total_amount'];
    }

    /**
     * Sets base_currency_total_amount
     *
     * @param double|null $base_currency_total_amount The total amount for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTotalAmount($base_currency_total_amount)
    {
        $this->container['base_currency_total_amount'] = $base_currency_total_amount;

        return $this;
    }

    /**
     * Gets eu_goods_services_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getEuGoodsServicesType()
    {
        return $this->container['eu_goods_services_type'];
    }

    /**
     * Sets eu_goods_services_type
     *
     * @param \SageOne\Model\Base|null $eu_goods_services_type eu_goods_services_type
     *
     * @return self
     */
    public function setEuGoodsServicesType($eu_goods_services_type)
    {
        $this->container['eu_goods_services_type'] = $eu_goods_services_type;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return double|null
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param double|null $discount_amount The discount amount for the invoice line
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets base_currency_discount_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyDiscountAmount()
    {
        return $this->container['base_currency_discount_amount'];
    }

    /**
     * Sets base_currency_discount_amount
     *
     * @param double|null $base_currency_discount_amount The discount amount for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyDiscountAmount($base_currency_discount_amount)
    {
        $this->container['base_currency_discount_amount'] = $base_currency_discount_amount;

        return $this;
    }

    /**
     * Gets discount_percentage
     *
     * @return double|null
     */
    public function getDiscountPercentage()
    {
        return $this->container['discount_percentage'];
    }

    /**
     * Sets discount_percentage
     *
     * @param double|null $discount_percentage The discount percentage for the invoice line
     *
     * @return self
     */
    public function setDiscountPercentage($discount_percentage)
    {
        $this->container['discount_percentage'] = $discount_percentage;

        return $this;
    }

    /**
     * Gets eu_sales_description
     *
     * @return \SageOne\Model\EuSalesDescription|null
     */
    public function getEuSalesDescription()
    {
        return $this->container['eu_sales_description'];
    }

    /**
     * Sets eu_sales_description
     *
     * @param \SageOne\Model\EuSalesDescription|null $eu_sales_description eu_sales_description
     *
     * @return self
     */
    public function setEuSalesDescription($eu_sales_description)
    {
        $this->container['eu_sales_description'] = $eu_sales_description;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


