<?php
/**
 * PutTaxProfilesTaxProfile
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PutTaxProfilesTaxProfile Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PutTaxProfilesTaxProfile implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'putTaxProfiles_tax_profile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'tax_type_id' => 'string',
        'tax_number' => 'string',
        'tax_number_suffix' => 'string',
        'collect_tax' => 'bool',
        'tax_return_frequency_id' => 'string',
        'address_region' => '\SageOne\Model\PutTaxProfilesTaxProfileAddressRegion'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_id' => null,
        'transaction_type_id' => null,
        'tax_type_id' => null,
        'tax_number' => null,
        'tax_number_suffix' => null,
        'collect_tax' => null,
        'tax_return_frequency_id' => null,
        'address_region' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'tax_type_id' => 'tax_type_id',
        'tax_number' => 'tax_number',
        'tax_number_suffix' => 'tax_number_suffix',
        'collect_tax' => 'collect_tax',
        'tax_return_frequency_id' => 'tax_return_frequency_id',
        'address_region' => 'address_region'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'tax_type_id' => 'setTaxTypeId',
        'tax_number' => 'setTaxNumber',
        'tax_number_suffix' => 'setTaxNumberSuffix',
        'collect_tax' => 'setCollectTax',
        'tax_return_frequency_id' => 'setTaxReturnFrequencyId',
        'address_region' => 'setAddressRegion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'tax_type_id' => 'getTaxTypeId',
        'tax_number' => 'getTaxNumber',
        'tax_number_suffix' => 'getTaxNumberSuffix',
        'collect_tax' => 'getCollectTax',
        'tax_return_frequency_id' => 'getTaxReturnFrequencyId',
        'address_region' => 'getAddressRegion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['tax_type_id'] = $data['tax_type_id'] ?? null;
        $this->container['tax_number'] = $data['tax_number'] ?? null;
        $this->container['tax_number_suffix'] = $data['tax_number_suffix'] ?? null;
        $this->container['collect_tax'] = $data['collect_tax'] ?? null;
        $this->container['tax_return_frequency_id'] = $data['tax_return_frequency_id'] ?? null;
        $this->container['address_region'] = $data['address_region'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets tax_type_id
     *
     * @return string|null
     */
    public function getTaxTypeId()
    {
        return $this->container['tax_type_id'];
    }

    /**
     * Sets tax_type_id
     *
     * @param string|null $tax_type_id The ID of the Tax Type.
     *
     * @return self
     */
    public function setTaxTypeId($tax_type_id)
    {
        $this->container['tax_type_id'] = $tax_type_id;

        return $this;
    }

    /**
     * Gets tax_number
     *
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->container['tax_number'];
    }

    /**
     * Sets tax_number
     *
     * @param string|null $tax_number The tax number
     *
     * @return self
     */
    public function setTaxNumber($tax_number)
    {
        $this->container['tax_number'] = $tax_number;

        return $this;
    }

    /**
     * Gets tax_number_suffix
     *
     * @return string|null
     */
    public function getTaxNumberSuffix()
    {
        return $this->container['tax_number_suffix'];
    }

    /**
     * Sets tax_number_suffix
     *
     * @param string|null $tax_number_suffix The tax number suffix
     *
     * @return self
     */
    public function setTaxNumberSuffix($tax_number_suffix)
    {
        $this->container['tax_number_suffix'] = $tax_number_suffix;

        return $this;
    }

    /**
     * Gets collect_tax
     *
     * @return bool|null
     */
    public function getCollectTax()
    {
        return $this->container['collect_tax'];
    }

    /**
     * Sets collect_tax
     *
     * @param bool|null $collect_tax Indicates whether tax is collected for this tax type
     *
     * @return self
     */
    public function setCollectTax($collect_tax)
    {
        $this->container['collect_tax'] = $collect_tax;

        return $this;
    }

    /**
     * Gets tax_return_frequency_id
     *
     * @return string|null
     */
    public function getTaxReturnFrequencyId()
    {
        return $this->container['tax_return_frequency_id'];
    }

    /**
     * Sets tax_return_frequency_id
     *
     * @param string|null $tax_return_frequency_id The ID of the Tax Return Frequency.
     *
     * @return self
     */
    public function setTaxReturnFrequencyId($tax_return_frequency_id)
    {
        $this->container['tax_return_frequency_id'] = $tax_return_frequency_id;

        return $this;
    }

    /**
     * Gets address_region
     *
     * @return \SageOne\Model\PutTaxProfilesTaxProfileAddressRegion|null
     */
    public function getAddressRegion()
    {
        return $this->container['address_region'];
    }

    /**
     * Sets address_region
     *
     * @param \SageOne\Model\PutTaxProfilesTaxProfileAddressRegion|null $address_region address_region
     *
     * @return self
     */
    public function setAddressRegion($address_region)
    {
        $this->container['address_region'] = $address_region;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


