<?php
/**
 * PutPurchaseInvoicesPurchaseInvoiceInvoiceLines
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PutPurchaseInvoicesPurchaseInvoiceInvoiceLines Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PutPurchaseInvoicesPurchaseInvoiceInvoiceLines implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'putPurchaseInvoices_purchase_invoice_invoice_lines';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'description' => 'string[]',
        'ledger_account_id' => 'string[]',
        'quantity' => 'double[]',
        'unit_price' => 'double[]',
        'is_purchase_for_resale' => 'bool[]',
        'product_id' => 'string[]',
        'service_id' => 'string[]',
        'trade_of_asset' => 'bool[]',
        'net_amount' => 'double[]',
        'tax_rate_id' => 'string[]',
        'tax_amount' => 'double[]',
        'tax_breakdown' => 'string[]',
        'total_amount' => 'double',
        'base_currency_unit_price' => 'double',
        'unit_price_includes_tax' => 'bool',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_tax_breakdown' => 'string[]',
        'base_currency_total_amount' => 'double',
        'eu_goods_services_type_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'description' => null,
        'ledger_account_id' => null,
        'quantity' => 'double',
        'unit_price' => 'double',
        'is_purchase_for_resale' => null,
        'product_id' => null,
        'service_id' => null,
        'trade_of_asset' => null,
        'net_amount' => 'double',
        'tax_rate_id' => null,
        'tax_amount' => 'double',
        'tax_breakdown' => null,
        'total_amount' => 'double',
        'base_currency_unit_price' => 'double',
        'unit_price_includes_tax' => null,
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_tax_breakdown' => null,
        'base_currency_total_amount' => 'double',
        'eu_goods_services_type_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'description' => 'description',
        'ledger_account_id' => 'ledger_account_id',
        'quantity' => 'quantity',
        'unit_price' => 'unit_price',
        'is_purchase_for_resale' => 'is_purchase_for_resale',
        'product_id' => 'product_id',
        'service_id' => 'service_id',
        'trade_of_asset' => 'trade_of_asset',
        'net_amount' => 'net_amount',
        'tax_rate_id' => 'tax_rate_id',
        'tax_amount' => 'tax_amount',
        'tax_breakdown' => 'tax_breakdown',
        'total_amount' => 'total_amount',
        'base_currency_unit_price' => 'base_currency_unit_price',
        'unit_price_includes_tax' => 'unit_price_includes_tax',
        'base_currency_net_amount' => 'base_currency_net_amount',
        'base_currency_tax_amount' => 'base_currency_tax_amount',
        'base_currency_tax_breakdown' => 'base_currency_tax_breakdown',
        'base_currency_total_amount' => 'base_currency_total_amount',
        'eu_goods_services_type_id' => 'eu_goods_services_type_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'description' => 'setDescription',
        'ledger_account_id' => 'setLedgerAccountId',
        'quantity' => 'setQuantity',
        'unit_price' => 'setUnitPrice',
        'is_purchase_for_resale' => 'setIsPurchaseForResale',
        'product_id' => 'setProductId',
        'service_id' => 'setServiceId',
        'trade_of_asset' => 'setTradeOfAsset',
        'net_amount' => 'setNetAmount',
        'tax_rate_id' => 'setTaxRateId',
        'tax_amount' => 'setTaxAmount',
        'tax_breakdown' => 'setTaxBreakdown',
        'total_amount' => 'setTotalAmount',
        'base_currency_unit_price' => 'setBaseCurrencyUnitPrice',
        'unit_price_includes_tax' => 'setUnitPriceIncludesTax',
        'base_currency_net_amount' => 'setBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'setBaseCurrencyTaxAmount',
        'base_currency_tax_breakdown' => 'setBaseCurrencyTaxBreakdown',
        'base_currency_total_amount' => 'setBaseCurrencyTotalAmount',
        'eu_goods_services_type_id' => 'setEuGoodsServicesTypeId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'description' => 'getDescription',
        'ledger_account_id' => 'getLedgerAccountId',
        'quantity' => 'getQuantity',
        'unit_price' => 'getUnitPrice',
        'is_purchase_for_resale' => 'getIsPurchaseForResale',
        'product_id' => 'getProductId',
        'service_id' => 'getServiceId',
        'trade_of_asset' => 'getTradeOfAsset',
        'net_amount' => 'getNetAmount',
        'tax_rate_id' => 'getTaxRateId',
        'tax_amount' => 'getTaxAmount',
        'tax_breakdown' => 'getTaxBreakdown',
        'total_amount' => 'getTotalAmount',
        'base_currency_unit_price' => 'getBaseCurrencyUnitPrice',
        'unit_price_includes_tax' => 'getUnitPriceIncludesTax',
        'base_currency_net_amount' => 'getBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'getBaseCurrencyTaxAmount',
        'base_currency_tax_breakdown' => 'getBaseCurrencyTaxBreakdown',
        'base_currency_total_amount' => 'getBaseCurrencyTotalAmount',
        'eu_goods_services_type_id' => 'getEuGoodsServicesTypeId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['description'] = $data['description'] ?? null;
        $this->container['ledger_account_id'] = $data['ledger_account_id'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['unit_price'] = $data['unit_price'] ?? null;
        $this->container['is_purchase_for_resale'] = $data['is_purchase_for_resale'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['service_id'] = $data['service_id'] ?? null;
        $this->container['trade_of_asset'] = $data['trade_of_asset'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_rate_id'] = $data['tax_rate_id'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['tax_breakdown'] = $data['tax_breakdown'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['base_currency_unit_price'] = $data['base_currency_unit_price'] ?? null;
        $this->container['unit_price_includes_tax'] = $data['unit_price_includes_tax'] ?? null;
        $this->container['base_currency_net_amount'] = $data['base_currency_net_amount'] ?? null;
        $this->container['base_currency_tax_amount'] = $data['base_currency_tax_amount'] ?? null;
        $this->container['base_currency_tax_breakdown'] = $data['base_currency_tax_breakdown'] ?? null;
        $this->container['base_currency_total_amount'] = $data['base_currency_total_amount'] ?? null;
        $this->container['eu_goods_services_type_id'] = $data['eu_goods_services_type_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets description
     *
     * @return string[]|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string[]|null $description The description for the invoice line
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets ledger_account_id
     *
     * @return string[]|null
     */
    public function getLedgerAccountId()
    {
        return $this->container['ledger_account_id'];
    }

    /**
     * Sets ledger_account_id
     *
     * @param string[]|null $ledger_account_id The ID of the Ledger Account.
     *
     * @return self
     */
    public function setLedgerAccountId($ledger_account_id)
    {
        $this->container['ledger_account_id'] = $ledger_account_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return double[]|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param double[]|null $quantity The quantity for the invoice line
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets unit_price
     *
     * @return double[]|null
     */
    public function getUnitPrice()
    {
        return $this->container['unit_price'];
    }

    /**
     * Sets unit_price
     *
     * @param double[]|null $unit_price The unit price for the invoice line
     *
     * @return self
     */
    public function setUnitPrice($unit_price)
    {
        $this->container['unit_price'] = $unit_price;

        return $this;
    }

    /**
     * Gets is_purchase_for_resale
     *
     * @return bool[]|null
     */
    public function getIsPurchaseForResale()
    {
        return $this->container['is_purchase_for_resale'];
    }

    /**
     * Sets is_purchase_for_resale
     *
     * @param bool[]|null $is_purchase_for_resale Identifies whether the line item is for resale. (Ireland Only)
     *
     * @return self
     */
    public function setIsPurchaseForResale($is_purchase_for_resale)
    {
        $this->container['is_purchase_for_resale'] = $is_purchase_for_resale;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return string[]|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string[]|null $product_id The ID of the Product.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets service_id
     *
     * @return string[]|null
     */
    public function getServiceId()
    {
        return $this->container['service_id'];
    }

    /**
     * Sets service_id
     *
     * @param string[]|null $service_id The ID of the Service.
     *
     * @return self
     */
    public function setServiceId($service_id)
    {
        $this->container['service_id'] = $service_id;

        return $this;
    }

    /**
     * Gets trade_of_asset
     *
     * @return bool[]|null
     */
    public function getTradeOfAsset()
    {
        return $this->container['trade_of_asset'];
    }

    /**
     * Sets trade_of_asset
     *
     * @param bool[]|null $trade_of_asset Whether the line item is marked as trade of asset.
     *
     * @return self
     */
    public function setTradeOfAsset($trade_of_asset)
    {
        $this->container['trade_of_asset'] = $trade_of_asset;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double[]|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double[]|null $net_amount The net amount for the invoice line
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_rate_id
     *
     * @return string[]|null
     */
    public function getTaxRateId()
    {
        return $this->container['tax_rate_id'];
    }

    /**
     * Sets tax_rate_id
     *
     * @param string[]|null $tax_rate_id The ID of the Tax Rate.
     *
     * @return self
     */
    public function setTaxRateId($tax_rate_id)
    {
        $this->container['tax_rate_id'] = $tax_rate_id;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double[]|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double[]|null $tax_amount The tax amount for the invoice line
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets tax_breakdown
     *
     * @return string[]|null
     */
    public function getTaxBreakdown()
    {
        return $this->container['tax_breakdown'];
    }

    /**
     * Sets tax_breakdown
     *
     * @param string[]|null $tax_breakdown The tax breakdown for the invoice line
     *
     * @return self
     */
    public function setTaxBreakdown($tax_breakdown)
    {
        $this->container['tax_breakdown'] = $tax_breakdown;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount The total amount for the invoice line
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets base_currency_unit_price
     *
     * @return double|null
     */
    public function getBaseCurrencyUnitPrice()
    {
        return $this->container['base_currency_unit_price'];
    }

    /**
     * Sets base_currency_unit_price
     *
     * @param double|null $base_currency_unit_price The unit price for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyUnitPrice($base_currency_unit_price)
    {
        $this->container['base_currency_unit_price'] = $base_currency_unit_price;

        return $this;
    }

    /**
     * Gets unit_price_includes_tax
     *
     * @return bool|null
     */
    public function getUnitPriceIncludesTax()
    {
        return $this->container['unit_price_includes_tax'];
    }

    /**
     * Sets unit_price_includes_tax
     *
     * @param bool|null $unit_price_includes_tax Defines whether the unit price includes tax
     *
     * @return self
     */
    public function setUnitPriceIncludesTax($unit_price_includes_tax)
    {
        $this->container['unit_price_includes_tax'] = $unit_price_includes_tax;

        return $this;
    }

    /**
     * Gets base_currency_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyNetAmount()
    {
        return $this->container['base_currency_net_amount'];
    }

    /**
     * Sets base_currency_net_amount
     *
     * @param double|null $base_currency_net_amount The net amount for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyNetAmount($base_currency_net_amount)
    {
        $this->container['base_currency_net_amount'] = $base_currency_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTaxAmount()
    {
        return $this->container['base_currency_tax_amount'];
    }

    /**
     * Sets base_currency_tax_amount
     *
     * @param double|null $base_currency_tax_amount The tax amount for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxAmount($base_currency_tax_amount)
    {
        $this->container['base_currency_tax_amount'] = $base_currency_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_breakdown
     *
     * @return string[]|null
     */
    public function getBaseCurrencyTaxBreakdown()
    {
        return $this->container['base_currency_tax_breakdown'];
    }

    /**
     * Sets base_currency_tax_breakdown
     *
     * @param string[]|null $base_currency_tax_breakdown The tax breakdown for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxBreakdown($base_currency_tax_breakdown)
    {
        $this->container['base_currency_tax_breakdown'] = $base_currency_tax_breakdown;

        return $this;
    }

    /**
     * Gets base_currency_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalAmount()
    {
        return $this->container['base_currency_total_amount'];
    }

    /**
     * Sets base_currency_total_amount
     *
     * @param double|null $base_currency_total_amount The total amount for the invoice line in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTotalAmount($base_currency_total_amount)
    {
        $this->container['base_currency_total_amount'] = $base_currency_total_amount;

        return $this;
    }

    /**
     * Gets eu_goods_services_type_id
     *
     * @return string|null
     */
    public function getEuGoodsServicesTypeId()
    {
        return $this->container['eu_goods_services_type_id'];
    }

    /**
     * Sets eu_goods_services_type_id
     *
     * @param string|null $eu_goods_services_type_id The ID of the Eu Goods Services Type.
     *
     * @return self
     */
    public function setEuGoodsServicesTypeId($eu_goods_services_type_id)
    {
        $this->container['eu_goods_services_type_id'] = $eu_goods_services_type_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


