<?php
/**
 * PutProductsProduct
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PutProductsProduct Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PutProductsProduct implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'putProducts_product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'description' => 'string',
        'sales_ledger_account_id' => 'string',
        'purchase_ledger_account_id' => 'string',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'deleted_at' => '\DateTime',
        'item_code' => 'string',
        'notes' => 'string',
        'sales_tax_rate_id' => 'string',
        'purchase_tax_rate_id' => 'string',
        'cost_price' => 'double',
        'sales_prices' => 'string[]',
        'source_guid' => 'string',
        'purchase_description' => 'string',
        'active' => 'bool',
        'usual_supplier' => '\SageOne\Model\PostProductsProductUsualSupplier'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'description' => null,
        'sales_ledger_account_id' => null,
        'purchase_ledger_account_id' => null,
        'transaction_id' => null,
        'transaction_type_id' => null,
        'deleted_at' => 'date-time',
        'item_code' => null,
        'notes' => null,
        'sales_tax_rate_id' => null,
        'purchase_tax_rate_id' => null,
        'cost_price' => 'double',
        'sales_prices' => null,
        'source_guid' => null,
        'purchase_description' => null,
        'active' => null,
        'usual_supplier' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'description' => 'description',
        'sales_ledger_account_id' => 'sales_ledger_account_id',
        'purchase_ledger_account_id' => 'purchase_ledger_account_id',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'deleted_at' => 'deleted_at',
        'item_code' => 'item_code',
        'notes' => 'notes',
        'sales_tax_rate_id' => 'sales_tax_rate_id',
        'purchase_tax_rate_id' => 'purchase_tax_rate_id',
        'cost_price' => 'cost_price',
        'sales_prices' => 'sales_prices',
        'source_guid' => 'source_guid',
        'purchase_description' => 'purchase_description',
        'active' => 'active',
        'usual_supplier' => 'usual_supplier'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'description' => 'setDescription',
        'sales_ledger_account_id' => 'setSalesLedgerAccountId',
        'purchase_ledger_account_id' => 'setPurchaseLedgerAccountId',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'deleted_at' => 'setDeletedAt',
        'item_code' => 'setItemCode',
        'notes' => 'setNotes',
        'sales_tax_rate_id' => 'setSalesTaxRateId',
        'purchase_tax_rate_id' => 'setPurchaseTaxRateId',
        'cost_price' => 'setCostPrice',
        'sales_prices' => 'setSalesPrices',
        'source_guid' => 'setSourceGuid',
        'purchase_description' => 'setPurchaseDescription',
        'active' => 'setActive',
        'usual_supplier' => 'setUsualSupplier'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'description' => 'getDescription',
        'sales_ledger_account_id' => 'getSalesLedgerAccountId',
        'purchase_ledger_account_id' => 'getPurchaseLedgerAccountId',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'deleted_at' => 'getDeletedAt',
        'item_code' => 'getItemCode',
        'notes' => 'getNotes',
        'sales_tax_rate_id' => 'getSalesTaxRateId',
        'purchase_tax_rate_id' => 'getPurchaseTaxRateId',
        'cost_price' => 'getCostPrice',
        'sales_prices' => 'getSalesPrices',
        'source_guid' => 'getSourceGuid',
        'purchase_description' => 'getPurchaseDescription',
        'active' => 'getActive',
        'usual_supplier' => 'getUsualSupplier'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['description'] = $data['description'] ?? null;
        $this->container['sales_ledger_account_id'] = $data['sales_ledger_account_id'] ?? null;
        $this->container['purchase_ledger_account_id'] = $data['purchase_ledger_account_id'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['item_code'] = $data['item_code'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['sales_tax_rate_id'] = $data['sales_tax_rate_id'] ?? null;
        $this->container['purchase_tax_rate_id'] = $data['purchase_tax_rate_id'] ?? null;
        $this->container['cost_price'] = $data['cost_price'] ?? null;
        $this->container['sales_prices'] = $data['sales_prices'] ?? null;
        $this->container['source_guid'] = $data['source_guid'] ?? null;
        $this->container['purchase_description'] = $data['purchase_description'] ?? null;
        $this->container['active'] = $data['active'] ?? null;
        $this->container['usual_supplier'] = $data['usual_supplier'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The product description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets sales_ledger_account_id
     *
     * @return string|null
     */
    public function getSalesLedgerAccountId()
    {
        return $this->container['sales_ledger_account_id'];
    }

    /**
     * Sets sales_ledger_account_id
     *
     * @param string|null $sales_ledger_account_id The sales ledger account for the product
     *
     * @return self
     */
    public function setSalesLedgerAccountId($sales_ledger_account_id)
    {
        $this->container['sales_ledger_account_id'] = $sales_ledger_account_id;

        return $this;
    }

    /**
     * Gets purchase_ledger_account_id
     *
     * @return string|null
     */
    public function getPurchaseLedgerAccountId()
    {
        return $this->container['purchase_ledger_account_id'];
    }

    /**
     * Sets purchase_ledger_account_id
     *
     * @param string|null $purchase_ledger_account_id The purchase ledger account for the product
     *
     * @return self
     */
    public function setPurchaseLedgerAccountId($purchase_ledger_account_id)
    {
        $this->container['purchase_ledger_account_id'] = $purchase_ledger_account_id;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets item_code
     *
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->container['item_code'];
    }

    /**
     * Sets item_code
     *
     * @param string|null $item_code The item code for the product
     *
     * @return self
     */
    public function setItemCode($item_code)
    {
        $this->container['item_code'] = $item_code;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes The notes for the product
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets sales_tax_rate_id
     *
     * @return string|null
     */
    public function getSalesTaxRateId()
    {
        return $this->container['sales_tax_rate_id'];
    }

    /**
     * Sets sales_tax_rate_id
     *
     * @param string|null $sales_tax_rate_id The ID of the Sales Tax Rate.
     *
     * @return self
     */
    public function setSalesTaxRateId($sales_tax_rate_id)
    {
        $this->container['sales_tax_rate_id'] = $sales_tax_rate_id;

        return $this;
    }

    /**
     * Gets purchase_tax_rate_id
     *
     * @return string|null
     */
    public function getPurchaseTaxRateId()
    {
        return $this->container['purchase_tax_rate_id'];
    }

    /**
     * Sets purchase_tax_rate_id
     *
     * @param string|null $purchase_tax_rate_id The ID of the Purchase Tax Rate.
     *
     * @return self
     */
    public function setPurchaseTaxRateId($purchase_tax_rate_id)
    {
        $this->container['purchase_tax_rate_id'] = $purchase_tax_rate_id;

        return $this;
    }

    /**
     * Gets cost_price
     *
     * @return double|null
     */
    public function getCostPrice()
    {
        return $this->container['cost_price'];
    }

    /**
     * Sets cost_price
     *
     * @param double|null $cost_price The cost price of the product
     *
     * @return self
     */
    public function setCostPrice($cost_price)
    {
        $this->container['cost_price'] = $cost_price;

        return $this;
    }

    /**
     * Gets sales_prices
     *
     * @return string[]|null
     */
    public function getSalesPrices()
    {
        return $this->container['sales_prices'];
    }

    /**
     * Sets sales_prices
     *
     * @param string[]|null $sales_prices The sales prices for the product
     *
     * @return self
     */
    public function setSalesPrices($sales_prices)
    {
        $this->container['sales_prices'] = $sales_prices;

        return $this;
    }

    /**
     * Gets source_guid
     *
     * @return string|null
     */
    public function getSourceGuid()
    {
        return $this->container['source_guid'];
    }

    /**
     * Sets source_guid
     *
     * @param string|null $source_guid Used when importing products from external sources
     *
     * @return self
     */
    public function setSourceGuid($source_guid)
    {
        $this->container['source_guid'] = $source_guid;

        return $this;
    }

    /**
     * Gets purchase_description
     *
     * @return string|null
     */
    public function getPurchaseDescription()
    {
        return $this->container['purchase_description'];
    }

    /**
     * Sets purchase_description
     *
     * @param string|null $purchase_description The product purchase description
     *
     * @return self
     */
    public function setPurchaseDescription($purchase_description)
    {
        $this->container['purchase_description'] = $purchase_description;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Indicates whether the product is active
     *
     * @return self
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets usual_supplier
     *
     * @return \SageOne\Model\PostProductsProductUsualSupplier|null
     */
    public function getUsualSupplier()
    {
        return $this->container['usual_supplier'];
    }

    /**
     * Sets usual_supplier
     *
     * @param \SageOne\Model\PostProductsProductUsualSupplier|null $usual_supplier usual_supplier
     *
     * @return self
     */
    public function setUsualSupplier($usual_supplier)
    {
        $this->container['usual_supplier'] = $usual_supplier;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


