<?php
/**
 * PutMigrationsMigrations
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PutMigrationsMigrations Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PutMigrationsMigrations implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'putMigrations_migrations';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'started_at' => '\DateTime',
        'completed_at' => '\DateTime',
        'source_product' => 'string',
        'source_product_version' => 'string',
        'source_license' => 'string',
        'source_tool' => 'string',
        'source_tool_version' => 'string',
        'schema_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'started_at' => 'date-time',
        'completed_at' => 'date-time',
        'source_product' => null,
        'source_product_version' => null,
        'source_license' => null,
        'source_tool' => null,
        'source_tool_version' => null,
        'schema_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'started_at' => 'started_at',
        'completed_at' => 'completed_at',
        'source_product' => 'source_product',
        'source_product_version' => 'source_product_version',
        'source_license' => 'source_license',
        'source_tool' => 'source_tool',
        'source_tool_version' => 'source_tool_version',
        'schema_id' => 'schema_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'started_at' => 'setStartedAt',
        'completed_at' => 'setCompletedAt',
        'source_product' => 'setSourceProduct',
        'source_product_version' => 'setSourceProductVersion',
        'source_license' => 'setSourceLicense',
        'source_tool' => 'setSourceTool',
        'source_tool_version' => 'setSourceToolVersion',
        'schema_id' => 'setSchemaId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'started_at' => 'getStartedAt',
        'completed_at' => 'getCompletedAt',
        'source_product' => 'getSourceProduct',
        'source_product_version' => 'getSourceProductVersion',
        'source_license' => 'getSourceLicense',
        'source_tool' => 'getSourceTool',
        'source_tool_version' => 'getSourceToolVersion',
        'schema_id' => 'getSchemaId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['started_at'] = $data['started_at'] ?? null;
        $this->container['completed_at'] = $data['completed_at'] ?? null;
        $this->container['source_product'] = $data['source_product'] ?? null;
        $this->container['source_product_version'] = $data['source_product_version'] ?? null;
        $this->container['source_license'] = $data['source_license'] ?? null;
        $this->container['source_tool'] = $data['source_tool'] ?? null;
        $this->container['source_tool_version'] = $data['source_tool_version'] ?? null;
        $this->container['schema_id'] = $data['schema_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets started_at
     *
     * @return \DateTime|null
     */
    public function getStartedAt()
    {
        return $this->container['started_at'];
    }

    /**
     * Sets started_at
     *
     * @param \DateTime|null $started_at The date/time the migration started
     *
     * @return self
     */
    public function setStartedAt($started_at)
    {
        $this->container['started_at'] = $started_at;

        return $this;
    }

    /**
     * Gets completed_at
     *
     * @return \DateTime|null
     */
    public function getCompletedAt()
    {
        return $this->container['completed_at'];
    }

    /**
     * Sets completed_at
     *
     * @param \DateTime|null $completed_at The date/time the migration completed
     *
     * @return self
     */
    public function setCompletedAt($completed_at)
    {
        $this->container['completed_at'] = $completed_at;

        return $this;
    }

    /**
     * Gets source_product
     *
     * @return string|null
     */
    public function getSourceProduct()
    {
        return $this->container['source_product'];
    }

    /**
     * Sets source_product
     *
     * @param string|null $source_product The source product for the migration
     *
     * @return self
     */
    public function setSourceProduct($source_product)
    {
        $this->container['source_product'] = $source_product;

        return $this;
    }

    /**
     * Gets source_product_version
     *
     * @return string|null
     */
    public function getSourceProductVersion()
    {
        return $this->container['source_product_version'];
    }

    /**
     * Sets source_product_version
     *
     * @param string|null $source_product_version The source product version for the migration
     *
     * @return self
     */
    public function setSourceProductVersion($source_product_version)
    {
        $this->container['source_product_version'] = $source_product_version;

        return $this;
    }

    /**
     * Gets source_license
     *
     * @return string|null
     */
    public function getSourceLicense()
    {
        return $this->container['source_license'];
    }

    /**
     * Sets source_license
     *
     * @param string|null $source_license The source product license for the migration
     *
     * @return self
     */
    public function setSourceLicense($source_license)
    {
        $this->container['source_license'] = $source_license;

        return $this;
    }

    /**
     * Gets source_tool
     *
     * @return string|null
     */
    public function getSourceTool()
    {
        return $this->container['source_tool'];
    }

    /**
     * Sets source_tool
     *
     * @param string|null $source_tool The source product extract tool for the migration
     *
     * @return self
     */
    public function setSourceTool($source_tool)
    {
        $this->container['source_tool'] = $source_tool;

        return $this;
    }

    /**
     * Gets source_tool_version
     *
     * @return string|null
     */
    public function getSourceToolVersion()
    {
        return $this->container['source_tool_version'];
    }

    /**
     * Sets source_tool_version
     *
     * @param string|null $source_tool_version The source product extract tool version for the migration
     *
     * @return self
     */
    public function setSourceToolVersion($source_tool_version)
    {
        $this->container['source_tool_version'] = $source_tool_version;

        return $this;
    }

    /**
     * Gets schema_id
     *
     * @return string|null
     */
    public function getSchemaId()
    {
        return $this->container['schema_id'];
    }

    /**
     * Sets schema_id
     *
     * @param string|null $schema_id The schema id used for the migration
     *
     * @return self
     */
    public function setSchemaId($schema_id)
    {
        $this->container['schema_id'] = $schema_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


