<?php
/**
 * PutInvoiceSettingsInvoiceSettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PutInvoiceSettingsInvoiceSettings Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PutInvoiceSettingsInvoiceSettings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'putInvoiceSettings_invoice_settings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'next_invoice_number' => 'int',
        'next_credit_note_number' => 'int',
        'separate_invoice_credit_note_numbering' => 'bool',
        'sales_invoice_number_prefix' => 'string',
        'sales_credit_note_number_prefix' => 'string',
        'invoice_terms_and_conditions' => 'string',
        'default_note_on_invoice' => 'string',
        'default_note_on_credit_note' => 'string',
        'next_quote_number' => 'int',
        'quote_number_prefix' => 'string',
        'estimate_number_prefix' => 'string',
        'quote_default_days_to_expiry' => 'int',
        'estimate_default_days_to_expiry' => 'int',
        'quote_terms_and_conditions' => 'string',
        'estimate_terms_and_conditions' => 'string',
        'delivery_note_terms_and_conditions' => 'string',
        'delivery_note_show_signature' => 'bool',
        'delivery_note_show_picked' => 'bool',
        'delivery_note_show_notes' => 'bool',
        'delivery_note_show_contact_details' => 'bool',
        'quick_entry_prefix' => 'string',
        'late_payment_percentage' => 'double',
        'prompt_payment_percentage' => 'double',
        'show_auto_entrepreneur' => 'bool',
        'show_insurance' => 'bool',
        'insurance_area' => 'string',
        'insurance_type' => 'string',
        'insurance_text' => 'string',
        'payment_bank_account_id' => 'string',
        'sales_corrective_invoice_number_prefix' => 'string',
        'next_sales_corrective_invoice_number' => 'int',
        'customer_credit_days' => 'int',
        'vendor_credit_days' => 'int',
        'insurer' => '\SageOne\Model\PostProductsProductUsualSupplier',
        'document_headings' => '\SageOne\Model\PutInvoiceSettingsInvoiceSettingsDocumentHeadings',
        'line_item_titles' => '\SageOne\Model\PutInvoiceSettingsInvoiceSettingsLineItemTitles',
        'footer_details' => '\SageOne\Model\PutInvoiceSettingsInvoiceSettingsFooterDetails'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'next_invoice_number' => 'int32',
        'next_credit_note_number' => 'int32',
        'separate_invoice_credit_note_numbering' => null,
        'sales_invoice_number_prefix' => null,
        'sales_credit_note_number_prefix' => null,
        'invoice_terms_and_conditions' => null,
        'default_note_on_invoice' => null,
        'default_note_on_credit_note' => null,
        'next_quote_number' => 'int32',
        'quote_number_prefix' => null,
        'estimate_number_prefix' => null,
        'quote_default_days_to_expiry' => 'int32',
        'estimate_default_days_to_expiry' => 'int32',
        'quote_terms_and_conditions' => null,
        'estimate_terms_and_conditions' => null,
        'delivery_note_terms_and_conditions' => null,
        'delivery_note_show_signature' => null,
        'delivery_note_show_picked' => null,
        'delivery_note_show_notes' => null,
        'delivery_note_show_contact_details' => null,
        'quick_entry_prefix' => null,
        'late_payment_percentage' => 'double',
        'prompt_payment_percentage' => 'double',
        'show_auto_entrepreneur' => null,
        'show_insurance' => null,
        'insurance_area' => null,
        'insurance_type' => null,
        'insurance_text' => null,
        'payment_bank_account_id' => null,
        'sales_corrective_invoice_number_prefix' => null,
        'next_sales_corrective_invoice_number' => 'int32',
        'customer_credit_days' => 'int32',
        'vendor_credit_days' => 'int32',
        'insurer' => null,
        'document_headings' => null,
        'line_item_titles' => null,
        'footer_details' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'next_invoice_number' => 'next_invoice_number',
        'next_credit_note_number' => 'next_credit_note_number',
        'separate_invoice_credit_note_numbering' => 'separate_invoice_credit_note_numbering',
        'sales_invoice_number_prefix' => 'sales_invoice_number_prefix',
        'sales_credit_note_number_prefix' => 'sales_credit_note_number_prefix',
        'invoice_terms_and_conditions' => 'invoice_terms_and_conditions',
        'default_note_on_invoice' => 'default_note_on_invoice',
        'default_note_on_credit_note' => 'default_note_on_credit_note',
        'next_quote_number' => 'next_quote_number',
        'quote_number_prefix' => 'quote_number_prefix',
        'estimate_number_prefix' => 'estimate_number_prefix',
        'quote_default_days_to_expiry' => 'quote_default_days_to_expiry',
        'estimate_default_days_to_expiry' => 'estimate_default_days_to_expiry',
        'quote_terms_and_conditions' => 'quote_terms_and_conditions',
        'estimate_terms_and_conditions' => 'estimate_terms_and_conditions',
        'delivery_note_terms_and_conditions' => 'delivery_note_terms_and_conditions',
        'delivery_note_show_signature' => 'delivery_note_show_signature',
        'delivery_note_show_picked' => 'delivery_note_show_picked',
        'delivery_note_show_notes' => 'delivery_note_show_notes',
        'delivery_note_show_contact_details' => 'delivery_note_show_contact_details',
        'quick_entry_prefix' => 'quick_entry_prefix',
        'late_payment_percentage' => 'late_payment_percentage',
        'prompt_payment_percentage' => 'prompt_payment_percentage',
        'show_auto_entrepreneur' => 'show_auto_entrepreneur',
        'show_insurance' => 'show_insurance',
        'insurance_area' => 'insurance_area',
        'insurance_type' => 'insurance_type',
        'insurance_text' => 'insurance_text',
        'payment_bank_account_id' => 'payment_bank_account_id',
        'sales_corrective_invoice_number_prefix' => 'sales_corrective_invoice_number_prefix',
        'next_sales_corrective_invoice_number' => 'next_sales_corrective_invoice_number',
        'customer_credit_days' => 'customer_credit_days',
        'vendor_credit_days' => 'vendor_credit_days',
        'insurer' => 'insurer',
        'document_headings' => 'document_headings',
        'line_item_titles' => 'line_item_titles',
        'footer_details' => 'footer_details'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'next_invoice_number' => 'setNextInvoiceNumber',
        'next_credit_note_number' => 'setNextCreditNoteNumber',
        'separate_invoice_credit_note_numbering' => 'setSeparateInvoiceCreditNoteNumbering',
        'sales_invoice_number_prefix' => 'setSalesInvoiceNumberPrefix',
        'sales_credit_note_number_prefix' => 'setSalesCreditNoteNumberPrefix',
        'invoice_terms_and_conditions' => 'setInvoiceTermsAndConditions',
        'default_note_on_invoice' => 'setDefaultNoteOnInvoice',
        'default_note_on_credit_note' => 'setDefaultNoteOnCreditNote',
        'next_quote_number' => 'setNextQuoteNumber',
        'quote_number_prefix' => 'setQuoteNumberPrefix',
        'estimate_number_prefix' => 'setEstimateNumberPrefix',
        'quote_default_days_to_expiry' => 'setQuoteDefaultDaysToExpiry',
        'estimate_default_days_to_expiry' => 'setEstimateDefaultDaysToExpiry',
        'quote_terms_and_conditions' => 'setQuoteTermsAndConditions',
        'estimate_terms_and_conditions' => 'setEstimateTermsAndConditions',
        'delivery_note_terms_and_conditions' => 'setDeliveryNoteTermsAndConditions',
        'delivery_note_show_signature' => 'setDeliveryNoteShowSignature',
        'delivery_note_show_picked' => 'setDeliveryNoteShowPicked',
        'delivery_note_show_notes' => 'setDeliveryNoteShowNotes',
        'delivery_note_show_contact_details' => 'setDeliveryNoteShowContactDetails',
        'quick_entry_prefix' => 'setQuickEntryPrefix',
        'late_payment_percentage' => 'setLatePaymentPercentage',
        'prompt_payment_percentage' => 'setPromptPaymentPercentage',
        'show_auto_entrepreneur' => 'setShowAutoEntrepreneur',
        'show_insurance' => 'setShowInsurance',
        'insurance_area' => 'setInsuranceArea',
        'insurance_type' => 'setInsuranceType',
        'insurance_text' => 'setInsuranceText',
        'payment_bank_account_id' => 'setPaymentBankAccountId',
        'sales_corrective_invoice_number_prefix' => 'setSalesCorrectiveInvoiceNumberPrefix',
        'next_sales_corrective_invoice_number' => 'setNextSalesCorrectiveInvoiceNumber',
        'customer_credit_days' => 'setCustomerCreditDays',
        'vendor_credit_days' => 'setVendorCreditDays',
        'insurer' => 'setInsurer',
        'document_headings' => 'setDocumentHeadings',
        'line_item_titles' => 'setLineItemTitles',
        'footer_details' => 'setFooterDetails'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'next_invoice_number' => 'getNextInvoiceNumber',
        'next_credit_note_number' => 'getNextCreditNoteNumber',
        'separate_invoice_credit_note_numbering' => 'getSeparateInvoiceCreditNoteNumbering',
        'sales_invoice_number_prefix' => 'getSalesInvoiceNumberPrefix',
        'sales_credit_note_number_prefix' => 'getSalesCreditNoteNumberPrefix',
        'invoice_terms_and_conditions' => 'getInvoiceTermsAndConditions',
        'default_note_on_invoice' => 'getDefaultNoteOnInvoice',
        'default_note_on_credit_note' => 'getDefaultNoteOnCreditNote',
        'next_quote_number' => 'getNextQuoteNumber',
        'quote_number_prefix' => 'getQuoteNumberPrefix',
        'estimate_number_prefix' => 'getEstimateNumberPrefix',
        'quote_default_days_to_expiry' => 'getQuoteDefaultDaysToExpiry',
        'estimate_default_days_to_expiry' => 'getEstimateDefaultDaysToExpiry',
        'quote_terms_and_conditions' => 'getQuoteTermsAndConditions',
        'estimate_terms_and_conditions' => 'getEstimateTermsAndConditions',
        'delivery_note_terms_and_conditions' => 'getDeliveryNoteTermsAndConditions',
        'delivery_note_show_signature' => 'getDeliveryNoteShowSignature',
        'delivery_note_show_picked' => 'getDeliveryNoteShowPicked',
        'delivery_note_show_notes' => 'getDeliveryNoteShowNotes',
        'delivery_note_show_contact_details' => 'getDeliveryNoteShowContactDetails',
        'quick_entry_prefix' => 'getQuickEntryPrefix',
        'late_payment_percentage' => 'getLatePaymentPercentage',
        'prompt_payment_percentage' => 'getPromptPaymentPercentage',
        'show_auto_entrepreneur' => 'getShowAutoEntrepreneur',
        'show_insurance' => 'getShowInsurance',
        'insurance_area' => 'getInsuranceArea',
        'insurance_type' => 'getInsuranceType',
        'insurance_text' => 'getInsuranceText',
        'payment_bank_account_id' => 'getPaymentBankAccountId',
        'sales_corrective_invoice_number_prefix' => 'getSalesCorrectiveInvoiceNumberPrefix',
        'next_sales_corrective_invoice_number' => 'getNextSalesCorrectiveInvoiceNumber',
        'customer_credit_days' => 'getCustomerCreditDays',
        'vendor_credit_days' => 'getVendorCreditDays',
        'insurer' => 'getInsurer',
        'document_headings' => 'getDocumentHeadings',
        'line_item_titles' => 'getLineItemTitles',
        'footer_details' => 'getFooterDetails'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['next_invoice_number'] = $data['next_invoice_number'] ?? null;
        $this->container['next_credit_note_number'] = $data['next_credit_note_number'] ?? null;
        $this->container['separate_invoice_credit_note_numbering'] = $data['separate_invoice_credit_note_numbering'] ?? null;
        $this->container['sales_invoice_number_prefix'] = $data['sales_invoice_number_prefix'] ?? null;
        $this->container['sales_credit_note_number_prefix'] = $data['sales_credit_note_number_prefix'] ?? null;
        $this->container['invoice_terms_and_conditions'] = $data['invoice_terms_and_conditions'] ?? null;
        $this->container['default_note_on_invoice'] = $data['default_note_on_invoice'] ?? null;
        $this->container['default_note_on_credit_note'] = $data['default_note_on_credit_note'] ?? null;
        $this->container['next_quote_number'] = $data['next_quote_number'] ?? null;
        $this->container['quote_number_prefix'] = $data['quote_number_prefix'] ?? null;
        $this->container['estimate_number_prefix'] = $data['estimate_number_prefix'] ?? null;
        $this->container['quote_default_days_to_expiry'] = $data['quote_default_days_to_expiry'] ?? null;
        $this->container['estimate_default_days_to_expiry'] = $data['estimate_default_days_to_expiry'] ?? null;
        $this->container['quote_terms_and_conditions'] = $data['quote_terms_and_conditions'] ?? null;
        $this->container['estimate_terms_and_conditions'] = $data['estimate_terms_and_conditions'] ?? null;
        $this->container['delivery_note_terms_and_conditions'] = $data['delivery_note_terms_and_conditions'] ?? null;
        $this->container['delivery_note_show_signature'] = $data['delivery_note_show_signature'] ?? null;
        $this->container['delivery_note_show_picked'] = $data['delivery_note_show_picked'] ?? null;
        $this->container['delivery_note_show_notes'] = $data['delivery_note_show_notes'] ?? null;
        $this->container['delivery_note_show_contact_details'] = $data['delivery_note_show_contact_details'] ?? null;
        $this->container['quick_entry_prefix'] = $data['quick_entry_prefix'] ?? null;
        $this->container['late_payment_percentage'] = $data['late_payment_percentage'] ?? null;
        $this->container['prompt_payment_percentage'] = $data['prompt_payment_percentage'] ?? null;
        $this->container['show_auto_entrepreneur'] = $data['show_auto_entrepreneur'] ?? null;
        $this->container['show_insurance'] = $data['show_insurance'] ?? null;
        $this->container['insurance_area'] = $data['insurance_area'] ?? null;
        $this->container['insurance_type'] = $data['insurance_type'] ?? null;
        $this->container['insurance_text'] = $data['insurance_text'] ?? null;
        $this->container['payment_bank_account_id'] = $data['payment_bank_account_id'] ?? null;
        $this->container['sales_corrective_invoice_number_prefix'] = $data['sales_corrective_invoice_number_prefix'] ?? null;
        $this->container['next_sales_corrective_invoice_number'] = $data['next_sales_corrective_invoice_number'] ?? null;
        $this->container['customer_credit_days'] = $data['customer_credit_days'] ?? null;
        $this->container['vendor_credit_days'] = $data['vendor_credit_days'] ?? null;
        $this->container['insurer'] = $data['insurer'] ?? null;
        $this->container['document_headings'] = $data['document_headings'] ?? null;
        $this->container['line_item_titles'] = $data['line_item_titles'] ?? null;
        $this->container['footer_details'] = $data['footer_details'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets next_invoice_number
     *
     * @return int|null
     */
    public function getNextInvoiceNumber()
    {
        return $this->container['next_invoice_number'];
    }

    /**
     * Sets next_invoice_number
     *
     * @param int|null $next_invoice_number The next invoice number
     *
     * @return self
     */
    public function setNextInvoiceNumber($next_invoice_number)
    {
        $this->container['next_invoice_number'] = $next_invoice_number;

        return $this;
    }

    /**
     * Gets next_credit_note_number
     *
     * @return int|null
     */
    public function getNextCreditNoteNumber()
    {
        return $this->container['next_credit_note_number'];
    }

    /**
     * Sets next_credit_note_number
     *
     * @param int|null $next_credit_note_number The next credit note number
     *
     * @return self
     */
    public function setNextCreditNoteNumber($next_credit_note_number)
    {
        $this->container['next_credit_note_number'] = $next_credit_note_number;

        return $this;
    }

    /**
     * Gets separate_invoice_credit_note_numbering
     *
     * @return bool|null
     */
    public function getSeparateInvoiceCreditNoteNumbering()
    {
        return $this->container['separate_invoice_credit_note_numbering'];
    }

    /**
     * Sets separate_invoice_credit_note_numbering
     *
     * @param bool|null $separate_invoice_credit_note_numbering Indicates whether to use separate or combined number sequences for invoices and credit notes
     *
     * @return self
     */
    public function setSeparateInvoiceCreditNoteNumbering($separate_invoice_credit_note_numbering)
    {
        $this->container['separate_invoice_credit_note_numbering'] = $separate_invoice_credit_note_numbering;

        return $this;
    }

    /**
     * Gets sales_invoice_number_prefix
     *
     * @return string|null
     */
    public function getSalesInvoiceNumberPrefix()
    {
        return $this->container['sales_invoice_number_prefix'];
    }

    /**
     * Sets sales_invoice_number_prefix
     *
     * @param string|null $sales_invoice_number_prefix The prefix to use for sales invoices
     *
     * @return self
     */
    public function setSalesInvoiceNumberPrefix($sales_invoice_number_prefix)
    {
        $this->container['sales_invoice_number_prefix'] = $sales_invoice_number_prefix;

        return $this;
    }

    /**
     * Gets sales_credit_note_number_prefix
     *
     * @return string|null
     */
    public function getSalesCreditNoteNumberPrefix()
    {
        return $this->container['sales_credit_note_number_prefix'];
    }

    /**
     * Sets sales_credit_note_number_prefix
     *
     * @param string|null $sales_credit_note_number_prefix The prefix to use for sales credit notes
     *
     * @return self
     */
    public function setSalesCreditNoteNumberPrefix($sales_credit_note_number_prefix)
    {
        $this->container['sales_credit_note_number_prefix'] = $sales_credit_note_number_prefix;

        return $this;
    }

    /**
     * Gets invoice_terms_and_conditions
     *
     * @return string|null
     */
    public function getInvoiceTermsAndConditions()
    {
        return $this->container['invoice_terms_and_conditions'];
    }

    /**
     * Sets invoice_terms_and_conditions
     *
     * @param string|null $invoice_terms_and_conditions The default terms and conditions to include on invoices
     *
     * @return self
     */
    public function setInvoiceTermsAndConditions($invoice_terms_and_conditions)
    {
        $this->container['invoice_terms_and_conditions'] = $invoice_terms_and_conditions;

        return $this;
    }

    /**
     * Gets default_note_on_invoice
     *
     * @return string|null
     */
    public function getDefaultNoteOnInvoice()
    {
        return $this->container['default_note_on_invoice'];
    }

    /**
     * Sets default_note_on_invoice
     *
     * @param string|null $default_note_on_invoice The default notes to include on invoices
     *
     * @return self
     */
    public function setDefaultNoteOnInvoice($default_note_on_invoice)
    {
        $this->container['default_note_on_invoice'] = $default_note_on_invoice;

        return $this;
    }

    /**
     * Gets default_note_on_credit_note
     *
     * @return string|null
     */
    public function getDefaultNoteOnCreditNote()
    {
        return $this->container['default_note_on_credit_note'];
    }

    /**
     * Sets default_note_on_credit_note
     *
     * @param string|null $default_note_on_credit_note The default notes to include on credit notes
     *
     * @return self
     */
    public function setDefaultNoteOnCreditNote($default_note_on_credit_note)
    {
        $this->container['default_note_on_credit_note'] = $default_note_on_credit_note;

        return $this;
    }

    /**
     * Gets next_quote_number
     *
     * @return int|null
     */
    public function getNextQuoteNumber()
    {
        return $this->container['next_quote_number'];
    }

    /**
     * Sets next_quote_number
     *
     * @param int|null $next_quote_number The next quote number
     *
     * @return self
     */
    public function setNextQuoteNumber($next_quote_number)
    {
        $this->container['next_quote_number'] = $next_quote_number;

        return $this;
    }

    /**
     * Gets quote_number_prefix
     *
     * @return string|null
     */
    public function getQuoteNumberPrefix()
    {
        return $this->container['quote_number_prefix'];
    }

    /**
     * Sets quote_number_prefix
     *
     * @param string|null $quote_number_prefix The prefix to use for sales quotes
     *
     * @return self
     */
    public function setQuoteNumberPrefix($quote_number_prefix)
    {
        $this->container['quote_number_prefix'] = $quote_number_prefix;

        return $this;
    }

    /**
     * Gets estimate_number_prefix
     *
     * @return string|null
     */
    public function getEstimateNumberPrefix()
    {
        return $this->container['estimate_number_prefix'];
    }

    /**
     * Sets estimate_number_prefix
     *
     * @param string|null $estimate_number_prefix The prefix to use for sales estimates
     *
     * @return self
     */
    public function setEstimateNumberPrefix($estimate_number_prefix)
    {
        $this->container['estimate_number_prefix'] = $estimate_number_prefix;

        return $this;
    }

    /**
     * Gets quote_default_days_to_expiry
     *
     * @return int|null
     */
    public function getQuoteDefaultDaysToExpiry()
    {
        return $this->container['quote_default_days_to_expiry'];
    }

    /**
     * Sets quote_default_days_to_expiry
     *
     * @param int|null $quote_default_days_to_expiry The default number of days before quotes expire
     *
     * @return self
     */
    public function setQuoteDefaultDaysToExpiry($quote_default_days_to_expiry)
    {
        $this->container['quote_default_days_to_expiry'] = $quote_default_days_to_expiry;

        return $this;
    }

    /**
     * Gets estimate_default_days_to_expiry
     *
     * @return int|null
     */
    public function getEstimateDefaultDaysToExpiry()
    {
        return $this->container['estimate_default_days_to_expiry'];
    }

    /**
     * Sets estimate_default_days_to_expiry
     *
     * @param int|null $estimate_default_days_to_expiry The default number of days before estimates expire
     *
     * @return self
     */
    public function setEstimateDefaultDaysToExpiry($estimate_default_days_to_expiry)
    {
        $this->container['estimate_default_days_to_expiry'] = $estimate_default_days_to_expiry;

        return $this;
    }

    /**
     * Gets quote_terms_and_conditions
     *
     * @return string|null
     */
    public function getQuoteTermsAndConditions()
    {
        return $this->container['quote_terms_and_conditions'];
    }

    /**
     * Sets quote_terms_and_conditions
     *
     * @param string|null $quote_terms_and_conditions The default terms and conditions to include on quotes
     *
     * @return self
     */
    public function setQuoteTermsAndConditions($quote_terms_and_conditions)
    {
        $this->container['quote_terms_and_conditions'] = $quote_terms_and_conditions;

        return $this;
    }

    /**
     * Gets estimate_terms_and_conditions
     *
     * @return string|null
     */
    public function getEstimateTermsAndConditions()
    {
        return $this->container['estimate_terms_and_conditions'];
    }

    /**
     * Sets estimate_terms_and_conditions
     *
     * @param string|null $estimate_terms_and_conditions The default terms and conditions to include on estimates
     *
     * @return self
     */
    public function setEstimateTermsAndConditions($estimate_terms_and_conditions)
    {
        $this->container['estimate_terms_and_conditions'] = $estimate_terms_and_conditions;

        return $this;
    }

    /**
     * Gets delivery_note_terms_and_conditions
     *
     * @return string|null
     */
    public function getDeliveryNoteTermsAndConditions()
    {
        return $this->container['delivery_note_terms_and_conditions'];
    }

    /**
     * Sets delivery_note_terms_and_conditions
     *
     * @param string|null $delivery_note_terms_and_conditions The default terms and conditions to include on delivery notes
     *
     * @return self
     */
    public function setDeliveryNoteTermsAndConditions($delivery_note_terms_and_conditions)
    {
        $this->container['delivery_note_terms_and_conditions'] = $delivery_note_terms_and_conditions;

        return $this;
    }

    /**
     * Gets delivery_note_show_signature
     *
     * @return bool|null
     */
    public function getDeliveryNoteShowSignature()
    {
        return $this->container['delivery_note_show_signature'];
    }

    /**
     * Sets delivery_note_show_signature
     *
     * @param bool|null $delivery_note_show_signature Indicates whether to include the signature lines on delivery notes
     *
     * @return self
     */
    public function setDeliveryNoteShowSignature($delivery_note_show_signature)
    {
        $this->container['delivery_note_show_signature'] = $delivery_note_show_signature;

        return $this;
    }

    /**
     * Gets delivery_note_show_picked
     *
     * @return bool|null
     */
    public function getDeliveryNoteShowPicked()
    {
        return $this->container['delivery_note_show_picked'];
    }

    /**
     * Sets delivery_note_show_picked
     *
     * @param bool|null $delivery_note_show_picked Indicates whether to include the picked column on delivery notes
     *
     * @return self
     */
    public function setDeliveryNoteShowPicked($delivery_note_show_picked)
    {
        $this->container['delivery_note_show_picked'] = $delivery_note_show_picked;

        return $this;
    }

    /**
     * Gets delivery_note_show_notes
     *
     * @return bool|null
     */
    public function getDeliveryNoteShowNotes()
    {
        return $this->container['delivery_note_show_notes'];
    }

    /**
     * Sets delivery_note_show_notes
     *
     * @param bool|null $delivery_note_show_notes Indicates whether to include the document notes on delivery notes
     *
     * @return self
     */
    public function setDeliveryNoteShowNotes($delivery_note_show_notes)
    {
        $this->container['delivery_note_show_notes'] = $delivery_note_show_notes;

        return $this;
    }

    /**
     * Gets delivery_note_show_contact_details
     *
     * @return bool|null
     */
    public function getDeliveryNoteShowContactDetails()
    {
        return $this->container['delivery_note_show_contact_details'];
    }

    /**
     * Sets delivery_note_show_contact_details
     *
     * @param bool|null $delivery_note_show_contact_details Indicates whether to include contact details on delivery notes
     *
     * @return self
     */
    public function setDeliveryNoteShowContactDetails($delivery_note_show_contact_details)
    {
        $this->container['delivery_note_show_contact_details'] = $delivery_note_show_contact_details;

        return $this;
    }

    /**
     * Gets quick_entry_prefix
     *
     * @return string|null
     */
    public function getQuickEntryPrefix()
    {
        return $this->container['quick_entry_prefix'];
    }

    /**
     * Sets quick_entry_prefix
     *
     * @param string|null $quick_entry_prefix The prefix to use for quick entries
     *
     * @return self
     */
    public function setQuickEntryPrefix($quick_entry_prefix)
    {
        $this->container['quick_entry_prefix'] = $quick_entry_prefix;

        return $this;
    }

    /**
     * Gets late_payment_percentage
     *
     * @return double|null
     */
    public function getLatePaymentPercentage()
    {
        return $this->container['late_payment_percentage'];
    }

    /**
     * Sets late_payment_percentage
     *
     * @param double|null $late_payment_percentage The percentage charge applied to late payment of invoices (France only)
     *
     * @return self
     */
    public function setLatePaymentPercentage($late_payment_percentage)
    {
        $this->container['late_payment_percentage'] = $late_payment_percentage;

        return $this;
    }

    /**
     * Gets prompt_payment_percentage
     *
     * @return double|null
     */
    public function getPromptPaymentPercentage()
    {
        return $this->container['prompt_payment_percentage'];
    }

    /**
     * Sets prompt_payment_percentage
     *
     * @param double|null $prompt_payment_percentage The percentage applied to late payment of invoices (France only)
     *
     * @return self
     */
    public function setPromptPaymentPercentage($prompt_payment_percentage)
    {
        $this->container['prompt_payment_percentage'] = $prompt_payment_percentage;

        return $this;
    }

    /**
     * Gets show_auto_entrepreneur
     *
     * @return bool|null
     */
    public function getShowAutoEntrepreneur()
    {
        return $this->container['show_auto_entrepreneur'];
    }

    /**
     * Sets show_auto_entrepreneur
     *
     * @param bool|null $show_auto_entrepreneur Indicates whether to include auto entrepreneur details on invoices (France only)
     *
     * @return self
     */
    public function setShowAutoEntrepreneur($show_auto_entrepreneur)
    {
        $this->container['show_auto_entrepreneur'] = $show_auto_entrepreneur;

        return $this;
    }

    /**
     * Gets show_insurance
     *
     * @return bool|null
     */
    public function getShowInsurance()
    {
        return $this->container['show_insurance'];
    }

    /**
     * Sets show_insurance
     *
     * @param bool|null $show_insurance Indicates whether to include insurance details on invoices (France only)
     *
     * @return self
     */
    public function setShowInsurance($show_insurance)
    {
        $this->container['show_insurance'] = $show_insurance;

        return $this;
    }

    /**
     * Gets insurance_area
     *
     * @return string|null
     */
    public function getInsuranceArea()
    {
        return $this->container['insurance_area'];
    }

    /**
     * Sets insurance_area
     *
     * @param string|null $insurance_area The insurance area to be displayed on invoices (France only)
     *
     * @return self
     */
    public function setInsuranceArea($insurance_area)
    {
        $this->container['insurance_area'] = $insurance_area;

        return $this;
    }

    /**
     * Gets insurance_type
     *
     * @return string|null
     */
    public function getInsuranceType()
    {
        return $this->container['insurance_type'];
    }

    /**
     * Sets insurance_type
     *
     * @param string|null $insurance_type The insurance type to be displayed on invoices (France only)
     *
     * @return self
     */
    public function setInsuranceType($insurance_type)
    {
        $this->container['insurance_type'] = $insurance_type;

        return $this;
    }

    /**
     * Gets insurance_text
     *
     * @return string|null
     */
    public function getInsuranceText()
    {
        return $this->container['insurance_text'];
    }

    /**
     * Sets insurance_text
     *
     * @param string|null $insurance_text The insurance mention to be displayed on invoices (France only)
     *
     * @return self
     */
    public function setInsuranceText($insurance_text)
    {
        $this->container['insurance_text'] = $insurance_text;

        return $this;
    }

    /**
     * Gets payment_bank_account_id
     *
     * @return string|null
     */
    public function getPaymentBankAccountId()
    {
        return $this->container['payment_bank_account_id'];
    }

    /**
     * Sets payment_bank_account_id
     *
     * @param string|null $payment_bank_account_id The ID of the Payment Bank Account.
     *
     * @return self
     */
    public function setPaymentBankAccountId($payment_bank_account_id)
    {
        $this->container['payment_bank_account_id'] = $payment_bank_account_id;

        return $this;
    }

    /**
     * Gets sales_corrective_invoice_number_prefix
     *
     * @return string|null
     */
    public function getSalesCorrectiveInvoiceNumberPrefix()
    {
        return $this->container['sales_corrective_invoice_number_prefix'];
    }

    /**
     * Sets sales_corrective_invoice_number_prefix
     *
     * @param string|null $sales_corrective_invoice_number_prefix The sales corrective invoice number prefix (Spain only)
     *
     * @return self
     */
    public function setSalesCorrectiveInvoiceNumberPrefix($sales_corrective_invoice_number_prefix)
    {
        $this->container['sales_corrective_invoice_number_prefix'] = $sales_corrective_invoice_number_prefix;

        return $this;
    }

    /**
     * Gets next_sales_corrective_invoice_number
     *
     * @return int|null
     */
    public function getNextSalesCorrectiveInvoiceNumber()
    {
        return $this->container['next_sales_corrective_invoice_number'];
    }

    /**
     * Sets next_sales_corrective_invoice_number
     *
     * @param int|null $next_sales_corrective_invoice_number The next sales corrective invoice number
     *
     * @return self
     */
    public function setNextSalesCorrectiveInvoiceNumber($next_sales_corrective_invoice_number)
    {
        $this->container['next_sales_corrective_invoice_number'] = $next_sales_corrective_invoice_number;

        return $this;
    }

    /**
     * Gets customer_credit_days
     *
     * @return int|null
     */
    public function getCustomerCreditDays()
    {
        return $this->container['customer_credit_days'];
    }

    /**
     * Sets customer_credit_days
     *
     * @param int|null $customer_credit_days The default delay within which the business' customer has to pay an invoice Prefer the (customer) contact's attribute 'credit_days' over this setting to calculate an invoice's date of payment; only if null, use this as default.
     *
     * @return self
     */
    public function setCustomerCreditDays($customer_credit_days)
    {
        $this->container['customer_credit_days'] = $customer_credit_days;

        return $this;
    }

    /**
     * Gets vendor_credit_days
     *
     * @return int|null
     */
    public function getVendorCreditDays()
    {
        return $this->container['vendor_credit_days'];
    }

    /**
     * Sets vendor_credit_days
     *
     * @param int|null $vendor_credit_days The default delay within which the business has to pay any vendor's invoice Prefer the specific (vendor) contact's attribute 'credit_days' over this setting; only if null, use this as default.
     *
     * @return self
     */
    public function setVendorCreditDays($vendor_credit_days)
    {
        $this->container['vendor_credit_days'] = $vendor_credit_days;

        return $this;
    }

    /**
     * Gets insurer
     *
     * @return \SageOne\Model\PostProductsProductUsualSupplier|null
     */
    public function getInsurer()
    {
        return $this->container['insurer'];
    }

    /**
     * Sets insurer
     *
     * @param \SageOne\Model\PostProductsProductUsualSupplier|null $insurer insurer
     *
     * @return self
     */
    public function setInsurer($insurer)
    {
        $this->container['insurer'] = $insurer;

        return $this;
    }

    /**
     * Gets document_headings
     *
     * @return \SageOne\Model\PutInvoiceSettingsInvoiceSettingsDocumentHeadings|null
     */
    public function getDocumentHeadings()
    {
        return $this->container['document_headings'];
    }

    /**
     * Sets document_headings
     *
     * @param \SageOne\Model\PutInvoiceSettingsInvoiceSettingsDocumentHeadings|null $document_headings document_headings
     *
     * @return self
     */
    public function setDocumentHeadings($document_headings)
    {
        $this->container['document_headings'] = $document_headings;

        return $this;
    }

    /**
     * Gets line_item_titles
     *
     * @return \SageOne\Model\PutInvoiceSettingsInvoiceSettingsLineItemTitles|null
     */
    public function getLineItemTitles()
    {
        return $this->container['line_item_titles'];
    }

    /**
     * Sets line_item_titles
     *
     * @param \SageOne\Model\PutInvoiceSettingsInvoiceSettingsLineItemTitles|null $line_item_titles line_item_titles
     *
     * @return self
     */
    public function setLineItemTitles($line_item_titles)
    {
        $this->container['line_item_titles'] = $line_item_titles;

        return $this;
    }

    /**
     * Gets footer_details
     *
     * @return \SageOne\Model\PutInvoiceSettingsInvoiceSettingsFooterDetails|null
     */
    public function getFooterDetails()
    {
        return $this->container['footer_details'];
    }

    /**
     * Sets footer_details
     *
     * @param \SageOne\Model\PutInvoiceSettingsInvoiceSettingsFooterDetails|null $footer_details footer_details
     *
     * @return self
     */
    public function setFooterDetails($footer_details)
    {
        $this->container['footer_details'] = $footer_details;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


