<?php
/**
 * PutContactPaymentsContactPayment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PutContactPaymentsContactPayment Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PutContactPaymentsContactPayment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'putContactPayments_contact_payment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_type_id' => 'string',
        'contact_id' => 'string',
        'bank_account_id' => 'string',
        'date' => '\DateTime',
        'total_amount' => 'double',
        'transaction_id' => 'string',
        'deleted_at' => '\DateTime',
        'payment_method_id' => 'string',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'currency_id' => 'string',
        'exchange_rate' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_currency_charge' => 'double',
        'reference' => 'string',
        'tax_rate_id' => 'string',
        'editable' => 'bool',
        'links' => '\SageOne\Model\PostContactsContactLinksInner[]',
        'allocated_artefacts' => '\SageOne\Model\PostContactPaymentsContactPaymentAllocatedArtefactsInner[]',
        'payment_on_account' => '\SageOne\Model\PostContactPaymentsContactPaymentPaymentOnAccount'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_type_id' => null,
        'contact_id' => null,
        'bank_account_id' => null,
        'date' => 'date',
        'total_amount' => 'double',
        'transaction_id' => null,
        'deleted_at' => 'date-time',
        'payment_method_id' => null,
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'currency_id' => null,
        'exchange_rate' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_currency_charge' => 'double',
        'reference' => null,
        'tax_rate_id' => null,
        'editable' => null,
        'links' => null,
        'allocated_artefacts' => null,
        'payment_on_account' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_type_id' => 'transaction_type_id',
        'contact_id' => 'contact_id',
        'bank_account_id' => 'bank_account_id',
        'date' => 'date',
        'total_amount' => 'total_amount',
        'transaction_id' => 'transaction_id',
        'deleted_at' => 'deleted_at',
        'payment_method_id' => 'payment_method_id',
        'net_amount' => 'net_amount',
        'tax_amount' => 'tax_amount',
        'currency_id' => 'currency_id',
        'exchange_rate' => 'exchange_rate',
        'base_currency_net_amount' => 'base_currency_net_amount',
        'base_currency_tax_amount' => 'base_currency_tax_amount',
        'base_currency_total_amount' => 'base_currency_total_amount',
        'base_currency_currency_charge' => 'base_currency_currency_charge',
        'reference' => 'reference',
        'tax_rate_id' => 'tax_rate_id',
        'editable' => 'editable',
        'links' => 'links',
        'allocated_artefacts' => 'allocated_artefacts',
        'payment_on_account' => 'payment_on_account'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_type_id' => 'setTransactionTypeId',
        'contact_id' => 'setContactId',
        'bank_account_id' => 'setBankAccountId',
        'date' => 'setDate',
        'total_amount' => 'setTotalAmount',
        'transaction_id' => 'setTransactionId',
        'deleted_at' => 'setDeletedAt',
        'payment_method_id' => 'setPaymentMethodId',
        'net_amount' => 'setNetAmount',
        'tax_amount' => 'setTaxAmount',
        'currency_id' => 'setCurrencyId',
        'exchange_rate' => 'setExchangeRate',
        'base_currency_net_amount' => 'setBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'setBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'setBaseCurrencyTotalAmount',
        'base_currency_currency_charge' => 'setBaseCurrencyCurrencyCharge',
        'reference' => 'setReference',
        'tax_rate_id' => 'setTaxRateId',
        'editable' => 'setEditable',
        'links' => 'setLinks',
        'allocated_artefacts' => 'setAllocatedArtefacts',
        'payment_on_account' => 'setPaymentOnAccount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_type_id' => 'getTransactionTypeId',
        'contact_id' => 'getContactId',
        'bank_account_id' => 'getBankAccountId',
        'date' => 'getDate',
        'total_amount' => 'getTotalAmount',
        'transaction_id' => 'getTransactionId',
        'deleted_at' => 'getDeletedAt',
        'payment_method_id' => 'getPaymentMethodId',
        'net_amount' => 'getNetAmount',
        'tax_amount' => 'getTaxAmount',
        'currency_id' => 'getCurrencyId',
        'exchange_rate' => 'getExchangeRate',
        'base_currency_net_amount' => 'getBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'getBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'getBaseCurrencyTotalAmount',
        'base_currency_currency_charge' => 'getBaseCurrencyCurrencyCharge',
        'reference' => 'getReference',
        'tax_rate_id' => 'getTaxRateId',
        'editable' => 'getEditable',
        'links' => 'getLinks',
        'allocated_artefacts' => 'getAllocatedArtefacts',
        'payment_on_account' => 'getPaymentOnAccount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['contact_id'] = $data['contact_id'] ?? null;
        $this->container['bank_account_id'] = $data['bank_account_id'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['payment_method_id'] = $data['payment_method_id'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['currency_id'] = $data['currency_id'] ?? null;
        $this->container['exchange_rate'] = $data['exchange_rate'] ?? null;
        $this->container['base_currency_net_amount'] = $data['base_currency_net_amount'] ?? null;
        $this->container['base_currency_tax_amount'] = $data['base_currency_tax_amount'] ?? null;
        $this->container['base_currency_total_amount'] = $data['base_currency_total_amount'] ?? null;
        $this->container['base_currency_currency_charge'] = $data['base_currency_currency_charge'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['tax_rate_id'] = $data['tax_rate_id'] ?? null;
        $this->container['editable'] = $data['editable'] ?? null;
        $this->container['links'] = $data['links'] ?? null;
        $this->container['allocated_artefacts'] = $data['allocated_artefacts'] ?? null;
        $this->container['payment_on_account'] = $data['payment_on_account'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The transaction type of the payment
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets contact_id
     *
     * @return string|null
     */
    public function getContactId()
    {
        return $this->container['contact_id'];
    }

    /**
     * Sets contact_id
     *
     * @param string|null $contact_id The contact of the payment
     *
     * @return self
     */
    public function setContactId($contact_id)
    {
        $this->container['contact_id'] = $contact_id;

        return $this;
    }

    /**
     * Gets bank_account_id
     *
     * @return string|null
     */
    public function getBankAccountId()
    {
        return $this->container['bank_account_id'];
    }

    /**
     * Sets bank_account_id
     *
     * @param string|null $bank_account_id The bank account of the payment
     *
     * @return self
     */
    public function setBankAccountId($bank_account_id)
    {
        $this->container['bank_account_id'] = $bank_account_id;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date The date the payment was made
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount The total amount of the payment
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets payment_method_id
     *
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->container['payment_method_id'];
    }

    /**
     * Sets payment_method_id
     *
     * @param string|null $payment_method_id The ID of the Payment Method.
     *
     * @return self
     */
    public function setPaymentMethodId($payment_method_id)
    {
        $this->container['payment_method_id'] = $payment_method_id;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double|null $net_amount The net amount of the payment
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double|null $tax_amount The tax amount of the payment
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets currency_id
     *
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->container['currency_id'];
    }

    /**
     * Sets currency_id
     *
     * @param string|null $currency_id The ID of the Currency.
     *
     * @return self
     */
    public function setCurrencyId($currency_id)
    {
        $this->container['currency_id'] = $currency_id;

        return $this;
    }

    /**
     * Gets exchange_rate
     *
     * @return double|null
     */
    public function getExchangeRate()
    {
        return $this->container['exchange_rate'];
    }

    /**
     * Sets exchange_rate
     *
     * @param double|null $exchange_rate The exchange rate of the payment
     *
     * @return self
     */
    public function setExchangeRate($exchange_rate)
    {
        $this->container['exchange_rate'] = $exchange_rate;

        return $this;
    }

    /**
     * Gets base_currency_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyNetAmount()
    {
        return $this->container['base_currency_net_amount'];
    }

    /**
     * Sets base_currency_net_amount
     *
     * @param double|null $base_currency_net_amount The net amount of the payment in base currency
     *
     * @return self
     */
    public function setBaseCurrencyNetAmount($base_currency_net_amount)
    {
        $this->container['base_currency_net_amount'] = $base_currency_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTaxAmount()
    {
        return $this->container['base_currency_tax_amount'];
    }

    /**
     * Sets base_currency_tax_amount
     *
     * @param double|null $base_currency_tax_amount The tax amount of the payment in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxAmount($base_currency_tax_amount)
    {
        $this->container['base_currency_tax_amount'] = $base_currency_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalAmount()
    {
        return $this->container['base_currency_total_amount'];
    }

    /**
     * Sets base_currency_total_amount
     *
     * @param double|null $base_currency_total_amount The total amount of the payment in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTotalAmount($base_currency_total_amount)
    {
        $this->container['base_currency_total_amount'] = $base_currency_total_amount;

        return $this;
    }

    /**
     * Gets base_currency_currency_charge
     *
     * @return double|null
     */
    public function getBaseCurrencyCurrencyCharge()
    {
        return $this->container['base_currency_currency_charge'];
    }

    /**
     * Sets base_currency_currency_charge
     *
     * @param double|null $base_currency_currency_charge The currency conversion charges in base currency
     *
     * @return self
     */
    public function setBaseCurrencyCurrencyCharge($base_currency_currency_charge)
    {
        $this->container['base_currency_currency_charge'] = $base_currency_currency_charge;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference A reference for the payment
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets tax_rate_id
     *
     * @return string|null
     */
    public function getTaxRateId()
    {
        return $this->container['tax_rate_id'];
    }

    /**
     * Sets tax_rate_id
     *
     * @param string|null $tax_rate_id The ID of the Tax Rate.
     *
     * @return self
     */
    public function setTaxRateId($tax_rate_id)
    {
        $this->container['tax_rate_id'] = $tax_rate_id;

        return $this;
    }

    /**
     * Gets editable
     *
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->container['editable'];
    }

    /**
     * Sets editable
     *
     * @param bool|null $editable Indicates whether payment can be edited
     *
     * @return self
     */
    public function setEditable($editable)
    {
        $this->container['editable'] = $editable;

        return $this;
    }

    /**
     * Gets links
     *
     * @return \SageOne\Model\PostContactsContactLinksInner[]|null
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     *
     * @param \SageOne\Model\PostContactsContactLinksInner[]|null $links links
     *
     * @return self
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }

    /**
     * Gets allocated_artefacts
     *
     * @return \SageOne\Model\PostContactPaymentsContactPaymentAllocatedArtefactsInner[]|null
     */
    public function getAllocatedArtefacts()
    {
        return $this->container['allocated_artefacts'];
    }

    /**
     * Sets allocated_artefacts
     *
     * @param \SageOne\Model\PostContactPaymentsContactPaymentAllocatedArtefactsInner[]|null $allocated_artefacts allocated_artefacts
     *
     * @return self
     */
    public function setAllocatedArtefacts($allocated_artefacts)
    {
        $this->container['allocated_artefacts'] = $allocated_artefacts;

        return $this;
    }

    /**
     * Gets payment_on_account
     *
     * @return \SageOne\Model\PostContactPaymentsContactPaymentPaymentOnAccount|null
     */
    public function getPaymentOnAccount()
    {
        return $this->container['payment_on_account'];
    }

    /**
     * Sets payment_on_account
     *
     * @param \SageOne\Model\PostContactPaymentsContactPaymentPaymentOnAccount|null $payment_on_account payment_on_account
     *
     * @return self
     */
    public function setPaymentOnAccount($payment_on_account)
    {
        $this->container['payment_on_account'] = $payment_on_account;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


