<?php
/**
 * PurchaseCorrectiveInvoice
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PurchaseCorrectiveInvoice Class Doc Comment
 *
 * @category Class
 * @description Updates a Purchase Corrective Invoice
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PurchaseCorrectiveInvoice implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PurchaseCorrectiveInvoice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Transaction',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'links' => '\SageOne\Model\Link[]',
        'editable' => 'bool',
        'contact' => '\SageOne\Model\Contact',
        'deleted_at' => '\DateTime',
        'contact_name' => 'string',
        'contact_reference' => 'string',
        'date' => '\DateTime',
        'due_date' => '\DateTime',
        'reference' => 'string',
        'vendor_reference' => 'string',
        'notes' => 'string',
        'total_quantity' => 'double',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'total_amount' => 'double',
        'payments_allocations_total_amount' => 'double',
        'payments_allocations_total_discount' => 'double',
        'total_paid' => 'double',
        'outstanding_amount' => 'double',
        'currency' => '\SageOne\Model\Base',
        'exchange_rate' => 'double',
        'inverse_exchange_rate' => 'string',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_outstanding_amount' => 'double',
        'status' => '\SageOne\Model\Base',
        'void_reason' => 'string',
        'invoice_lines' => '\SageOne\Model\PurchaseInvoiceLineItem[]',
        'tax_analysis' => '\SageOne\Model\ArtefactTaxAnalysis[]',
        'detailed_tax_analysis' => '\SageOne\Model\ArtefactDetailedTaxAnalysis',
        'payments_allocations' => '\SageOne\Model\PaymentAllocation[]',
        'last_paid' => '\DateTime',
        'withholding_tax_rate' => 'double',
        'withholding_tax_amount' => 'double',
        'base_currency_withholding_tax_amount' => 'double',
        'original_invoice' => '\SageOne\Model\Generic',
        'original_invoice_number' => 'string',
        'original_invoice_date' => 'string',
        'tax_reconciled' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'links' => null,
        'editable' => null,
        'contact' => null,
        'deleted_at' => 'date-time',
        'contact_name' => null,
        'contact_reference' => null,
        'date' => 'date',
        'due_date' => 'date',
        'reference' => null,
        'vendor_reference' => null,
        'notes' => null,
        'total_quantity' => 'double',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'total_amount' => 'double',
        'payments_allocations_total_amount' => 'double',
        'payments_allocations_total_discount' => 'double',
        'total_paid' => 'double',
        'outstanding_amount' => 'double',
        'currency' => null,
        'exchange_rate' => 'double',
        'inverse_exchange_rate' => null,
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_outstanding_amount' => 'double',
        'status' => null,
        'void_reason' => null,
        'invoice_lines' => null,
        'tax_analysis' => null,
        'detailed_tax_analysis' => null,
        'payments_allocations' => null,
        'last_paid' => 'date',
        'withholding_tax_rate' => 'double',
        'withholding_tax_amount' => 'double',
        'base_currency_withholding_tax_amount' => 'double',
        'original_invoice' => null,
        'original_invoice_number' => null,
        'original_invoice_date' => null,
        'tax_reconciled' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'links' => 'links',
        'editable' => 'editable',
        'contact' => 'contact',
        'deleted_at' => 'deleted_at',
        'contact_name' => 'contact_name',
        'contact_reference' => 'contact_reference',
        'date' => 'date',
        'due_date' => 'due_date',
        'reference' => 'reference',
        'vendor_reference' => 'vendor_reference',
        'notes' => 'notes',
        'total_quantity' => 'total_quantity',
        'net_amount' => 'net_amount',
        'tax_amount' => 'tax_amount',
        'total_amount' => 'total_amount',
        'payments_allocations_total_amount' => 'payments_allocations_total_amount',
        'payments_allocations_total_discount' => 'payments_allocations_total_discount',
        'total_paid' => 'total_paid',
        'outstanding_amount' => 'outstanding_amount',
        'currency' => 'currency',
        'exchange_rate' => 'exchange_rate',
        'inverse_exchange_rate' => 'inverse_exchange_rate',
        'base_currency_net_amount' => 'base_currency_net_amount',
        'base_currency_tax_amount' => 'base_currency_tax_amount',
        'base_currency_total_amount' => 'base_currency_total_amount',
        'base_currency_outstanding_amount' => 'base_currency_outstanding_amount',
        'status' => 'status',
        'void_reason' => 'void_reason',
        'invoice_lines' => 'invoice_lines',
        'tax_analysis' => 'tax_analysis',
        'detailed_tax_analysis' => 'detailed_tax_analysis',
        'payments_allocations' => 'payments_allocations',
        'last_paid' => 'last_paid',
        'withholding_tax_rate' => 'withholding_tax_rate',
        'withholding_tax_amount' => 'withholding_tax_amount',
        'base_currency_withholding_tax_amount' => 'base_currency_withholding_tax_amount',
        'original_invoice' => 'original_invoice',
        'original_invoice_number' => 'original_invoice_number',
        'original_invoice_date' => 'original_invoice_date',
        'tax_reconciled' => 'tax_reconciled'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'links' => 'setLinks',
        'editable' => 'setEditable',
        'contact' => 'setContact',
        'deleted_at' => 'setDeletedAt',
        'contact_name' => 'setContactName',
        'contact_reference' => 'setContactReference',
        'date' => 'setDate',
        'due_date' => 'setDueDate',
        'reference' => 'setReference',
        'vendor_reference' => 'setVendorReference',
        'notes' => 'setNotes',
        'total_quantity' => 'setTotalQuantity',
        'net_amount' => 'setNetAmount',
        'tax_amount' => 'setTaxAmount',
        'total_amount' => 'setTotalAmount',
        'payments_allocations_total_amount' => 'setPaymentsAllocationsTotalAmount',
        'payments_allocations_total_discount' => 'setPaymentsAllocationsTotalDiscount',
        'total_paid' => 'setTotalPaid',
        'outstanding_amount' => 'setOutstandingAmount',
        'currency' => 'setCurrency',
        'exchange_rate' => 'setExchangeRate',
        'inverse_exchange_rate' => 'setInverseExchangeRate',
        'base_currency_net_amount' => 'setBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'setBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'setBaseCurrencyTotalAmount',
        'base_currency_outstanding_amount' => 'setBaseCurrencyOutstandingAmount',
        'status' => 'setStatus',
        'void_reason' => 'setVoidReason',
        'invoice_lines' => 'setInvoiceLines',
        'tax_analysis' => 'setTaxAnalysis',
        'detailed_tax_analysis' => 'setDetailedTaxAnalysis',
        'payments_allocations' => 'setPaymentsAllocations',
        'last_paid' => 'setLastPaid',
        'withholding_tax_rate' => 'setWithholdingTaxRate',
        'withholding_tax_amount' => 'setWithholdingTaxAmount',
        'base_currency_withholding_tax_amount' => 'setBaseCurrencyWithholdingTaxAmount',
        'original_invoice' => 'setOriginalInvoice',
        'original_invoice_number' => 'setOriginalInvoiceNumber',
        'original_invoice_date' => 'setOriginalInvoiceDate',
        'tax_reconciled' => 'setTaxReconciled'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'links' => 'getLinks',
        'editable' => 'getEditable',
        'contact' => 'getContact',
        'deleted_at' => 'getDeletedAt',
        'contact_name' => 'getContactName',
        'contact_reference' => 'getContactReference',
        'date' => 'getDate',
        'due_date' => 'getDueDate',
        'reference' => 'getReference',
        'vendor_reference' => 'getVendorReference',
        'notes' => 'getNotes',
        'total_quantity' => 'getTotalQuantity',
        'net_amount' => 'getNetAmount',
        'tax_amount' => 'getTaxAmount',
        'total_amount' => 'getTotalAmount',
        'payments_allocations_total_amount' => 'getPaymentsAllocationsTotalAmount',
        'payments_allocations_total_discount' => 'getPaymentsAllocationsTotalDiscount',
        'total_paid' => 'getTotalPaid',
        'outstanding_amount' => 'getOutstandingAmount',
        'currency' => 'getCurrency',
        'exchange_rate' => 'getExchangeRate',
        'inverse_exchange_rate' => 'getInverseExchangeRate',
        'base_currency_net_amount' => 'getBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'getBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'getBaseCurrencyTotalAmount',
        'base_currency_outstanding_amount' => 'getBaseCurrencyOutstandingAmount',
        'status' => 'getStatus',
        'void_reason' => 'getVoidReason',
        'invoice_lines' => 'getInvoiceLines',
        'tax_analysis' => 'getTaxAnalysis',
        'detailed_tax_analysis' => 'getDetailedTaxAnalysis',
        'payments_allocations' => 'getPaymentsAllocations',
        'last_paid' => 'getLastPaid',
        'withholding_tax_rate' => 'getWithholdingTaxRate',
        'withholding_tax_amount' => 'getWithholdingTaxAmount',
        'base_currency_withholding_tax_amount' => 'getBaseCurrencyWithholdingTaxAmount',
        'original_invoice' => 'getOriginalInvoice',
        'original_invoice_number' => 'getOriginalInvoiceNumber',
        'original_invoice_date' => 'getOriginalInvoiceDate',
        'tax_reconciled' => 'getTaxReconciled'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['links'] = $data['links'] ?? null;
        $this->container['editable'] = $data['editable'] ?? null;
        $this->container['contact'] = $data['contact'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['contact_name'] = $data['contact_name'] ?? null;
        $this->container['contact_reference'] = $data['contact_reference'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['due_date'] = $data['due_date'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['vendor_reference'] = $data['vendor_reference'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['total_quantity'] = $data['total_quantity'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['payments_allocations_total_amount'] = $data['payments_allocations_total_amount'] ?? null;
        $this->container['payments_allocations_total_discount'] = $data['payments_allocations_total_discount'] ?? null;
        $this->container['total_paid'] = $data['total_paid'] ?? null;
        $this->container['outstanding_amount'] = $data['outstanding_amount'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['exchange_rate'] = $data['exchange_rate'] ?? null;
        $this->container['inverse_exchange_rate'] = $data['inverse_exchange_rate'] ?? null;
        $this->container['base_currency_net_amount'] = $data['base_currency_net_amount'] ?? null;
        $this->container['base_currency_tax_amount'] = $data['base_currency_tax_amount'] ?? null;
        $this->container['base_currency_total_amount'] = $data['base_currency_total_amount'] ?? null;
        $this->container['base_currency_outstanding_amount'] = $data['base_currency_outstanding_amount'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['void_reason'] = $data['void_reason'] ?? null;
        $this->container['invoice_lines'] = $data['invoice_lines'] ?? null;
        $this->container['tax_analysis'] = $data['tax_analysis'] ?? null;
        $this->container['detailed_tax_analysis'] = $data['detailed_tax_analysis'] ?? null;
        $this->container['payments_allocations'] = $data['payments_allocations'] ?? null;
        $this->container['last_paid'] = $data['last_paid'] ?? null;
        $this->container['withholding_tax_rate'] = $data['withholding_tax_rate'] ?? null;
        $this->container['withholding_tax_amount'] = $data['withholding_tax_amount'] ?? null;
        $this->container['base_currency_withholding_tax_amount'] = $data['base_currency_withholding_tax_amount'] ?? null;
        $this->container['original_invoice'] = $data['original_invoice'] ?? null;
        $this->container['original_invoice_number'] = $data['original_invoice_number'] ?? null;
        $this->container['original_invoice_date'] = $data['original_invoice_date'] ?? null;
        $this->container['tax_reconciled'] = $data['tax_reconciled'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Transaction|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Transaction|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets links
     *
     * @return \SageOne\Model\Link[]|null
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     *
     * @param \SageOne\Model\Link[]|null $links Links for the resource
     *
     * @return self
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }

    /**
     * Gets editable
     *
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->container['editable'];
    }

    /**
     * Sets editable
     *
     * @param bool|null $editable Indicates whether artefact can be edited
     *
     * @return self
     */
    public function setEditable($editable)
    {
        $this->container['editable'] = $editable;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \SageOne\Model\Contact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \SageOne\Model\Contact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets contact_name
     *
     * @return string|null
     */
    public function getContactName()
    {
        return $this->container['contact_name'];
    }

    /**
     * Sets contact_name
     *
     * @param string|null $contact_name The name of the contact when the invoice was created
     *
     * @return self
     */
    public function setContactName($contact_name)
    {
        $this->container['contact_name'] = $contact_name;

        return $this;
    }

    /**
     * Gets contact_reference
     *
     * @return string|null
     */
    public function getContactReference()
    {
        return $this->container['contact_reference'];
    }

    /**
     * Sets contact_reference
     *
     * @param string|null $contact_reference The reference of the contact when the invoice was created
     *
     * @return self
     */
    public function setContactReference($contact_reference)
    {
        $this->container['contact_reference'] = $contact_reference;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date The date of the invoice
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets due_date
     *
     * @return \DateTime|null
     */
    public function getDueDate()
    {
        return $this->container['due_date'];
    }

    /**
     * Sets due_date
     *
     * @param \DateTime|null $due_date The due date of the invoice
     *
     * @return self
     */
    public function setDueDate($due_date)
    {
        $this->container['due_date'] = $due_date;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference The reference for the invoice
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets vendor_reference
     *
     * @return string|null
     */
    public function getVendorReference()
    {
        return $this->container['vendor_reference'];
    }

    /**
     * Sets vendor_reference
     *
     * @param string|null $vendor_reference The vendor reference for the invoice
     *
     * @return self
     */
    public function setVendorReference($vendor_reference)
    {
        $this->container['vendor_reference'] = $vendor_reference;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Invoice notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets total_quantity
     *
     * @return double|null
     */
    public function getTotalQuantity()
    {
        return $this->container['total_quantity'];
    }

    /**
     * Sets total_quantity
     *
     * @param double|null $total_quantity The total quantity of the invoice
     *
     * @return self
     */
    public function setTotalQuantity($total_quantity)
    {
        $this->container['total_quantity'] = $total_quantity;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double|null $net_amount The net amount of the invoice
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double|null $tax_amount The tax amount of the invoice
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount The total amount of the invoice
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets payments_allocations_total_amount
     *
     * @return double|null
     */
    public function getPaymentsAllocationsTotalAmount()
    {
        return $this->container['payments_allocations_total_amount'];
    }

    /**
     * Sets payments_allocations_total_amount
     *
     * @param double|null $payments_allocations_total_amount The total amount of all payments and allocations
     *
     * @return self
     */
    public function setPaymentsAllocationsTotalAmount($payments_allocations_total_amount)
    {
        $this->container['payments_allocations_total_amount'] = $payments_allocations_total_amount;

        return $this;
    }

    /**
     * Gets payments_allocations_total_discount
     *
     * @return double|null
     */
    public function getPaymentsAllocationsTotalDiscount()
    {
        return $this->container['payments_allocations_total_discount'];
    }

    /**
     * Sets payments_allocations_total_discount
     *
     * @param double|null $payments_allocations_total_discount The total discount of all payments and allocations
     *
     * @return self
     */
    public function setPaymentsAllocationsTotalDiscount($payments_allocations_total_discount)
    {
        $this->container['payments_allocations_total_discount'] = $payments_allocations_total_discount;

        return $this;
    }

    /**
     * Gets total_paid
     *
     * @return double|null
     */
    public function getTotalPaid()
    {
        return $this->container['total_paid'];
    }

    /**
     * Sets total_paid
     *
     * @param double|null $total_paid The total paid amount of the invoice including any payments, allocations and discounts
     *
     * @return self
     */
    public function setTotalPaid($total_paid)
    {
        $this->container['total_paid'] = $total_paid;

        return $this;
    }

    /**
     * Gets outstanding_amount
     *
     * @return double|null
     */
    public function getOutstandingAmount()
    {
        return $this->container['outstanding_amount'];
    }

    /**
     * Sets outstanding_amount
     *
     * @param double|null $outstanding_amount The outstanding amount of the invoice
     *
     * @return self
     */
    public function setOutstandingAmount($outstanding_amount)
    {
        $this->container['outstanding_amount'] = $outstanding_amount;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \SageOne\Model\Base|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \SageOne\Model\Base|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets exchange_rate
     *
     * @return double|null
     */
    public function getExchangeRate()
    {
        return $this->container['exchange_rate'];
    }

    /**
     * Sets exchange_rate
     *
     * @param double|null $exchange_rate The exchange rate for the invoice
     *
     * @return self
     */
    public function setExchangeRate($exchange_rate)
    {
        $this->container['exchange_rate'] = $exchange_rate;

        return $this;
    }

    /**
     * Gets inverse_exchange_rate
     *
     * @return string|null
     */
    public function getInverseExchangeRate()
    {
        return $this->container['inverse_exchange_rate'];
    }

    /**
     * Sets inverse_exchange_rate
     *
     * @param string|null $inverse_exchange_rate The inverse exchange rate for the credit note
     *
     * @return self
     */
    public function setInverseExchangeRate($inverse_exchange_rate)
    {
        $this->container['inverse_exchange_rate'] = $inverse_exchange_rate;

        return $this;
    }

    /**
     * Gets base_currency_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyNetAmount()
    {
        return $this->container['base_currency_net_amount'];
    }

    /**
     * Sets base_currency_net_amount
     *
     * @param double|null $base_currency_net_amount The net amount of the invoice in base currency
     *
     * @return self
     */
    public function setBaseCurrencyNetAmount($base_currency_net_amount)
    {
        $this->container['base_currency_net_amount'] = $base_currency_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTaxAmount()
    {
        return $this->container['base_currency_tax_amount'];
    }

    /**
     * Sets base_currency_tax_amount
     *
     * @param double|null $base_currency_tax_amount The tax amount of the invoice in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxAmount($base_currency_tax_amount)
    {
        $this->container['base_currency_tax_amount'] = $base_currency_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalAmount()
    {
        return $this->container['base_currency_total_amount'];
    }

    /**
     * Sets base_currency_total_amount
     *
     * @param double|null $base_currency_total_amount The total amount of the invoice in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTotalAmount($base_currency_total_amount)
    {
        $this->container['base_currency_total_amount'] = $base_currency_total_amount;

        return $this;
    }

    /**
     * Gets base_currency_outstanding_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyOutstandingAmount()
    {
        return $this->container['base_currency_outstanding_amount'];
    }

    /**
     * Sets base_currency_outstanding_amount
     *
     * @param double|null $base_currency_outstanding_amount The outstanding amount of the invoice in base currency
     *
     * @return self
     */
    public function setBaseCurrencyOutstandingAmount($base_currency_outstanding_amount)
    {
        $this->container['base_currency_outstanding_amount'] = $base_currency_outstanding_amount;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \SageOne\Model\Base|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \SageOne\Model\Base|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets void_reason
     *
     * @return string|null
     */
    public function getVoidReason()
    {
        return $this->container['void_reason'];
    }

    /**
     * Sets void_reason
     *
     * @param string|null $void_reason The reason the invoice was voided
     *
     * @return self
     */
    public function setVoidReason($void_reason)
    {
        $this->container['void_reason'] = $void_reason;

        return $this;
    }

    /**
     * Gets invoice_lines
     *
     * @return \SageOne\Model\PurchaseInvoiceLineItem[]|null
     */
    public function getInvoiceLines()
    {
        return $this->container['invoice_lines'];
    }

    /**
     * Sets invoice_lines
     *
     * @param \SageOne\Model\PurchaseInvoiceLineItem[]|null $invoice_lines The invoice lines of the invoice
     *
     * @return self
     */
    public function setInvoiceLines($invoice_lines)
    {
        $this->container['invoice_lines'] = $invoice_lines;

        return $this;
    }

    /**
     * Gets tax_analysis
     *
     * @return \SageOne\Model\ArtefactTaxAnalysis[]|null
     */
    public function getTaxAnalysis()
    {
        return $this->container['tax_analysis'];
    }

    /**
     * Sets tax_analysis
     *
     * @param \SageOne\Model\ArtefactTaxAnalysis[]|null $tax_analysis The invoice tax analysis (Optional for Spain, restricted for all other regions)
     *
     * @return self
     */
    public function setTaxAnalysis($tax_analysis)
    {
        $this->container['tax_analysis'] = $tax_analysis;

        return $this;
    }

    /**
     * Gets detailed_tax_analysis
     *
     * @return \SageOne\Model\ArtefactDetailedTaxAnalysis|null
     */
    public function getDetailedTaxAnalysis()
    {
        return $this->container['detailed_tax_analysis'];
    }

    /**
     * Sets detailed_tax_analysis
     *
     * @param \SageOne\Model\ArtefactDetailedTaxAnalysis|null $detailed_tax_analysis detailed_tax_analysis
     *
     * @return self
     */
    public function setDetailedTaxAnalysis($detailed_tax_analysis)
    {
        $this->container['detailed_tax_analysis'] = $detailed_tax_analysis;

        return $this;
    }

    /**
     * Gets payments_allocations
     *
     * @return \SageOne\Model\PaymentAllocation[]|null
     */
    public function getPaymentsAllocations()
    {
        return $this->container['payments_allocations'];
    }

    /**
     * Sets payments_allocations
     *
     * @param \SageOne\Model\PaymentAllocation[]|null $payments_allocations The associated payments and allocations
     *
     * @return self
     */
    public function setPaymentsAllocations($payments_allocations)
    {
        $this->container['payments_allocations'] = $payments_allocations;

        return $this;
    }

    /**
     * Gets last_paid
     *
     * @return \DateTime|null
     */
    public function getLastPaid()
    {
        return $this->container['last_paid'];
    }

    /**
     * Sets last_paid
     *
     * @param \DateTime|null $last_paid The date of the last payment
     *
     * @return self
     */
    public function setLastPaid($last_paid)
    {
        $this->container['last_paid'] = $last_paid;

        return $this;
    }

    /**
     * Gets withholding_tax_rate
     *
     * @return double|null
     */
    public function getWithholdingTaxRate()
    {
        return $this->container['withholding_tax_rate'];
    }

    /**
     * Sets withholding_tax_rate
     *
     * @param double|null $withholding_tax_rate IRPF withheld Tax Rate (Spain only)
     *
     * @return self
     */
    public function setWithholdingTaxRate($withholding_tax_rate)
    {
        $this->container['withholding_tax_rate'] = $withholding_tax_rate;

        return $this;
    }

    /**
     * Gets withholding_tax_amount
     *
     * @return double|null
     */
    public function getWithholdingTaxAmount()
    {
        return $this->container['withholding_tax_amount'];
    }

    /**
     * Sets withholding_tax_amount
     *
     * @param double|null $withholding_tax_amount IRPF withheld Tax Amount (Spain only)
     *
     * @return self
     */
    public function setWithholdingTaxAmount($withholding_tax_amount)
    {
        $this->container['withholding_tax_amount'] = $withholding_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_withholding_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyWithholdingTaxAmount()
    {
        return $this->container['base_currency_withholding_tax_amount'];
    }

    /**
     * Sets base_currency_withholding_tax_amount
     *
     * @param double|null $base_currency_withholding_tax_amount IRPF withheld Tax Amount (Spain only) in the base currency
     *
     * @return self
     */
    public function setBaseCurrencyWithholdingTaxAmount($base_currency_withholding_tax_amount)
    {
        $this->container['base_currency_withholding_tax_amount'] = $base_currency_withholding_tax_amount;

        return $this;
    }

    /**
     * Gets original_invoice
     *
     * @return \SageOne\Model\Generic|null
     */
    public function getOriginalInvoice()
    {
        return $this->container['original_invoice'];
    }

    /**
     * Sets original_invoice
     *
     * @param \SageOne\Model\Generic|null $original_invoice original_invoice
     *
     * @return self
     */
    public function setOriginalInvoice($original_invoice)
    {
        $this->container['original_invoice'] = $original_invoice;

        return $this;
    }

    /**
     * Gets original_invoice_number
     *
     * @return string|null
     */
    public function getOriginalInvoiceNumber()
    {
        return $this->container['original_invoice_number'];
    }

    /**
     * Sets original_invoice_number
     *
     * @param string|null $original_invoice_number The number relating to the original invoice (Spain only)
     *
     * @return self
     */
    public function setOriginalInvoiceNumber($original_invoice_number)
    {
        $this->container['original_invoice_number'] = $original_invoice_number;

        return $this;
    }

    /**
     * Gets original_invoice_date
     *
     * @return string|null
     */
    public function getOriginalInvoiceDate()
    {
        return $this->container['original_invoice_date'];
    }

    /**
     * Sets original_invoice_date
     *
     * @param string|null $original_invoice_date The Invoice date relating to the original invoice (Spain only)
     *
     * @return self
     */
    public function setOriginalInvoiceDate($original_invoice_date)
    {
        $this->container['original_invoice_date'] = $original_invoice_date;

        return $this;
    }

    /**
     * Gets tax_reconciled
     *
     * @return bool|null
     */
    public function getTaxReconciled()
    {
        return $this->container['tax_reconciled'];
    }

    /**
     * Sets tax_reconciled
     *
     * @param bool|null $tax_reconciled Indicates if the artefact is tax reconciled or not.
     *
     * @return self
     */
    public function setTaxReconciled($tax_reconciled)
    {
        $this->container['tax_reconciled'] = $tax_reconciled;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


