<?php
/**
 * Product
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @description Updates a Product
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Base',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'deleted_at' => '\DateTime',
        'item_code' => 'string',
        'description' => 'string',
        'notes' => 'string',
        'sales_ledger_account' => '\SageOne\Model\Base',
        'sales_tax_rate' => '\SageOne\Model\Base',
        'purchase_ledger_account' => '\SageOne\Model\Base',
        'usual_supplier' => '\SageOne\Model\Contact',
        'purchase_tax_rate' => '\SageOne\Model\Base',
        'cost_price' => 'double',
        'sales_prices' => '\SageOne\Model\ProductSalesPriceType[]',
        'source_guid' => 'string',
        'purchase_description' => 'string',
        'active' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'deleted_at' => 'date-time',
        'item_code' => null,
        'description' => null,
        'notes' => null,
        'sales_ledger_account' => null,
        'sales_tax_rate' => null,
        'purchase_ledger_account' => null,
        'usual_supplier' => null,
        'purchase_tax_rate' => null,
        'cost_price' => 'double',
        'sales_prices' => null,
        'source_guid' => null,
        'purchase_description' => null,
        'active' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'item_code' => 'item_code',
        'description' => 'description',
        'notes' => 'notes',
        'sales_ledger_account' => 'sales_ledger_account',
        'sales_tax_rate' => 'sales_tax_rate',
        'purchase_ledger_account' => 'purchase_ledger_account',
        'usual_supplier' => 'usual_supplier',
        'purchase_tax_rate' => 'purchase_tax_rate',
        'cost_price' => 'cost_price',
        'sales_prices' => 'sales_prices',
        'source_guid' => 'source_guid',
        'purchase_description' => 'purchase_description',
        'active' => 'active'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'item_code' => 'setItemCode',
        'description' => 'setDescription',
        'notes' => 'setNotes',
        'sales_ledger_account' => 'setSalesLedgerAccount',
        'sales_tax_rate' => 'setSalesTaxRate',
        'purchase_ledger_account' => 'setPurchaseLedgerAccount',
        'usual_supplier' => 'setUsualSupplier',
        'purchase_tax_rate' => 'setPurchaseTaxRate',
        'cost_price' => 'setCostPrice',
        'sales_prices' => 'setSalesPrices',
        'source_guid' => 'setSourceGuid',
        'purchase_description' => 'setPurchaseDescription',
        'active' => 'setActive'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'item_code' => 'getItemCode',
        'description' => 'getDescription',
        'notes' => 'getNotes',
        'sales_ledger_account' => 'getSalesLedgerAccount',
        'sales_tax_rate' => 'getSalesTaxRate',
        'purchase_ledger_account' => 'getPurchaseLedgerAccount',
        'usual_supplier' => 'getUsualSupplier',
        'purchase_tax_rate' => 'getPurchaseTaxRate',
        'cost_price' => 'getCostPrice',
        'sales_prices' => 'getSalesPrices',
        'source_guid' => 'getSourceGuid',
        'purchase_description' => 'getPurchaseDescription',
        'active' => 'getActive'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['item_code'] = $data['item_code'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['sales_ledger_account'] = $data['sales_ledger_account'] ?? null;
        $this->container['sales_tax_rate'] = $data['sales_tax_rate'] ?? null;
        $this->container['purchase_ledger_account'] = $data['purchase_ledger_account'] ?? null;
        $this->container['usual_supplier'] = $data['usual_supplier'] ?? null;
        $this->container['purchase_tax_rate'] = $data['purchase_tax_rate'] ?? null;
        $this->container['cost_price'] = $data['cost_price'] ?? null;
        $this->container['sales_prices'] = $data['sales_prices'] ?? null;
        $this->container['source_guid'] = $data['source_guid'] ?? null;
        $this->container['purchase_description'] = $data['purchase_description'] ?? null;
        $this->container['active'] = $data['active'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Base|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets item_code
     *
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->container['item_code'];
    }

    /**
     * Sets item_code
     *
     * @param string|null $item_code The item code for the product
     *
     * @return self
     */
    public function setItemCode($item_code)
    {
        $this->container['item_code'] = $item_code;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The product description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes The notes for the product
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets sales_ledger_account
     *
     * @return \SageOne\Model\Base|null
     */
    public function getSalesLedgerAccount()
    {
        return $this->container['sales_ledger_account'];
    }

    /**
     * Sets sales_ledger_account
     *
     * @param \SageOne\Model\Base|null $sales_ledger_account sales_ledger_account
     *
     * @return self
     */
    public function setSalesLedgerAccount($sales_ledger_account)
    {
        $this->container['sales_ledger_account'] = $sales_ledger_account;

        return $this;
    }

    /**
     * Gets sales_tax_rate
     *
     * @return \SageOne\Model\Base|null
     */
    public function getSalesTaxRate()
    {
        return $this->container['sales_tax_rate'];
    }

    /**
     * Sets sales_tax_rate
     *
     * @param \SageOne\Model\Base|null $sales_tax_rate sales_tax_rate
     *
     * @return self
     */
    public function setSalesTaxRate($sales_tax_rate)
    {
        $this->container['sales_tax_rate'] = $sales_tax_rate;

        return $this;
    }

    /**
     * Gets purchase_ledger_account
     *
     * @return \SageOne\Model\Base|null
     */
    public function getPurchaseLedgerAccount()
    {
        return $this->container['purchase_ledger_account'];
    }

    /**
     * Sets purchase_ledger_account
     *
     * @param \SageOne\Model\Base|null $purchase_ledger_account purchase_ledger_account
     *
     * @return self
     */
    public function setPurchaseLedgerAccount($purchase_ledger_account)
    {
        $this->container['purchase_ledger_account'] = $purchase_ledger_account;

        return $this;
    }

    /**
     * Gets usual_supplier
     *
     * @return \SageOne\Model\Contact|null
     */
    public function getUsualSupplier()
    {
        return $this->container['usual_supplier'];
    }

    /**
     * Sets usual_supplier
     *
     * @param \SageOne\Model\Contact|null $usual_supplier usual_supplier
     *
     * @return self
     */
    public function setUsualSupplier($usual_supplier)
    {
        $this->container['usual_supplier'] = $usual_supplier;

        return $this;
    }

    /**
     * Gets purchase_tax_rate
     *
     * @return \SageOne\Model\Base|null
     */
    public function getPurchaseTaxRate()
    {
        return $this->container['purchase_tax_rate'];
    }

    /**
     * Sets purchase_tax_rate
     *
     * @param \SageOne\Model\Base|null $purchase_tax_rate purchase_tax_rate
     *
     * @return self
     */
    public function setPurchaseTaxRate($purchase_tax_rate)
    {
        $this->container['purchase_tax_rate'] = $purchase_tax_rate;

        return $this;
    }

    /**
     * Gets cost_price
     *
     * @return double|null
     */
    public function getCostPrice()
    {
        return $this->container['cost_price'];
    }

    /**
     * Sets cost_price
     *
     * @param double|null $cost_price The cost price of the product
     *
     * @return self
     */
    public function setCostPrice($cost_price)
    {
        $this->container['cost_price'] = $cost_price;

        return $this;
    }

    /**
     * Gets sales_prices
     *
     * @return \SageOne\Model\ProductSalesPriceType[]|null
     */
    public function getSalesPrices()
    {
        return $this->container['sales_prices'];
    }

    /**
     * Sets sales_prices
     *
     * @param \SageOne\Model\ProductSalesPriceType[]|null $sales_prices The sales prices for the product
     *
     * @return self
     */
    public function setSalesPrices($sales_prices)
    {
        $this->container['sales_prices'] = $sales_prices;

        return $this;
    }

    /**
     * Gets source_guid
     *
     * @return string|null
     */
    public function getSourceGuid()
    {
        return $this->container['source_guid'];
    }

    /**
     * Sets source_guid
     *
     * @param string|null $source_guid Used when importing products from external sources
     *
     * @return self
     */
    public function setSourceGuid($source_guid)
    {
        $this->container['source_guid'] = $source_guid;

        return $this;
    }

    /**
     * Gets purchase_description
     *
     * @return string|null
     */
    public function getPurchaseDescription()
    {
        return $this->container['purchase_description'];
    }

    /**
     * Sets purchase_description
     *
     * @param string|null $purchase_description The product purchase description
     *
     * @return self
     */
    public function setPurchaseDescription($purchase_description)
    {
        $this->container['purchase_description'] = $purchase_description;

        return $this;
    }

    /**
     * Gets active
     *
     * @return bool|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param bool|null $active Indicates whether the product is active
     *
     * @return self
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


