<?php
/**
 * PostSalesQuotesSalesQuote
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostSalesQuotesSalesQuote Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostSalesQuotesSalesQuote implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postSalesQuotes_sales_quote';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'contact_id' => 'string',
        'date' => '\DateTime',
        'expiry_date' => '\DateTime',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'editable' => 'bool',
        'tax_calculation_method' => 'string',
        'quote_number' => 'string',
        'contact_name' => 'string',
        'contact_reference' => 'string',
        'reference' => 'string',
        'main_address_free_form' => 'string',
        'delivery_address_free_form' => 'string',
        'notes' => 'string',
        'terms_and_conditions' => 'string',
        'shipping_net_amount' => 'double',
        'shipping_tax_rate_id' => 'string',
        'shipping_tax_amount' => 'double',
        'shipping_total_amount' => 'double',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'total_amount' => 'double',
        'currency_id' => 'string',
        'exchange_rate' => 'double',
        'inverse_exchange_rate' => 'double',
        'base_currency_shipping_net_amount' => 'double',
        'base_currency_shipping_tax_amount' => 'double',
        'base_currency_shipping_total_amount' => 'double',
        'total_quantity' => 'double',
        'total_discount_amount' => 'double',
        'base_currency_total_discount_amount' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'payments_allocations_total_amount' => 'double',
        'payments_allocations_total_discount' => 'double',
        'total_paid' => 'double',
        'sent' => 'bool',
        'sent_by_email' => 'bool',
        'tax_address_region_id' => 'string',
        'withholding_tax_rate' => 'double',
        'withholding_tax_amount' => 'double',
        'base_currency_withholding_tax_amount' => 'double',
        'tax_reconciled' => 'bool',
        'quote_lines' => '\SageOne\Model\PostSalesEstimatesSalesEstimateEstimateLines',
        'links' => '\SageOne\Model\PostContactsContactLinksInner[]',
        'main_address' => '\SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress',
        'delivery_address' => '\SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress',
        'shipping_tax_breakdown' => '\SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]',
        'base_currency_shipping_tax_breakdown' => '\SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]',
        'tax_analysis' => '\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceTaxAnalysisInner[]',
        'detailed_tax_analysis' => '\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceDetailedTaxAnalysis',
        'profit_analysis' => '\SageOne\Model\PostSalesEstimatesSalesEstimateProfitAnalysis',
        'invoice_id' => '\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceOriginalInvoiceIdInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'contact_id' => null,
        'date' => 'date',
        'expiry_date' => 'date',
        'transaction_id' => null,
        'transaction_type_id' => null,
        'editable' => null,
        'tax_calculation_method' => null,
        'quote_number' => null,
        'contact_name' => null,
        'contact_reference' => null,
        'reference' => null,
        'main_address_free_form' => null,
        'delivery_address_free_form' => null,
        'notes' => null,
        'terms_and_conditions' => null,
        'shipping_net_amount' => 'double',
        'shipping_tax_rate_id' => null,
        'shipping_tax_amount' => 'double',
        'shipping_total_amount' => 'double',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'total_amount' => 'double',
        'currency_id' => null,
        'exchange_rate' => 'double',
        'inverse_exchange_rate' => 'double',
        'base_currency_shipping_net_amount' => 'double',
        'base_currency_shipping_tax_amount' => 'double',
        'base_currency_shipping_total_amount' => 'double',
        'total_quantity' => 'double',
        'total_discount_amount' => 'double',
        'base_currency_total_discount_amount' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'payments_allocations_total_amount' => 'double',
        'payments_allocations_total_discount' => 'double',
        'total_paid' => 'double',
        'sent' => null,
        'sent_by_email' => null,
        'tax_address_region_id' => null,
        'withholding_tax_rate' => 'double',
        'withholding_tax_amount' => 'double',
        'base_currency_withholding_tax_amount' => 'double',
        'tax_reconciled' => null,
        'quote_lines' => null,
        'links' => null,
        'main_address' => null,
        'delivery_address' => null,
        'shipping_tax_breakdown' => null,
        'base_currency_shipping_tax_breakdown' => null,
        'tax_analysis' => null,
        'detailed_tax_analysis' => null,
        'profit_analysis' => null,
        'invoice_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'contact_id' => 'contact_id',
        'date' => 'date',
        'expiry_date' => 'expiry_date',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'editable' => 'editable',
        'tax_calculation_method' => 'tax_calculation_method',
        'quote_number' => 'quote_number',
        'contact_name' => 'contact_name',
        'contact_reference' => 'contact_reference',
        'reference' => 'reference',
        'main_address_free_form' => 'main_address_free_form',
        'delivery_address_free_form' => 'delivery_address_free_form',
        'notes' => 'notes',
        'terms_and_conditions' => 'terms_and_conditions',
        'shipping_net_amount' => 'shipping_net_amount',
        'shipping_tax_rate_id' => 'shipping_tax_rate_id',
        'shipping_tax_amount' => 'shipping_tax_amount',
        'shipping_total_amount' => 'shipping_total_amount',
        'net_amount' => 'net_amount',
        'tax_amount' => 'tax_amount',
        'total_amount' => 'total_amount',
        'currency_id' => 'currency_id',
        'exchange_rate' => 'exchange_rate',
        'inverse_exchange_rate' => 'inverse_exchange_rate',
        'base_currency_shipping_net_amount' => 'base_currency_shipping_net_amount',
        'base_currency_shipping_tax_amount' => 'base_currency_shipping_tax_amount',
        'base_currency_shipping_total_amount' => 'base_currency_shipping_total_amount',
        'total_quantity' => 'total_quantity',
        'total_discount_amount' => 'total_discount_amount',
        'base_currency_total_discount_amount' => 'base_currency_total_discount_amount',
        'base_currency_net_amount' => 'base_currency_net_amount',
        'base_currency_tax_amount' => 'base_currency_tax_amount',
        'base_currency_total_amount' => 'base_currency_total_amount',
        'payments_allocations_total_amount' => 'payments_allocations_total_amount',
        'payments_allocations_total_discount' => 'payments_allocations_total_discount',
        'total_paid' => 'total_paid',
        'sent' => 'sent',
        'sent_by_email' => 'sent_by_email',
        'tax_address_region_id' => 'tax_address_region_id',
        'withholding_tax_rate' => 'withholding_tax_rate',
        'withholding_tax_amount' => 'withholding_tax_amount',
        'base_currency_withholding_tax_amount' => 'base_currency_withholding_tax_amount',
        'tax_reconciled' => 'tax_reconciled',
        'quote_lines' => 'quote_lines',
        'links' => 'links',
        'main_address' => 'main_address',
        'delivery_address' => 'delivery_address',
        'shipping_tax_breakdown' => 'shipping_tax_breakdown',
        'base_currency_shipping_tax_breakdown' => 'base_currency_shipping_tax_breakdown',
        'tax_analysis' => 'tax_analysis',
        'detailed_tax_analysis' => 'detailed_tax_analysis',
        'profit_analysis' => 'profit_analysis',
        'invoice_id' => 'invoice_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'contact_id' => 'setContactId',
        'date' => 'setDate',
        'expiry_date' => 'setExpiryDate',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'editable' => 'setEditable',
        'tax_calculation_method' => 'setTaxCalculationMethod',
        'quote_number' => 'setQuoteNumber',
        'contact_name' => 'setContactName',
        'contact_reference' => 'setContactReference',
        'reference' => 'setReference',
        'main_address_free_form' => 'setMainAddressFreeForm',
        'delivery_address_free_form' => 'setDeliveryAddressFreeForm',
        'notes' => 'setNotes',
        'terms_and_conditions' => 'setTermsAndConditions',
        'shipping_net_amount' => 'setShippingNetAmount',
        'shipping_tax_rate_id' => 'setShippingTaxRateId',
        'shipping_tax_amount' => 'setShippingTaxAmount',
        'shipping_total_amount' => 'setShippingTotalAmount',
        'net_amount' => 'setNetAmount',
        'tax_amount' => 'setTaxAmount',
        'total_amount' => 'setTotalAmount',
        'currency_id' => 'setCurrencyId',
        'exchange_rate' => 'setExchangeRate',
        'inverse_exchange_rate' => 'setInverseExchangeRate',
        'base_currency_shipping_net_amount' => 'setBaseCurrencyShippingNetAmount',
        'base_currency_shipping_tax_amount' => 'setBaseCurrencyShippingTaxAmount',
        'base_currency_shipping_total_amount' => 'setBaseCurrencyShippingTotalAmount',
        'total_quantity' => 'setTotalQuantity',
        'total_discount_amount' => 'setTotalDiscountAmount',
        'base_currency_total_discount_amount' => 'setBaseCurrencyTotalDiscountAmount',
        'base_currency_net_amount' => 'setBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'setBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'setBaseCurrencyTotalAmount',
        'payments_allocations_total_amount' => 'setPaymentsAllocationsTotalAmount',
        'payments_allocations_total_discount' => 'setPaymentsAllocationsTotalDiscount',
        'total_paid' => 'setTotalPaid',
        'sent' => 'setSent',
        'sent_by_email' => 'setSentByEmail',
        'tax_address_region_id' => 'setTaxAddressRegionId',
        'withholding_tax_rate' => 'setWithholdingTaxRate',
        'withholding_tax_amount' => 'setWithholdingTaxAmount',
        'base_currency_withholding_tax_amount' => 'setBaseCurrencyWithholdingTaxAmount',
        'tax_reconciled' => 'setTaxReconciled',
        'quote_lines' => 'setQuoteLines',
        'links' => 'setLinks',
        'main_address' => 'setMainAddress',
        'delivery_address' => 'setDeliveryAddress',
        'shipping_tax_breakdown' => 'setShippingTaxBreakdown',
        'base_currency_shipping_tax_breakdown' => 'setBaseCurrencyShippingTaxBreakdown',
        'tax_analysis' => 'setTaxAnalysis',
        'detailed_tax_analysis' => 'setDetailedTaxAnalysis',
        'profit_analysis' => 'setProfitAnalysis',
        'invoice_id' => 'setInvoiceId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'contact_id' => 'getContactId',
        'date' => 'getDate',
        'expiry_date' => 'getExpiryDate',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'editable' => 'getEditable',
        'tax_calculation_method' => 'getTaxCalculationMethod',
        'quote_number' => 'getQuoteNumber',
        'contact_name' => 'getContactName',
        'contact_reference' => 'getContactReference',
        'reference' => 'getReference',
        'main_address_free_form' => 'getMainAddressFreeForm',
        'delivery_address_free_form' => 'getDeliveryAddressFreeForm',
        'notes' => 'getNotes',
        'terms_and_conditions' => 'getTermsAndConditions',
        'shipping_net_amount' => 'getShippingNetAmount',
        'shipping_tax_rate_id' => 'getShippingTaxRateId',
        'shipping_tax_amount' => 'getShippingTaxAmount',
        'shipping_total_amount' => 'getShippingTotalAmount',
        'net_amount' => 'getNetAmount',
        'tax_amount' => 'getTaxAmount',
        'total_amount' => 'getTotalAmount',
        'currency_id' => 'getCurrencyId',
        'exchange_rate' => 'getExchangeRate',
        'inverse_exchange_rate' => 'getInverseExchangeRate',
        'base_currency_shipping_net_amount' => 'getBaseCurrencyShippingNetAmount',
        'base_currency_shipping_tax_amount' => 'getBaseCurrencyShippingTaxAmount',
        'base_currency_shipping_total_amount' => 'getBaseCurrencyShippingTotalAmount',
        'total_quantity' => 'getTotalQuantity',
        'total_discount_amount' => 'getTotalDiscountAmount',
        'base_currency_total_discount_amount' => 'getBaseCurrencyTotalDiscountAmount',
        'base_currency_net_amount' => 'getBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'getBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'getBaseCurrencyTotalAmount',
        'payments_allocations_total_amount' => 'getPaymentsAllocationsTotalAmount',
        'payments_allocations_total_discount' => 'getPaymentsAllocationsTotalDiscount',
        'total_paid' => 'getTotalPaid',
        'sent' => 'getSent',
        'sent_by_email' => 'getSentByEmail',
        'tax_address_region_id' => 'getTaxAddressRegionId',
        'withholding_tax_rate' => 'getWithholdingTaxRate',
        'withholding_tax_amount' => 'getWithholdingTaxAmount',
        'base_currency_withholding_tax_amount' => 'getBaseCurrencyWithholdingTaxAmount',
        'tax_reconciled' => 'getTaxReconciled',
        'quote_lines' => 'getQuoteLines',
        'links' => 'getLinks',
        'main_address' => 'getMainAddress',
        'delivery_address' => 'getDeliveryAddress',
        'shipping_tax_breakdown' => 'getShippingTaxBreakdown',
        'base_currency_shipping_tax_breakdown' => 'getBaseCurrencyShippingTaxBreakdown',
        'tax_analysis' => 'getTaxAnalysis',
        'detailed_tax_analysis' => 'getDetailedTaxAnalysis',
        'profit_analysis' => 'getProfitAnalysis',
        'invoice_id' => 'getInvoiceId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['contact_id'] = $data['contact_id'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['expiry_date'] = $data['expiry_date'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['editable'] = $data['editable'] ?? null;
        $this->container['tax_calculation_method'] = $data['tax_calculation_method'] ?? null;
        $this->container['quote_number'] = $data['quote_number'] ?? null;
        $this->container['contact_name'] = $data['contact_name'] ?? null;
        $this->container['contact_reference'] = $data['contact_reference'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['main_address_free_form'] = $data['main_address_free_form'] ?? null;
        $this->container['delivery_address_free_form'] = $data['delivery_address_free_form'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['terms_and_conditions'] = $data['terms_and_conditions'] ?? null;
        $this->container['shipping_net_amount'] = $data['shipping_net_amount'] ?? null;
        $this->container['shipping_tax_rate_id'] = $data['shipping_tax_rate_id'] ?? null;
        $this->container['shipping_tax_amount'] = $data['shipping_tax_amount'] ?? null;
        $this->container['shipping_total_amount'] = $data['shipping_total_amount'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['currency_id'] = $data['currency_id'] ?? null;
        $this->container['exchange_rate'] = $data['exchange_rate'] ?? null;
        $this->container['inverse_exchange_rate'] = $data['inverse_exchange_rate'] ?? null;
        $this->container['base_currency_shipping_net_amount'] = $data['base_currency_shipping_net_amount'] ?? null;
        $this->container['base_currency_shipping_tax_amount'] = $data['base_currency_shipping_tax_amount'] ?? null;
        $this->container['base_currency_shipping_total_amount'] = $data['base_currency_shipping_total_amount'] ?? null;
        $this->container['total_quantity'] = $data['total_quantity'] ?? null;
        $this->container['total_discount_amount'] = $data['total_discount_amount'] ?? null;
        $this->container['base_currency_total_discount_amount'] = $data['base_currency_total_discount_amount'] ?? null;
        $this->container['base_currency_net_amount'] = $data['base_currency_net_amount'] ?? null;
        $this->container['base_currency_tax_amount'] = $data['base_currency_tax_amount'] ?? null;
        $this->container['base_currency_total_amount'] = $data['base_currency_total_amount'] ?? null;
        $this->container['payments_allocations_total_amount'] = $data['payments_allocations_total_amount'] ?? null;
        $this->container['payments_allocations_total_discount'] = $data['payments_allocations_total_discount'] ?? null;
        $this->container['total_paid'] = $data['total_paid'] ?? null;
        $this->container['sent'] = $data['sent'] ?? null;
        $this->container['sent_by_email'] = $data['sent_by_email'] ?? null;
        $this->container['tax_address_region_id'] = $data['tax_address_region_id'] ?? null;
        $this->container['withholding_tax_rate'] = $data['withholding_tax_rate'] ?? null;
        $this->container['withholding_tax_amount'] = $data['withholding_tax_amount'] ?? null;
        $this->container['base_currency_withholding_tax_amount'] = $data['base_currency_withholding_tax_amount'] ?? null;
        $this->container['tax_reconciled'] = $data['tax_reconciled'] ?? null;
        $this->container['quote_lines'] = $data['quote_lines'] ?? null;
        $this->container['links'] = $data['links'] ?? null;
        $this->container['main_address'] = $data['main_address'] ?? null;
        $this->container['delivery_address'] = $data['delivery_address'] ?? null;
        $this->container['shipping_tax_breakdown'] = $data['shipping_tax_breakdown'] ?? null;
        $this->container['base_currency_shipping_tax_breakdown'] = $data['base_currency_shipping_tax_breakdown'] ?? null;
        $this->container['tax_analysis'] = $data['tax_analysis'] ?? null;
        $this->container['detailed_tax_analysis'] = $data['detailed_tax_analysis'] ?? null;
        $this->container['profit_analysis'] = $data['profit_analysis'] ?? null;
        $this->container['invoice_id'] = $data['invoice_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['contact_id'] === null) {
            $invalidProperties[] = "'contact_id' can't be null";
        }
        if ($this->container['date'] === null) {
            $invalidProperties[] = "'date' can't be null";
        }
        if ($this->container['expiry_date'] === null) {
            $invalidProperties[] = "'expiry_date' can't be null";
        }
        if ($this->container['quote_lines'] === null) {
            $invalidProperties[] = "'quote_lines' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets contact_id
     *
     * @return string
     */
    public function getContactId()
    {
        return $this->container['contact_id'];
    }

    /**
     * Sets contact_id
     *
     * @param string $contact_id The contact the quote relates to
     *
     * @return self
     */
    public function setContactId($contact_id)
    {
        $this->container['contact_id'] = $contact_id;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime $date The date of the quote
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets expiry_date
     *
     * @return \DateTime
     */
    public function getExpiryDate()
    {
        return $this->container['expiry_date'];
    }

    /**
     * Sets expiry_date
     *
     * @param \DateTime $expiry_date The expiry date of the quote
     *
     * @return self
     */
    public function setExpiryDate($expiry_date)
    {
        $this->container['expiry_date'] = $expiry_date;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets editable
     *
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->container['editable'];
    }

    /**
     * Sets editable
     *
     * @param bool|null $editable Indicates whether artefact can be edited
     *
     * @return self
     */
    public function setEditable($editable)
    {
        $this->container['editable'] = $editable;

        return $this;
    }

    /**
     * Gets tax_calculation_method
     *
     * @return string|null
     */
    public function getTaxCalculationMethod()
    {
        return $this->container['tax_calculation_method'];
    }

    /**
     * Sets tax_calculation_method
     *
     * @param string|null $tax_calculation_method The tax calculation method, if applicable, for this sales invoice, returns invoice, cash or retailer.
     *
     * @return self
     */
    public function setTaxCalculationMethod($tax_calculation_method)
    {
        $this->container['tax_calculation_method'] = $tax_calculation_method;

        return $this;
    }

    /**
     * Gets quote_number
     *
     * @return string|null
     */
    public function getQuoteNumber()
    {
        return $this->container['quote_number'];
    }

    /**
     * Sets quote_number
     *
     * @param string|null $quote_number The generated quote number
     *
     * @return self
     */
    public function setQuoteNumber($quote_number)
    {
        $this->container['quote_number'] = $quote_number;

        return $this;
    }

    /**
     * Gets contact_name
     *
     * @return string|null
     */
    public function getContactName()
    {
        return $this->container['contact_name'];
    }

    /**
     * Sets contact_name
     *
     * @param string|null $contact_name The name of the contact when the quote was created
     *
     * @return self
     */
    public function setContactName($contact_name)
    {
        $this->container['contact_name'] = $contact_name;

        return $this;
    }

    /**
     * Gets contact_reference
     *
     * @return string|null
     */
    public function getContactReference()
    {
        return $this->container['contact_reference'];
    }

    /**
     * Sets contact_reference
     *
     * @param string|null $contact_reference The reference of the contact when the quote was created
     *
     * @return self
     */
    public function setContactReference($contact_reference)
    {
        $this->container['contact_reference'] = $contact_reference;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference The reference for the quote
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets main_address_free_form
     *
     * @return string|null
     */
    public function getMainAddressFreeForm()
    {
        return $this->container['main_address_free_form'];
    }

    /**
     * Sets main_address_free_form
     *
     * @param string|null $main_address_free_form The free-form main address of the quote
     *
     * @return self
     */
    public function setMainAddressFreeForm($main_address_free_form)
    {
        $this->container['main_address_free_form'] = $main_address_free_form;

        return $this;
    }

    /**
     * Gets delivery_address_free_form
     *
     * @return string|null
     */
    public function getDeliveryAddressFreeForm()
    {
        return $this->container['delivery_address_free_form'];
    }

    /**
     * Sets delivery_address_free_form
     *
     * @param string|null $delivery_address_free_form The free-form delivery address of the quote
     *
     * @return self
     */
    public function setDeliveryAddressFreeForm($delivery_address_free_form)
    {
        $this->container['delivery_address_free_form'] = $delivery_address_free_form;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes Quote notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets terms_and_conditions
     *
     * @return string|null
     */
    public function getTermsAndConditions()
    {
        return $this->container['terms_and_conditions'];
    }

    /**
     * Sets terms_and_conditions
     *
     * @param string|null $terms_and_conditions Quote terms and conditions
     *
     * @return self
     */
    public function setTermsAndConditions($terms_and_conditions)
    {
        $this->container['terms_and_conditions'] = $terms_and_conditions;

        return $this;
    }

    /**
     * Gets shipping_net_amount
     *
     * @return double|null
     */
    public function getShippingNetAmount()
    {
        return $this->container['shipping_net_amount'];
    }

    /**
     * Sets shipping_net_amount
     *
     * @param double|null $shipping_net_amount The net shipping amount
     *
     * @return self
     */
    public function setShippingNetAmount($shipping_net_amount)
    {
        $this->container['shipping_net_amount'] = $shipping_net_amount;

        return $this;
    }

    /**
     * Gets shipping_tax_rate_id
     *
     * @return string|null
     */
    public function getShippingTaxRateId()
    {
        return $this->container['shipping_tax_rate_id'];
    }

    /**
     * Sets shipping_tax_rate_id
     *
     * @param string|null $shipping_tax_rate_id The ID of the Shipping Tax Rate.
     *
     * @return self
     */
    public function setShippingTaxRateId($shipping_tax_rate_id)
    {
        $this->container['shipping_tax_rate_id'] = $shipping_tax_rate_id;

        return $this;
    }

    /**
     * Gets shipping_tax_amount
     *
     * @return double|null
     */
    public function getShippingTaxAmount()
    {
        return $this->container['shipping_tax_amount'];
    }

    /**
     * Sets shipping_tax_amount
     *
     * @param double|null $shipping_tax_amount The tax shipping amount. NOTE: This is not required for POST/PUT requests as the shipping tax is calculated based on the shipping_net_amount and the shipping_tax_rate.
     *
     * @return self
     */
    public function setShippingTaxAmount($shipping_tax_amount)
    {
        $this->container['shipping_tax_amount'] = $shipping_tax_amount;

        return $this;
    }

    /**
     * Gets shipping_total_amount
     *
     * @return double|null
     */
    public function getShippingTotalAmount()
    {
        return $this->container['shipping_total_amount'];
    }

    /**
     * Sets shipping_total_amount
     *
     * @param double|null $shipping_total_amount The total shipping amount
     *
     * @return self
     */
    public function setShippingTotalAmount($shipping_total_amount)
    {
        $this->container['shipping_total_amount'] = $shipping_total_amount;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double|null $net_amount The net amount of the quote
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double|null $tax_amount The tax amount of the quote
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount The total amount of the quote
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets currency_id
     *
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->container['currency_id'];
    }

    /**
     * Sets currency_id
     *
     * @param string|null $currency_id The ID of the Currency.
     *
     * @return self
     */
    public function setCurrencyId($currency_id)
    {
        $this->container['currency_id'] = $currency_id;

        return $this;
    }

    /**
     * Gets exchange_rate
     *
     * @return double|null
     */
    public function getExchangeRate()
    {
        return $this->container['exchange_rate'];
    }

    /**
     * Sets exchange_rate
     *
     * @param double|null $exchange_rate The exchange rate for the quote
     *
     * @return self
     */
    public function setExchangeRate($exchange_rate)
    {
        $this->container['exchange_rate'] = $exchange_rate;

        return $this;
    }

    /**
     * Gets inverse_exchange_rate
     *
     * @return double|null
     */
    public function getInverseExchangeRate()
    {
        return $this->container['inverse_exchange_rate'];
    }

    /**
     * Sets inverse_exchange_rate
     *
     * @param double|null $inverse_exchange_rate The inverse exchange rate for the quote
     *
     * @return self
     */
    public function setInverseExchangeRate($inverse_exchange_rate)
    {
        $this->container['inverse_exchange_rate'] = $inverse_exchange_rate;

        return $this;
    }

    /**
     * Gets base_currency_shipping_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyShippingNetAmount()
    {
        return $this->container['base_currency_shipping_net_amount'];
    }

    /**
     * Sets base_currency_shipping_net_amount
     *
     * @param double|null $base_currency_shipping_net_amount The net shipping amount in base currency
     *
     * @return self
     */
    public function setBaseCurrencyShippingNetAmount($base_currency_shipping_net_amount)
    {
        $this->container['base_currency_shipping_net_amount'] = $base_currency_shipping_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_shipping_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyShippingTaxAmount()
    {
        return $this->container['base_currency_shipping_tax_amount'];
    }

    /**
     * Sets base_currency_shipping_tax_amount
     *
     * @param double|null $base_currency_shipping_tax_amount The tax shipping amount in base currency
     *
     * @return self
     */
    public function setBaseCurrencyShippingTaxAmount($base_currency_shipping_tax_amount)
    {
        $this->container['base_currency_shipping_tax_amount'] = $base_currency_shipping_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_shipping_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyShippingTotalAmount()
    {
        return $this->container['base_currency_shipping_total_amount'];
    }

    /**
     * Sets base_currency_shipping_total_amount
     *
     * @param double|null $base_currency_shipping_total_amount The total shipping amount in base currency
     *
     * @return self
     */
    public function setBaseCurrencyShippingTotalAmount($base_currency_shipping_total_amount)
    {
        $this->container['base_currency_shipping_total_amount'] = $base_currency_shipping_total_amount;

        return $this;
    }

    /**
     * Gets total_quantity
     *
     * @return double|null
     */
    public function getTotalQuantity()
    {
        return $this->container['total_quantity'];
    }

    /**
     * Sets total_quantity
     *
     * @param double|null $total_quantity The total quantity of the quote
     *
     * @return self
     */
    public function setTotalQuantity($total_quantity)
    {
        $this->container['total_quantity'] = $total_quantity;

        return $this;
    }

    /**
     * Gets total_discount_amount
     *
     * @return double|null
     */
    public function getTotalDiscountAmount()
    {
        return $this->container['total_discount_amount'];
    }

    /**
     * Sets total_discount_amount
     *
     * @param double|null $total_discount_amount The discount amount on the  quote
     *
     * @return self
     */
    public function setTotalDiscountAmount($total_discount_amount)
    {
        $this->container['total_discount_amount'] = $total_discount_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_discount_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalDiscountAmount()
    {
        return $this->container['base_currency_total_discount_amount'];
    }

    /**
     * Sets base_currency_total_discount_amount
     *
     * @param double|null $base_currency_total_discount_amount The discount amount on the  quote in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTotalDiscountAmount($base_currency_total_discount_amount)
    {
        $this->container['base_currency_total_discount_amount'] = $base_currency_total_discount_amount;

        return $this;
    }

    /**
     * Gets base_currency_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyNetAmount()
    {
        return $this->container['base_currency_net_amount'];
    }

    /**
     * Sets base_currency_net_amount
     *
     * @param double|null $base_currency_net_amount The net amount of the quote in base currency
     *
     * @return self
     */
    public function setBaseCurrencyNetAmount($base_currency_net_amount)
    {
        $this->container['base_currency_net_amount'] = $base_currency_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTaxAmount()
    {
        return $this->container['base_currency_tax_amount'];
    }

    /**
     * Sets base_currency_tax_amount
     *
     * @param double|null $base_currency_tax_amount The tax amount of the quote in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxAmount($base_currency_tax_amount)
    {
        $this->container['base_currency_tax_amount'] = $base_currency_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalAmount()
    {
        return $this->container['base_currency_total_amount'];
    }

    /**
     * Sets base_currency_total_amount
     *
     * @param double|null $base_currency_total_amount The total amount of the quote in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTotalAmount($base_currency_total_amount)
    {
        $this->container['base_currency_total_amount'] = $base_currency_total_amount;

        return $this;
    }

    /**
     * Gets payments_allocations_total_amount
     *
     * @return double|null
     */
    public function getPaymentsAllocationsTotalAmount()
    {
        return $this->container['payments_allocations_total_amount'];
    }

    /**
     * Sets payments_allocations_total_amount
     *
     * @param double|null $payments_allocations_total_amount The total amount of all payments and allocations
     *
     * @return self
     */
    public function setPaymentsAllocationsTotalAmount($payments_allocations_total_amount)
    {
        $this->container['payments_allocations_total_amount'] = $payments_allocations_total_amount;

        return $this;
    }

    /**
     * Gets payments_allocations_total_discount
     *
     * @return double|null
     */
    public function getPaymentsAllocationsTotalDiscount()
    {
        return $this->container['payments_allocations_total_discount'];
    }

    /**
     * Sets payments_allocations_total_discount
     *
     * @param double|null $payments_allocations_total_discount The total discount of all payments and allocations
     *
     * @return self
     */
    public function setPaymentsAllocationsTotalDiscount($payments_allocations_total_discount)
    {
        $this->container['payments_allocations_total_discount'] = $payments_allocations_total_discount;

        return $this;
    }

    /**
     * Gets total_paid
     *
     * @return double|null
     */
    public function getTotalPaid()
    {
        return $this->container['total_paid'];
    }

    /**
     * Sets total_paid
     *
     * @param double|null $total_paid The total paid amount of the quote including any payments, allocations and discounts
     *
     * @return self
     */
    public function setTotalPaid($total_paid)
    {
        $this->container['total_paid'] = $total_paid;

        return $this;
    }

    /**
     * Gets sent
     *
     * @return bool|null
     */
    public function getSent()
    {
        return $this->container['sent'];
    }

    /**
     * Sets sent
     *
     * @param bool|null $sent Indicates whether the quote has been sent
     *
     * @return self
     */
    public function setSent($sent)
    {
        $this->container['sent'] = $sent;

        return $this;
    }

    /**
     * Gets sent_by_email
     *
     * @return bool|null
     */
    public function getSentByEmail()
    {
        return $this->container['sent_by_email'];
    }

    /**
     * Sets sent_by_email
     *
     * @param bool|null $sent_by_email Indicates whether the quote has been emailed
     *
     * @return self
     */
    public function setSentByEmail($sent_by_email)
    {
        $this->container['sent_by_email'] = $sent_by_email;

        return $this;
    }

    /**
     * Gets tax_address_region_id
     *
     * @return string|null
     */
    public function getTaxAddressRegionId()
    {
        return $this->container['tax_address_region_id'];
    }

    /**
     * Sets tax_address_region_id
     *
     * @param string|null $tax_address_region_id The ID of the Tax Address Region. (Canada only)
     *
     * @return self
     */
    public function setTaxAddressRegionId($tax_address_region_id)
    {
        $this->container['tax_address_region_id'] = $tax_address_region_id;

        return $this;
    }

    /**
     * Gets withholding_tax_rate
     *
     * @return double|null
     */
    public function getWithholdingTaxRate()
    {
        return $this->container['withholding_tax_rate'];
    }

    /**
     * Sets withholding_tax_rate
     *
     * @param double|null $withholding_tax_rate IRPF withheld Tax Rate (Spain only)
     *
     * @return self
     */
    public function setWithholdingTaxRate($withholding_tax_rate)
    {
        $this->container['withholding_tax_rate'] = $withholding_tax_rate;

        return $this;
    }

    /**
     * Gets withholding_tax_amount
     *
     * @return double|null
     */
    public function getWithholdingTaxAmount()
    {
        return $this->container['withholding_tax_amount'];
    }

    /**
     * Sets withholding_tax_amount
     *
     * @param double|null $withholding_tax_amount IRPF withheld Tax Amount (Spain only)
     *
     * @return self
     */
    public function setWithholdingTaxAmount($withholding_tax_amount)
    {
        $this->container['withholding_tax_amount'] = $withholding_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_withholding_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyWithholdingTaxAmount()
    {
        return $this->container['base_currency_withholding_tax_amount'];
    }

    /**
     * Sets base_currency_withholding_tax_amount
     *
     * @param double|null $base_currency_withholding_tax_amount IRPF withheld Tax Amount (Spain only) in the base currency
     *
     * @return self
     */
    public function setBaseCurrencyWithholdingTaxAmount($base_currency_withholding_tax_amount)
    {
        $this->container['base_currency_withholding_tax_amount'] = $base_currency_withholding_tax_amount;

        return $this;
    }

    /**
     * Gets tax_reconciled
     *
     * @return bool|null
     */
    public function getTaxReconciled()
    {
        return $this->container['tax_reconciled'];
    }

    /**
     * Sets tax_reconciled
     *
     * @param bool|null $tax_reconciled Indicates if the quote/estimate is tax reconciled or not.
     *
     * @return self
     */
    public function setTaxReconciled($tax_reconciled)
    {
        $this->container['tax_reconciled'] = $tax_reconciled;

        return $this;
    }

    /**
     * Gets quote_lines
     *
     * @return \SageOne\Model\PostSalesEstimatesSalesEstimateEstimateLines
     */
    public function getQuoteLines()
    {
        return $this->container['quote_lines'];
    }

    /**
     * Sets quote_lines
     *
     * @param \SageOne\Model\PostSalesEstimatesSalesEstimateEstimateLines $quote_lines quote_lines
     *
     * @return self
     */
    public function setQuoteLines($quote_lines)
    {
        $this->container['quote_lines'] = $quote_lines;

        return $this;
    }

    /**
     * Gets links
     *
     * @return \SageOne\Model\PostContactsContactLinksInner[]|null
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     *
     * @param \SageOne\Model\PostContactsContactLinksInner[]|null $links links
     *
     * @return self
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }

    /**
     * Gets main_address
     *
     * @return \SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress|null
     */
    public function getMainAddress()
    {
        return $this->container['main_address'];
    }

    /**
     * Sets main_address
     *
     * @param \SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress|null $main_address main_address
     *
     * @return self
     */
    public function setMainAddress($main_address)
    {
        $this->container['main_address'] = $main_address;

        return $this;
    }

    /**
     * Gets delivery_address
     *
     * @return \SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['delivery_address'];
    }

    /**
     * Sets delivery_address
     *
     * @param \SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress|null $delivery_address delivery_address
     *
     * @return self
     */
    public function setDeliveryAddress($delivery_address)
    {
        $this->container['delivery_address'] = $delivery_address;

        return $this;
    }

    /**
     * Gets shipping_tax_breakdown
     *
     * @return \SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]|null
     */
    public function getShippingTaxBreakdown()
    {
        return $this->container['shipping_tax_breakdown'];
    }

    /**
     * Sets shipping_tax_breakdown
     *
     * @param \SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]|null $shipping_tax_breakdown shipping_tax_breakdown
     *
     * @return self
     */
    public function setShippingTaxBreakdown($shipping_tax_breakdown)
    {
        $this->container['shipping_tax_breakdown'] = $shipping_tax_breakdown;

        return $this;
    }

    /**
     * Gets base_currency_shipping_tax_breakdown
     *
     * @return \SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]|null
     */
    public function getBaseCurrencyShippingTaxBreakdown()
    {
        return $this->container['base_currency_shipping_tax_breakdown'];
    }

    /**
     * Sets base_currency_shipping_tax_breakdown
     *
     * @param \SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]|null $base_currency_shipping_tax_breakdown base_currency_shipping_tax_breakdown
     *
     * @return self
     */
    public function setBaseCurrencyShippingTaxBreakdown($base_currency_shipping_tax_breakdown)
    {
        $this->container['base_currency_shipping_tax_breakdown'] = $base_currency_shipping_tax_breakdown;

        return $this;
    }

    /**
     * Gets tax_analysis
     *
     * @return \SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceTaxAnalysisInner[]|null
     */
    public function getTaxAnalysis()
    {
        return $this->container['tax_analysis'];
    }

    /**
     * Sets tax_analysis
     *
     * @param \SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceTaxAnalysisInner[]|null $tax_analysis tax_analysis
     *
     * @return self
     */
    public function setTaxAnalysis($tax_analysis)
    {
        $this->container['tax_analysis'] = $tax_analysis;

        return $this;
    }

    /**
     * Gets detailed_tax_analysis
     *
     * @return \SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceDetailedTaxAnalysis|null
     */
    public function getDetailedTaxAnalysis()
    {
        return $this->container['detailed_tax_analysis'];
    }

    /**
     * Sets detailed_tax_analysis
     *
     * @param \SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceDetailedTaxAnalysis|null $detailed_tax_analysis detailed_tax_analysis
     *
     * @return self
     */
    public function setDetailedTaxAnalysis($detailed_tax_analysis)
    {
        $this->container['detailed_tax_analysis'] = $detailed_tax_analysis;

        return $this;
    }

    /**
     * Gets profit_analysis
     *
     * @return \SageOne\Model\PostSalesEstimatesSalesEstimateProfitAnalysis|null
     */
    public function getProfitAnalysis()
    {
        return $this->container['profit_analysis'];
    }

    /**
     * Sets profit_analysis
     *
     * @param \SageOne\Model\PostSalesEstimatesSalesEstimateProfitAnalysis|null $profit_analysis profit_analysis
     *
     * @return self
     */
    public function setProfitAnalysis($profit_analysis)
    {
        $this->container['profit_analysis'] = $profit_analysis;

        return $this;
    }

    /**
     * Gets invoice_id
     *
     * @return \SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceOriginalInvoiceIdInner[]|null
     */
    public function getInvoiceId()
    {
        return $this->container['invoice_id'];
    }

    /**
     * Sets invoice_id
     *
     * @param \SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceOriginalInvoiceIdInner[]|null $invoice_id invoice_id
     *
     * @return self
     */
    public function setInvoiceId($invoice_id)
    {
        $this->container['invoice_id'] = $invoice_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


