<?php
/**
 * PostOtherPaymentsOtherPayment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostOtherPaymentsOtherPayment Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostOtherPaymentsOtherPayment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postOtherPayments_other_payment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_type_id' => 'string',
        'date' => '\DateTime',
        'total_amount' => 'double',
        'transaction_id' => 'string',
        'deleted_at' => '\DateTime',
        'payment_method_id' => 'string',
        'contact_id' => 'string',
        'bank_account_id' => 'string',
        'tax_address_region_id' => 'string',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'reference' => 'string',
        'editable' => 'bool',
        'deletable' => 'bool',
        'withholding_tax_rate' => 'double',
        'withholding_tax_amount' => 'double',
        'payment_lines' => '\SageOne\Model\PostOtherPaymentsOtherPaymentPaymentLines'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_type_id' => null,
        'date' => 'date',
        'total_amount' => 'double',
        'transaction_id' => null,
        'deleted_at' => 'date-time',
        'payment_method_id' => null,
        'contact_id' => null,
        'bank_account_id' => null,
        'tax_address_region_id' => null,
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'reference' => null,
        'editable' => null,
        'deletable' => null,
        'withholding_tax_rate' => 'double',
        'withholding_tax_amount' => 'double',
        'payment_lines' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_type_id' => 'transaction_type_id',
        'date' => 'date',
        'total_amount' => 'total_amount',
        'transaction_id' => 'transaction_id',
        'deleted_at' => 'deleted_at',
        'payment_method_id' => 'payment_method_id',
        'contact_id' => 'contact_id',
        'bank_account_id' => 'bank_account_id',
        'tax_address_region_id' => 'tax_address_region_id',
        'net_amount' => 'net_amount',
        'tax_amount' => 'tax_amount',
        'reference' => 'reference',
        'editable' => 'editable',
        'deletable' => 'deletable',
        'withholding_tax_rate' => 'withholding_tax_rate',
        'withholding_tax_amount' => 'withholding_tax_amount',
        'payment_lines' => 'payment_lines'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_type_id' => 'setTransactionTypeId',
        'date' => 'setDate',
        'total_amount' => 'setTotalAmount',
        'transaction_id' => 'setTransactionId',
        'deleted_at' => 'setDeletedAt',
        'payment_method_id' => 'setPaymentMethodId',
        'contact_id' => 'setContactId',
        'bank_account_id' => 'setBankAccountId',
        'tax_address_region_id' => 'setTaxAddressRegionId',
        'net_amount' => 'setNetAmount',
        'tax_amount' => 'setTaxAmount',
        'reference' => 'setReference',
        'editable' => 'setEditable',
        'deletable' => 'setDeletable',
        'withholding_tax_rate' => 'setWithholdingTaxRate',
        'withholding_tax_amount' => 'setWithholdingTaxAmount',
        'payment_lines' => 'setPaymentLines'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_type_id' => 'getTransactionTypeId',
        'date' => 'getDate',
        'total_amount' => 'getTotalAmount',
        'transaction_id' => 'getTransactionId',
        'deleted_at' => 'getDeletedAt',
        'payment_method_id' => 'getPaymentMethodId',
        'contact_id' => 'getContactId',
        'bank_account_id' => 'getBankAccountId',
        'tax_address_region_id' => 'getTaxAddressRegionId',
        'net_amount' => 'getNetAmount',
        'tax_amount' => 'getTaxAmount',
        'reference' => 'getReference',
        'editable' => 'getEditable',
        'deletable' => 'getDeletable',
        'withholding_tax_rate' => 'getWithholdingTaxRate',
        'withholding_tax_amount' => 'getWithholdingTaxAmount',
        'payment_lines' => 'getPaymentLines'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['payment_method_id'] = $data['payment_method_id'] ?? null;
        $this->container['contact_id'] = $data['contact_id'] ?? null;
        $this->container['bank_account_id'] = $data['bank_account_id'] ?? null;
        $this->container['tax_address_region_id'] = $data['tax_address_region_id'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['editable'] = $data['editable'] ?? null;
        $this->container['deletable'] = $data['deletable'] ?? null;
        $this->container['withholding_tax_rate'] = $data['withholding_tax_rate'] ?? null;
        $this->container['withholding_tax_amount'] = $data['withholding_tax_amount'] ?? null;
        $this->container['payment_lines'] = $data['payment_lines'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['transaction_type_id'] === null) {
            $invalidProperties[] = "'transaction_type_id' can't be null";
        }
        if ($this->container['date'] === null) {
            $invalidProperties[] = "'date' can't be null";
        }
        if ($this->container['total_amount'] === null) {
            $invalidProperties[] = "'total_amount' can't be null";
        }
        if ($this->container['payment_lines'] === null) {
            $invalidProperties[] = "'payment_lines' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_type_id
     *
     * @return string
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string $transaction_type_id The transaction type of the payment
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime $date The date of the payment
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double $total_amount The total amount of the payment
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets payment_method_id
     *
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->container['payment_method_id'];
    }

    /**
     * Sets payment_method_id
     *
     * @param string|null $payment_method_id The ID of the Payment Method.
     *
     * @return self
     */
    public function setPaymentMethodId($payment_method_id)
    {
        $this->container['payment_method_id'] = $payment_method_id;

        return $this;
    }

    /**
     * Gets contact_id
     *
     * @return string|null
     */
    public function getContactId()
    {
        return $this->container['contact_id'];
    }

    /**
     * Sets contact_id
     *
     * @param string|null $contact_id The ID of the Contact.
     *
     * @return self
     */
    public function setContactId($contact_id)
    {
        $this->container['contact_id'] = $contact_id;

        return $this;
    }

    /**
     * Gets bank_account_id
     *
     * @return string|null
     */
    public function getBankAccountId()
    {
        return $this->container['bank_account_id'];
    }

    /**
     * Sets bank_account_id
     *
     * @param string|null $bank_account_id The ID of the Bank Account.
     *
     * @return self
     */
    public function setBankAccountId($bank_account_id)
    {
        $this->container['bank_account_id'] = $bank_account_id;

        return $this;
    }

    /**
     * Gets tax_address_region_id
     *
     * @return string|null
     */
    public function getTaxAddressRegionId()
    {
        return $this->container['tax_address_region_id'];
    }

    /**
     * Sets tax_address_region_id
     *
     * @param string|null $tax_address_region_id The ID of the Tax Address Region. (Canada only)
     *
     * @return self
     */
    public function setTaxAddressRegionId($tax_address_region_id)
    {
        $this->container['tax_address_region_id'] = $tax_address_region_id;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double|null $net_amount The net amount of the payment
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double|null $tax_amount The tax amount of the payment
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference A reference of the payment
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets editable
     *
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->container['editable'];
    }

    /**
     * Sets editable
     *
     * @param bool|null $editable Indicates whether or not the payment can be edited
     *
     * @return self
     */
    public function setEditable($editable)
    {
        $this->container['editable'] = $editable;

        return $this;
    }

    /**
     * Gets deletable
     *
     * @return bool|null
     */
    public function getDeletable()
    {
        return $this->container['deletable'];
    }

    /**
     * Sets deletable
     *
     * @param bool|null $deletable Indicates whether or not the payment can be deleted
     *
     * @return self
     */
    public function setDeletable($deletable)
    {
        $this->container['deletable'] = $deletable;

        return $this;
    }

    /**
     * Gets withholding_tax_rate
     *
     * @return double|null
     */
    public function getWithholdingTaxRate()
    {
        return $this->container['withholding_tax_rate'];
    }

    /**
     * Sets withholding_tax_rate
     *
     * @param double|null $withholding_tax_rate IRPF withheld tax rate
     *
     * @return self
     */
    public function setWithholdingTaxRate($withholding_tax_rate)
    {
        $this->container['withholding_tax_rate'] = $withholding_tax_rate;

        return $this;
    }

    /**
     * Gets withholding_tax_amount
     *
     * @return double|null
     */
    public function getWithholdingTaxAmount()
    {
        return $this->container['withholding_tax_amount'];
    }

    /**
     * Sets withholding_tax_amount
     *
     * @param double|null $withholding_tax_amount IRPF withheld tax amount
     *
     * @return self
     */
    public function setWithholdingTaxAmount($withholding_tax_amount)
    {
        $this->container['withholding_tax_amount'] = $withholding_tax_amount;

        return $this;
    }

    /**
     * Gets payment_lines
     *
     * @return \SageOne\Model\PostOtherPaymentsOtherPaymentPaymentLines
     */
    public function getPaymentLines()
    {
        return $this->container['payment_lines'];
    }

    /**
     * Sets payment_lines
     *
     * @param \SageOne\Model\PostOtherPaymentsOtherPaymentPaymentLines $payment_lines payment_lines
     *
     * @return self
     */
    public function setPaymentLines($payment_lines)
    {
        $this->container['payment_lines'] = $payment_lines;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


