<?php
/**
 * PostMigrationTaxReturnsMigrationTaxReturn
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostMigrationTaxReturnsMigrationTaxReturn Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostMigrationTaxReturnsMigrationTaxReturn implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postMigrationTaxReturns_migration_tax_return';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'from_date' => '\DateTime',
        'to_date' => '\DateTime',
        'total_amount' => 'double',
        'tax_return_frequency_id' => 'string',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'gb' => '\SageOne\Model\PostMigrationTaxReturnsMigrationTaxReturnGb',
        'ie' => '\SageOne\Model\PostMigrationTaxReturnsMigrationTaxReturnIe'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'from_date' => 'date',
        'to_date' => 'date',
        'total_amount' => 'double',
        'tax_return_frequency_id' => null,
        'transaction_id' => null,
        'transaction_type_id' => null,
        'gb' => null,
        'ie' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'from_date' => 'from_date',
        'to_date' => 'to_date',
        'total_amount' => 'total_amount',
        'tax_return_frequency_id' => 'tax_return_frequency_id',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'gb' => 'gb',
        'ie' => 'ie'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'from_date' => 'setFromDate',
        'to_date' => 'setToDate',
        'total_amount' => 'setTotalAmount',
        'tax_return_frequency_id' => 'setTaxReturnFrequencyId',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'gb' => 'setGb',
        'ie' => 'setIe'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'from_date' => 'getFromDate',
        'to_date' => 'getToDate',
        'total_amount' => 'getTotalAmount',
        'tax_return_frequency_id' => 'getTaxReturnFrequencyId',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'gb' => 'getGb',
        'ie' => 'getIe'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['from_date'] = $data['from_date'] ?? null;
        $this->container['to_date'] = $data['to_date'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['tax_return_frequency_id'] = $data['tax_return_frequency_id'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['gb'] = $data['gb'] ?? null;
        $this->container['ie'] = $data['ie'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['from_date'] === null) {
            $invalidProperties[] = "'from_date' can't be null";
        }
        if ($this->container['to_date'] === null) {
            $invalidProperties[] = "'to_date' can't be null";
        }
        if ($this->container['total_amount'] === null) {
            $invalidProperties[] = "'total_amount' can't be null";
        }
        if ($this->container['tax_return_frequency_id'] === null) {
            $invalidProperties[] = "'tax_return_frequency_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets from_date
     *
     * @return \DateTime
     */
    public function getFromDate()
    {
        return $this->container['from_date'];
    }

    /**
     * Sets from_date
     *
     * @param \DateTime $from_date The start date of the tax return
     *
     * @return self
     */
    public function setFromDate($from_date)
    {
        $this->container['from_date'] = $from_date;

        return $this;
    }

    /**
     * Gets to_date
     *
     * @return \DateTime
     */
    public function getToDate()
    {
        return $this->container['to_date'];
    }

    /**
     * Sets to_date
     *
     * @param \DateTime $to_date The end date of the tax return
     *
     * @return self
     */
    public function setToDate($to_date)
    {
        $this->container['to_date'] = $to_date;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double $total_amount The total of the tax return
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets tax_return_frequency_id
     *
     * @return string
     */
    public function getTaxReturnFrequencyId()
    {
        return $this->container['tax_return_frequency_id'];
    }

    /**
     * Sets tax_return_frequency_id
     *
     * @param string $tax_return_frequency_id The tax return submission frequency
     *
     * @return self
     */
    public function setTaxReturnFrequencyId($tax_return_frequency_id)
    {
        $this->container['tax_return_frequency_id'] = $tax_return_frequency_id;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets gb
     *
     * @return \SageOne\Model\PostMigrationTaxReturnsMigrationTaxReturnGb|null
     */
    public function getGb()
    {
        return $this->container['gb'];
    }

    /**
     * Sets gb
     *
     * @param \SageOne\Model\PostMigrationTaxReturnsMigrationTaxReturnGb|null $gb gb
     *
     * @return self
     */
    public function setGb($gb)
    {
        $this->container['gb'] = $gb;

        return $this;
    }

    /**
     * Gets ie
     *
     * @return \SageOne\Model\PostMigrationTaxReturnsMigrationTaxReturnIe|null
     */
    public function getIe()
    {
        return $this->container['ie'];
    }

    /**
     * Sets ie
     *
     * @param \SageOne\Model\PostMigrationTaxReturnsMigrationTaxReturnIe|null $ie ie
     *
     * @return self
     */
    public function setIe($ie)
    {
        $this->container['ie'] = $ie;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


