<?php
/**
 * PostLedgerAccountsLedgerAccount
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostLedgerAccountsLedgerAccount Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostLedgerAccountsLedgerAccount implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postLedgerAccounts_ledger_account';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ledger_account_type_id' => 'string',
        'included_in_chart' => 'bool',
        'name' => 'string',
        'display_name' => 'string',
        'nominal_code' => 'int',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'ledger_account_classification_id' => 'string',
        'tax_rate_id' => 'string',
        'fixed_tax_rate' => 'bool',
        'visible_in_banking' => 'bool',
        'visible_in_expenses' => 'bool',
        'visible_in_journals' => 'bool',
        'visible_in_other_payments' => 'bool',
        'visible_in_other_receipts' => 'bool',
        'visible_in_reporting' => 'bool',
        'visible_in_sales' => 'bool',
        'is_control_account' => 'bool',
        'control_name' => 'string',
        'display_formatted' => 'string',
        'balance_details' => '\SageOne\Model\PutLedgerAccountsLedgerAccountBalanceDetails'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ledger_account_type_id' => null,
        'included_in_chart' => null,
        'name' => null,
        'display_name' => null,
        'nominal_code' => 'int32',
        'transaction_id' => null,
        'transaction_type_id' => null,
        'ledger_account_classification_id' => null,
        'tax_rate_id' => null,
        'fixed_tax_rate' => null,
        'visible_in_banking' => null,
        'visible_in_expenses' => null,
        'visible_in_journals' => null,
        'visible_in_other_payments' => null,
        'visible_in_other_receipts' => null,
        'visible_in_reporting' => null,
        'visible_in_sales' => null,
        'is_control_account' => null,
        'control_name' => null,
        'display_formatted' => null,
        'balance_details' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ledger_account_type_id' => 'ledger_account_type_id',
        'included_in_chart' => 'included_in_chart',
        'name' => 'name',
        'display_name' => 'display_name',
        'nominal_code' => 'nominal_code',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'ledger_account_classification_id' => 'ledger_account_classification_id',
        'tax_rate_id' => 'tax_rate_id',
        'fixed_tax_rate' => 'fixed_tax_rate',
        'visible_in_banking' => 'visible_in_banking',
        'visible_in_expenses' => 'visible_in_expenses',
        'visible_in_journals' => 'visible_in_journals',
        'visible_in_other_payments' => 'visible_in_other_payments',
        'visible_in_other_receipts' => 'visible_in_other_receipts',
        'visible_in_reporting' => 'visible_in_reporting',
        'visible_in_sales' => 'visible_in_sales',
        'is_control_account' => 'is_control_account',
        'control_name' => 'control_name',
        'display_formatted' => 'display_formatted',
        'balance_details' => 'balance_details'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ledger_account_type_id' => 'setLedgerAccountTypeId',
        'included_in_chart' => 'setIncludedInChart',
        'name' => 'setName',
        'display_name' => 'setDisplayName',
        'nominal_code' => 'setNominalCode',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'ledger_account_classification_id' => 'setLedgerAccountClassificationId',
        'tax_rate_id' => 'setTaxRateId',
        'fixed_tax_rate' => 'setFixedTaxRate',
        'visible_in_banking' => 'setVisibleInBanking',
        'visible_in_expenses' => 'setVisibleInExpenses',
        'visible_in_journals' => 'setVisibleInJournals',
        'visible_in_other_payments' => 'setVisibleInOtherPayments',
        'visible_in_other_receipts' => 'setVisibleInOtherReceipts',
        'visible_in_reporting' => 'setVisibleInReporting',
        'visible_in_sales' => 'setVisibleInSales',
        'is_control_account' => 'setIsControlAccount',
        'control_name' => 'setControlName',
        'display_formatted' => 'setDisplayFormatted',
        'balance_details' => 'setBalanceDetails'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ledger_account_type_id' => 'getLedgerAccountTypeId',
        'included_in_chart' => 'getIncludedInChart',
        'name' => 'getName',
        'display_name' => 'getDisplayName',
        'nominal_code' => 'getNominalCode',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'ledger_account_classification_id' => 'getLedgerAccountClassificationId',
        'tax_rate_id' => 'getTaxRateId',
        'fixed_tax_rate' => 'getFixedTaxRate',
        'visible_in_banking' => 'getVisibleInBanking',
        'visible_in_expenses' => 'getVisibleInExpenses',
        'visible_in_journals' => 'getVisibleInJournals',
        'visible_in_other_payments' => 'getVisibleInOtherPayments',
        'visible_in_other_receipts' => 'getVisibleInOtherReceipts',
        'visible_in_reporting' => 'getVisibleInReporting',
        'visible_in_sales' => 'getVisibleInSales',
        'is_control_account' => 'getIsControlAccount',
        'control_name' => 'getControlName',
        'display_formatted' => 'getDisplayFormatted',
        'balance_details' => 'getBalanceDetails'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['ledger_account_type_id'] = $data['ledger_account_type_id'] ?? null;
        $this->container['included_in_chart'] = $data['included_in_chart'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['display_name'] = $data['display_name'] ?? null;
        $this->container['nominal_code'] = $data['nominal_code'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['ledger_account_classification_id'] = $data['ledger_account_classification_id'] ?? null;
        $this->container['tax_rate_id'] = $data['tax_rate_id'] ?? null;
        $this->container['fixed_tax_rate'] = $data['fixed_tax_rate'] ?? null;
        $this->container['visible_in_banking'] = $data['visible_in_banking'] ?? null;
        $this->container['visible_in_expenses'] = $data['visible_in_expenses'] ?? null;
        $this->container['visible_in_journals'] = $data['visible_in_journals'] ?? null;
        $this->container['visible_in_other_payments'] = $data['visible_in_other_payments'] ?? null;
        $this->container['visible_in_other_receipts'] = $data['visible_in_other_receipts'] ?? null;
        $this->container['visible_in_reporting'] = $data['visible_in_reporting'] ?? null;
        $this->container['visible_in_sales'] = $data['visible_in_sales'] ?? null;
        $this->container['is_control_account'] = $data['is_control_account'] ?? null;
        $this->container['control_name'] = $data['control_name'] ?? null;
        $this->container['display_formatted'] = $data['display_formatted'] ?? null;
        $this->container['balance_details'] = $data['balance_details'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['ledger_account_type_id'] === null) {
            $invalidProperties[] = "'ledger_account_type_id' can't be null";
        }
        if ($this->container['included_in_chart'] === null) {
            $invalidProperties[] = "'included_in_chart' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['display_name'] === null) {
            $invalidProperties[] = "'display_name' can't be null";
        }
        if ($this->container['nominal_code'] === null) {
            $invalidProperties[] = "'nominal_code' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ledger_account_type_id
     *
     * @return string
     */
    public function getLedgerAccountTypeId()
    {
        return $this->container['ledger_account_type_id'];
    }

    /**
     * Sets ledger_account_type_id
     *
     * @param string $ledger_account_type_id The ledger account type for the ledger account
     *
     * @return self
     */
    public function setLedgerAccountTypeId($ledger_account_type_id)
    {
        $this->container['ledger_account_type_id'] = $ledger_account_type_id;

        return $this;
    }

    /**
     * Gets included_in_chart
     *
     * @return bool
     */
    public function getIncludedInChart()
    {
        return $this->container['included_in_chart'];
    }

    /**
     * Sets included_in_chart
     *
     * @param bool $included_in_chart Indicates whether the ledger account is included in the chart of accounts
     *
     * @return self
     */
    public function setIncludedInChart($included_in_chart)
    {
        $this->container['included_in_chart'] = $included_in_chart;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name for the ledger account
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets display_name
     *
     * @return string
     */
    public function getDisplayName()
    {
        return $this->container['display_name'];
    }

    /**
     * Sets display_name
     *
     * @param string $display_name The display name for the ledger account
     *
     * @return self
     */
    public function setDisplayName($display_name)
    {
        $this->container['display_name'] = $display_name;

        return $this;
    }

    /**
     * Gets nominal_code
     *
     * @return int
     */
    public function getNominalCode()
    {
        return $this->container['nominal_code'];
    }

    /**
     * Sets nominal_code
     *
     * @param int $nominal_code The nominal code of the ledger account
     *
     * @return self
     */
    public function setNominalCode($nominal_code)
    {
        $this->container['nominal_code'] = $nominal_code;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets ledger_account_classification_id
     *
     * @return string|null
     */
    public function getLedgerAccountClassificationId()
    {
        return $this->container['ledger_account_classification_id'];
    }

    /**
     * Sets ledger_account_classification_id
     *
     * @param string|null $ledger_account_classification_id The ID of the Ledger Account Classification.
     *
     * @return self
     */
    public function setLedgerAccountClassificationId($ledger_account_classification_id)
    {
        $this->container['ledger_account_classification_id'] = $ledger_account_classification_id;

        return $this;
    }

    /**
     * Gets tax_rate_id
     *
     * @return string|null
     */
    public function getTaxRateId()
    {
        return $this->container['tax_rate_id'];
    }

    /**
     * Sets tax_rate_id
     *
     * @param string|null $tax_rate_id The ID of the Tax Rate.
     *
     * @return self
     */
    public function setTaxRateId($tax_rate_id)
    {
        $this->container['tax_rate_id'] = $tax_rate_id;

        return $this;
    }

    /**
     * Gets fixed_tax_rate
     *
     * @return bool|null
     */
    public function getFixedTaxRate()
    {
        return $this->container['fixed_tax_rate'];
    }

    /**
     * Sets fixed_tax_rate
     *
     * @param bool|null $fixed_tax_rate Indicates whether the default tax rate is fixed or may be changed
     *
     * @return self
     */
    public function setFixedTaxRate($fixed_tax_rate)
    {
        $this->container['fixed_tax_rate'] = $fixed_tax_rate;

        return $this;
    }

    /**
     * Gets visible_in_banking
     *
     * @return bool|null
     */
    public function getVisibleInBanking()
    {
        return $this->container['visible_in_banking'];
    }

    /**
     * Sets visible_in_banking
     *
     * @param bool|null $visible_in_banking Indicates whether the ledger account is displayed in this area of the application
     *
     * @return self
     */
    public function setVisibleInBanking($visible_in_banking)
    {
        $this->container['visible_in_banking'] = $visible_in_banking;

        return $this;
    }

    /**
     * Gets visible_in_expenses
     *
     * @return bool|null
     */
    public function getVisibleInExpenses()
    {
        return $this->container['visible_in_expenses'];
    }

    /**
     * Sets visible_in_expenses
     *
     * @param bool|null $visible_in_expenses Indicates whether the ledger account is displayed in this area of the application
     *
     * @return self
     */
    public function setVisibleInExpenses($visible_in_expenses)
    {
        $this->container['visible_in_expenses'] = $visible_in_expenses;

        return $this;
    }

    /**
     * Gets visible_in_journals
     *
     * @return bool|null
     */
    public function getVisibleInJournals()
    {
        return $this->container['visible_in_journals'];
    }

    /**
     * Sets visible_in_journals
     *
     * @param bool|null $visible_in_journals Indicates whether the ledger account is displayed in this area of the application
     *
     * @return self
     */
    public function setVisibleInJournals($visible_in_journals)
    {
        $this->container['visible_in_journals'] = $visible_in_journals;

        return $this;
    }

    /**
     * Gets visible_in_other_payments
     *
     * @return bool|null
     */
    public function getVisibleInOtherPayments()
    {
        return $this->container['visible_in_other_payments'];
    }

    /**
     * Sets visible_in_other_payments
     *
     * @param bool|null $visible_in_other_payments Indicates whether the ledger account is displayed in this area of the application
     *
     * @return self
     */
    public function setVisibleInOtherPayments($visible_in_other_payments)
    {
        $this->container['visible_in_other_payments'] = $visible_in_other_payments;

        return $this;
    }

    /**
     * Gets visible_in_other_receipts
     *
     * @return bool|null
     */
    public function getVisibleInOtherReceipts()
    {
        return $this->container['visible_in_other_receipts'];
    }

    /**
     * Sets visible_in_other_receipts
     *
     * @param bool|null $visible_in_other_receipts Indicates whether the ledger account is displayed in this area of the application
     *
     * @return self
     */
    public function setVisibleInOtherReceipts($visible_in_other_receipts)
    {
        $this->container['visible_in_other_receipts'] = $visible_in_other_receipts;

        return $this;
    }

    /**
     * Gets visible_in_reporting
     *
     * @return bool|null
     */
    public function getVisibleInReporting()
    {
        return $this->container['visible_in_reporting'];
    }

    /**
     * Sets visible_in_reporting
     *
     * @param bool|null $visible_in_reporting Indicates whether the ledger account is displayed in this area of the application
     *
     * @return self
     */
    public function setVisibleInReporting($visible_in_reporting)
    {
        $this->container['visible_in_reporting'] = $visible_in_reporting;

        return $this;
    }

    /**
     * Gets visible_in_sales
     *
     * @return bool|null
     */
    public function getVisibleInSales()
    {
        return $this->container['visible_in_sales'];
    }

    /**
     * Sets visible_in_sales
     *
     * @param bool|null $visible_in_sales Indicates whether the ledger account is displayed in this area of the application
     *
     * @return self
     */
    public function setVisibleInSales($visible_in_sales)
    {
        $this->container['visible_in_sales'] = $visible_in_sales;

        return $this;
    }

    /**
     * Gets is_control_account
     *
     * @return bool|null
     */
    public function getIsControlAccount()
    {
        return $this->container['is_control_account'];
    }

    /**
     * Sets is_control_account
     *
     * @param bool|null $is_control_account Indicates whether the ledger account is a control account
     *
     * @return self
     */
    public function setIsControlAccount($is_control_account)
    {
        $this->container['is_control_account'] = $is_control_account;

        return $this;
    }

    /**
     * Gets control_name
     *
     * @return string|null
     */
    public function getControlName()
    {
        return $this->container['control_name'];
    }

    /**
     * Sets control_name
     *
     * @param string|null $control_name The control name for the ledger account
     *
     * @return self
     */
    public function setControlName($control_name)
    {
        $this->container['control_name'] = $control_name;

        return $this;
    }

    /**
     * Gets display_formatted
     *
     * @return string|null
     */
    public function getDisplayFormatted()
    {
        return $this->container['display_formatted'];
    }

    /**
     * Sets display_formatted
     *
     * @param string|null $display_formatted The display name formatted based on coa_list_order in settings
     *
     * @return self
     */
    public function setDisplayFormatted($display_formatted)
    {
        $this->container['display_formatted'] = $display_formatted;

        return $this;
    }

    /**
     * Gets balance_details
     *
     * @return \SageOne\Model\PutLedgerAccountsLedgerAccountBalanceDetails|null
     */
    public function getBalanceDetails()
    {
        return $this->container['balance_details'];
    }

    /**
     * Sets balance_details
     *
     * @param \SageOne\Model\PutLedgerAccountsLedgerAccountBalanceDetails|null $balance_details balance_details
     *
     * @return self
     */
    public function setBalanceDetails($balance_details)
    {
        $this->container['balance_details'] = $balance_details;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


