<?php
/**
 * PostJournalsJournalJournalLinesInner
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostJournalsJournalJournalLinesInner Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostJournalsJournalJournalLinesInner implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postJournals_journal_journal_lines_inner';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ledger_account_id' => 'string',
        'debit' => 'double',
        'credit' => 'double',
        'details' => 'string',
        'include_on_tax_return' => 'bool',
        'tax_reconciled' => 'bool',
        'cleared' => 'bool',
        'bank_reconciled' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ledger_account_id' => null,
        'debit' => 'double',
        'credit' => 'double',
        'details' => null,
        'include_on_tax_return' => null,
        'tax_reconciled' => null,
        'cleared' => null,
        'bank_reconciled' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ledger_account_id' => 'ledger_account_id',
        'debit' => 'debit',
        'credit' => 'credit',
        'details' => 'details',
        'include_on_tax_return' => 'include_on_tax_return',
        'tax_reconciled' => 'tax_reconciled',
        'cleared' => 'cleared',
        'bank_reconciled' => 'bank_reconciled'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ledger_account_id' => 'setLedgerAccountId',
        'debit' => 'setDebit',
        'credit' => 'setCredit',
        'details' => 'setDetails',
        'include_on_tax_return' => 'setIncludeOnTaxReturn',
        'tax_reconciled' => 'setTaxReconciled',
        'cleared' => 'setCleared',
        'bank_reconciled' => 'setBankReconciled'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ledger_account_id' => 'getLedgerAccountId',
        'debit' => 'getDebit',
        'credit' => 'getCredit',
        'details' => 'getDetails',
        'include_on_tax_return' => 'getIncludeOnTaxReturn',
        'tax_reconciled' => 'getTaxReconciled',
        'cleared' => 'getCleared',
        'bank_reconciled' => 'getBankReconciled'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['ledger_account_id'] = $data['ledger_account_id'] ?? null;
        $this->container['debit'] = $data['debit'] ?? null;
        $this->container['credit'] = $data['credit'] ?? null;
        $this->container['details'] = $data['details'] ?? null;
        $this->container['include_on_tax_return'] = $data['include_on_tax_return'] ?? null;
        $this->container['tax_reconciled'] = $data['tax_reconciled'] ?? null;
        $this->container['cleared'] = $data['cleared'] ?? null;
        $this->container['bank_reconciled'] = $data['bank_reconciled'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['ledger_account_id'] === null) {
            $invalidProperties[] = "'ledger_account_id' can't be null";
        }
        if ($this->container['debit'] === null) {
            $invalidProperties[] = "'debit' can't be null";
        }
        if ($this->container['credit'] === null) {
            $invalidProperties[] = "'credit' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ledger_account_id
     *
     * @return string
     */
    public function getLedgerAccountId()
    {
        return $this->container['ledger_account_id'];
    }

    /**
     * Sets ledger_account_id
     *
     * @param string $ledger_account_id The ID of the Ledger Account.
     *
     * @return self
     */
    public function setLedgerAccountId($ledger_account_id)
    {
        $this->container['ledger_account_id'] = $ledger_account_id;

        return $this;
    }

    /**
     * Gets debit
     *
     * @return double
     */
    public function getDebit()
    {
        return $this->container['debit'];
    }

    /**
     * Sets debit
     *
     * @param double $debit The debit amount of the journal line
     *
     * @return self
     */
    public function setDebit($debit)
    {
        $this->container['debit'] = $debit;

        return $this;
    }

    /**
     * Gets credit
     *
     * @return double
     */
    public function getCredit()
    {
        return $this->container['credit'];
    }

    /**
     * Sets credit
     *
     * @param double $credit The credit amount of the journal line
     *
     * @return self
     */
    public function setCredit($credit)
    {
        $this->container['credit'] = $credit;

        return $this;
    }

    /**
     * Gets details
     *
     * @return string|null
     */
    public function getDetails()
    {
        return $this->container['details'];
    }

    /**
     * Sets details
     *
     * @param string|null $details A description of the journal line
     *
     * @return self
     */
    public function setDetails($details)
    {
        $this->container['details'] = $details;

        return $this;
    }

    /**
     * Gets include_on_tax_return
     *
     * @return bool|null
     */
    public function getIncludeOnTaxReturn()
    {
        return $this->container['include_on_tax_return'];
    }

    /**
     * Sets include_on_tax_return
     *
     * @param bool|null $include_on_tax_return Indicates whether the journal line should affect the tax return
     *
     * @return self
     */
    public function setIncludeOnTaxReturn($include_on_tax_return)
    {
        $this->container['include_on_tax_return'] = $include_on_tax_return;

        return $this;
    }

    /**
     * Gets tax_reconciled
     *
     * @return bool|null
     */
    public function getTaxReconciled()
    {
        return $this->container['tax_reconciled'];
    }

    /**
     * Sets tax_reconciled
     *
     * @param bool|null $tax_reconciled Indicates if the journal line is tax reconciled or not.
     *
     * @return self
     */
    public function setTaxReconciled($tax_reconciled)
    {
        $this->container['tax_reconciled'] = $tax_reconciled;

        return $this;
    }

    /**
     * Gets cleared
     *
     * @return bool|null
     */
    public function getCleared()
    {
        return $this->container['cleared'];
    }

    /**
     * Sets cleared
     *
     * @param bool|null $cleared Indicates if the journal line is cleared or not.
     *
     * @return self
     */
    public function setCleared($cleared)
    {
        $this->container['cleared'] = $cleared;

        return $this;
    }

    /**
     * Gets bank_reconciled
     *
     * @return bool|null
     */
    public function getBankReconciled()
    {
        return $this->container['bank_reconciled'];
    }

    /**
     * Sets bank_reconciled
     *
     * @param bool|null $bank_reconciled Indicates if the journal line is bank reconciled or not.
     *
     * @return self
     */
    public function setBankReconciled($bank_reconciled)
    {
        $this->container['bank_reconciled'] = $bank_reconciled;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


