<?php
/**
 * PostContactsContact
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostContactsContact Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostContactsContact implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postContacts_contact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'contact_type_ids' => 'string[]',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'deleted_at' => '\DateTime',
        'balance' => 'double',
        'reference' => 'string',
        'default_sales_ledger_account_id' => 'string',
        'default_sales_tax_rate_id' => 'string',
        'default_purchase_ledger_account_id' => 'string',
        'tax_number' => 'string',
        'notes' => 'string',
        'locale' => 'string',
        'credit_limit' => 'double',
        'credit_days' => 'int',
        'credit_terms_and_conditions' => 'string',
        'product_sales_price_type_id' => 'string',
        'source_guid' => 'string',
        'currency_id' => 'string',
        'aux_reference' => 'string',
        'registered_number' => 'string',
        'deletable' => 'bool',
        'email' => 'string',
        'tax_calculation' => 'string',
        'auxiliary_account' => 'string',
        'gdpr_obfuscated' => 'bool',
        'system' => 'bool',
        'links' => '\SageOne\Model\PostContactsContactLinksInner[]',
        'main_address' => '\SageOne\Model\PostBankAccountsBankAccountMainAddress',
        'delivery_address' => '\SageOne\Model\PostBankAccountsBankAccountMainAddress',
        'main_contact_person' => '\SageOne\Model\PostContactsContactMainContactPerson',
        'bank_account_details' => '\SageOne\Model\PutBankAccountsBankAccountBankAccountDetails',
        'tax_treatment' => '\SageOne\Model\PostContactsContactTaxTreatment'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'contact_type_ids' => null,
        'transaction_id' => null,
        'transaction_type_id' => null,
        'deleted_at' => 'date-time',
        'balance' => 'double',
        'reference' => null,
        'default_sales_ledger_account_id' => null,
        'default_sales_tax_rate_id' => null,
        'default_purchase_ledger_account_id' => null,
        'tax_number' => null,
        'notes' => null,
        'locale' => null,
        'credit_limit' => 'double',
        'credit_days' => 'int32',
        'credit_terms_and_conditions' => null,
        'product_sales_price_type_id' => null,
        'source_guid' => null,
        'currency_id' => null,
        'aux_reference' => null,
        'registered_number' => null,
        'deletable' => null,
        'email' => null,
        'tax_calculation' => null,
        'auxiliary_account' => null,
        'gdpr_obfuscated' => null,
        'system' => null,
        'links' => null,
        'main_address' => null,
        'delivery_address' => null,
        'main_contact_person' => null,
        'bank_account_details' => null,
        'tax_treatment' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'contact_type_ids' => 'contact_type_ids',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'deleted_at' => 'deleted_at',
        'balance' => 'balance',
        'reference' => 'reference',
        'default_sales_ledger_account_id' => 'default_sales_ledger_account_id',
        'default_sales_tax_rate_id' => 'default_sales_tax_rate_id',
        'default_purchase_ledger_account_id' => 'default_purchase_ledger_account_id',
        'tax_number' => 'tax_number',
        'notes' => 'notes',
        'locale' => 'locale',
        'credit_limit' => 'credit_limit',
        'credit_days' => 'credit_days',
        'credit_terms_and_conditions' => 'credit_terms_and_conditions',
        'product_sales_price_type_id' => 'product_sales_price_type_id',
        'source_guid' => 'source_guid',
        'currency_id' => 'currency_id',
        'aux_reference' => 'aux_reference',
        'registered_number' => 'registered_number',
        'deletable' => 'deletable',
        'email' => 'email',
        'tax_calculation' => 'tax_calculation',
        'auxiliary_account' => 'auxiliary_account',
        'gdpr_obfuscated' => 'gdpr_obfuscated',
        'system' => 'system',
        'links' => 'links',
        'main_address' => 'main_address',
        'delivery_address' => 'delivery_address',
        'main_contact_person' => 'main_contact_person',
        'bank_account_details' => 'bank_account_details',
        'tax_treatment' => 'tax_treatment'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'contact_type_ids' => 'setContactTypeIds',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'deleted_at' => 'setDeletedAt',
        'balance' => 'setBalance',
        'reference' => 'setReference',
        'default_sales_ledger_account_id' => 'setDefaultSalesLedgerAccountId',
        'default_sales_tax_rate_id' => 'setDefaultSalesTaxRateId',
        'default_purchase_ledger_account_id' => 'setDefaultPurchaseLedgerAccountId',
        'tax_number' => 'setTaxNumber',
        'notes' => 'setNotes',
        'locale' => 'setLocale',
        'credit_limit' => 'setCreditLimit',
        'credit_days' => 'setCreditDays',
        'credit_terms_and_conditions' => 'setCreditTermsAndConditions',
        'product_sales_price_type_id' => 'setProductSalesPriceTypeId',
        'source_guid' => 'setSourceGuid',
        'currency_id' => 'setCurrencyId',
        'aux_reference' => 'setAuxReference',
        'registered_number' => 'setRegisteredNumber',
        'deletable' => 'setDeletable',
        'email' => 'setEmail',
        'tax_calculation' => 'setTaxCalculation',
        'auxiliary_account' => 'setAuxiliaryAccount',
        'gdpr_obfuscated' => 'setGdprObfuscated',
        'system' => 'setSystem',
        'links' => 'setLinks',
        'main_address' => 'setMainAddress',
        'delivery_address' => 'setDeliveryAddress',
        'main_contact_person' => 'setMainContactPerson',
        'bank_account_details' => 'setBankAccountDetails',
        'tax_treatment' => 'setTaxTreatment'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'contact_type_ids' => 'getContactTypeIds',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'deleted_at' => 'getDeletedAt',
        'balance' => 'getBalance',
        'reference' => 'getReference',
        'default_sales_ledger_account_id' => 'getDefaultSalesLedgerAccountId',
        'default_sales_tax_rate_id' => 'getDefaultSalesTaxRateId',
        'default_purchase_ledger_account_id' => 'getDefaultPurchaseLedgerAccountId',
        'tax_number' => 'getTaxNumber',
        'notes' => 'getNotes',
        'locale' => 'getLocale',
        'credit_limit' => 'getCreditLimit',
        'credit_days' => 'getCreditDays',
        'credit_terms_and_conditions' => 'getCreditTermsAndConditions',
        'product_sales_price_type_id' => 'getProductSalesPriceTypeId',
        'source_guid' => 'getSourceGuid',
        'currency_id' => 'getCurrencyId',
        'aux_reference' => 'getAuxReference',
        'registered_number' => 'getRegisteredNumber',
        'deletable' => 'getDeletable',
        'email' => 'getEmail',
        'tax_calculation' => 'getTaxCalculation',
        'auxiliary_account' => 'getAuxiliaryAccount',
        'gdpr_obfuscated' => 'getGdprObfuscated',
        'system' => 'getSystem',
        'links' => 'getLinks',
        'main_address' => 'getMainAddress',
        'delivery_address' => 'getDeliveryAddress',
        'main_contact_person' => 'getMainContactPerson',
        'bank_account_details' => 'getBankAccountDetails',
        'tax_treatment' => 'getTaxTreatment'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = $data['name'] ?? null;
        $this->container['contact_type_ids'] = $data['contact_type_ids'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['balance'] = $data['balance'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['default_sales_ledger_account_id'] = $data['default_sales_ledger_account_id'] ?? null;
        $this->container['default_sales_tax_rate_id'] = $data['default_sales_tax_rate_id'] ?? null;
        $this->container['default_purchase_ledger_account_id'] = $data['default_purchase_ledger_account_id'] ?? null;
        $this->container['tax_number'] = $data['tax_number'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['locale'] = $data['locale'] ?? null;
        $this->container['credit_limit'] = $data['credit_limit'] ?? null;
        $this->container['credit_days'] = $data['credit_days'] ?? null;
        $this->container['credit_terms_and_conditions'] = $data['credit_terms_and_conditions'] ?? null;
        $this->container['product_sales_price_type_id'] = $data['product_sales_price_type_id'] ?? null;
        $this->container['source_guid'] = $data['source_guid'] ?? null;
        $this->container['currency_id'] = $data['currency_id'] ?? null;
        $this->container['aux_reference'] = $data['aux_reference'] ?? null;
        $this->container['registered_number'] = $data['registered_number'] ?? null;
        $this->container['deletable'] = $data['deletable'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['tax_calculation'] = $data['tax_calculation'] ?? null;
        $this->container['auxiliary_account'] = $data['auxiliary_account'] ?? null;
        $this->container['gdpr_obfuscated'] = $data['gdpr_obfuscated'] ?? null;
        $this->container['system'] = $data['system'] ?? null;
        $this->container['links'] = $data['links'] ?? null;
        $this->container['main_address'] = $data['main_address'] ?? null;
        $this->container['delivery_address'] = $data['delivery_address'] ?? null;
        $this->container['main_contact_person'] = $data['main_contact_person'] ?? null;
        $this->container['bank_account_details'] = $data['bank_account_details'] ?? null;
        $this->container['tax_treatment'] = $data['tax_treatment'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['contact_type_ids'] === null) {
            $invalidProperties[] = "'contact_type_ids' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name of the contact
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets contact_type_ids
     *
     * @return string[]
     */
    public function getContactTypeIds()
    {
        return $this->container['contact_type_ids'];
    }

    /**
     * Sets contact_type_ids
     *
     * @param string[] $contact_type_ids The IDs of the Contact Types.
     *
     * @return self
     */
    public function setContactTypeIds($contact_type_ids)
    {
        $this->container['contact_type_ids'] = $contact_type_ids;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return double|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param double|null $balance The contact balance
     *
     * @return self
     */
    public function setBalance($balance)
    {
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference The reference for the contact
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets default_sales_ledger_account_id
     *
     * @return string|null
     */
    public function getDefaultSalesLedgerAccountId()
    {
        return $this->container['default_sales_ledger_account_id'];
    }

    /**
     * Sets default_sales_ledger_account_id
     *
     * @param string|null $default_sales_ledger_account_id The ID of the Default Sales Ledger Account.
     *
     * @return self
     */
    public function setDefaultSalesLedgerAccountId($default_sales_ledger_account_id)
    {
        $this->container['default_sales_ledger_account_id'] = $default_sales_ledger_account_id;

        return $this;
    }

    /**
     * Gets default_sales_tax_rate_id
     *
     * @return string|null
     */
    public function getDefaultSalesTaxRateId()
    {
        return $this->container['default_sales_tax_rate_id'];
    }

    /**
     * Sets default_sales_tax_rate_id
     *
     * @param string|null $default_sales_tax_rate_id The ID of the Default Sales Tax Rate.
     *
     * @return self
     */
    public function setDefaultSalesTaxRateId($default_sales_tax_rate_id)
    {
        $this->container['default_sales_tax_rate_id'] = $default_sales_tax_rate_id;

        return $this;
    }

    /**
     * Gets default_purchase_ledger_account_id
     *
     * @return string|null
     */
    public function getDefaultPurchaseLedgerAccountId()
    {
        return $this->container['default_purchase_ledger_account_id'];
    }

    /**
     * Sets default_purchase_ledger_account_id
     *
     * @param string|null $default_purchase_ledger_account_id The ID of the Default Purchase Ledger Account.
     *
     * @return self
     */
    public function setDefaultPurchaseLedgerAccountId($default_purchase_ledger_account_id)
    {
        $this->container['default_purchase_ledger_account_id'] = $default_purchase_ledger_account_id;

        return $this;
    }

    /**
     * Gets tax_number
     *
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->container['tax_number'];
    }

    /**
     * Sets tax_number
     *
     * @param string|null $tax_number The tax number for the contact
     *
     * @return self
     */
    public function setTaxNumber($tax_number)
    {
        $this->container['tax_number'] = $tax_number;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes The notes for the contact
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return string|null
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param string|null $locale The locale for the contact
     *
     * @return self
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets credit_limit
     *
     * @return double|null
     */
    public function getCreditLimit()
    {
        return $this->container['credit_limit'];
    }

    /**
     * Sets credit_limit
     *
     * @param double|null $credit_limit Custom credit limit amount for the contact
     *
     * @return self
     */
    public function setCreditLimit($credit_limit)
    {
        $this->container['credit_limit'] = $credit_limit;

        return $this;
    }

    /**
     * Gets credit_days
     *
     * @return int|null
     */
    public function getCreditDays()
    {
        return $this->container['credit_days'];
    }

    /**
     * Sets credit_days
     *
     * @param int|null $credit_days Custom credit days for the contact If returned as null in a GET response, you may want to GET /invoice_settings and use 'vendor_credit_days' as default/fallback according to your use case.
     *
     * @return self
     */
    public function setCreditDays($credit_days)
    {
        $this->container['credit_days'] = $credit_days;

        return $this;
    }

    /**
     * Gets credit_terms_and_conditions
     *
     * @return string|null
     */
    public function getCreditTermsAndConditions()
    {
        return $this->container['credit_terms_and_conditions'];
    }

    /**
     * Sets credit_terms_and_conditions
     *
     * @param string|null $credit_terms_and_conditions Custom terms and conditions for the contact (Customers only)
     *
     * @return self
     */
    public function setCreditTermsAndConditions($credit_terms_and_conditions)
    {
        $this->container['credit_terms_and_conditions'] = $credit_terms_and_conditions;

        return $this;
    }

    /**
     * Gets product_sales_price_type_id
     *
     * @return string|null
     */
    public function getProductSalesPriceTypeId()
    {
        return $this->container['product_sales_price_type_id'];
    }

    /**
     * Sets product_sales_price_type_id
     *
     * @param string|null $product_sales_price_type_id The ID of the Product Sales Price Type.
     *
     * @return self
     */
    public function setProductSalesPriceTypeId($product_sales_price_type_id)
    {
        $this->container['product_sales_price_type_id'] = $product_sales_price_type_id;

        return $this;
    }

    /**
     * Gets source_guid
     *
     * @return string|null
     */
    public function getSourceGuid()
    {
        return $this->container['source_guid'];
    }

    /**
     * Sets source_guid
     *
     * @param string|null $source_guid Used when importing contacts from external sources
     *
     * @return self
     */
    public function setSourceGuid($source_guid)
    {
        $this->container['source_guid'] = $source_guid;

        return $this;
    }

    /**
     * Gets currency_id
     *
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->container['currency_id'];
    }

    /**
     * Sets currency_id
     *
     * @param string|null $currency_id The ID of the Currency.
     *
     * @return self
     */
    public function setCurrencyId($currency_id)
    {
        $this->container['currency_id'] = $currency_id;

        return $this;
    }

    /**
     * Gets aux_reference
     *
     * @return string|null
     */
    public function getAuxReference()
    {
        return $this->container['aux_reference'];
    }

    /**
     * Sets aux_reference
     *
     * @param string|null $aux_reference Auxiliary reference. Used for German \"Kreditorennummer\" and \"Debitorennummer\"
     *
     * @return self
     */
    public function setAuxReference($aux_reference)
    {
        $this->container['aux_reference'] = $aux_reference;

        return $this;
    }

    /**
     * Gets registered_number
     *
     * @return string|null
     */
    public function getRegisteredNumber()
    {
        return $this->container['registered_number'];
    }

    /**
     * Sets registered_number
     *
     * @param string|null $registered_number The registered number of the contact's business. Only used for German businesses and represents the \"Steuernummer\" there (not the \"USt-ID\").
     *
     * @return self
     */
    public function setRegisteredNumber($registered_number)
    {
        $this->container['registered_number'] = $registered_number;

        return $this;
    }

    /**
     * Gets deletable
     *
     * @return bool|null
     */
    public function getDeletable()
    {
        return $this->container['deletable'];
    }

    /**
     * Sets deletable
     *
     * @param bool|null $deletable Indicates whether the ledger entry has been deleted or not
     *
     * @return self
     */
    public function setDeletable($deletable)
    {
        $this->container['deletable'] = $deletable;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email The email address for the given contact
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets tax_calculation
     *
     * @return string|null
     */
    public function getTaxCalculation()
    {
        return $this->container['tax_calculation'];
    }

    /**
     * Sets tax_calculation
     *
     * @param string|null $tax_calculation The tax calculation method - used for French VAT & Recargo
     *
     * @return self
     */
    public function setTaxCalculation($tax_calculation)
    {
        $this->container['tax_calculation'] = $tax_calculation;

        return $this;
    }

    /**
     * Gets auxiliary_account
     *
     * @return string|null
     */
    public function getAuxiliaryAccount()
    {
        return $this->container['auxiliary_account'];
    }

    /**
     * Sets auxiliary_account
     *
     * @param string|null $auxiliary_account Auxiliary account - used when auxiliary accounting is enabled in business settings
     *
     * @return self
     */
    public function setAuxiliaryAccount($auxiliary_account)
    {
        $this->container['auxiliary_account'] = $auxiliary_account;

        return $this;
    }

    /**
     * Gets gdpr_obfuscated
     *
     * @return bool|null
     */
    public function getGdprObfuscated()
    {
        return $this->container['gdpr_obfuscated'];
    }

    /**
     * Sets gdpr_obfuscated
     *
     * @param bool|null $gdpr_obfuscated General Data Protection Regulation (GDPR) came into effect on 25th May 2018. It introduces new rules for how business owners manage their contacts' personal data. When this field returns 'true', means that the contact has been requested to be obfuscated and you can not create any artifact (sales invoices, purchase invoices, ...) but you can still check previously created artifacts.
     *
     * @return self
     */
    public function setGdprObfuscated($gdpr_obfuscated)
    {
        $this->container['gdpr_obfuscated'] = $gdpr_obfuscated;

        return $this;
    }

    /**
     * Gets system
     *
     * @return bool|null
     */
    public function getSystem()
    {
        return $this->container['system'];
    }

    /**
     * Sets system
     *
     * @param bool|null $system Identifies a contact as being a system contact used for processing specific transaction types and reserved specifically for those transaction types such as tax return payments/refunds.
     *
     * @return self
     */
    public function setSystem($system)
    {
        $this->container['system'] = $system;

        return $this;
    }

    /**
     * Gets links
     *
     * @return \SageOne\Model\PostContactsContactLinksInner[]|null
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     *
     * @param \SageOne\Model\PostContactsContactLinksInner[]|null $links links
     *
     * @return self
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }

    /**
     * Gets main_address
     *
     * @return \SageOne\Model\PostBankAccountsBankAccountMainAddress|null
     */
    public function getMainAddress()
    {
        return $this->container['main_address'];
    }

    /**
     * Sets main_address
     *
     * @param \SageOne\Model\PostBankAccountsBankAccountMainAddress|null $main_address main_address
     *
     * @return self
     */
    public function setMainAddress($main_address)
    {
        $this->container['main_address'] = $main_address;

        return $this;
    }

    /**
     * Gets delivery_address
     *
     * @return \SageOne\Model\PostBankAccountsBankAccountMainAddress|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['delivery_address'];
    }

    /**
     * Sets delivery_address
     *
     * @param \SageOne\Model\PostBankAccountsBankAccountMainAddress|null $delivery_address delivery_address
     *
     * @return self
     */
    public function setDeliveryAddress($delivery_address)
    {
        $this->container['delivery_address'] = $delivery_address;

        return $this;
    }

    /**
     * Gets main_contact_person
     *
     * @return \SageOne\Model\PostContactsContactMainContactPerson|null
     */
    public function getMainContactPerson()
    {
        return $this->container['main_contact_person'];
    }

    /**
     * Sets main_contact_person
     *
     * @param \SageOne\Model\PostContactsContactMainContactPerson|null $main_contact_person main_contact_person
     *
     * @return self
     */
    public function setMainContactPerson($main_contact_person)
    {
        $this->container['main_contact_person'] = $main_contact_person;

        return $this;
    }

    /**
     * Gets bank_account_details
     *
     * @return \SageOne\Model\PutBankAccountsBankAccountBankAccountDetails|null
     */
    public function getBankAccountDetails()
    {
        return $this->container['bank_account_details'];
    }

    /**
     * Sets bank_account_details
     *
     * @param \SageOne\Model\PutBankAccountsBankAccountBankAccountDetails|null $bank_account_details bank_account_details
     *
     * @return self
     */
    public function setBankAccountDetails($bank_account_details)
    {
        $this->container['bank_account_details'] = $bank_account_details;

        return $this;
    }

    /**
     * Gets tax_treatment
     *
     * @return \SageOne\Model\PostContactsContactTaxTreatment|null
     */
    public function getTaxTreatment()
    {
        return $this->container['tax_treatment'];
    }

    /**
     * Sets tax_treatment
     *
     * @param \SageOne\Model\PostContactsContactTaxTreatment|null $tax_treatment tax_treatment
     *
     * @return self
     */
    public function setTaxTreatment($tax_treatment)
    {
        $this->container['tax_treatment'] = $tax_treatment;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


