<?php
/**
 * PostContactPersonsContactPerson
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostContactPersonsContactPerson Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostContactPersonsContactPerson implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postContactPersons_contact_person';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'address_id' => 'string',
        'name' => 'string',
        'contact_person_type_ids' => 'string[]',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'deleted_at' => '\DateTime',
        'job_title' => 'string',
        'telephone' => 'string',
        'mobile' => 'string',
        'email' => 'string',
        'fax' => 'string',
        'is_main_contact' => 'bool',
        'is_preferred_contact' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'address_id' => null,
        'name' => null,
        'contact_person_type_ids' => null,
        'transaction_id' => null,
        'transaction_type_id' => null,
        'deleted_at' => 'date-time',
        'job_title' => null,
        'telephone' => null,
        'mobile' => null,
        'email' => null,
        'fax' => null,
        'is_main_contact' => null,
        'is_preferred_contact' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'address_id' => 'address_id',
        'name' => 'name',
        'contact_person_type_ids' => 'contact_person_type_ids',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'deleted_at' => 'deleted_at',
        'job_title' => 'job_title',
        'telephone' => 'telephone',
        'mobile' => 'mobile',
        'email' => 'email',
        'fax' => 'fax',
        'is_main_contact' => 'is_main_contact',
        'is_preferred_contact' => 'is_preferred_contact'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'address_id' => 'setAddressId',
        'name' => 'setName',
        'contact_person_type_ids' => 'setContactPersonTypeIds',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'deleted_at' => 'setDeletedAt',
        'job_title' => 'setJobTitle',
        'telephone' => 'setTelephone',
        'mobile' => 'setMobile',
        'email' => 'setEmail',
        'fax' => 'setFax',
        'is_main_contact' => 'setIsMainContact',
        'is_preferred_contact' => 'setIsPreferredContact'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'address_id' => 'getAddressId',
        'name' => 'getName',
        'contact_person_type_ids' => 'getContactPersonTypeIds',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'deleted_at' => 'getDeletedAt',
        'job_title' => 'getJobTitle',
        'telephone' => 'getTelephone',
        'mobile' => 'getMobile',
        'email' => 'getEmail',
        'fax' => 'getFax',
        'is_main_contact' => 'getIsMainContact',
        'is_preferred_contact' => 'getIsPreferredContact'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['address_id'] = $data['address_id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['contact_person_type_ids'] = $data['contact_person_type_ids'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['job_title'] = $data['job_title'] ?? null;
        $this->container['telephone'] = $data['telephone'] ?? null;
        $this->container['mobile'] = $data['mobile'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['fax'] = $data['fax'] ?? null;
        $this->container['is_main_contact'] = $data['is_main_contact'] ?? null;
        $this->container['is_preferred_contact'] = $data['is_preferred_contact'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['address_id'] === null) {
            $invalidProperties[] = "'address_id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['contact_person_type_ids'] === null) {
            $invalidProperties[] = "'contact_person_type_ids' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets address_id
     *
     * @return string
     */
    public function getAddressId()
    {
        return $this->container['address_id'];
    }

    /**
     * Sets address_id
     *
     * @param string $address_id The address of the contact person
     *
     * @return self
     */
    public function setAddressId($address_id)
    {
        $this->container['address_id'] = $address_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name of the contact person
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets contact_person_type_ids
     *
     * @return string[]
     */
    public function getContactPersonTypeIds()
    {
        return $this->container['contact_person_type_ids'];
    }

    /**
     * Sets contact_person_type_ids
     *
     * @param string[] $contact_person_type_ids The IDs of the Contact Person Types.
     *
     * @return self
     */
    public function setContactPersonTypeIds($contact_person_type_ids)
    {
        $this->container['contact_person_type_ids'] = $contact_person_type_ids;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets job_title
     *
     * @return string|null
     */
    public function getJobTitle()
    {
        return $this->container['job_title'];
    }

    /**
     * Sets job_title
     *
     * @param string|null $job_title The job title of the contact person
     *
     * @return self
     */
    public function setJobTitle($job_title)
    {
        $this->container['job_title'] = $job_title;

        return $this;
    }

    /**
     * Gets telephone
     *
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->container['telephone'];
    }

    /**
     * Sets telephone
     *
     * @param string|null $telephone The telephone number of the contact person
     *
     * @return self
     */
    public function setTelephone($telephone)
    {
        $this->container['telephone'] = $telephone;

        return $this;
    }

    /**
     * Gets mobile
     *
     * @return string|null
     */
    public function getMobile()
    {
        return $this->container['mobile'];
    }

    /**
     * Sets mobile
     *
     * @param string|null $mobile The mobile number of the contact person
     *
     * @return self
     */
    public function setMobile($mobile)
    {
        $this->container['mobile'] = $mobile;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email The email address of the contact person
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax The fax number of the contact person
     *
     * @return self
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets is_main_contact
     *
     * @return bool|null
     */
    public function getIsMainContact()
    {
        return $this->container['is_main_contact'];
    }

    /**
     * Sets is_main_contact
     *
     * @param bool|null $is_main_contact Indicates whether this is the main contact person
     *
     * @return self
     */
    public function setIsMainContact($is_main_contact)
    {
        $this->container['is_main_contact'] = $is_main_contact;

        return $this;
    }

    /**
     * Gets is_preferred_contact
     *
     * @return bool|null
     */
    public function getIsPreferredContact()
    {
        return $this->container['is_preferred_contact'];
    }

    /**
     * Sets is_preferred_contact
     *
     * @param bool|null $is_preferred_contact Indicates that this contact person is a preferred contact
     *
     * @return self
     */
    public function setIsPreferredContact($is_preferred_contact)
    {
        $this->container['is_preferred_contact'] = $is_preferred_contact;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


