<?php
/**
 * PostContactPaymentsContactPaymentPaymentOnAccount
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostContactPaymentsContactPaymentPaymentOnAccount Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostContactPaymentsContactPaymentPaymentOnAccount implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postContactPayments_contact_payment_payment_on_account';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'contact_name' => 'string',
        'contact_reference' => 'string',
        'contact_id' => 'string',
        'date' => '\DateTime',
        'reference' => 'string',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'total_amount' => 'double',
        'outstanding_amount' => 'double',
        'currency_id' => 'string',
        'exchange_rate' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_outstanding_amount' => 'double',
        'status_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transaction_id' => null,
        'transaction_type_id' => null,
        'contact_name' => null,
        'contact_reference' => null,
        'contact_id' => null,
        'date' => 'date',
        'reference' => null,
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'total_amount' => 'double',
        'outstanding_amount' => 'double',
        'currency_id' => null,
        'exchange_rate' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_outstanding_amount' => 'double',
        'status_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'contact_name' => 'contact_name',
        'contact_reference' => 'contact_reference',
        'contact_id' => 'contact_id',
        'date' => 'date',
        'reference' => 'reference',
        'net_amount' => 'net_amount',
        'tax_amount' => 'tax_amount',
        'total_amount' => 'total_amount',
        'outstanding_amount' => 'outstanding_amount',
        'currency_id' => 'currency_id',
        'exchange_rate' => 'exchange_rate',
        'base_currency_net_amount' => 'base_currency_net_amount',
        'base_currency_tax_amount' => 'base_currency_tax_amount',
        'base_currency_total_amount' => 'base_currency_total_amount',
        'base_currency_outstanding_amount' => 'base_currency_outstanding_amount',
        'status_id' => 'status_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'contact_name' => 'setContactName',
        'contact_reference' => 'setContactReference',
        'contact_id' => 'setContactId',
        'date' => 'setDate',
        'reference' => 'setReference',
        'net_amount' => 'setNetAmount',
        'tax_amount' => 'setTaxAmount',
        'total_amount' => 'setTotalAmount',
        'outstanding_amount' => 'setOutstandingAmount',
        'currency_id' => 'setCurrencyId',
        'exchange_rate' => 'setExchangeRate',
        'base_currency_net_amount' => 'setBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'setBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'setBaseCurrencyTotalAmount',
        'base_currency_outstanding_amount' => 'setBaseCurrencyOutstandingAmount',
        'status_id' => 'setStatusId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'contact_name' => 'getContactName',
        'contact_reference' => 'getContactReference',
        'contact_id' => 'getContactId',
        'date' => 'getDate',
        'reference' => 'getReference',
        'net_amount' => 'getNetAmount',
        'tax_amount' => 'getTaxAmount',
        'total_amount' => 'getTotalAmount',
        'outstanding_amount' => 'getOutstandingAmount',
        'currency_id' => 'getCurrencyId',
        'exchange_rate' => 'getExchangeRate',
        'base_currency_net_amount' => 'getBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'getBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'getBaseCurrencyTotalAmount',
        'base_currency_outstanding_amount' => 'getBaseCurrencyOutstandingAmount',
        'status_id' => 'getStatusId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['contact_name'] = $data['contact_name'] ?? null;
        $this->container['contact_reference'] = $data['contact_reference'] ?? null;
        $this->container['contact_id'] = $data['contact_id'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['outstanding_amount'] = $data['outstanding_amount'] ?? null;
        $this->container['currency_id'] = $data['currency_id'] ?? null;
        $this->container['exchange_rate'] = $data['exchange_rate'] ?? null;
        $this->container['base_currency_net_amount'] = $data['base_currency_net_amount'] ?? null;
        $this->container['base_currency_tax_amount'] = $data['base_currency_tax_amount'] ?? null;
        $this->container['base_currency_total_amount'] = $data['base_currency_total_amount'] ?? null;
        $this->container['base_currency_outstanding_amount'] = $data['base_currency_outstanding_amount'] ?? null;
        $this->container['status_id'] = $data['status_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets contact_name
     *
     * @return string|null
     */
    public function getContactName()
    {
        return $this->container['contact_name'];
    }

    /**
     * Sets contact_name
     *
     * @param string|null $contact_name The name of the contact when the payment on account was created
     *
     * @return self
     */
    public function setContactName($contact_name)
    {
        $this->container['contact_name'] = $contact_name;

        return $this;
    }

    /**
     * Gets contact_reference
     *
     * @return string|null
     */
    public function getContactReference()
    {
        return $this->container['contact_reference'];
    }

    /**
     * Sets contact_reference
     *
     * @param string|null $contact_reference The reference of the contact when the payment on account was created
     *
     * @return self
     */
    public function setContactReference($contact_reference)
    {
        $this->container['contact_reference'] = $contact_reference;

        return $this;
    }

    /**
     * Gets contact_id
     *
     * @return string|null
     */
    public function getContactId()
    {
        return $this->container['contact_id'];
    }

    /**
     * Sets contact_id
     *
     * @param string|null $contact_id The ID of the Contact.
     *
     * @return self
     */
    public function setContactId($contact_id)
    {
        $this->container['contact_id'] = $contact_id;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date The date of the payment on account
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference The reference for the payment on account
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double|null $net_amount The net amount of the payment on account
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double|null $tax_amount The tax amount of the payment on account
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount The total amount of the payment on account
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets outstanding_amount
     *
     * @return double|null
     */
    public function getOutstandingAmount()
    {
        return $this->container['outstanding_amount'];
    }

    /**
     * Sets outstanding_amount
     *
     * @param double|null $outstanding_amount The outstanding amount of the payment on account
     *
     * @return self
     */
    public function setOutstandingAmount($outstanding_amount)
    {
        $this->container['outstanding_amount'] = $outstanding_amount;

        return $this;
    }

    /**
     * Gets currency_id
     *
     * @return string|null
     */
    public function getCurrencyId()
    {
        return $this->container['currency_id'];
    }

    /**
     * Sets currency_id
     *
     * @param string|null $currency_id The ID of the Currency.
     *
     * @return self
     */
    public function setCurrencyId($currency_id)
    {
        $this->container['currency_id'] = $currency_id;

        return $this;
    }

    /**
     * Gets exchange_rate
     *
     * @return double|null
     */
    public function getExchangeRate()
    {
        return $this->container['exchange_rate'];
    }

    /**
     * Sets exchange_rate
     *
     * @param double|null $exchange_rate The exchange rate for the payment on account
     *
     * @return self
     */
    public function setExchangeRate($exchange_rate)
    {
        $this->container['exchange_rate'] = $exchange_rate;

        return $this;
    }

    /**
     * Gets base_currency_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyNetAmount()
    {
        return $this->container['base_currency_net_amount'];
    }

    /**
     * Sets base_currency_net_amount
     *
     * @param double|null $base_currency_net_amount The net amount of the payment on account in base currency
     *
     * @return self
     */
    public function setBaseCurrencyNetAmount($base_currency_net_amount)
    {
        $this->container['base_currency_net_amount'] = $base_currency_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTaxAmount()
    {
        return $this->container['base_currency_tax_amount'];
    }

    /**
     * Sets base_currency_tax_amount
     *
     * @param double|null $base_currency_tax_amount The tax amount of the payment on account in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTaxAmount($base_currency_tax_amount)
    {
        $this->container['base_currency_tax_amount'] = $base_currency_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalAmount()
    {
        return $this->container['base_currency_total_amount'];
    }

    /**
     * Sets base_currency_total_amount
     *
     * @param double|null $base_currency_total_amount The total amount of the payment on account in base currency
     *
     * @return self
     */
    public function setBaseCurrencyTotalAmount($base_currency_total_amount)
    {
        $this->container['base_currency_total_amount'] = $base_currency_total_amount;

        return $this;
    }

    /**
     * Gets base_currency_outstanding_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyOutstandingAmount()
    {
        return $this->container['base_currency_outstanding_amount'];
    }

    /**
     * Sets base_currency_outstanding_amount
     *
     * @param double|null $base_currency_outstanding_amount The outstanding amount of the payment on account in base currency
     *
     * @return self
     */
    public function setBaseCurrencyOutstandingAmount($base_currency_outstanding_amount)
    {
        $this->container['base_currency_outstanding_amount'] = $base_currency_outstanding_amount;

        return $this;
    }

    /**
     * Gets status_id
     *
     * @return string|null
     */
    public function getStatusId()
    {
        return $this->container['status_id'];
    }

    /**
     * Sets status_id
     *
     * @param string|null $status_id The ID of the Status.
     *
     * @return self
     */
    public function setStatusId($status_id)
    {
        $this->container['status_id'] = $status_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


