<?php
/**
 * PostBankDepositsBankDeposit
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostBankDepositsBankDeposit Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostBankDepositsBankDeposit implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postBankDeposits_bank_deposit';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'from_bank_account_id' => 'string',
        'to_bank_account_id' => 'string',
        'date' => '\DateTime',
        'reference' => 'string',
        'cash_amount' => 'double',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'deleted_at' => '\DateTime',
        'cheque_amount' => 'double',
        'total_amount' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'from_bank_account_id' => null,
        'to_bank_account_id' => null,
        'date' => 'date',
        'reference' => null,
        'cash_amount' => 'double',
        'transaction_id' => null,
        'transaction_type_id' => null,
        'deleted_at' => 'date-time',
        'cheque_amount' => 'double',
        'total_amount' => 'double'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'from_bank_account_id' => 'from_bank_account_id',
        'to_bank_account_id' => 'to_bank_account_id',
        'date' => 'date',
        'reference' => 'reference',
        'cash_amount' => 'cash_amount',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'deleted_at' => 'deleted_at',
        'cheque_amount' => 'cheque_amount',
        'total_amount' => 'total_amount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'from_bank_account_id' => 'setFromBankAccountId',
        'to_bank_account_id' => 'setToBankAccountId',
        'date' => 'setDate',
        'reference' => 'setReference',
        'cash_amount' => 'setCashAmount',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'deleted_at' => 'setDeletedAt',
        'cheque_amount' => 'setChequeAmount',
        'total_amount' => 'setTotalAmount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'from_bank_account_id' => 'getFromBankAccountId',
        'to_bank_account_id' => 'getToBankAccountId',
        'date' => 'getDate',
        'reference' => 'getReference',
        'cash_amount' => 'getCashAmount',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'deleted_at' => 'getDeletedAt',
        'cheque_amount' => 'getChequeAmount',
        'total_amount' => 'getTotalAmount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['from_bank_account_id'] = $data['from_bank_account_id'] ?? null;
        $this->container['to_bank_account_id'] = $data['to_bank_account_id'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['cash_amount'] = $data['cash_amount'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['cheque_amount'] = $data['cheque_amount'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['from_bank_account_id'] === null) {
            $invalidProperties[] = "'from_bank_account_id' can't be null";
        }
        if ($this->container['to_bank_account_id'] === null) {
            $invalidProperties[] = "'to_bank_account_id' can't be null";
        }
        if ($this->container['date'] === null) {
            $invalidProperties[] = "'date' can't be null";
        }
        if ($this->container['reference'] === null) {
            $invalidProperties[] = "'reference' can't be null";
        }
        if ($this->container['cash_amount'] === null) {
            $invalidProperties[] = "'cash_amount' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets from_bank_account_id
     *
     * @return string
     */
    public function getFromBankAccountId()
    {
        return $this->container['from_bank_account_id'];
    }

    /**
     * Sets from_bank_account_id
     *
     * @param string $from_bank_account_id From bank account - money leaves this account
     *
     * @return self
     */
    public function setFromBankAccountId($from_bank_account_id)
    {
        $this->container['from_bank_account_id'] = $from_bank_account_id;

        return $this;
    }

    /**
     * Gets to_bank_account_id
     *
     * @return string
     */
    public function getToBankAccountId()
    {
        return $this->container['to_bank_account_id'];
    }

    /**
     * Sets to_bank_account_id
     *
     * @param string $to_bank_account_id To bank account - money goes into this account
     *
     * @return self
     */
    public function setToBankAccountId($to_bank_account_id)
    {
        $this->container['to_bank_account_id'] = $to_bank_account_id;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime $date User generated date of transaction, not necessarily when it was created
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string $reference Reference
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets cash_amount
     *
     * @return double
     */
    public function getCashAmount()
    {
        return $this->container['cash_amount'];
    }

    /**
     * Sets cash_amount
     *
     * @param double $cash_amount Cash total in the deposit
     *
     * @return self
     */
    public function setCashAmount($cash_amount)
    {
        $this->container['cash_amount'] = $cash_amount;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets cheque_amount
     *
     * @return double|null
     */
    public function getChequeAmount()
    {
        return $this->container['cheque_amount'];
    }

    /**
     * Sets cheque_amount
     *
     * @param double|null $cheque_amount Cheque total in the deposit
     *
     * @return self
     */
    public function setChequeAmount($cheque_amount)
    {
        $this->container['cheque_amount'] = $cheque_amount;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount Total of cash and cheques in the deposit
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


