<?php
/**
 * PostBankAccountsBankAccount
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PostBankAccountsBankAccount Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PostBankAccountsBankAccount implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'postBankAccounts_bank_account';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bank_account_type_id' => 'string',
        'transaction_id' => 'string',
        'transaction_type_id' => 'string',
        'deleted_at' => '\DateTime',
        'ledger_account_id' => 'string',
        'balance' => 'double',
        'nominal_code' => 'int',
        'editable' => 'bool',
        'deletable' => 'bool',
        'default_payment_method_id' => 'string',
        'bank_account_details' => '\SageOne\Model\PostBankAccountsBankAccountBankAccountDetails',
        'main_address' => '\SageOne\Model\PostBankAccountsBankAccountMainAddress',
        'main_contact_person' => '\SageOne\Model\PostBankAccountsBankAccountMainContactPerson',
        'journal_code' => '\SageOne\Model\PostJournalsJournalJournalCode'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bank_account_type_id' => null,
        'transaction_id' => null,
        'transaction_type_id' => null,
        'deleted_at' => 'date-time',
        'ledger_account_id' => null,
        'balance' => 'double',
        'nominal_code' => 'int32',
        'editable' => null,
        'deletable' => null,
        'default_payment_method_id' => null,
        'bank_account_details' => null,
        'main_address' => null,
        'main_contact_person' => null,
        'journal_code' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bank_account_type_id' => 'bank_account_type_id',
        'transaction_id' => 'transaction_id',
        'transaction_type_id' => 'transaction_type_id',
        'deleted_at' => 'deleted_at',
        'ledger_account_id' => 'ledger_account_id',
        'balance' => 'balance',
        'nominal_code' => 'nominal_code',
        'editable' => 'editable',
        'deletable' => 'deletable',
        'default_payment_method_id' => 'default_payment_method_id',
        'bank_account_details' => 'bank_account_details',
        'main_address' => 'main_address',
        'main_contact_person' => 'main_contact_person',
        'journal_code' => 'journal_code'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bank_account_type_id' => 'setBankAccountTypeId',
        'transaction_id' => 'setTransactionId',
        'transaction_type_id' => 'setTransactionTypeId',
        'deleted_at' => 'setDeletedAt',
        'ledger_account_id' => 'setLedgerAccountId',
        'balance' => 'setBalance',
        'nominal_code' => 'setNominalCode',
        'editable' => 'setEditable',
        'deletable' => 'setDeletable',
        'default_payment_method_id' => 'setDefaultPaymentMethodId',
        'bank_account_details' => 'setBankAccountDetails',
        'main_address' => 'setMainAddress',
        'main_contact_person' => 'setMainContactPerson',
        'journal_code' => 'setJournalCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bank_account_type_id' => 'getBankAccountTypeId',
        'transaction_id' => 'getTransactionId',
        'transaction_type_id' => 'getTransactionTypeId',
        'deleted_at' => 'getDeletedAt',
        'ledger_account_id' => 'getLedgerAccountId',
        'balance' => 'getBalance',
        'nominal_code' => 'getNominalCode',
        'editable' => 'getEditable',
        'deletable' => 'getDeletable',
        'default_payment_method_id' => 'getDefaultPaymentMethodId',
        'bank_account_details' => 'getBankAccountDetails',
        'main_address' => 'getMainAddress',
        'main_contact_person' => 'getMainContactPerson',
        'journal_code' => 'getJournalCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['bank_account_type_id'] = $data['bank_account_type_id'] ?? null;
        $this->container['transaction_id'] = $data['transaction_id'] ?? null;
        $this->container['transaction_type_id'] = $data['transaction_type_id'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['ledger_account_id'] = $data['ledger_account_id'] ?? null;
        $this->container['balance'] = $data['balance'] ?? null;
        $this->container['nominal_code'] = $data['nominal_code'] ?? null;
        $this->container['editable'] = $data['editable'] ?? null;
        $this->container['deletable'] = $data['deletable'] ?? null;
        $this->container['default_payment_method_id'] = $data['default_payment_method_id'] ?? null;
        $this->container['bank_account_details'] = $data['bank_account_details'] ?? null;
        $this->container['main_address'] = $data['main_address'] ?? null;
        $this->container['main_contact_person'] = $data['main_contact_person'] ?? null;
        $this->container['journal_code'] = $data['journal_code'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['bank_account_type_id'] === null) {
            $invalidProperties[] = "'bank_account_type_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bank_account_type_id
     *
     * @return string
     */
    public function getBankAccountTypeId()
    {
        return $this->container['bank_account_type_id'];
    }

    /**
     * Sets bank_account_type_id
     *
     * @param string $bank_account_type_id The bank account type for the bank account
     *
     * @return self
     */
    public function setBankAccountTypeId($bank_account_type_id)
    {
        $this->container['bank_account_type_id'] = $bank_account_type_id;

        return $this;
    }

    /**
     * Gets transaction_id
     *
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->container['transaction_id'];
    }

    /**
     * Sets transaction_id
     *
     * @param string|null $transaction_id The ID of the Transaction.
     *
     * @return self
     */
    public function setTransactionId($transaction_id)
    {
        $this->container['transaction_id'] = $transaction_id;

        return $this;
    }

    /**
     * Gets transaction_type_id
     *
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return $this->container['transaction_type_id'];
    }

    /**
     * Sets transaction_type_id
     *
     * @param string|null $transaction_type_id The ID of the Transaction Type.
     *
     * @return self
     */
    public function setTransactionTypeId($transaction_type_id)
    {
        $this->container['transaction_type_id'] = $transaction_type_id;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets ledger_account_id
     *
     * @return string|null
     */
    public function getLedgerAccountId()
    {
        return $this->container['ledger_account_id'];
    }

    /**
     * Sets ledger_account_id
     *
     * @param string|null $ledger_account_id The ID of the Ledger Account.
     *
     * @return self
     */
    public function setLedgerAccountId($ledger_account_id)
    {
        $this->container['ledger_account_id'] = $ledger_account_id;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return double|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param double|null $balance The bank account balance
     *
     * @return self
     */
    public function setBalance($balance)
    {
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets nominal_code
     *
     * @return int|null
     */
    public function getNominalCode()
    {
        return $this->container['nominal_code'];
    }

    /**
     * Sets nominal_code
     *
     * @param int|null $nominal_code The nominal code of the bank account
     *
     * @return self
     */
    public function setNominalCode($nominal_code)
    {
        $this->container['nominal_code'] = $nominal_code;

        return $this;
    }

    /**
     * Gets editable
     *
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->container['editable'];
    }

    /**
     * Sets editable
     *
     * @param bool|null $editable Indicates whether or not the bank account can be edited
     *
     * @return self
     */
    public function setEditable($editable)
    {
        $this->container['editable'] = $editable;

        return $this;
    }

    /**
     * Gets deletable
     *
     * @return bool|null
     */
    public function getDeletable()
    {
        return $this->container['deletable'];
    }

    /**
     * Sets deletable
     *
     * @param bool|null $deletable Indicates whether or not the bank account can be deleted
     *
     * @return self
     */
    public function setDeletable($deletable)
    {
        $this->container['deletable'] = $deletable;

        return $this;
    }

    /**
     * Gets default_payment_method_id
     *
     * @return string|null
     */
    public function getDefaultPaymentMethodId()
    {
        return $this->container['default_payment_method_id'];
    }

    /**
     * Sets default_payment_method_id
     *
     * @param string|null $default_payment_method_id The ID of the Default Payment Method.
     *
     * @return self
     */
    public function setDefaultPaymentMethodId($default_payment_method_id)
    {
        $this->container['default_payment_method_id'] = $default_payment_method_id;

        return $this;
    }

    /**
     * Gets bank_account_details
     *
     * @return \SageOne\Model\PostBankAccountsBankAccountBankAccountDetails|null
     */
    public function getBankAccountDetails()
    {
        return $this->container['bank_account_details'];
    }

    /**
     * Sets bank_account_details
     *
     * @param \SageOne\Model\PostBankAccountsBankAccountBankAccountDetails|null $bank_account_details bank_account_details
     *
     * @return self
     */
    public function setBankAccountDetails($bank_account_details)
    {
        $this->container['bank_account_details'] = $bank_account_details;

        return $this;
    }

    /**
     * Gets main_address
     *
     * @return \SageOne\Model\PostBankAccountsBankAccountMainAddress|null
     */
    public function getMainAddress()
    {
        return $this->container['main_address'];
    }

    /**
     * Sets main_address
     *
     * @param \SageOne\Model\PostBankAccountsBankAccountMainAddress|null $main_address main_address
     *
     * @return self
     */
    public function setMainAddress($main_address)
    {
        $this->container['main_address'] = $main_address;

        return $this;
    }

    /**
     * Gets main_contact_person
     *
     * @return \SageOne\Model\PostBankAccountsBankAccountMainContactPerson|null
     */
    public function getMainContactPerson()
    {
        return $this->container['main_contact_person'];
    }

    /**
     * Sets main_contact_person
     *
     * @param \SageOne\Model\PostBankAccountsBankAccountMainContactPerson|null $main_contact_person main_contact_person
     *
     * @return self
     */
    public function setMainContactPerson($main_contact_person)
    {
        $this->container['main_contact_person'] = $main_contact_person;

        return $this;
    }

    /**
     * Gets journal_code
     *
     * @return \SageOne\Model\PostJournalsJournalJournalCode|null
     */
    public function getJournalCode()
    {
        return $this->container['journal_code'];
    }

    /**
     * Sets journal_code
     *
     * @param \SageOne\Model\PostJournalsJournalJournalCode|null $journal_code journal_code
     *
     * @return self
     */
    public function setJournalCode($journal_code)
    {
        $this->container['journal_code'] = $journal_code;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


