<?php
/**
 * PaymentAllocation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * PaymentAllocation Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PaymentAllocation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PaymentAllocation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'links' => '\SageOne\Model\Link[]',
        'date' => '\DateTime',
        'type' => 'string',
        'reference' => 'string',
        'amount' => 'double',
        'discount' => 'double',
        'stripe_transaction_id' => 'string',
        'contact_allocation' => '\SageOne\Model\ContactAllocation',
        'artefact' => '\SageOne\Model\Generic',
        'contact_payment' => '\SageOne\Model\ContactPayment',
        'displayed_as' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'links' => null,
        'date' => 'date',
        'type' => null,
        'reference' => null,
        'amount' => 'double',
        'discount' => 'double',
        'stripe_transaction_id' => null,
        'contact_allocation' => null,
        'artefact' => null,
        'contact_payment' => null,
        'displayed_as' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'links' => 'links',
        'date' => 'date',
        'type' => 'type',
        'reference' => 'reference',
        'amount' => 'amount',
        'discount' => 'discount',
        'stripe_transaction_id' => 'stripe_transaction_id',
        'contact_allocation' => 'contact_allocation',
        'artefact' => 'artefact',
        'contact_payment' => 'contact_payment',
        'displayed_as' => 'displayed_as'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'links' => 'setLinks',
        'date' => 'setDate',
        'type' => 'setType',
        'reference' => 'setReference',
        'amount' => 'setAmount',
        'discount' => 'setDiscount',
        'stripe_transaction_id' => 'setStripeTransactionId',
        'contact_allocation' => 'setContactAllocation',
        'artefact' => 'setArtefact',
        'contact_payment' => 'setContactPayment',
        'displayed_as' => 'setDisplayedAs'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'links' => 'getLinks',
        'date' => 'getDate',
        'type' => 'getType',
        'reference' => 'getReference',
        'amount' => 'getAmount',
        'discount' => 'getDiscount',
        'stripe_transaction_id' => 'getStripeTransactionId',
        'contact_allocation' => 'getContactAllocation',
        'artefact' => 'getArtefact',
        'contact_payment' => 'getContactPayment',
        'displayed_as' => 'getDisplayedAs'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['links'] = $data['links'] ?? null;
        $this->container['date'] = $data['date'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['amount'] = $data['amount'] ?? null;
        $this->container['discount'] = $data['discount'] ?? null;
        $this->container['stripe_transaction_id'] = $data['stripe_transaction_id'] ?? null;
        $this->container['contact_allocation'] = $data['contact_allocation'] ?? null;
        $this->container['artefact'] = $data['artefact'] ?? null;
        $this->container['contact_payment'] = $data['contact_payment'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets links
     *
     * @return \SageOne\Model\Link[]|null
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     *
     * @param \SageOne\Model\Link[]|null $links Links for the resource
     *
     * @return self
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }

    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date The date for the payment/allocation
     *
     * @return self
     */
    public function setDate($date)
    {
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The type of the payment/allocation
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference The reference for the payment/allocation
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return double|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param double|null $amount The allocated amount of the payment/allocation
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return double|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param double|null $discount The discount amount of the payment/allocation
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets stripe_transaction_id
     *
     * @return string|null
     */
    public function getStripeTransactionId()
    {
        return $this->container['stripe_transaction_id'];
    }

    /**
     * Sets stripe_transaction_id
     *
     * @param string|null $stripe_transaction_id stripe_transaction_id
     *
     * @return self
     */
    public function setStripeTransactionId($stripe_transaction_id)
    {
        $this->container['stripe_transaction_id'] = $stripe_transaction_id;

        return $this;
    }

    /**
     * Gets contact_allocation
     *
     * @return \SageOne\Model\ContactAllocation|null
     */
    public function getContactAllocation()
    {
        return $this->container['contact_allocation'];
    }

    /**
     * Sets contact_allocation
     *
     * @param \SageOne\Model\ContactAllocation|null $contact_allocation contact_allocation
     *
     * @return self
     */
    public function setContactAllocation($contact_allocation)
    {
        $this->container['contact_allocation'] = $contact_allocation;

        return $this;
    }

    /**
     * Gets artefact
     *
     * @return \SageOne\Model\Generic|null
     */
    public function getArtefact()
    {
        return $this->container['artefact'];
    }

    /**
     * Sets artefact
     *
     * @param \SageOne\Model\Generic|null $artefact artefact
     *
     * @return self
     */
    public function setArtefact($artefact)
    {
        $this->container['artefact'] = $artefact;

        return $this;
    }

    /**
     * Gets contact_payment
     *
     * @return \SageOne\Model\ContactPayment|null
     */
    public function getContactPayment()
    {
        return $this->container['contact_payment'];
    }

    /**
     * Sets contact_payment
     *
     * @param \SageOne\Model\ContactPayment|null $contact_payment contact_payment
     *
     * @return self
     */
    public function setContactPayment($contact_payment)
    {
        $this->container['contact_payment'] = $contact_payment;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as Display text for the item
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


