<?php
/**
 * GBBoxData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * GBBoxData Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class GBBoxData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GBBoxData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'box_1' => 'double',
        'box_2' => 'double',
        'box_3' => 'double',
        'box_4' => 'double',
        'box_5' => 'double',
        'box_6' => 'double',
        'box_7' => 'double',
        'box_8' => 'double',
        'box_9' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'box_1' => 'double',
        'box_2' => 'double',
        'box_3' => 'double',
        'box_4' => 'double',
        'box_5' => 'double',
        'box_6' => 'double',
        'box_7' => 'double',
        'box_8' => 'double',
        'box_9' => 'double'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'box_1' => 'box_1',
        'box_2' => 'box_2',
        'box_3' => 'box_3',
        'box_4' => 'box_4',
        'box_5' => 'box_5',
        'box_6' => 'box_6',
        'box_7' => 'box_7',
        'box_8' => 'box_8',
        'box_9' => 'box_9'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'box_1' => 'setBox1',
        'box_2' => 'setBox2',
        'box_3' => 'setBox3',
        'box_4' => 'setBox4',
        'box_5' => 'setBox5',
        'box_6' => 'setBox6',
        'box_7' => 'setBox7',
        'box_8' => 'setBox8',
        'box_9' => 'setBox9'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'box_1' => 'getBox1',
        'box_2' => 'getBox2',
        'box_3' => 'getBox3',
        'box_4' => 'getBox4',
        'box_5' => 'getBox5',
        'box_6' => 'getBox6',
        'box_7' => 'getBox7',
        'box_8' => 'getBox8',
        'box_9' => 'getBox9'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['box_1'] = $data['box_1'] ?? null;
        $this->container['box_2'] = $data['box_2'] ?? null;
        $this->container['box_3'] = $data['box_3'] ?? null;
        $this->container['box_4'] = $data['box_4'] ?? null;
        $this->container['box_5'] = $data['box_5'] ?? null;
        $this->container['box_6'] = $data['box_6'] ?? null;
        $this->container['box_7'] = $data['box_7'] ?? null;
        $this->container['box_8'] = $data['box_8'] ?? null;
        $this->container['box_9'] = $data['box_9'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets box_1
     *
     * @return double|null
     */
    public function getBox1()
    {
        return $this->container['box_1'];
    }

    /**
     * Sets box_1
     *
     * @param double|null $box_1 The value of box 1
     *
     * @return self
     */
    public function setBox1($box_1)
    {
        $this->container['box_1'] = $box_1;

        return $this;
    }

    /**
     * Gets box_2
     *
     * @return double|null
     */
    public function getBox2()
    {
        return $this->container['box_2'];
    }

    /**
     * Sets box_2
     *
     * @param double|null $box_2 The value of box 2
     *
     * @return self
     */
    public function setBox2($box_2)
    {
        $this->container['box_2'] = $box_2;

        return $this;
    }

    /**
     * Gets box_3
     *
     * @return double|null
     */
    public function getBox3()
    {
        return $this->container['box_3'];
    }

    /**
     * Sets box_3
     *
     * @param double|null $box_3 The value of box 3
     *
     * @return self
     */
    public function setBox3($box_3)
    {
        $this->container['box_3'] = $box_3;

        return $this;
    }

    /**
     * Gets box_4
     *
     * @return double|null
     */
    public function getBox4()
    {
        return $this->container['box_4'];
    }

    /**
     * Sets box_4
     *
     * @param double|null $box_4 The value of box 4
     *
     * @return self
     */
    public function setBox4($box_4)
    {
        $this->container['box_4'] = $box_4;

        return $this;
    }

    /**
     * Gets box_5
     *
     * @return double|null
     */
    public function getBox5()
    {
        return $this->container['box_5'];
    }

    /**
     * Sets box_5
     *
     * @param double|null $box_5 The value of box 5
     *
     * @return self
     */
    public function setBox5($box_5)
    {
        $this->container['box_5'] = $box_5;

        return $this;
    }

    /**
     * Gets box_6
     *
     * @return double|null
     */
    public function getBox6()
    {
        return $this->container['box_6'];
    }

    /**
     * Sets box_6
     *
     * @param double|null $box_6 The value of box 6
     *
     * @return self
     */
    public function setBox6($box_6)
    {
        $this->container['box_6'] = $box_6;

        return $this;
    }

    /**
     * Gets box_7
     *
     * @return double|null
     */
    public function getBox7()
    {
        return $this->container['box_7'];
    }

    /**
     * Sets box_7
     *
     * @param double|null $box_7 The value of box 7
     *
     * @return self
     */
    public function setBox7($box_7)
    {
        $this->container['box_7'] = $box_7;

        return $this;
    }

    /**
     * Gets box_8
     *
     * @return double|null
     */
    public function getBox8()
    {
        return $this->container['box_8'];
    }

    /**
     * Sets box_8
     *
     * @param double|null $box_8 The value of box 8
     *
     * @return self
     */
    public function setBox8($box_8)
    {
        $this->container['box_8'] = $box_8;

        return $this;
    }

    /**
     * Gets box_9
     *
     * @return double|null
     */
    public function getBox9()
    {
        return $this->container['box_9'];
    }

    /**
     * Sets box_9
     *
     * @param double|null $box_9 The value of box 9
     *
     * @return self
     */
    public function setBox9($box_9)
    {
        $this->container['box_9'] = $box_9;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


