<?php
/**
 * FinancialSettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * FinancialSettings Class Doc Comment
 *
 * @category Class
 * @description Updates a Financial Settings
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class FinancialSettings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FinancialSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'path' => 'string',
        'year_end_date' => '\DateTime',
        'year_end_lockdown_date' => '\DateTime',
        'accounts_start_date' => '\DateTime',
        'base_currency' => '\SageOne\Model\Base',
        'multi_currency_enabled' => 'bool',
        'use_live_exchange_rates' => 'bool',
        'mtd_activation_status' => 'string',
        'mtd_connected' => 'bool',
        'mtd_authenticated_date' => '\DateTime',
        'tax_scheme' => '\SageOne\Model\TaxScheme',
        'tax_return_frequency' => '\SageOne\Model\Base',
        'tax_number' => 'string',
        'general_tax_number' => 'string',
        'tax_office' => '\SageOne\Model\Base',
        'default_irpf_rate' => 'double',
        'flat_rate_tax_percentage' => 'double',
        'sales_tax_calculation' => 'string',
        'purchase_tax_calculation' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'path' => null,
        'year_end_date' => 'date',
        'year_end_lockdown_date' => 'date',
        'accounts_start_date' => 'date',
        'base_currency' => null,
        'multi_currency_enabled' => null,
        'use_live_exchange_rates' => null,
        'mtd_activation_status' => null,
        'mtd_connected' => null,
        'mtd_authenticated_date' => 'date',
        'tax_scheme' => null,
        'tax_return_frequency' => null,
        'tax_number' => null,
        'general_tax_number' => null,
        'tax_office' => null,
        'default_irpf_rate' => 'double',
        'flat_rate_tax_percentage' => 'double',
        'sales_tax_calculation' => null,
        'purchase_tax_calculation' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'path' => '$path',
        'year_end_date' => 'year_end_date',
        'year_end_lockdown_date' => 'year_end_lockdown_date',
        'accounts_start_date' => 'accounts_start_date',
        'base_currency' => 'base_currency',
        'multi_currency_enabled' => 'multi_currency_enabled',
        'use_live_exchange_rates' => 'use_live_exchange_rates',
        'mtd_activation_status' => 'mtd_activation_status',
        'mtd_connected' => 'mtd_connected',
        'mtd_authenticated_date' => 'mtd_authenticated_date',
        'tax_scheme' => 'tax_scheme',
        'tax_return_frequency' => 'tax_return_frequency',
        'tax_number' => 'tax_number',
        'general_tax_number' => 'general_tax_number',
        'tax_office' => 'tax_office',
        'default_irpf_rate' => 'default_irpf_rate',
        'flat_rate_tax_percentage' => 'flat_rate_tax_percentage',
        'sales_tax_calculation' => 'sales_tax_calculation',
        'purchase_tax_calculation' => 'purchase_tax_calculation'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'path' => 'setPath',
        'year_end_date' => 'setYearEndDate',
        'year_end_lockdown_date' => 'setYearEndLockdownDate',
        'accounts_start_date' => 'setAccountsStartDate',
        'base_currency' => 'setBaseCurrency',
        'multi_currency_enabled' => 'setMultiCurrencyEnabled',
        'use_live_exchange_rates' => 'setUseLiveExchangeRates',
        'mtd_activation_status' => 'setMtdActivationStatus',
        'mtd_connected' => 'setMtdConnected',
        'mtd_authenticated_date' => 'setMtdAuthenticatedDate',
        'tax_scheme' => 'setTaxScheme',
        'tax_return_frequency' => 'setTaxReturnFrequency',
        'tax_number' => 'setTaxNumber',
        'general_tax_number' => 'setGeneralTaxNumber',
        'tax_office' => 'setTaxOffice',
        'default_irpf_rate' => 'setDefaultIrpfRate',
        'flat_rate_tax_percentage' => 'setFlatRateTaxPercentage',
        'sales_tax_calculation' => 'setSalesTaxCalculation',
        'purchase_tax_calculation' => 'setPurchaseTaxCalculation'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'path' => 'getPath',
        'year_end_date' => 'getYearEndDate',
        'year_end_lockdown_date' => 'getYearEndLockdownDate',
        'accounts_start_date' => 'getAccountsStartDate',
        'base_currency' => 'getBaseCurrency',
        'multi_currency_enabled' => 'getMultiCurrencyEnabled',
        'use_live_exchange_rates' => 'getUseLiveExchangeRates',
        'mtd_activation_status' => 'getMtdActivationStatus',
        'mtd_connected' => 'getMtdConnected',
        'mtd_authenticated_date' => 'getMtdAuthenticatedDate',
        'tax_scheme' => 'getTaxScheme',
        'tax_return_frequency' => 'getTaxReturnFrequency',
        'tax_number' => 'getTaxNumber',
        'general_tax_number' => 'getGeneralTaxNumber',
        'tax_office' => 'getTaxOffice',
        'default_irpf_rate' => 'getDefaultIrpfRate',
        'flat_rate_tax_percentage' => 'getFlatRateTaxPercentage',
        'sales_tax_calculation' => 'getSalesTaxCalculation',
        'purchase_tax_calculation' => 'getPurchaseTaxCalculation'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['path'] = $data['path'] ?? null;
        $this->container['year_end_date'] = $data['year_end_date'] ?? null;
        $this->container['year_end_lockdown_date'] = $data['year_end_lockdown_date'] ?? null;
        $this->container['accounts_start_date'] = $data['accounts_start_date'] ?? null;
        $this->container['base_currency'] = $data['base_currency'] ?? null;
        $this->container['multi_currency_enabled'] = $data['multi_currency_enabled'] ?? null;
        $this->container['use_live_exchange_rates'] = $data['use_live_exchange_rates'] ?? null;
        $this->container['mtd_activation_status'] = $data['mtd_activation_status'] ?? null;
        $this->container['mtd_connected'] = $data['mtd_connected'] ?? null;
        $this->container['mtd_authenticated_date'] = $data['mtd_authenticated_date'] ?? null;
        $this->container['tax_scheme'] = $data['tax_scheme'] ?? null;
        $this->container['tax_return_frequency'] = $data['tax_return_frequency'] ?? null;
        $this->container['tax_number'] = $data['tax_number'] ?? null;
        $this->container['general_tax_number'] = $data['general_tax_number'] ?? null;
        $this->container['tax_office'] = $data['tax_office'] ?? null;
        $this->container['default_irpf_rate'] = $data['default_irpf_rate'] ?? null;
        $this->container['flat_rate_tax_percentage'] = $data['flat_rate_tax_percentage'] ?? null;
        $this->container['sales_tax_calculation'] = $data['sales_tax_calculation'] ?? null;
        $this->container['purchase_tax_calculation'] = $data['purchase_tax_calculation'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The api path for this item
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets year_end_date
     *
     * @return \DateTime|null
     */
    public function getYearEndDate()
    {
        return $this->container['year_end_date'];
    }

    /**
     * Sets year_end_date
     *
     * @param \DateTime|null $year_end_date The financial year end date of the business
     *
     * @return self
     */
    public function setYearEndDate($year_end_date)
    {
        $this->container['year_end_date'] = $year_end_date;

        return $this;
    }

    /**
     * Gets year_end_lockdown_date
     *
     * @return \DateTime|null
     */
    public function getYearEndLockdownDate()
    {
        return $this->container['year_end_lockdown_date'];
    }

    /**
     * Sets year_end_lockdown_date
     *
     * @param \DateTime|null $year_end_lockdown_date The year end lockdown date of the business
     *
     * @return self
     */
    public function setYearEndLockdownDate($year_end_lockdown_date)
    {
        $this->container['year_end_lockdown_date'] = $year_end_lockdown_date;

        return $this;
    }

    /**
     * Gets accounts_start_date
     *
     * @return \DateTime|null
     */
    public function getAccountsStartDate()
    {
        return $this->container['accounts_start_date'];
    }

    /**
     * Sets accounts_start_date
     *
     * @param \DateTime|null $accounts_start_date The accounts start date of the business
     *
     * @return self
     */
    public function setAccountsStartDate($accounts_start_date)
    {
        $this->container['accounts_start_date'] = $accounts_start_date;

        return $this;
    }

    /**
     * Gets base_currency
     *
     * @return \SageOne\Model\Base|null
     */
    public function getBaseCurrency()
    {
        return $this->container['base_currency'];
    }

    /**
     * Sets base_currency
     *
     * @param \SageOne\Model\Base|null $base_currency base_currency
     *
     * @return self
     */
    public function setBaseCurrency($base_currency)
    {
        $this->container['base_currency'] = $base_currency;

        return $this;
    }

    /**
     * Gets multi_currency_enabled
     *
     * @return bool|null
     */
    public function getMultiCurrencyEnabled()
    {
        return $this->container['multi_currency_enabled'];
    }

    /**
     * Sets multi_currency_enabled
     *
     * @param bool|null $multi_currency_enabled Indicates whether multi-currency is enabled for the business
     *
     * @return self
     */
    public function setMultiCurrencyEnabled($multi_currency_enabled)
    {
        $this->container['multi_currency_enabled'] = $multi_currency_enabled;

        return $this;
    }

    /**
     * Gets use_live_exchange_rates
     *
     * @return bool|null
     */
    public function getUseLiveExchangeRates()
    {
        return $this->container['use_live_exchange_rates'];
    }

    /**
     * Sets use_live_exchange_rates
     *
     * @param bool|null $use_live_exchange_rates Indicates whether to use live or business defined exchange rates
     *
     * @return self
     */
    public function setUseLiveExchangeRates($use_live_exchange_rates)
    {
        $this->container['use_live_exchange_rates'] = $use_live_exchange_rates;

        return $this;
    }

    /**
     * Gets mtd_activation_status
     *
     * @return string|null
     */
    public function getMtdActivationStatus()
    {
        return $this->container['mtd_activation_status'];
    }

    /**
     * Sets mtd_activation_status
     *
     * @param string|null $mtd_activation_status Indicates the UK Making Tax Digital for VAT activation status
     *
     * @return self
     */
    public function setMtdActivationStatus($mtd_activation_status)
    {
        $this->container['mtd_activation_status'] = $mtd_activation_status;

        return $this;
    }

    /**
     * Gets mtd_connected
     *
     * @return bool|null
     */
    public function getMtdConnected()
    {
        return $this->container['mtd_connected'];
    }

    /**
     * Sets mtd_connected
     *
     * @param bool|null $mtd_connected Indicates whether UK Making Tax Digital for VAT is currently connected
     *
     * @return self
     */
    public function setMtdConnected($mtd_connected)
    {
        $this->container['mtd_connected'] = $mtd_connected;

        return $this;
    }

    /**
     * Gets mtd_authenticated_date
     *
     * @return \DateTime|null
     */
    public function getMtdAuthenticatedDate()
    {
        return $this->container['mtd_authenticated_date'];
    }

    /**
     * Sets mtd_authenticated_date
     *
     * @param \DateTime|null $mtd_authenticated_date Indicates when a UK business enabled UK Making Tax Digital for VAT, nil if not enabled or non-uk
     *
     * @return self
     */
    public function setMtdAuthenticatedDate($mtd_authenticated_date)
    {
        $this->container['mtd_authenticated_date'] = $mtd_authenticated_date;

        return $this;
    }

    /**
     * Gets tax_scheme
     *
     * @return \SageOne\Model\TaxScheme|null
     */
    public function getTaxScheme()
    {
        return $this->container['tax_scheme'];
    }

    /**
     * Sets tax_scheme
     *
     * @param \SageOne\Model\TaxScheme|null $tax_scheme tax_scheme
     *
     * @return self
     */
    public function setTaxScheme($tax_scheme)
    {
        $this->container['tax_scheme'] = $tax_scheme;

        return $this;
    }

    /**
     * Gets tax_return_frequency
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTaxReturnFrequency()
    {
        return $this->container['tax_return_frequency'];
    }

    /**
     * Sets tax_return_frequency
     *
     * @param \SageOne\Model\Base|null $tax_return_frequency tax_return_frequency
     *
     * @return self
     */
    public function setTaxReturnFrequency($tax_return_frequency)
    {
        $this->container['tax_return_frequency'] = $tax_return_frequency;

        return $this;
    }

    /**
     * Gets tax_number
     *
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->container['tax_number'];
    }

    /**
     * Sets tax_number
     *
     * @param string|null $tax_number The tax number
     *
     * @return self
     */
    public function setTaxNumber($tax_number)
    {
        $this->container['tax_number'] = $tax_number;

        return $this;
    }

    /**
     * Gets general_tax_number
     *
     * @return string|null
     */
    public function getGeneralTaxNumber()
    {
        return $this->container['general_tax_number'];
    }

    /**
     * Sets general_tax_number
     *
     * @param string|null $general_tax_number The number for various tax report submissions
     *
     * @return self
     */
    public function setGeneralTaxNumber($general_tax_number)
    {
        $this->container['general_tax_number'] = $general_tax_number;

        return $this;
    }

    /**
     * Gets tax_office
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTaxOffice()
    {
        return $this->container['tax_office'];
    }

    /**
     * Sets tax_office
     *
     * @param \SageOne\Model\Base|null $tax_office tax_office
     *
     * @return self
     */
    public function setTaxOffice($tax_office)
    {
        $this->container['tax_office'] = $tax_office;

        return $this;
    }

    /**
     * Gets default_irpf_rate
     *
     * @return double|null
     */
    public function getDefaultIrpfRate()
    {
        return $this->container['default_irpf_rate'];
    }

    /**
     * Sets default_irpf_rate
     *
     * @param double|null $default_irpf_rate The default IRPF rate
     *
     * @return self
     */
    public function setDefaultIrpfRate($default_irpf_rate)
    {
        $this->container['default_irpf_rate'] = $default_irpf_rate;

        return $this;
    }

    /**
     * Gets flat_rate_tax_percentage
     *
     * @return double|null
     */
    public function getFlatRateTaxPercentage()
    {
        return $this->container['flat_rate_tax_percentage'];
    }

    /**
     * Sets flat_rate_tax_percentage
     *
     * @param double|null $flat_rate_tax_percentage The tax percentage that applies to flat rate tax schemes.
     *
     * @return self
     */
    public function setFlatRateTaxPercentage($flat_rate_tax_percentage)
    {
        $this->container['flat_rate_tax_percentage'] = $flat_rate_tax_percentage;

        return $this;
    }

    /**
     * Gets sales_tax_calculation
     *
     * @return string|null
     */
    public function getSalesTaxCalculation()
    {
        return $this->container['sales_tax_calculation'];
    }

    /**
     * Sets sales_tax_calculation
     *
     * @param string|null $sales_tax_calculation The method of collection for tax on sales. Allowed values - \"invoice\", \"cash\".
     *
     * @return self
     */
    public function setSalesTaxCalculation($sales_tax_calculation)
    {
        $this->container['sales_tax_calculation'] = $sales_tax_calculation;

        return $this;
    }

    /**
     * Gets purchase_tax_calculation
     *
     * @return string|null
     */
    public function getPurchaseTaxCalculation()
    {
        return $this->container['purchase_tax_calculation'];
    }

    /**
     * Sets purchase_tax_calculation
     *
     * @param string|null $purchase_tax_calculation The method of collection for tax on purchases. Allowed values - \"invoice\", \"cash\".
     *
     * @return self
     */
    public function setPurchaseTaxCalculation($purchase_tax_calculation)
    {
        $this->container['purchase_tax_calculation'] = $purchase_tax_calculation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


