<?php
/**
 * DatevSettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * DatevSettings Class Doc Comment
 *
 * @category Class
 * @description Updates a Datev Settings
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class DatevSettings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DatevSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'path' => 'string',
        'tax_consultant_number' => 'int',
        'client_number' => 'int',
        'next_customer_number' => 'int',
        'next_supplier_number' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'path' => null,
        'tax_consultant_number' => 'int32',
        'client_number' => 'int32',
        'next_customer_number' => 'int32',
        'next_supplier_number' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'path' => '$path',
        'tax_consultant_number' => 'tax_consultant_number',
        'client_number' => 'client_number',
        'next_customer_number' => 'next_customer_number',
        'next_supplier_number' => 'next_supplier_number'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'path' => 'setPath',
        'tax_consultant_number' => 'setTaxConsultantNumber',
        'client_number' => 'setClientNumber',
        'next_customer_number' => 'setNextCustomerNumber',
        'next_supplier_number' => 'setNextSupplierNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'path' => 'getPath',
        'tax_consultant_number' => 'getTaxConsultantNumber',
        'client_number' => 'getClientNumber',
        'next_customer_number' => 'getNextCustomerNumber',
        'next_supplier_number' => 'getNextSupplierNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['path'] = $data['path'] ?? null;
        $this->container['tax_consultant_number'] = $data['tax_consultant_number'] ?? null;
        $this->container['client_number'] = $data['client_number'] ?? null;
        $this->container['next_customer_number'] = $data['next_customer_number'] ?? null;
        $this->container['next_supplier_number'] = $data['next_supplier_number'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The api path for this item
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets tax_consultant_number
     *
     * @return int|null
     */
    public function getTaxConsultantNumber()
    {
        return $this->container['tax_consultant_number'];
    }

    /**
     * Sets tax_consultant_number
     *
     * @param int|null $tax_consultant_number Registration number of the Accountant
     *
     * @return self
     */
    public function setTaxConsultantNumber($tax_consultant_number)
    {
        $this->container['tax_consultant_number'] = $tax_consultant_number;

        return $this;
    }

    /**
     * Gets client_number
     *
     * @return int|null
     */
    public function getClientNumber()
    {
        return $this->container['client_number'];
    }

    /**
     * Sets client_number
     *
     * @param int|null $client_number The users registration number
     *
     * @return self
     */
    public function setClientNumber($client_number)
    {
        $this->container['client_number'] = $client_number;

        return $this;
    }

    /**
     * Gets next_customer_number
     *
     * @return int|null
     */
    public function getNextCustomerNumber()
    {
        return $this->container['next_customer_number'];
    }

    /**
     * Sets next_customer_number
     *
     * @param int|null $next_customer_number The next unique customer number
     *
     * @return self
     */
    public function setNextCustomerNumber($next_customer_number)
    {
        $this->container['next_customer_number'] = $next_customer_number;

        return $this;
    }

    /**
     * Gets next_supplier_number
     *
     * @return int|null
     */
    public function getNextSupplierNumber()
    {
        return $this->container['next_supplier_number'];
    }

    /**
     * Sets next_supplier_number
     *
     * @param int|null $next_supplier_number The next unique supplier number
     *
     * @return self
     */
    public function setNextSupplierNumber($next_supplier_number)
    {
        $this->container['next_supplier_number'] = $next_supplier_number;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


