<?php
/**
 * ContactTaxTreatment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * ContactTaxTreatment Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ContactTaxTreatment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ContactTaxTreatment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'home_tax' => 'bool',
        'eu_tax_registered' => 'bool',
        'eu_not_tax_registered' => 'bool',
        'rest_of_world_tax' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'home_tax' => null,
        'eu_tax_registered' => null,
        'eu_not_tax_registered' => null,
        'rest_of_world_tax' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'home_tax' => 'home_tax',
        'eu_tax_registered' => 'eu_tax_registered',
        'eu_not_tax_registered' => 'eu_not_tax_registered',
        'rest_of_world_tax' => 'rest_of_world_tax'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'home_tax' => 'setHomeTax',
        'eu_tax_registered' => 'setEuTaxRegistered',
        'eu_not_tax_registered' => 'setEuNotTaxRegistered',
        'rest_of_world_tax' => 'setRestOfWorldTax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'home_tax' => 'getHomeTax',
        'eu_tax_registered' => 'getEuTaxRegistered',
        'eu_not_tax_registered' => 'getEuNotTaxRegistered',
        'rest_of_world_tax' => 'getRestOfWorldTax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['home_tax'] = $data['home_tax'] ?? null;
        $this->container['eu_tax_registered'] = $data['eu_tax_registered'] ?? null;
        $this->container['eu_not_tax_registered'] = $data['eu_not_tax_registered'] ?? null;
        $this->container['rest_of_world_tax'] = $data['rest_of_world_tax'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets home_tax
     *
     * @return bool|null
     */
    public function getHomeTax()
    {
        return $this->container['home_tax'];
    }

    /**
     * Sets home_tax
     *
     * @param bool|null $home_tax Indicates a contact where home country tax rules should be applied
     *
     * @return self
     */
    public function setHomeTax($home_tax)
    {
        $this->container['home_tax'] = $home_tax;

        return $this;
    }

    /**
     * Gets eu_tax_registered
     *
     * @return bool|null
     */
    public function getEuTaxRegistered()
    {
        return $this->container['eu_tax_registered'];
    }

    /**
     * Sets eu_tax_registered
     *
     * @param bool|null $eu_tax_registered Indicates a contact where EC tax rules should be applied
     *
     * @return self
     */
    public function setEuTaxRegistered($eu_tax_registered)
    {
        $this->container['eu_tax_registered'] = $eu_tax_registered;

        return $this;
    }

    /**
     * Gets eu_not_tax_registered
     *
     * @return bool|null
     */
    public function getEuNotTaxRegistered()
    {
        return $this->container['eu_not_tax_registered'];
    }

    /**
     * Sets eu_not_tax_registered
     *
     * @param bool|null $eu_not_tax_registered Indicates an EU contact without a tax number - home tax rules should be applied
     *
     * @return self
     */
    public function setEuNotTaxRegistered($eu_not_tax_registered)
    {
        $this->container['eu_not_tax_registered'] = $eu_not_tax_registered;

        return $this;
    }

    /**
     * Gets rest_of_world_tax
     *
     * @return bool|null
     */
    public function getRestOfWorldTax()
    {
        return $this->container['rest_of_world_tax'];
    }

    /**
     * Sets rest_of_world_tax
     *
     * @param bool|null $rest_of_world_tax Indicates a contact where rest of world tax rules should be applied
     *
     * @return self
     */
    public function setRestOfWorldTax($rest_of_world_tax)
    {
        $this->container['rest_of_world_tax'] = $rest_of_world_tax;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


