<?php
/**
 * Contact
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * Contact Class Doc Comment
 *
 * @category Class
 * @description Updates a Contact
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Contact implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Contact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Base',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'links' => '\SageOne\Model\Link[]',
        'deleted_at' => '\DateTime',
        'balance' => 'double',
        'contact_types' => '\SageOne\Model\Base[]',
        'name' => 'string',
        'reference' => 'string',
        'default_sales_ledger_account' => '\SageOne\Model\LedgerAccount',
        'default_sales_tax_rate' => '\SageOne\Model\Base',
        'default_purchase_ledger_account' => '\SageOne\Model\LedgerAccount',
        'tax_number' => 'string',
        'notes' => 'string',
        'locale' => 'string',
        'main_address' => '\SageOne\Model\Address',
        'delivery_address' => '\SageOne\Model\Address',
        'main_contact_person' => '\SageOne\Model\ContactPerson',
        'bank_account_details' => '\SageOne\Model\BankAccountDetails',
        'credit_limit' => 'double',
        'credit_days' => 'int',
        'credit_terms_and_conditions' => 'string',
        'product_sales_price_type' => '\SageOne\Model\Base',
        'source_guid' => 'string',
        'currency' => '\SageOne\Model\Base',
        'aux_reference' => 'string',
        'registered_number' => 'string',
        'deletable' => 'bool',
        'tax_treatment' => '\SageOne\Model\ContactTaxTreatment',
        'email' => 'string',
        'tax_calculation' => 'string',
        'auxiliary_account' => 'string',
        'gdpr_obfuscated' => 'bool',
        'system' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'links' => null,
        'deleted_at' => 'date-time',
        'balance' => 'double',
        'contact_types' => null,
        'name' => null,
        'reference' => null,
        'default_sales_ledger_account' => null,
        'default_sales_tax_rate' => null,
        'default_purchase_ledger_account' => null,
        'tax_number' => null,
        'notes' => null,
        'locale' => null,
        'main_address' => null,
        'delivery_address' => null,
        'main_contact_person' => null,
        'bank_account_details' => null,
        'credit_limit' => 'double',
        'credit_days' => 'int32',
        'credit_terms_and_conditions' => null,
        'product_sales_price_type' => null,
        'source_guid' => null,
        'currency' => null,
        'aux_reference' => null,
        'registered_number' => null,
        'deletable' => null,
        'tax_treatment' => null,
        'email' => null,
        'tax_calculation' => null,
        'auxiliary_account' => null,
        'gdpr_obfuscated' => null,
        'system' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'links' => 'links',
        'deleted_at' => 'deleted_at',
        'balance' => 'balance',
        'contact_types' => 'contact_types',
        'name' => 'name',
        'reference' => 'reference',
        'default_sales_ledger_account' => 'default_sales_ledger_account',
        'default_sales_tax_rate' => 'default_sales_tax_rate',
        'default_purchase_ledger_account' => 'default_purchase_ledger_account',
        'tax_number' => 'tax_number',
        'notes' => 'notes',
        'locale' => 'locale',
        'main_address' => 'main_address',
        'delivery_address' => 'delivery_address',
        'main_contact_person' => 'main_contact_person',
        'bank_account_details' => 'bank_account_details',
        'credit_limit' => 'credit_limit',
        'credit_days' => 'credit_days',
        'credit_terms_and_conditions' => 'credit_terms_and_conditions',
        'product_sales_price_type' => 'product_sales_price_type',
        'source_guid' => 'source_guid',
        'currency' => 'currency',
        'aux_reference' => 'aux_reference',
        'registered_number' => 'registered_number',
        'deletable' => 'deletable',
        'tax_treatment' => 'tax_treatment',
        'email' => 'email',
        'tax_calculation' => 'tax_calculation',
        'auxiliary_account' => 'auxiliary_account',
        'gdpr_obfuscated' => 'gdpr_obfuscated',
        'system' => 'system'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'links' => 'setLinks',
        'deleted_at' => 'setDeletedAt',
        'balance' => 'setBalance',
        'contact_types' => 'setContactTypes',
        'name' => 'setName',
        'reference' => 'setReference',
        'default_sales_ledger_account' => 'setDefaultSalesLedgerAccount',
        'default_sales_tax_rate' => 'setDefaultSalesTaxRate',
        'default_purchase_ledger_account' => 'setDefaultPurchaseLedgerAccount',
        'tax_number' => 'setTaxNumber',
        'notes' => 'setNotes',
        'locale' => 'setLocale',
        'main_address' => 'setMainAddress',
        'delivery_address' => 'setDeliveryAddress',
        'main_contact_person' => 'setMainContactPerson',
        'bank_account_details' => 'setBankAccountDetails',
        'credit_limit' => 'setCreditLimit',
        'credit_days' => 'setCreditDays',
        'credit_terms_and_conditions' => 'setCreditTermsAndConditions',
        'product_sales_price_type' => 'setProductSalesPriceType',
        'source_guid' => 'setSourceGuid',
        'currency' => 'setCurrency',
        'aux_reference' => 'setAuxReference',
        'registered_number' => 'setRegisteredNumber',
        'deletable' => 'setDeletable',
        'tax_treatment' => 'setTaxTreatment',
        'email' => 'setEmail',
        'tax_calculation' => 'setTaxCalculation',
        'auxiliary_account' => 'setAuxiliaryAccount',
        'gdpr_obfuscated' => 'setGdprObfuscated',
        'system' => 'setSystem'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'links' => 'getLinks',
        'deleted_at' => 'getDeletedAt',
        'balance' => 'getBalance',
        'contact_types' => 'getContactTypes',
        'name' => 'getName',
        'reference' => 'getReference',
        'default_sales_ledger_account' => 'getDefaultSalesLedgerAccount',
        'default_sales_tax_rate' => 'getDefaultSalesTaxRate',
        'default_purchase_ledger_account' => 'getDefaultPurchaseLedgerAccount',
        'tax_number' => 'getTaxNumber',
        'notes' => 'getNotes',
        'locale' => 'getLocale',
        'main_address' => 'getMainAddress',
        'delivery_address' => 'getDeliveryAddress',
        'main_contact_person' => 'getMainContactPerson',
        'bank_account_details' => 'getBankAccountDetails',
        'credit_limit' => 'getCreditLimit',
        'credit_days' => 'getCreditDays',
        'credit_terms_and_conditions' => 'getCreditTermsAndConditions',
        'product_sales_price_type' => 'getProductSalesPriceType',
        'source_guid' => 'getSourceGuid',
        'currency' => 'getCurrency',
        'aux_reference' => 'getAuxReference',
        'registered_number' => 'getRegisteredNumber',
        'deletable' => 'getDeletable',
        'tax_treatment' => 'getTaxTreatment',
        'email' => 'getEmail',
        'tax_calculation' => 'getTaxCalculation',
        'auxiliary_account' => 'getAuxiliaryAccount',
        'gdpr_obfuscated' => 'getGdprObfuscated',
        'system' => 'getSystem'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['links'] = $data['links'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['balance'] = $data['balance'] ?? null;
        $this->container['contact_types'] = $data['contact_types'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['default_sales_ledger_account'] = $data['default_sales_ledger_account'] ?? null;
        $this->container['default_sales_tax_rate'] = $data['default_sales_tax_rate'] ?? null;
        $this->container['default_purchase_ledger_account'] = $data['default_purchase_ledger_account'] ?? null;
        $this->container['tax_number'] = $data['tax_number'] ?? null;
        $this->container['notes'] = $data['notes'] ?? null;
        $this->container['locale'] = $data['locale'] ?? null;
        $this->container['main_address'] = $data['main_address'] ?? null;
        $this->container['delivery_address'] = $data['delivery_address'] ?? null;
        $this->container['main_contact_person'] = $data['main_contact_person'] ?? null;
        $this->container['bank_account_details'] = $data['bank_account_details'] ?? null;
        $this->container['credit_limit'] = $data['credit_limit'] ?? null;
        $this->container['credit_days'] = $data['credit_days'] ?? null;
        $this->container['credit_terms_and_conditions'] = $data['credit_terms_and_conditions'] ?? null;
        $this->container['product_sales_price_type'] = $data['product_sales_price_type'] ?? null;
        $this->container['source_guid'] = $data['source_guid'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['aux_reference'] = $data['aux_reference'] ?? null;
        $this->container['registered_number'] = $data['registered_number'] ?? null;
        $this->container['deletable'] = $data['deletable'] ?? null;
        $this->container['tax_treatment'] = $data['tax_treatment'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['tax_calculation'] = $data['tax_calculation'] ?? null;
        $this->container['auxiliary_account'] = $data['auxiliary_account'] ?? null;
        $this->container['gdpr_obfuscated'] = $data['gdpr_obfuscated'] ?? null;
        $this->container['system'] = $data['system'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Base|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets links
     *
     * @return \SageOne\Model\Link[]|null
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     *
     * @param \SageOne\Model\Link[]|null $links Links for the resource
     *
     * @return self
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return double|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param double|null $balance The contact balance
     *
     * @return self
     */
    public function setBalance($balance)
    {
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets contact_types
     *
     * @return \SageOne\Model\Base[]|null
     */
    public function getContactTypes()
    {
        return $this->container['contact_types'];
    }

    /**
     * Sets contact_types
     *
     * @param \SageOne\Model\Base[]|null $contact_types The contact types for the contact
     *
     * @return self
     */
    public function setContactTypes($contact_types)
    {
        $this->container['contact_types'] = $contact_types;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the contact
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference The reference for the contact
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets default_sales_ledger_account
     *
     * @return \SageOne\Model\LedgerAccount|null
     */
    public function getDefaultSalesLedgerAccount()
    {
        return $this->container['default_sales_ledger_account'];
    }

    /**
     * Sets default_sales_ledger_account
     *
     * @param \SageOne\Model\LedgerAccount|null $default_sales_ledger_account default_sales_ledger_account
     *
     * @return self
     */
    public function setDefaultSalesLedgerAccount($default_sales_ledger_account)
    {
        $this->container['default_sales_ledger_account'] = $default_sales_ledger_account;

        return $this;
    }

    /**
     * Gets default_sales_tax_rate
     *
     * @return \SageOne\Model\Base|null
     */
    public function getDefaultSalesTaxRate()
    {
        return $this->container['default_sales_tax_rate'];
    }

    /**
     * Sets default_sales_tax_rate
     *
     * @param \SageOne\Model\Base|null $default_sales_tax_rate default_sales_tax_rate
     *
     * @return self
     */
    public function setDefaultSalesTaxRate($default_sales_tax_rate)
    {
        $this->container['default_sales_tax_rate'] = $default_sales_tax_rate;

        return $this;
    }

    /**
     * Gets default_purchase_ledger_account
     *
     * @return \SageOne\Model\LedgerAccount|null
     */
    public function getDefaultPurchaseLedgerAccount()
    {
        return $this->container['default_purchase_ledger_account'];
    }

    /**
     * Sets default_purchase_ledger_account
     *
     * @param \SageOne\Model\LedgerAccount|null $default_purchase_ledger_account default_purchase_ledger_account
     *
     * @return self
     */
    public function setDefaultPurchaseLedgerAccount($default_purchase_ledger_account)
    {
        $this->container['default_purchase_ledger_account'] = $default_purchase_ledger_account;

        return $this;
    }

    /**
     * Gets tax_number
     *
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->container['tax_number'];
    }

    /**
     * Sets tax_number
     *
     * @param string|null $tax_number The tax number for the contact
     *
     * @return self
     */
    public function setTaxNumber($tax_number)
    {
        $this->container['tax_number'] = $tax_number;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes The notes for the contact
     *
     * @return self
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return string|null
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param string|null $locale The locale for the contact
     *
     * @return self
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets main_address
     *
     * @return \SageOne\Model\Address|null
     */
    public function getMainAddress()
    {
        return $this->container['main_address'];
    }

    /**
     * Sets main_address
     *
     * @param \SageOne\Model\Address|null $main_address main_address
     *
     * @return self
     */
    public function setMainAddress($main_address)
    {
        $this->container['main_address'] = $main_address;

        return $this;
    }

    /**
     * Gets delivery_address
     *
     * @return \SageOne\Model\Address|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['delivery_address'];
    }

    /**
     * Sets delivery_address
     *
     * @param \SageOne\Model\Address|null $delivery_address delivery_address
     *
     * @return self
     */
    public function setDeliveryAddress($delivery_address)
    {
        $this->container['delivery_address'] = $delivery_address;

        return $this;
    }

    /**
     * Gets main_contact_person
     *
     * @return \SageOne\Model\ContactPerson|null
     */
    public function getMainContactPerson()
    {
        return $this->container['main_contact_person'];
    }

    /**
     * Sets main_contact_person
     *
     * @param \SageOne\Model\ContactPerson|null $main_contact_person main_contact_person
     *
     * @return self
     */
    public function setMainContactPerson($main_contact_person)
    {
        $this->container['main_contact_person'] = $main_contact_person;

        return $this;
    }

    /**
     * Gets bank_account_details
     *
     * @return \SageOne\Model\BankAccountDetails|null
     */
    public function getBankAccountDetails()
    {
        return $this->container['bank_account_details'];
    }

    /**
     * Sets bank_account_details
     *
     * @param \SageOne\Model\BankAccountDetails|null $bank_account_details bank_account_details
     *
     * @return self
     */
    public function setBankAccountDetails($bank_account_details)
    {
        $this->container['bank_account_details'] = $bank_account_details;

        return $this;
    }

    /**
     * Gets credit_limit
     *
     * @return double|null
     */
    public function getCreditLimit()
    {
        return $this->container['credit_limit'];
    }

    /**
     * Sets credit_limit
     *
     * @param double|null $credit_limit Custom credit limit amount for the contact
     *
     * @return self
     */
    public function setCreditLimit($credit_limit)
    {
        $this->container['credit_limit'] = $credit_limit;

        return $this;
    }

    /**
     * Gets credit_days
     *
     * @return int|null
     */
    public function getCreditDays()
    {
        return $this->container['credit_days'];
    }

    /**
     * Sets credit_days
     *
     * @param int|null $credit_days Custom credit days for the contact If returned as null in a GET response, you may want to GET /invoice_settings and use 'vendor_credit_days' as default/fallback according to your use case.
     *
     * @return self
     */
    public function setCreditDays($credit_days)
    {
        $this->container['credit_days'] = $credit_days;

        return $this;
    }

    /**
     * Gets credit_terms_and_conditions
     *
     * @return string|null
     */
    public function getCreditTermsAndConditions()
    {
        return $this->container['credit_terms_and_conditions'];
    }

    /**
     * Sets credit_terms_and_conditions
     *
     * @param string|null $credit_terms_and_conditions Custom terms and conditions for the contact (Customers only)
     *
     * @return self
     */
    public function setCreditTermsAndConditions($credit_terms_and_conditions)
    {
        $this->container['credit_terms_and_conditions'] = $credit_terms_and_conditions;

        return $this;
    }

    /**
     * Gets product_sales_price_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getProductSalesPriceType()
    {
        return $this->container['product_sales_price_type'];
    }

    /**
     * Sets product_sales_price_type
     *
     * @param \SageOne\Model\Base|null $product_sales_price_type product_sales_price_type
     *
     * @return self
     */
    public function setProductSalesPriceType($product_sales_price_type)
    {
        $this->container['product_sales_price_type'] = $product_sales_price_type;

        return $this;
    }

    /**
     * Gets source_guid
     *
     * @return string|null
     */
    public function getSourceGuid()
    {
        return $this->container['source_guid'];
    }

    /**
     * Sets source_guid
     *
     * @param string|null $source_guid Used when importing contacts from external sources
     *
     * @return self
     */
    public function setSourceGuid($source_guid)
    {
        $this->container['source_guid'] = $source_guid;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \SageOne\Model\Base|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \SageOne\Model\Base|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets aux_reference
     *
     * @return string|null
     */
    public function getAuxReference()
    {
        return $this->container['aux_reference'];
    }

    /**
     * Sets aux_reference
     *
     * @param string|null $aux_reference Auxiliary reference. Used for German \"Kreditorennummer\" and \"Debitorennummer\"
     *
     * @return self
     */
    public function setAuxReference($aux_reference)
    {
        $this->container['aux_reference'] = $aux_reference;

        return $this;
    }

    /**
     * Gets registered_number
     *
     * @return string|null
     */
    public function getRegisteredNumber()
    {
        return $this->container['registered_number'];
    }

    /**
     * Sets registered_number
     *
     * @param string|null $registered_number The registered number of the contact's business. Only used for German businesses and represents the \"Steuernummer\" there (not the \"USt-ID\").
     *
     * @return self
     */
    public function setRegisteredNumber($registered_number)
    {
        $this->container['registered_number'] = $registered_number;

        return $this;
    }

    /**
     * Gets deletable
     *
     * @return bool|null
     */
    public function getDeletable()
    {
        return $this->container['deletable'];
    }

    /**
     * Sets deletable
     *
     * @param bool|null $deletable Indicates whether the ledger entry has been deleted or not
     *
     * @return self
     */
    public function setDeletable($deletable)
    {
        $this->container['deletable'] = $deletable;

        return $this;
    }

    /**
     * Gets tax_treatment
     *
     * @return \SageOne\Model\ContactTaxTreatment|null
     */
    public function getTaxTreatment()
    {
        return $this->container['tax_treatment'];
    }

    /**
     * Sets tax_treatment
     *
     * @param \SageOne\Model\ContactTaxTreatment|null $tax_treatment tax_treatment
     *
     * @return self
     */
    public function setTaxTreatment($tax_treatment)
    {
        $this->container['tax_treatment'] = $tax_treatment;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email The email address for the given contact
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets tax_calculation
     *
     * @return string|null
     */
    public function getTaxCalculation()
    {
        return $this->container['tax_calculation'];
    }

    /**
     * Sets tax_calculation
     *
     * @param string|null $tax_calculation The tax calculation method - used for French VAT & Recargo
     *
     * @return self
     */
    public function setTaxCalculation($tax_calculation)
    {
        $this->container['tax_calculation'] = $tax_calculation;

        return $this;
    }

    /**
     * Gets auxiliary_account
     *
     * @return string|null
     */
    public function getAuxiliaryAccount()
    {
        return $this->container['auxiliary_account'];
    }

    /**
     * Sets auxiliary_account
     *
     * @param string|null $auxiliary_account Auxiliary account - used when auxiliary accounting is enabled in business settings
     *
     * @return self
     */
    public function setAuxiliaryAccount($auxiliary_account)
    {
        $this->container['auxiliary_account'] = $auxiliary_account;

        return $this;
    }

    /**
     * Gets gdpr_obfuscated
     *
     * @return bool|null
     */
    public function getGdprObfuscated()
    {
        return $this->container['gdpr_obfuscated'];
    }

    /**
     * Sets gdpr_obfuscated
     *
     * @param bool|null $gdpr_obfuscated General Data Protection Regulation (GDPR) came into effect on 25th May 2018. It introduces new rules for how business owners manage their contacts' personal data. When this field returns 'true', means that the contact has been requested to be obfuscated and you can not create any artifact (sales invoices, purchase invoices, ...) but you can still check previously created artifacts.
     *
     * @return self
     */
    public function setGdprObfuscated($gdpr_obfuscated)
    {
        $this->container['gdpr_obfuscated'] = $gdpr_obfuscated;

        return $this;
    }

    /**
     * Gets system
     *
     * @return bool|null
     */
    public function getSystem()
    {
        return $this->container['system'];
    }

    /**
     * Sets system
     *
     * @param bool|null $system Identifies a contact as being a system contact used for processing specific transaction types and reserved specifically for those transaction types such as tax return payments/refunds.
     *
     * @return self
     */
    public function setSystem($system)
    {
        $this->container['system'] = $system;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


