<?php
/**
 * CoaAccount
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * CoaAccount Class Doc Comment
 *
 * @category Class
 * @description Returns a Coa Account
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CoaAccount implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CoaAccount';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Base',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'ledger_account_group' => '\SageOne\Model\CoaGroupType',
        'name' => 'string',
        'control_name' => 'string',
        'nominal_code' => 'int',
        'ledger_account_type' => '\SageOne\Model\Base',
        'ledger_account_classification' => '\SageOne\Model\Base',
        'tax_rate' => '\SageOne\Model\Base',
        'fixed_tax_rate' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'ledger_account_group' => null,
        'name' => null,
        'control_name' => null,
        'nominal_code' => 'int32',
        'ledger_account_type' => null,
        'ledger_account_classification' => null,
        'tax_rate' => null,
        'fixed_tax_rate' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'ledger_account_group' => 'ledger_account_group',
        'name' => 'name',
        'control_name' => 'control_name',
        'nominal_code' => 'nominal_code',
        'ledger_account_type' => 'ledger_account_type',
        'ledger_account_classification' => 'ledger_account_classification',
        'tax_rate' => 'tax_rate',
        'fixed_tax_rate' => 'fixed_tax_rate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'ledger_account_group' => 'setLedgerAccountGroup',
        'name' => 'setName',
        'control_name' => 'setControlName',
        'nominal_code' => 'setNominalCode',
        'ledger_account_type' => 'setLedgerAccountType',
        'ledger_account_classification' => 'setLedgerAccountClassification',
        'tax_rate' => 'setTaxRate',
        'fixed_tax_rate' => 'setFixedTaxRate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'ledger_account_group' => 'getLedgerAccountGroup',
        'name' => 'getName',
        'control_name' => 'getControlName',
        'nominal_code' => 'getNominalCode',
        'ledger_account_type' => 'getLedgerAccountType',
        'ledger_account_classification' => 'getLedgerAccountClassification',
        'tax_rate' => 'getTaxRate',
        'fixed_tax_rate' => 'getFixedTaxRate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['ledger_account_group'] = $data['ledger_account_group'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['control_name'] = $data['control_name'] ?? null;
        $this->container['nominal_code'] = $data['nominal_code'] ?? null;
        $this->container['ledger_account_type'] = $data['ledger_account_type'] ?? null;
        $this->container['ledger_account_classification'] = $data['ledger_account_classification'] ?? null;
        $this->container['tax_rate'] = $data['tax_rate'] ?? null;
        $this->container['fixed_tax_rate'] = $data['fixed_tax_rate'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Base|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets ledger_account_group
     *
     * @return \SageOne\Model\CoaGroupType|null
     */
    public function getLedgerAccountGroup()
    {
        return $this->container['ledger_account_group'];
    }

    /**
     * Sets ledger_account_group
     *
     * @param \SageOne\Model\CoaGroupType|null $ledger_account_group ledger_account_group
     *
     * @return self
     */
    public function setLedgerAccountGroup($ledger_account_group)
    {
        $this->container['ledger_account_group'] = $ledger_account_group;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name for the COA account
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets control_name
     *
     * @return string|null
     */
    public function getControlName()
    {
        return $this->container['control_name'];
    }

    /**
     * Sets control_name
     *
     * @param string|null $control_name The system control name for the COA account
     *
     * @return self
     */
    public function setControlName($control_name)
    {
        $this->container['control_name'] = $control_name;

        return $this;
    }

    /**
     * Gets nominal_code
     *
     * @return int|null
     */
    public function getNominalCode()
    {
        return $this->container['nominal_code'];
    }

    /**
     * Sets nominal_code
     *
     * @param int|null $nominal_code The nominal code of the COA account
     *
     * @return self
     */
    public function setNominalCode($nominal_code)
    {
        $this->container['nominal_code'] = $nominal_code;

        return $this;
    }

    /**
     * Gets ledger_account_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getLedgerAccountType()
    {
        return $this->container['ledger_account_type'];
    }

    /**
     * Sets ledger_account_type
     *
     * @param \SageOne\Model\Base|null $ledger_account_type ledger_account_type
     *
     * @return self
     */
    public function setLedgerAccountType($ledger_account_type)
    {
        $this->container['ledger_account_type'] = $ledger_account_type;

        return $this;
    }

    /**
     * Gets ledger_account_classification
     *
     * @return \SageOne\Model\Base|null
     */
    public function getLedgerAccountClassification()
    {
        return $this->container['ledger_account_classification'];
    }

    /**
     * Sets ledger_account_classification
     *
     * @param \SageOne\Model\Base|null $ledger_account_classification ledger_account_classification
     *
     * @return self
     */
    public function setLedgerAccountClassification($ledger_account_classification)
    {
        $this->container['ledger_account_classification'] = $ledger_account_classification;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param \SageOne\Model\Base|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets fixed_tax_rate
     *
     * @return bool|null
     */
    public function getFixedTaxRate()
    {
        return $this->container['fixed_tax_rate'];
    }

    /**
     * Sets fixed_tax_rate
     *
     * @param bool|null $fixed_tax_rate Indicates whether the default tax rate is fixed or may be changed
     *
     * @return self
     */
    public function setFixedTaxRate($fixed_tax_rate)
    {
        $this->container['fixed_tax_rate'] = $fixed_tax_rate;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


