<?php
/**
 * BusinessSettings
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * BusinessSettings Class Doc Comment
 *
 * @category Class
 * @description Updates a Business Settings
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class BusinessSettings implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BusinessSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'path' => 'string',
        'siret' => 'int',
        'management_centre_member' => 'bool',
        'rcs_number' => 'string',
        'share_capital' => 'double',
        'business_activity_type' => '\SageOne\Model\BusinessActivityType',
        'legal_form_type' => '\SageOne\Model\LegalFormType',
        'auxiliary_accounts_visible' => 'bool',
        'default_ledger_accounts' => '\SageOne\Model\DefaultLedgerAccounts',
        'business_type' => '\SageOne\Model\BusinessType',
        'country_of_registration' => '\SageOne\Model\Base'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'path' => null,
        'siret' => 'int32',
        'management_centre_member' => null,
        'rcs_number' => null,
        'share_capital' => 'double',
        'business_activity_type' => null,
        'legal_form_type' => null,
        'auxiliary_accounts_visible' => null,
        'default_ledger_accounts' => null,
        'business_type' => null,
        'country_of_registration' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'path' => '$path',
        'siret' => 'siret',
        'management_centre_member' => 'management_centre_member',
        'rcs_number' => 'rcs_number',
        'share_capital' => 'share_capital',
        'business_activity_type' => 'business_activity_type',
        'legal_form_type' => 'legal_form_type',
        'auxiliary_accounts_visible' => 'auxiliary_accounts_visible',
        'default_ledger_accounts' => 'default_ledger_accounts',
        'business_type' => 'business_type',
        'country_of_registration' => 'country_of_registration'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'path' => 'setPath',
        'siret' => 'setSiret',
        'management_centre_member' => 'setManagementCentreMember',
        'rcs_number' => 'setRcsNumber',
        'share_capital' => 'setShareCapital',
        'business_activity_type' => 'setBusinessActivityType',
        'legal_form_type' => 'setLegalFormType',
        'auxiliary_accounts_visible' => 'setAuxiliaryAccountsVisible',
        'default_ledger_accounts' => 'setDefaultLedgerAccounts',
        'business_type' => 'setBusinessType',
        'country_of_registration' => 'setCountryOfRegistration'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'path' => 'getPath',
        'siret' => 'getSiret',
        'management_centre_member' => 'getManagementCentreMember',
        'rcs_number' => 'getRcsNumber',
        'share_capital' => 'getShareCapital',
        'business_activity_type' => 'getBusinessActivityType',
        'legal_form_type' => 'getLegalFormType',
        'auxiliary_accounts_visible' => 'getAuxiliaryAccountsVisible',
        'default_ledger_accounts' => 'getDefaultLedgerAccounts',
        'business_type' => 'getBusinessType',
        'country_of_registration' => 'getCountryOfRegistration'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['path'] = $data['path'] ?? null;
        $this->container['siret'] = $data['siret'] ?? null;
        $this->container['management_centre_member'] = $data['management_centre_member'] ?? null;
        $this->container['rcs_number'] = $data['rcs_number'] ?? null;
        $this->container['share_capital'] = $data['share_capital'] ?? null;
        $this->container['business_activity_type'] = $data['business_activity_type'] ?? null;
        $this->container['legal_form_type'] = $data['legal_form_type'] ?? null;
        $this->container['auxiliary_accounts_visible'] = $data['auxiliary_accounts_visible'] ?? null;
        $this->container['default_ledger_accounts'] = $data['default_ledger_accounts'] ?? null;
        $this->container['business_type'] = $data['business_type'] ?? null;
        $this->container['country_of_registration'] = $data['country_of_registration'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets siret
     *
     * @return int|null
     */
    public function getSiret()
    {
        return $this->container['siret'];
    }

    /**
     * Sets siret
     *
     * @param int|null $siret SIRET Number (France only)
     *
     * @return self
     */
    public function setSiret($siret)
    {
        $this->container['siret'] = $siret;

        return $this;
    }

    /**
     * Gets management_centre_member
     *
     * @return bool|null
     */
    public function getManagementCentreMember()
    {
        return $this->container['management_centre_member'];
    }

    /**
     * Sets management_centre_member
     *
     * @param bool|null $management_centre_member Member of Approved Management Centres (France only)
     *
     * @return self
     */
    public function setManagementCentreMember($management_centre_member)
    {
        $this->container['management_centre_member'] = $management_centre_member;

        return $this;
    }

    /**
     * Gets rcs_number
     *
     * @return string|null
     */
    public function getRcsNumber()
    {
        return $this->container['rcs_number'];
    }

    /**
     * Sets rcs_number
     *
     * @param string|null $rcs_number RCS Number (France only)
     *
     * @return self
     */
    public function setRcsNumber($rcs_number)
    {
        $this->container['rcs_number'] = $rcs_number;

        return $this;
    }

    /**
     * Gets share_capital
     *
     * @return double|null
     */
    public function getShareCapital()
    {
        return $this->container['share_capital'];
    }

    /**
     * Sets share_capital
     *
     * @param double|null $share_capital Share Capital (France only)
     *
     * @return self
     */
    public function setShareCapital($share_capital)
    {
        $this->container['share_capital'] = $share_capital;

        return $this;
    }

    /**
     * Gets business_activity_type
     *
     * @return \SageOne\Model\BusinessActivityType|null
     */
    public function getBusinessActivityType()
    {
        return $this->container['business_activity_type'];
    }

    /**
     * Sets business_activity_type
     *
     * @param \SageOne\Model\BusinessActivityType|null $business_activity_type business_activity_type
     *
     * @return self
     */
    public function setBusinessActivityType($business_activity_type)
    {
        $this->container['business_activity_type'] = $business_activity_type;

        return $this;
    }

    /**
     * Gets legal_form_type
     *
     * @return \SageOne\Model\LegalFormType|null
     */
    public function getLegalFormType()
    {
        return $this->container['legal_form_type'];
    }

    /**
     * Sets legal_form_type
     *
     * @param \SageOne\Model\LegalFormType|null $legal_form_type legal_form_type
     *
     * @return self
     */
    public function setLegalFormType($legal_form_type)
    {
        $this->container['legal_form_type'] = $legal_form_type;

        return $this;
    }

    /**
     * Gets auxiliary_accounts_visible
     *
     * @return bool|null
     */
    public function getAuxiliaryAccountsVisible()
    {
        return $this->container['auxiliary_accounts_visible'];
    }

    /**
     * Sets auxiliary_accounts_visible
     *
     * @param bool|null $auxiliary_accounts_visible Auxiliary Accounts Visible (France & Spain only)
     *
     * @return self
     */
    public function setAuxiliaryAccountsVisible($auxiliary_accounts_visible)
    {
        $this->container['auxiliary_accounts_visible'] = $auxiliary_accounts_visible;

        return $this;
    }

    /**
     * Gets default_ledger_accounts
     *
     * @return \SageOne\Model\DefaultLedgerAccounts|null
     */
    public function getDefaultLedgerAccounts()
    {
        return $this->container['default_ledger_accounts'];
    }

    /**
     * Sets default_ledger_accounts
     *
     * @param \SageOne\Model\DefaultLedgerAccounts|null $default_ledger_accounts default_ledger_accounts
     *
     * @return self
     */
    public function setDefaultLedgerAccounts($default_ledger_accounts)
    {
        $this->container['default_ledger_accounts'] = $default_ledger_accounts;

        return $this;
    }

    /**
     * Gets business_type
     *
     * @return \SageOne\Model\BusinessType|null
     */
    public function getBusinessType()
    {
        return $this->container['business_type'];
    }

    /**
     * Sets business_type
     *
     * @param \SageOne\Model\BusinessType|null $business_type business_type
     *
     * @return self
     */
    public function setBusinessType($business_type)
    {
        $this->container['business_type'] = $business_type;

        return $this;
    }

    /**
     * Gets country_of_registration
     *
     * @return \SageOne\Model\Base|null
     */
    public function getCountryOfRegistration()
    {
        return $this->container['country_of_registration'];
    }

    /**
     * Sets country_of_registration
     *
     * @param \SageOne\Model\Base|null $country_of_registration country_of_registration
     *
     * @return self
     */
    public function setCountryOfRegistration($country_of_registration)
    {
        $this->container['country_of_registration'] = $country_of_registration;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


