<?php
/**
 * BankReconciliation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * BankReconciliation Class Doc Comment
 *
 * @category Class
 * @description Updates a Bank Reconciliation
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class BankReconciliation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BankReconciliation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Base',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'bank_account' => '\SageOne\Model\Base',
        'statement_date' => '\DateTime',
        'statement_end_balance' => 'double',
        'reference' => 'string',
        'total_received' => 'double',
        'total_paid' => 'double',
        'starting_balance' => 'double',
        'closing_balance' => 'double',
        'reconciled_balance' => 'double',
        'balance_difference' => 'double',
        'status' => '\SageOne\Model\BankReconciliationStatus'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'bank_account' => null,
        'statement_date' => 'date',
        'statement_end_balance' => 'double',
        'reference' => null,
        'total_received' => 'double',
        'total_paid' => 'double',
        'starting_balance' => 'double',
        'closing_balance' => 'double',
        'reconciled_balance' => 'double',
        'balance_difference' => 'double',
        'status' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'bank_account' => 'bank_account',
        'statement_date' => 'statement_date',
        'statement_end_balance' => 'statement_end_balance',
        'reference' => 'reference',
        'total_received' => 'total_received',
        'total_paid' => 'total_paid',
        'starting_balance' => 'starting_balance',
        'closing_balance' => 'closing_balance',
        'reconciled_balance' => 'reconciled_balance',
        'balance_difference' => 'balance_difference',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'bank_account' => 'setBankAccount',
        'statement_date' => 'setStatementDate',
        'statement_end_balance' => 'setStatementEndBalance',
        'reference' => 'setReference',
        'total_received' => 'setTotalReceived',
        'total_paid' => 'setTotalPaid',
        'starting_balance' => 'setStartingBalance',
        'closing_balance' => 'setClosingBalance',
        'reconciled_balance' => 'setReconciledBalance',
        'balance_difference' => 'setBalanceDifference',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'bank_account' => 'getBankAccount',
        'statement_date' => 'getStatementDate',
        'statement_end_balance' => 'getStatementEndBalance',
        'reference' => 'getReference',
        'total_received' => 'getTotalReceived',
        'total_paid' => 'getTotalPaid',
        'starting_balance' => 'getStartingBalance',
        'closing_balance' => 'getClosingBalance',
        'reconciled_balance' => 'getReconciledBalance',
        'balance_difference' => 'getBalanceDifference',
        'status' => 'getStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['bank_account'] = $data['bank_account'] ?? null;
        $this->container['statement_date'] = $data['statement_date'] ?? null;
        $this->container['statement_end_balance'] = $data['statement_end_balance'] ?? null;
        $this->container['reference'] = $data['reference'] ?? null;
        $this->container['total_received'] = $data['total_received'] ?? null;
        $this->container['total_paid'] = $data['total_paid'] ?? null;
        $this->container['starting_balance'] = $data['starting_balance'] ?? null;
        $this->container['closing_balance'] = $data['closing_balance'] ?? null;
        $this->container['reconciled_balance'] = $data['reconciled_balance'] ?? null;
        $this->container['balance_difference'] = $data['balance_difference'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Base|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets bank_account
     *
     * @return \SageOne\Model\Base|null
     */
    public function getBankAccount()
    {
        return $this->container['bank_account'];
    }

    /**
     * Sets bank_account
     *
     * @param \SageOne\Model\Base|null $bank_account bank_account
     *
     * @return self
     */
    public function setBankAccount($bank_account)
    {
        $this->container['bank_account'] = $bank_account;

        return $this;
    }

    /**
     * Gets statement_date
     *
     * @return \DateTime|null
     */
    public function getStatementDate()
    {
        return $this->container['statement_date'];
    }

    /**
     * Sets statement_date
     *
     * @param \DateTime|null $statement_date The date of the bank reconciliation
     *
     * @return self
     */
    public function setStatementDate($statement_date)
    {
        $this->container['statement_date'] = $statement_date;

        return $this;
    }

    /**
     * Gets statement_end_balance
     *
     * @return double|null
     */
    public function getStatementEndBalance()
    {
        return $this->container['statement_end_balance'];
    }

    /**
     * Sets statement_end_balance
     *
     * @param double|null $statement_end_balance The statement end balance for the reconciliation
     *
     * @return self
     */
    public function setStatementEndBalance($statement_end_balance)
    {
        $this->container['statement_end_balance'] = $statement_end_balance;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference A reference for the bank reconciliation
     *
     * @return self
     */
    public function setReference($reference)
    {
        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets total_received
     *
     * @return double|null
     */
    public function getTotalReceived()
    {
        return $this->container['total_received'];
    }

    /**
     * Sets total_received
     *
     * @param double|null $total_received The total amount received
     *
     * @return self
     */
    public function setTotalReceived($total_received)
    {
        $this->container['total_received'] = $total_received;

        return $this;
    }

    /**
     * Gets total_paid
     *
     * @return double|null
     */
    public function getTotalPaid()
    {
        return $this->container['total_paid'];
    }

    /**
     * Sets total_paid
     *
     * @param double|null $total_paid The total amount paid
     *
     * @return self
     */
    public function setTotalPaid($total_paid)
    {
        $this->container['total_paid'] = $total_paid;

        return $this;
    }

    /**
     * Gets starting_balance
     *
     * @return double|null
     */
    public function getStartingBalance()
    {
        return $this->container['starting_balance'];
    }

    /**
     * Sets starting_balance
     *
     * @param double|null $starting_balance The starting balance of the bank reconciliation
     *
     * @return self
     */
    public function setStartingBalance($starting_balance)
    {
        $this->container['starting_balance'] = $starting_balance;

        return $this;
    }

    /**
     * Gets closing_balance
     *
     * @return double|null
     */
    public function getClosingBalance()
    {
        return $this->container['closing_balance'];
    }

    /**
     * Sets closing_balance
     *
     * @param double|null $closing_balance The closing balance of the bank reconciliation
     *
     * @return self
     */
    public function setClosingBalance($closing_balance)
    {
        $this->container['closing_balance'] = $closing_balance;

        return $this;
    }

    /**
     * Gets reconciled_balance
     *
     * @return double|null
     */
    public function getReconciledBalance()
    {
        return $this->container['reconciled_balance'];
    }

    /**
     * Sets reconciled_balance
     *
     * @param double|null $reconciled_balance The reconciled balance of the bank reconciliation
     *
     * @return self
     */
    public function setReconciledBalance($reconciled_balance)
    {
        $this->container['reconciled_balance'] = $reconciled_balance;

        return $this;
    }

    /**
     * Gets balance_difference
     *
     * @return double|null
     */
    public function getBalanceDifference()
    {
        return $this->container['balance_difference'];
    }

    /**
     * Sets balance_difference
     *
     * @param double|null $balance_difference The difference between the statement end balance and the reconciled balance
     *
     * @return self
     */
    public function setBalanceDifference($balance_difference)
    {
        $this->container['balance_difference'] = $balance_difference;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \SageOne\Model\BankReconciliationStatus|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \SageOne\Model\BankReconciliationStatus|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


