<?php
/**
 * BankAccount
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * BankAccount Class Doc Comment
 *
 * @category Class
 * @description Updates a Bank Account
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class BankAccount implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BankAccount';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'legacy_id' => 'int',
        'id' => 'string',
        'displayed_as' => 'string',
        'path' => 'string',
        'transaction' => '\SageOne\Model\Base',
        'transaction_type' => '\SageOne\Model\Base',
        'created_at' => '\DateTime',
        'updated_at' => '\DateTime',
        'deleted_at' => '\DateTime',
        'bank_account_details' => '\SageOne\Model\BankAccountDetails',
        'ledger_account' => '\SageOne\Model\Base',
        'bank_account_type' => '\SageOne\Model\Base',
        'balance' => 'double',
        'main_address' => '\SageOne\Model\Address',
        'main_contact_person' => '\SageOne\Model\BankAccountContact',
        'nominal_code' => 'int',
        'editable' => 'bool',
        'deletable' => 'bool',
        'journal_code' => '\SageOne\Model\JournalCode',
        'default_payment_method' => '\SageOne\Model\Base'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'legacy_id' => 'int32',
        'id' => null,
        'displayed_as' => null,
        'path' => null,
        'transaction' => null,
        'transaction_type' => null,
        'created_at' => 'date-time',
        'updated_at' => 'date-time',
        'deleted_at' => 'date-time',
        'bank_account_details' => null,
        'ledger_account' => null,
        'bank_account_type' => null,
        'balance' => 'double',
        'main_address' => null,
        'main_contact_person' => null,
        'nominal_code' => 'int32',
        'editable' => null,
        'deletable' => null,
        'journal_code' => null,
        'default_payment_method' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'legacy_id' => 'legacy_id',
        'id' => 'id',
        'displayed_as' => 'displayed_as',
        'path' => '$path',
        'transaction' => 'transaction',
        'transaction_type' => 'transaction_type',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'bank_account_details' => 'bank_account_details',
        'ledger_account' => 'ledger_account',
        'bank_account_type' => 'bank_account_type',
        'balance' => 'balance',
        'main_address' => 'main_address',
        'main_contact_person' => 'main_contact_person',
        'nominal_code' => 'nominal_code',
        'editable' => 'editable',
        'deletable' => 'deletable',
        'journal_code' => 'journal_code',
        'default_payment_method' => 'default_payment_method'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'legacy_id' => 'setLegacyId',
        'id' => 'setId',
        'displayed_as' => 'setDisplayedAs',
        'path' => 'setPath',
        'transaction' => 'setTransaction',
        'transaction_type' => 'setTransactionType',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'bank_account_details' => 'setBankAccountDetails',
        'ledger_account' => 'setLedgerAccount',
        'bank_account_type' => 'setBankAccountType',
        'balance' => 'setBalance',
        'main_address' => 'setMainAddress',
        'main_contact_person' => 'setMainContactPerson',
        'nominal_code' => 'setNominalCode',
        'editable' => 'setEditable',
        'deletable' => 'setDeletable',
        'journal_code' => 'setJournalCode',
        'default_payment_method' => 'setDefaultPaymentMethod'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'legacy_id' => 'getLegacyId',
        'id' => 'getId',
        'displayed_as' => 'getDisplayedAs',
        'path' => 'getPath',
        'transaction' => 'getTransaction',
        'transaction_type' => 'getTransactionType',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'bank_account_details' => 'getBankAccountDetails',
        'ledger_account' => 'getLedgerAccount',
        'bank_account_type' => 'getBankAccountType',
        'balance' => 'getBalance',
        'main_address' => 'getMainAddress',
        'main_contact_person' => 'getMainContactPerson',
        'nominal_code' => 'getNominalCode',
        'editable' => 'getEditable',
        'deletable' => 'getDeletable',
        'journal_code' => 'getJournalCode',
        'default_payment_method' => 'getDefaultPaymentMethod'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['legacy_id'] = $data['legacy_id'] ?? null;
        $this->container['id'] = $data['id'] ?? null;
        $this->container['displayed_as'] = $data['displayed_as'] ?? null;
        $this->container['path'] = $data['path'] ?? null;
        $this->container['transaction'] = $data['transaction'] ?? null;
        $this->container['transaction_type'] = $data['transaction_type'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['bank_account_details'] = $data['bank_account_details'] ?? null;
        $this->container['ledger_account'] = $data['ledger_account'] ?? null;
        $this->container['bank_account_type'] = $data['bank_account_type'] ?? null;
        $this->container['balance'] = $data['balance'] ?? null;
        $this->container['main_address'] = $data['main_address'] ?? null;
        $this->container['main_contact_person'] = $data['main_contact_person'] ?? null;
        $this->container['nominal_code'] = $data['nominal_code'] ?? null;
        $this->container['editable'] = $data['editable'] ?? null;
        $this->container['deletable'] = $data['deletable'] ?? null;
        $this->container['journal_code'] = $data['journal_code'] ?? null;
        $this->container['default_payment_method'] = $data['default_payment_method'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets legacy_id
     *
     * @return int|null
     */
    public function getLegacyId()
    {
        return $this->container['legacy_id'];
    }

    /**
     * Sets legacy_id
     *
     * @param int|null $legacy_id The legacy ID for the item
     *
     * @return self
     */
    public function setLegacyId($legacy_id)
    {
        $this->container['legacy_id'] = $legacy_id;

        return $this;
    }

    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id The unique identifier for the item
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayed_as
     *
     * @return string|null
     */
    public function getDisplayedAs()
    {
        return $this->container['displayed_as'];
    }

    /**
     * Sets displayed_as
     *
     * @param string|null $displayed_as The name of the resource
     *
     * @return self
     */
    public function setDisplayedAs($displayed_as)
    {
        $this->container['displayed_as'] = $displayed_as;

        return $this;
    }

    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path The API path for the resource
     *
     * @return self
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets transaction
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransaction()
    {
        return $this->container['transaction'];
    }

    /**
     * Sets transaction
     *
     * @param \SageOne\Model\Base|null $transaction transaction
     *
     * @return self
     */
    public function setTransaction($transaction)
    {
        $this->container['transaction'] = $transaction;

        return $this;
    }

    /**
     * Gets transaction_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getTransactionType()
    {
        return $this->container['transaction_type'];
    }

    /**
     * Sets transaction_type
     *
     * @param \SageOne\Model\Base|null $transaction_type transaction_type
     *
     * @return self
     */
    public function setTransactionType($transaction_type)
    {
        $this->container['transaction_type'] = $transaction_type;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at The datetime when the item was created
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return \DateTime|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param \DateTime|null $updated_at The datetime when the item was last updated
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return \DateTime|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param \DateTime|null $deleted_at The datetime when the item was deleted
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets bank_account_details
     *
     * @return \SageOne\Model\BankAccountDetails|null
     */
    public function getBankAccountDetails()
    {
        return $this->container['bank_account_details'];
    }

    /**
     * Sets bank_account_details
     *
     * @param \SageOne\Model\BankAccountDetails|null $bank_account_details bank_account_details
     *
     * @return self
     */
    public function setBankAccountDetails($bank_account_details)
    {
        $this->container['bank_account_details'] = $bank_account_details;

        return $this;
    }

    /**
     * Gets ledger_account
     *
     * @return \SageOne\Model\Base|null
     */
    public function getLedgerAccount()
    {
        return $this->container['ledger_account'];
    }

    /**
     * Sets ledger_account
     *
     * @param \SageOne\Model\Base|null $ledger_account ledger_account
     *
     * @return self
     */
    public function setLedgerAccount($ledger_account)
    {
        $this->container['ledger_account'] = $ledger_account;

        return $this;
    }

    /**
     * Gets bank_account_type
     *
     * @return \SageOne\Model\Base|null
     */
    public function getBankAccountType()
    {
        return $this->container['bank_account_type'];
    }

    /**
     * Sets bank_account_type
     *
     * @param \SageOne\Model\Base|null $bank_account_type bank_account_type
     *
     * @return self
     */
    public function setBankAccountType($bank_account_type)
    {
        $this->container['bank_account_type'] = $bank_account_type;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return double|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param double|null $balance The bank account balance
     *
     * @return self
     */
    public function setBalance($balance)
    {
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets main_address
     *
     * @return \SageOne\Model\Address|null
     */
    public function getMainAddress()
    {
        return $this->container['main_address'];
    }

    /**
     * Sets main_address
     *
     * @param \SageOne\Model\Address|null $main_address main_address
     *
     * @return self
     */
    public function setMainAddress($main_address)
    {
        $this->container['main_address'] = $main_address;

        return $this;
    }

    /**
     * Gets main_contact_person
     *
     * @return \SageOne\Model\BankAccountContact|null
     */
    public function getMainContactPerson()
    {
        return $this->container['main_contact_person'];
    }

    /**
     * Sets main_contact_person
     *
     * @param \SageOne\Model\BankAccountContact|null $main_contact_person main_contact_person
     *
     * @return self
     */
    public function setMainContactPerson($main_contact_person)
    {
        $this->container['main_contact_person'] = $main_contact_person;

        return $this;
    }

    /**
     * Gets nominal_code
     *
     * @return int|null
     */
    public function getNominalCode()
    {
        return $this->container['nominal_code'];
    }

    /**
     * Sets nominal_code
     *
     * @param int|null $nominal_code The nominal code of the bank account
     *
     * @return self
     */
    public function setNominalCode($nominal_code)
    {
        $this->container['nominal_code'] = $nominal_code;

        return $this;
    }

    /**
     * Gets editable
     *
     * @return bool|null
     */
    public function getEditable()
    {
        return $this->container['editable'];
    }

    /**
     * Sets editable
     *
     * @param bool|null $editable Indicates whether or not the bank account can be edited
     *
     * @return self
     */
    public function setEditable($editable)
    {
        $this->container['editable'] = $editable;

        return $this;
    }

    /**
     * Gets deletable
     *
     * @return bool|null
     */
    public function getDeletable()
    {
        return $this->container['deletable'];
    }

    /**
     * Sets deletable
     *
     * @param bool|null $deletable Indicates whether or not the bank account can be deleted
     *
     * @return self
     */
    public function setDeletable($deletable)
    {
        $this->container['deletable'] = $deletable;

        return $this;
    }

    /**
     * Gets journal_code
     *
     * @return \SageOne\Model\JournalCode|null
     */
    public function getJournalCode()
    {
        return $this->container['journal_code'];
    }

    /**
     * Sets journal_code
     *
     * @param \SageOne\Model\JournalCode|null $journal_code journal_code
     *
     * @return self
     */
    public function setJournalCode($journal_code)
    {
        $this->container['journal_code'] = $journal_code;

        return $this;
    }

    /**
     * Gets default_payment_method
     *
     * @return \SageOne\Model\Base|null
     */
    public function getDefaultPaymentMethod()
    {
        return $this->container['default_payment_method'];
    }

    /**
     * Sets default_payment_method
     *
     * @param \SageOne\Model\Base|null $default_payment_method default_payment_method
     *
     * @return self
     */
    public function setDefaultPaymentMethod($default_payment_method)
    {
        $this->container['default_payment_method'] = $default_payment_method;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


