<?php
/**
 * ArtefactDetailedTaxAnalysisBreakdown
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * ArtefactDetailedTaxAnalysisBreakdown Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ArtefactDetailedTaxAnalysisBreakdown implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ArtefactDetailedTaxAnalysisBreakdown';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tax_rate' => '\SageOne\Model\TaxRate',
        'name' => 'string',
        'percentage' => 'double',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'retail_tax_amount' => 'double',
        'total_amount' => 'double',
        'goods_amount' => 'double',
        'services_amount' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_goods_amount' => 'double',
        'base_currency_services_amount' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tax_rate' => null,
        'name' => null,
        'percentage' => 'double',
        'net_amount' => 'double',
        'tax_amount' => 'double',
        'retail_tax_amount' => 'double',
        'total_amount' => 'double',
        'goods_amount' => 'double',
        'services_amount' => 'double',
        'base_currency_net_amount' => 'double',
        'base_currency_tax_amount' => 'double',
        'base_currency_total_amount' => 'double',
        'base_currency_goods_amount' => 'double',
        'base_currency_services_amount' => 'double'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tax_rate' => 'tax_rate',
        'name' => 'name',
        'percentage' => 'percentage',
        'net_amount' => 'net_amount',
        'tax_amount' => 'tax_amount',
        'retail_tax_amount' => 'retail_tax_amount',
        'total_amount' => 'total_amount',
        'goods_amount' => 'goods_amount',
        'services_amount' => 'services_amount',
        'base_currency_net_amount' => 'base_currency_net_amount',
        'base_currency_tax_amount' => 'base_currency_tax_amount',
        'base_currency_total_amount' => 'base_currency_total_amount',
        'base_currency_goods_amount' => 'base_currency_goods_amount',
        'base_currency_services_amount' => 'base_currency_services_amount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tax_rate' => 'setTaxRate',
        'name' => 'setName',
        'percentage' => 'setPercentage',
        'net_amount' => 'setNetAmount',
        'tax_amount' => 'setTaxAmount',
        'retail_tax_amount' => 'setRetailTaxAmount',
        'total_amount' => 'setTotalAmount',
        'goods_amount' => 'setGoodsAmount',
        'services_amount' => 'setServicesAmount',
        'base_currency_net_amount' => 'setBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'setBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'setBaseCurrencyTotalAmount',
        'base_currency_goods_amount' => 'setBaseCurrencyGoodsAmount',
        'base_currency_services_amount' => 'setBaseCurrencyServicesAmount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tax_rate' => 'getTaxRate',
        'name' => 'getName',
        'percentage' => 'getPercentage',
        'net_amount' => 'getNetAmount',
        'tax_amount' => 'getTaxAmount',
        'retail_tax_amount' => 'getRetailTaxAmount',
        'total_amount' => 'getTotalAmount',
        'goods_amount' => 'getGoodsAmount',
        'services_amount' => 'getServicesAmount',
        'base_currency_net_amount' => 'getBaseCurrencyNetAmount',
        'base_currency_tax_amount' => 'getBaseCurrencyTaxAmount',
        'base_currency_total_amount' => 'getBaseCurrencyTotalAmount',
        'base_currency_goods_amount' => 'getBaseCurrencyGoodsAmount',
        'base_currency_services_amount' => 'getBaseCurrencyServicesAmount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tax_rate'] = $data['tax_rate'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['percentage'] = $data['percentage'] ?? null;
        $this->container['net_amount'] = $data['net_amount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['retail_tax_amount'] = $data['retail_tax_amount'] ?? null;
        $this->container['total_amount'] = $data['total_amount'] ?? null;
        $this->container['goods_amount'] = $data['goods_amount'] ?? null;
        $this->container['services_amount'] = $data['services_amount'] ?? null;
        $this->container['base_currency_net_amount'] = $data['base_currency_net_amount'] ?? null;
        $this->container['base_currency_tax_amount'] = $data['base_currency_tax_amount'] ?? null;
        $this->container['base_currency_total_amount'] = $data['base_currency_total_amount'] ?? null;
        $this->container['base_currency_goods_amount'] = $data['base_currency_goods_amount'] ?? null;
        $this->container['base_currency_services_amount'] = $data['base_currency_services_amount'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tax_rate
     *
     * @return \SageOne\Model\TaxRate|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param \SageOne\Model\TaxRate|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The tax rate name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets percentage
     *
     * @return double|null
     */
    public function getPercentage()
    {
        return $this->container['percentage'];
    }

    /**
     * Sets percentage
     *
     * @param double|null $percentage The tax rate percentage
     *
     * @return self
     */
    public function setPercentage($percentage)
    {
        $this->container['percentage'] = $percentage;

        return $this;
    }

    /**
     * Gets net_amount
     *
     * @return double|null
     */
    public function getNetAmount()
    {
        return $this->container['net_amount'];
    }

    /**
     * Sets net_amount
     *
     * @param double|null $net_amount The net amount for the tax rate
     *
     * @return self
     */
    public function setNetAmount($net_amount)
    {
        $this->container['net_amount'] = $net_amount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return double|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param double|null $tax_amount The tax amount for the tax rate
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets retail_tax_amount
     *
     * @return double|null
     */
    public function getRetailTaxAmount()
    {
        return $this->container['retail_tax_amount'];
    }

    /**
     * Sets retail_tax_amount
     *
     * @param double|null $retail_tax_amount The retailer tax amount for the tax rate
     *
     * @return self
     */
    public function setRetailTaxAmount($retail_tax_amount)
    {
        $this->container['retail_tax_amount'] = $retail_tax_amount;

        return $this;
    }

    /**
     * Gets total_amount
     *
     * @return double|null
     */
    public function getTotalAmount()
    {
        return $this->container['total_amount'];
    }

    /**
     * Sets total_amount
     *
     * @param double|null $total_amount The total amount for the tax rate
     *
     * @return self
     */
    public function setTotalAmount($total_amount)
    {
        $this->container['total_amount'] = $total_amount;

        return $this;
    }

    /**
     * Gets goods_amount
     *
     * @return double|null
     */
    public function getGoodsAmount()
    {
        return $this->container['goods_amount'];
    }

    /**
     * Sets goods_amount
     *
     * @param double|null $goods_amount The total amount for the tax rate relating to goods
     *
     * @return self
     */
    public function setGoodsAmount($goods_amount)
    {
        $this->container['goods_amount'] = $goods_amount;

        return $this;
    }

    /**
     * Gets services_amount
     *
     * @return double|null
     */
    public function getServicesAmount()
    {
        return $this->container['services_amount'];
    }

    /**
     * Sets services_amount
     *
     * @param double|null $services_amount The total amount for the tax rate relating to services
     *
     * @return self
     */
    public function setServicesAmount($services_amount)
    {
        $this->container['services_amount'] = $services_amount;

        return $this;
    }

    /**
     * Gets base_currency_net_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyNetAmount()
    {
        return $this->container['base_currency_net_amount'];
    }

    /**
     * Sets base_currency_net_amount
     *
     * @param double|null $base_currency_net_amount The base currency net amount for the tax rate
     *
     * @return self
     */
    public function setBaseCurrencyNetAmount($base_currency_net_amount)
    {
        $this->container['base_currency_net_amount'] = $base_currency_net_amount;

        return $this;
    }

    /**
     * Gets base_currency_tax_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTaxAmount()
    {
        return $this->container['base_currency_tax_amount'];
    }

    /**
     * Sets base_currency_tax_amount
     *
     * @param double|null $base_currency_tax_amount The base currency tax amount for the tax rate
     *
     * @return self
     */
    public function setBaseCurrencyTaxAmount($base_currency_tax_amount)
    {
        $this->container['base_currency_tax_amount'] = $base_currency_tax_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalAmount()
    {
        return $this->container['base_currency_total_amount'];
    }

    /**
     * Sets base_currency_total_amount
     *
     * @param double|null $base_currency_total_amount The base currency total amount for the tax rate
     *
     * @return self
     */
    public function setBaseCurrencyTotalAmount($base_currency_total_amount)
    {
        $this->container['base_currency_total_amount'] = $base_currency_total_amount;

        return $this;
    }

    /**
     * Gets base_currency_goods_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyGoodsAmount()
    {
        return $this->container['base_currency_goods_amount'];
    }

    /**
     * Sets base_currency_goods_amount
     *
     * @param double|null $base_currency_goods_amount The total base currency amount for the tax rate relating to goods
     *
     * @return self
     */
    public function setBaseCurrencyGoodsAmount($base_currency_goods_amount)
    {
        $this->container['base_currency_goods_amount'] = $base_currency_goods_amount;

        return $this;
    }

    /**
     * Gets base_currency_services_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyServicesAmount()
    {
        return $this->container['base_currency_services_amount'];
    }

    /**
     * Sets base_currency_services_amount
     *
     * @param double|null $base_currency_services_amount The total base currency amount for the tax rate relating to services
     *
     * @return self
     */
    public function setBaseCurrencyServicesAmount($base_currency_services_amount)
    {
        $this->container['base_currency_services_amount'] = $base_currency_services_amount;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


