<?php
/**
 * ArtefactDetailedTaxAnalysis
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Model;

use \ArrayAccess;
use \SageOne\ObjectSerializer;

/**
 * ArtefactDetailedTaxAnalysis Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ArtefactDetailedTaxAnalysis implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ArtefactDetailedTaxAnalysis';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tax_rates_breakdown' => '\SageOne\Model\ArtefactDetailedTaxAnalysisBreakdown',
        'total_net' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'total_goods_amount' => 'double',
        'total_services_amount' => 'double',
        'base_currency_total_net' => 'double',
        'base_currency_total_tax' => 'double',
        'base_currency_total' => 'double',
        'base_currency_total_goods_amount' => 'double',
        'base_currency_total_services_amount' => 'double',
        'total_retailer_tax' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tax_rates_breakdown' => null,
        'total_net' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'total_goods_amount' => 'double',
        'total_services_amount' => 'double',
        'base_currency_total_net' => 'double',
        'base_currency_total_tax' => 'double',
        'base_currency_total' => 'double',
        'base_currency_total_goods_amount' => 'double',
        'base_currency_total_services_amount' => 'double',
        'total_retailer_tax' => 'double'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tax_rates_breakdown' => 'tax_rates_breakdown',
        'total_net' => 'total_net',
        'total_tax' => 'total_tax',
        'total' => 'total',
        'total_goods_amount' => 'total_goods_amount',
        'total_services_amount' => 'total_services_amount',
        'base_currency_total_net' => 'base_currency_total_net',
        'base_currency_total_tax' => 'base_currency_total_tax',
        'base_currency_total' => 'base_currency_total',
        'base_currency_total_goods_amount' => 'base_currency_total_goods_amount',
        'base_currency_total_services_amount' => 'base_currency_total_services_amount',
        'total_retailer_tax' => 'total_retailer_tax'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tax_rates_breakdown' => 'setTaxRatesBreakdown',
        'total_net' => 'setTotalNet',
        'total_tax' => 'setTotalTax',
        'total' => 'setTotal',
        'total_goods_amount' => 'setTotalGoodsAmount',
        'total_services_amount' => 'setTotalServicesAmount',
        'base_currency_total_net' => 'setBaseCurrencyTotalNet',
        'base_currency_total_tax' => 'setBaseCurrencyTotalTax',
        'base_currency_total' => 'setBaseCurrencyTotal',
        'base_currency_total_goods_amount' => 'setBaseCurrencyTotalGoodsAmount',
        'base_currency_total_services_amount' => 'setBaseCurrencyTotalServicesAmount',
        'total_retailer_tax' => 'setTotalRetailerTax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tax_rates_breakdown' => 'getTaxRatesBreakdown',
        'total_net' => 'getTotalNet',
        'total_tax' => 'getTotalTax',
        'total' => 'getTotal',
        'total_goods_amount' => 'getTotalGoodsAmount',
        'total_services_amount' => 'getTotalServicesAmount',
        'base_currency_total_net' => 'getBaseCurrencyTotalNet',
        'base_currency_total_tax' => 'getBaseCurrencyTotalTax',
        'base_currency_total' => 'getBaseCurrencyTotal',
        'base_currency_total_goods_amount' => 'getBaseCurrencyTotalGoodsAmount',
        'base_currency_total_services_amount' => 'getBaseCurrencyTotalServicesAmount',
        'total_retailer_tax' => 'getTotalRetailerTax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tax_rates_breakdown'] = $data['tax_rates_breakdown'] ?? null;
        $this->container['total_net'] = $data['total_net'] ?? null;
        $this->container['total_tax'] = $data['total_tax'] ?? null;
        $this->container['total'] = $data['total'] ?? null;
        $this->container['total_goods_amount'] = $data['total_goods_amount'] ?? null;
        $this->container['total_services_amount'] = $data['total_services_amount'] ?? null;
        $this->container['base_currency_total_net'] = $data['base_currency_total_net'] ?? null;
        $this->container['base_currency_total_tax'] = $data['base_currency_total_tax'] ?? null;
        $this->container['base_currency_total'] = $data['base_currency_total'] ?? null;
        $this->container['base_currency_total_goods_amount'] = $data['base_currency_total_goods_amount'] ?? null;
        $this->container['base_currency_total_services_amount'] = $data['base_currency_total_services_amount'] ?? null;
        $this->container['total_retailer_tax'] = $data['total_retailer_tax'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tax_rates_breakdown
     *
     * @return \SageOne\Model\ArtefactDetailedTaxAnalysisBreakdown|null
     */
    public function getTaxRatesBreakdown()
    {
        return $this->container['tax_rates_breakdown'];
    }

    /**
     * Sets tax_rates_breakdown
     *
     * @param \SageOne\Model\ArtefactDetailedTaxAnalysisBreakdown|null $tax_rates_breakdown tax_rates_breakdown
     *
     * @return self
     */
    public function setTaxRatesBreakdown($tax_rates_breakdown)
    {
        $this->container['tax_rates_breakdown'] = $tax_rates_breakdown;

        return $this;
    }

    /**
     * Gets total_net
     *
     * @return double|null
     */
    public function getTotalNet()
    {
        return $this->container['total_net'];
    }

    /**
     * Sets total_net
     *
     * @param double|null $total_net The total net amount for all tax rates
     *
     * @return self
     */
    public function setTotalNet($total_net)
    {
        $this->container['total_net'] = $total_net;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return double|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param double|null $total_tax The total tax amount for all tax rates
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets total
     *
     * @return double|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param double|null $total The total amount for all tax rates
     *
     * @return self
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets total_goods_amount
     *
     * @return double|null
     */
    public function getTotalGoodsAmount()
    {
        return $this->container['total_goods_amount'];
    }

    /**
     * Sets total_goods_amount
     *
     * @param double|null $total_goods_amount The total amount relating to goods for all tax rates
     *
     * @return self
     */
    public function setTotalGoodsAmount($total_goods_amount)
    {
        $this->container['total_goods_amount'] = $total_goods_amount;

        return $this;
    }

    /**
     * Gets total_services_amount
     *
     * @return double|null
     */
    public function getTotalServicesAmount()
    {
        return $this->container['total_services_amount'];
    }

    /**
     * Sets total_services_amount
     *
     * @param double|null $total_services_amount The total amount relating to services for all tax rates
     *
     * @return self
     */
    public function setTotalServicesAmount($total_services_amount)
    {
        $this->container['total_services_amount'] = $total_services_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_net
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalNet()
    {
        return $this->container['base_currency_total_net'];
    }

    /**
     * Sets base_currency_total_net
     *
     * @param double|null $base_currency_total_net The base currency total net amount for all tax rates
     *
     * @return self
     */
    public function setBaseCurrencyTotalNet($base_currency_total_net)
    {
        $this->container['base_currency_total_net'] = $base_currency_total_net;

        return $this;
    }

    /**
     * Gets base_currency_total_tax
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalTax()
    {
        return $this->container['base_currency_total_tax'];
    }

    /**
     * Sets base_currency_total_tax
     *
     * @param double|null $base_currency_total_tax The base currency total tax amount for all tax rates
     *
     * @return self
     */
    public function setBaseCurrencyTotalTax($base_currency_total_tax)
    {
        $this->container['base_currency_total_tax'] = $base_currency_total_tax;

        return $this;
    }

    /**
     * Gets base_currency_total
     *
     * @return double|null
     */
    public function getBaseCurrencyTotal()
    {
        return $this->container['base_currency_total'];
    }

    /**
     * Sets base_currency_total
     *
     * @param double|null $base_currency_total The total base currency amount for all tax rates
     *
     * @return self
     */
    public function setBaseCurrencyTotal($base_currency_total)
    {
        $this->container['base_currency_total'] = $base_currency_total;

        return $this;
    }

    /**
     * Gets base_currency_total_goods_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalGoodsAmount()
    {
        return $this->container['base_currency_total_goods_amount'];
    }

    /**
     * Sets base_currency_total_goods_amount
     *
     * @param double|null $base_currency_total_goods_amount The total base currency amount relating to goods for all tax rates
     *
     * @return self
     */
    public function setBaseCurrencyTotalGoodsAmount($base_currency_total_goods_amount)
    {
        $this->container['base_currency_total_goods_amount'] = $base_currency_total_goods_amount;

        return $this;
    }

    /**
     * Gets base_currency_total_services_amount
     *
     * @return double|null
     */
    public function getBaseCurrencyTotalServicesAmount()
    {
        return $this->container['base_currency_total_services_amount'];
    }

    /**
     * Sets base_currency_total_services_amount
     *
     * @param double|null $base_currency_total_services_amount The total base currency amount relating to services for all tax rates
     *
     * @return self
     */
    public function setBaseCurrencyTotalServicesAmount($base_currency_total_services_amount)
    {
        $this->container['base_currency_total_services_amount'] = $base_currency_total_services_amount;

        return $this;
    }

    /**
     * Gets total_retailer_tax
     *
     * @return double|null
     */
    public function getTotalRetailerTax()
    {
        return $this->container['total_retailer_tax'];
    }

    /**
     * Sets total_retailer_tax
     *
     * @param double|null $total_retailer_tax The total retailer tax amount for all tax rates
     *
     * @return self
     */
    public function setTotalRetailerTax($total_retailer_tax)
    {
        $this->container['total_retailer_tax'] = $total_retailer_tax;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


