<?php
/**
 * ServiceRateTypesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SageOne\ApiException;
use SageOne\Configuration;
use SageOne\HeaderSelector;
use SageOne\ObjectSerializer;

/**
 * ServiceRateTypesApi Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ServiceRateTypesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteServiceRateTypesKey
     *
     * Deletes a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteServiceRateTypesKey($key)
    {
        $this->deleteServiceRateTypesKeyWithHttpInfo($key);
    }

    /**
     * Operation deleteServiceRateTypesKeyWithHttpInfo
     *
     * Deletes a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteServiceRateTypesKeyWithHttpInfo($key)
    {
        $request = $this->deleteServiceRateTypesKeyRequest($key);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteServiceRateTypesKeyAsync
     *
     * Deletes a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteServiceRateTypesKeyAsync($key)
    {
        return $this->deleteServiceRateTypesKeyAsyncWithHttpInfo($key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteServiceRateTypesKeyAsyncWithHttpInfo
     *
     * Deletes a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteServiceRateTypesKeyAsyncWithHttpInfo($key)
    {
        $returnType = '';
        $request = $this->deleteServiceRateTypesKeyRequest($key);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteServiceRateTypesKey'
     *
     * @param  string $key The Service Rate Type Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteServiceRateTypesKeyRequest($key)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling deleteServiceRateTypesKey'
            );
        }

        $resourcePath = '/service_rate_types/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getServiceRateTypes
     *
     * Returns all Service Rate Types
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Service Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $active Use this to only return active or inactive items (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rates. (optional)
     * @param  int $items_per_page Returns the given number of Service Rates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Service Rates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\ServiceRateType[]
     */
    public function getServiceRateTypes($updated_or_created_since = null, $active = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        list($response) = $this->getServiceRateTypesWithHttpInfo($updated_or_created_since, $active, $show_legacy_id, $items_per_page, $page, $attributes);
        return $response;
    }

    /**
     * Operation getServiceRateTypesWithHttpInfo
     *
     * Returns all Service Rate Types
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Service Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $active Use this to only return active or inactive items (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rates. (optional)
     * @param  int $items_per_page Returns the given number of Service Rates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Service Rates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\ServiceRateType[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getServiceRateTypesWithHttpInfo($updated_or_created_since = null, $active = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $request = $this->getServiceRateTypesRequest($updated_or_created_since, $active, $show_legacy_id, $items_per_page, $page, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\ServiceRateType[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\ServiceRateType[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\ServiceRateType[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\ServiceRateType[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\ServiceRateType[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getServiceRateTypesAsync
     *
     * Returns all Service Rate Types
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Service Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $active Use this to only return active or inactive items (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rates. (optional)
     * @param  int $items_per_page Returns the given number of Service Rates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Service Rates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceRateTypesAsync($updated_or_created_since = null, $active = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        return $this->getServiceRateTypesAsyncWithHttpInfo($updated_or_created_since, $active, $show_legacy_id, $items_per_page, $page, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getServiceRateTypesAsyncWithHttpInfo
     *
     * Returns all Service Rate Types
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Service Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $active Use this to only return active or inactive items (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rates. (optional)
     * @param  int $items_per_page Returns the given number of Service Rates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Service Rates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceRateTypesAsyncWithHttpInfo($updated_or_created_since = null, $active = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $returnType = '\SageOne\Model\ServiceRateType[]';
        $request = $this->getServiceRateTypesRequest($updated_or_created_since, $active, $show_legacy_id, $items_per_page, $page, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getServiceRateTypes'
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Service Rates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $active Use this to only return active or inactive items (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rates. (optional)
     * @param  int $items_per_page Returns the given number of Service Rates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Service Rates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getServiceRateTypesRequest($updated_or_created_since = null, $active = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        if ($items_per_page !== null && $items_per_page > 200) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling ServiceRateTypesApi.getServiceRateTypes, must be smaller than or equal to 200.');
        }
        if ($items_per_page !== null && $items_per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling ServiceRateTypesApi.getServiceRateTypes, must be bigger than or equal to 1.');
        }


        $resourcePath = '/service_rate_types';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_or_created_since,
            'updated_or_created_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $active,
            'active', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $items_per_page,
            'items_per_page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getServiceRateTypesKey
     *
     * Returns a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\ServiceRateType
     */
    public function getServiceRateTypesKey($key, $show_legacy_id = null, $attributes = null)
    {
        list($response) = $this->getServiceRateTypesKeyWithHttpInfo($key, $show_legacy_id, $attributes);
        return $response;
    }

    /**
     * Operation getServiceRateTypesKeyWithHttpInfo
     *
     * Returns a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\ServiceRateType, HTTP status code, HTTP response headers (array of strings)
     */
    public function getServiceRateTypesKeyWithHttpInfo($key, $show_legacy_id = null, $attributes = null)
    {
        $request = $this->getServiceRateTypesKeyRequest($key, $show_legacy_id, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\ServiceRateType' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\ServiceRateType' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\ServiceRateType', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\ServiceRateType';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\ServiceRateType',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getServiceRateTypesKeyAsync
     *
     * Returns a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceRateTypesKeyAsync($key, $show_legacy_id = null, $attributes = null)
    {
        return $this->getServiceRateTypesKeyAsyncWithHttpInfo($key, $show_legacy_id, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getServiceRateTypesKeyAsyncWithHttpInfo
     *
     * Returns a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getServiceRateTypesKeyAsyncWithHttpInfo($key, $show_legacy_id = null, $attributes = null)
    {
        $returnType = '\SageOne\Model\ServiceRateType';
        $request = $this->getServiceRateTypesKeyRequest($key, $show_legacy_id, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getServiceRateTypesKey'
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  bool $show_legacy_id Display the legacy_id for the Service Rate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Service Rate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getServiceRateTypesKeyRequest($key, $show_legacy_id = null, $attributes = null)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling getServiceRateTypesKey'
            );
        }

        $resourcePath = '/service_rate_types/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postServiceRateTypes
     *
     * Creates a Service Rate Type
     *
     * @param  \SageOne\Model\PostServiceRateTypes $service_rate_types service_rate_types (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\ServiceRateType
     */
    public function postServiceRateTypes($service_rate_types)
    {
        list($response) = $this->postServiceRateTypesWithHttpInfo($service_rate_types);
        return $response;
    }

    /**
     * Operation postServiceRateTypesWithHttpInfo
     *
     * Creates a Service Rate Type
     *
     * @param  \SageOne\Model\PostServiceRateTypes $service_rate_types (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\ServiceRateType, HTTP status code, HTTP response headers (array of strings)
     */
    public function postServiceRateTypesWithHttpInfo($service_rate_types)
    {
        $request = $this->postServiceRateTypesRequest($service_rate_types);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\SageOne\Model\ServiceRateType' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\ServiceRateType' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\ServiceRateType', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\ServiceRateType';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\ServiceRateType',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postServiceRateTypesAsync
     *
     * Creates a Service Rate Type
     *
     * @param  \SageOne\Model\PostServiceRateTypes $service_rate_types (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postServiceRateTypesAsync($service_rate_types)
    {
        return $this->postServiceRateTypesAsyncWithHttpInfo($service_rate_types)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postServiceRateTypesAsyncWithHttpInfo
     *
     * Creates a Service Rate Type
     *
     * @param  \SageOne\Model\PostServiceRateTypes $service_rate_types (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postServiceRateTypesAsyncWithHttpInfo($service_rate_types)
    {
        $returnType = '\SageOne\Model\ServiceRateType';
        $request = $this->postServiceRateTypesRequest($service_rate_types);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postServiceRateTypes'
     *
     * @param  \SageOne\Model\PostServiceRateTypes $service_rate_types (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postServiceRateTypesRequest($service_rate_types)
    {
        // verify the required parameter 'service_rate_types' is set
        if ($service_rate_types === null || (is_array($service_rate_types) && count($service_rate_types) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_rate_types when calling postServiceRateTypes'
            );
        }

        $resourcePath = '/service_rate_types';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($service_rate_types)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($service_rate_types));
            } else {
                $httpBody = $service_rate_types;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putServiceRateTypesKey
     *
     * Updates a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  \SageOne\Model\PutServiceRateTypes $service_rate_types service_rate_types (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\ServiceRateType
     */
    public function putServiceRateTypesKey($key, $service_rate_types)
    {
        list($response) = $this->putServiceRateTypesKeyWithHttpInfo($key, $service_rate_types);
        return $response;
    }

    /**
     * Operation putServiceRateTypesKeyWithHttpInfo
     *
     * Updates a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  \SageOne\Model\PutServiceRateTypes $service_rate_types (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\ServiceRateType, HTTP status code, HTTP response headers (array of strings)
     */
    public function putServiceRateTypesKeyWithHttpInfo($key, $service_rate_types)
    {
        $request = $this->putServiceRateTypesKeyRequest($key, $service_rate_types);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\ServiceRateType' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\ServiceRateType' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\ServiceRateType', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\ServiceRateType';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\ServiceRateType',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putServiceRateTypesKeyAsync
     *
     * Updates a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  \SageOne\Model\PutServiceRateTypes $service_rate_types (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putServiceRateTypesKeyAsync($key, $service_rate_types)
    {
        return $this->putServiceRateTypesKeyAsyncWithHttpInfo($key, $service_rate_types)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putServiceRateTypesKeyAsyncWithHttpInfo
     *
     * Updates a Service Rate Type
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  \SageOne\Model\PutServiceRateTypes $service_rate_types (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putServiceRateTypesKeyAsyncWithHttpInfo($key, $service_rate_types)
    {
        $returnType = '\SageOne\Model\ServiceRateType';
        $request = $this->putServiceRateTypesKeyRequest($key, $service_rate_types);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putServiceRateTypesKey'
     *
     * @param  string $key The Service Rate Type Key. (required)
     * @param  \SageOne\Model\PutServiceRateTypes $service_rate_types (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putServiceRateTypesKeyRequest($key, $service_rate_types)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling putServiceRateTypesKey'
            );
        }
        // verify the required parameter 'service_rate_types' is set
        if ($service_rate_types === null || (is_array($service_rate_types) && count($service_rate_types) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $service_rate_types when calling putServiceRateTypesKey'
            );
        }

        $resourcePath = '/service_rate_types/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($service_rate_types)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($service_rate_types));
            } else {
                $httpBody = $service_rate_types;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
