<?php
/**
 * SalesQuickEntriesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SageOne\ApiException;
use SageOne\Configuration;
use SageOne\HeaderSelector;
use SageOne\ObjectSerializer;

/**
 * SalesQuickEntriesApi Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SalesQuickEntriesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteSalesQuickEntriesKey
     *
     * Deletes a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSalesQuickEntriesKey($key)
    {
        $this->deleteSalesQuickEntriesKeyWithHttpInfo($key);
    }

    /**
     * Operation deleteSalesQuickEntriesKeyWithHttpInfo
     *
     * Deletes a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSalesQuickEntriesKeyWithHttpInfo($key)
    {
        $request = $this->deleteSalesQuickEntriesKeyRequest($key);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSalesQuickEntriesKeyAsync
     *
     * Deletes a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesQuickEntriesKeyAsync($key)
    {
        return $this->deleteSalesQuickEntriesKeyAsyncWithHttpInfo($key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSalesQuickEntriesKeyAsyncWithHttpInfo
     *
     * Deletes a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesQuickEntriesKeyAsyncWithHttpInfo($key)
    {
        $returnType = '';
        $request = $this->deleteSalesQuickEntriesKeyRequest($key);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSalesQuickEntriesKey'
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSalesQuickEntriesKeyRequest($key)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling deleteSalesQuickEntriesKey'
            );
        }

        $resourcePath = '/sales_quick_entries/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesQuickEntries
     *
     * Returns all Sales Quick Entries
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the quick entry reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entries. (optional)
     * @param  int $items_per_page Returns the given number of Sales Batch Entries per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Batch Entries (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\QuickEntry[]
     */
    public function getSalesQuickEntries($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_payments_allocations = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        list($response) = $this->getSalesQuickEntriesWithHttpInfo($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes);
        return $response;
    }

    /**
     * Operation getSalesQuickEntriesWithHttpInfo
     *
     * Returns all Sales Quick Entries
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the quick entry reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entries. (optional)
     * @param  int $items_per_page Returns the given number of Sales Batch Entries per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Batch Entries (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\QuickEntry[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesQuickEntriesWithHttpInfo($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_payments_allocations = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $request = $this->getSalesQuickEntriesRequest($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\QuickEntry[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\QuickEntry[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\QuickEntry[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\QuickEntry[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\QuickEntry[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSalesQuickEntriesAsync
     *
     * Returns all Sales Quick Entries
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the quick entry reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entries. (optional)
     * @param  int $items_per_page Returns the given number of Sales Batch Entries per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Batch Entries (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesQuickEntriesAsync($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_payments_allocations = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        return $this->getSalesQuickEntriesAsyncWithHttpInfo($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesQuickEntriesAsyncWithHttpInfo
     *
     * Returns all Sales Quick Entries
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the quick entry reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entries. (optional)
     * @param  int $items_per_page Returns the given number of Sales Batch Entries per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Batch Entries (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesQuickEntriesAsyncWithHttpInfo($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_payments_allocations = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $returnType = '\SageOne\Model\QuickEntry[]';
        $request = $this->getSalesQuickEntriesRequest($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_payments_allocations, $show_legacy_id, $items_per_page, $page, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesQuickEntries'
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the quick entry reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Batch Entries dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Batch Entries changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Batch Entries deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entries. (optional)
     * @param  int $items_per_page Returns the given number of Sales Batch Entries per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Batch Entries (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entries (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesQuickEntriesRequest($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_payments_allocations = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        if ($items_per_page !== null && $items_per_page > 200) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling SalesQuickEntriesApi.getSalesQuickEntries, must be smaller than or equal to 200.');
        }
        if ($items_per_page !== null && $items_per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling SalesQuickEntriesApi.getSalesQuickEntries, must be bigger than or equal to 1.');
        }


        $resourcePath = '/sales_quick_entries';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $contact_id,
            'contact_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status_id,
            'status_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'from_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'to_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_or_created_since,
            'updated_or_created_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $deleted_since,
            'deleted_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_payments_allocations,
            'show_payments_allocations', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $items_per_page,
            'items_per_page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesQuickEntriesKey
     *
     * Returns a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Batch Entry (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entry. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\QuickEntry
     */
    public function getSalesQuickEntriesKey($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        list($response) = $this->getSalesQuickEntriesKeyWithHttpInfo($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);
        return $response;
    }

    /**
     * Operation getSalesQuickEntriesKeyWithHttpInfo
     *
     * Returns a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Batch Entry (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entry. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\QuickEntry, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesQuickEntriesKeyWithHttpInfo($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        $request = $this->getSalesQuickEntriesKeyRequest($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\QuickEntry' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\QuickEntry' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\QuickEntry', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\QuickEntry';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\QuickEntry',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSalesQuickEntriesKeyAsync
     *
     * Returns a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Batch Entry (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entry. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesQuickEntriesKeyAsync($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        return $this->getSalesQuickEntriesKeyAsyncWithHttpInfo($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesQuickEntriesKeyAsyncWithHttpInfo
     *
     * Returns a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Batch Entry (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entry. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesQuickEntriesKeyAsyncWithHttpInfo($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        $returnType = '\SageOne\Model\QuickEntry';
        $request = $this->getSalesQuickEntriesKeyRequest($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesQuickEntriesKey'
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Batch Entry (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Batch Entry. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Batch Entry (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesQuickEntriesKeyRequest($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling getSalesQuickEntriesKey'
            );
        }

        $resourcePath = '/sales_quick_entries/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_payments_allocations,
            'show_payments_allocations', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $nested_attributes,
            'nested_attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSalesQuickEntries
     *
     * Creates a Sales Quick Entry
     *
     * @param  \SageOne\Model\PostSalesQuickEntries $sales_quick_entries sales_quick_entries (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\QuickEntry
     */
    public function postSalesQuickEntries($sales_quick_entries)
    {
        list($response) = $this->postSalesQuickEntriesWithHttpInfo($sales_quick_entries);
        return $response;
    }

    /**
     * Operation postSalesQuickEntriesWithHttpInfo
     *
     * Creates a Sales Quick Entry
     *
     * @param  \SageOne\Model\PostSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\QuickEntry, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSalesQuickEntriesWithHttpInfo($sales_quick_entries)
    {
        $request = $this->postSalesQuickEntriesRequest($sales_quick_entries);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\SageOne\Model\QuickEntry' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\QuickEntry' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\QuickEntry', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\QuickEntry';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\QuickEntry',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postSalesQuickEntriesAsync
     *
     * Creates a Sales Quick Entry
     *
     * @param  \SageOne\Model\PostSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalesQuickEntriesAsync($sales_quick_entries)
    {
        return $this->postSalesQuickEntriesAsyncWithHttpInfo($sales_quick_entries)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSalesQuickEntriesAsyncWithHttpInfo
     *
     * Creates a Sales Quick Entry
     *
     * @param  \SageOne\Model\PostSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalesQuickEntriesAsyncWithHttpInfo($sales_quick_entries)
    {
        $returnType = '\SageOne\Model\QuickEntry';
        $request = $this->postSalesQuickEntriesRequest($sales_quick_entries);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSalesQuickEntries'
     *
     * @param  \SageOne\Model\PostSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSalesQuickEntriesRequest($sales_quick_entries)
    {
        // verify the required parameter 'sales_quick_entries' is set
        if ($sales_quick_entries === null || (is_array($sales_quick_entries) && count($sales_quick_entries) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_quick_entries when calling postSalesQuickEntries'
            );
        }

        $resourcePath = '/sales_quick_entries';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($sales_quick_entries)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($sales_quick_entries));
            } else {
                $httpBody = $sales_quick_entries;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSalesQuickEntriesKey
     *
     * Updates a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  \SageOne\Model\PutSalesQuickEntries $sales_quick_entries sales_quick_entries (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\QuickEntry
     */
    public function putSalesQuickEntriesKey($key, $sales_quick_entries)
    {
        list($response) = $this->putSalesQuickEntriesKeyWithHttpInfo($key, $sales_quick_entries);
        return $response;
    }

    /**
     * Operation putSalesQuickEntriesKeyWithHttpInfo
     *
     * Updates a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  \SageOne\Model\PutSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\QuickEntry, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSalesQuickEntriesKeyWithHttpInfo($key, $sales_quick_entries)
    {
        $request = $this->putSalesQuickEntriesKeyRequest($key, $sales_quick_entries);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\QuickEntry' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\QuickEntry' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\QuickEntry', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\QuickEntry';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\QuickEntry',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSalesQuickEntriesKeyAsync
     *
     * Updates a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  \SageOne\Model\PutSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalesQuickEntriesKeyAsync($key, $sales_quick_entries)
    {
        return $this->putSalesQuickEntriesKeyAsyncWithHttpInfo($key, $sales_quick_entries)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSalesQuickEntriesKeyAsyncWithHttpInfo
     *
     * Updates a Sales Quick Entry
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  \SageOne\Model\PutSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalesQuickEntriesKeyAsyncWithHttpInfo($key, $sales_quick_entries)
    {
        $returnType = '\SageOne\Model\QuickEntry';
        $request = $this->putSalesQuickEntriesKeyRequest($key, $sales_quick_entries);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSalesQuickEntriesKey'
     *
     * @param  string $key The Sales Quick Entry Key. (required)
     * @param  \SageOne\Model\PutSalesQuickEntries $sales_quick_entries (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSalesQuickEntriesKeyRequest($key, $sales_quick_entries)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling putSalesQuickEntriesKey'
            );
        }
        // verify the required parameter 'sales_quick_entries' is set
        if ($sales_quick_entries === null || (is_array($sales_quick_entries) && count($sales_quick_entries) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_quick_entries when calling putSalesQuickEntriesKey'
            );
        }

        $resourcePath = '/sales_quick_entries/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($sales_quick_entries)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($sales_quick_entries));
            } else {
                $httpBody = $sales_quick_entries;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
