<?php
/**
 * SalesEstimatesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SageOne\ApiException;
use SageOne\Configuration;
use SageOne\HeaderSelector;
use SageOne\ObjectSerializer;

/**
 * SalesEstimatesApi Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SalesEstimatesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteSalesEstimatesKey
     *
     * Deletes a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSalesEstimatesKey($key)
    {
        $this->deleteSalesEstimatesKeyWithHttpInfo($key);
    }

    /**
     * Operation deleteSalesEstimatesKeyWithHttpInfo
     *
     * Deletes a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSalesEstimatesKeyWithHttpInfo($key)
    {
        $request = $this->deleteSalesEstimatesKeyRequest($key);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSalesEstimatesKeyAsync
     *
     * Deletes a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesEstimatesKeyAsync($key)
    {
        return $this->deleteSalesEstimatesKeyAsyncWithHttpInfo($key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSalesEstimatesKeyAsyncWithHttpInfo
     *
     * Deletes a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesEstimatesKeyAsyncWithHttpInfo($key)
    {
        $returnType = '';
        $request = $this->deleteSalesEstimatesKeyRequest($key);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSalesEstimatesKey'
     *
     * @param  string $key The Sales Estimate Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSalesEstimatesKeyRequest($key)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling deleteSalesEstimatesKey'
            );
        }

        $resourcePath = '/sales_estimates/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesEstimates
     *
     * Returns all Sales Estimates
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the estimate reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Estimates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimates. (optional)
     * @param  int $items_per_page Returns the given number of Sales Estimates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Estimates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesEstimate[]
     */
    public function getSalesEstimates($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        list($response) = $this->getSalesEstimatesWithHttpInfo($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);
        return $response;
    }

    /**
     * Operation getSalesEstimatesWithHttpInfo
     *
     * Returns all Sales Estimates
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the estimate reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Estimates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimates. (optional)
     * @param  int $items_per_page Returns the given number of Sales Estimates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Estimates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesEstimate[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesEstimatesWithHttpInfo($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $request = $this->getSalesEstimatesRequest($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\SalesEstimate[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesEstimate[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesEstimate[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesEstimate[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesEstimate[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSalesEstimatesAsync
     *
     * Returns all Sales Estimates
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the estimate reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Estimates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimates. (optional)
     * @param  int $items_per_page Returns the given number of Sales Estimates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Estimates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesEstimatesAsync($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        return $this->getSalesEstimatesAsyncWithHttpInfo($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesEstimatesAsyncWithHttpInfo
     *
     * Returns all Sales Estimates
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the estimate reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Estimates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimates. (optional)
     * @param  int $items_per_page Returns the given number of Sales Estimates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Estimates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesEstimatesAsyncWithHttpInfo($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $returnType = '\SageOne\Model\SalesEstimate[]';
        $request = $this->getSalesEstimatesRequest($contact_id, $search, $status_id, $from_date, $to_date, $updated_or_created_since, $show_legacy_id, $items_per_page, $page, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesEstimates'
     *
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $search Use this to filter by the estimate reference or contact name. (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Estimates dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Estimates changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimates. (optional)
     * @param  int $items_per_page Returns the given number of Sales Estimates per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Estimates (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimates (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesEstimatesRequest($contact_id = null, $search = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        if ($items_per_page !== null && $items_per_page > 200) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling SalesEstimatesApi.getSalesEstimates, must be smaller than or equal to 200.');
        }
        if ($items_per_page !== null && $items_per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling SalesEstimatesApi.getSalesEstimates, must be bigger than or equal to 1.');
        }


        $resourcePath = '/sales_estimates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $contact_id,
            'contact_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status_id,
            'status_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'from_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'to_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_or_created_since,
            'updated_or_created_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $items_per_page,
            'items_per_page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesEstimatesKey
     *
     * Returns a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Estimate (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesEstimate
     */
    public function getSalesEstimatesKey($key, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        list($response) = $this->getSalesEstimatesKeyWithHttpInfo($key, $nested_attributes, $show_legacy_id, $attributes);
        return $response;
    }

    /**
     * Operation getSalesEstimatesKeyWithHttpInfo
     *
     * Returns a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Estimate (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesEstimate, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesEstimatesKeyWithHttpInfo($key, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        $request = $this->getSalesEstimatesKeyRequest($key, $nested_attributes, $show_legacy_id, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\SalesEstimate' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesEstimate' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesEstimate', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesEstimate';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesEstimate',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSalesEstimatesKeyAsync
     *
     * Returns a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Estimate (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesEstimatesKeyAsync($key, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        return $this->getSalesEstimatesKeyAsyncWithHttpInfo($key, $nested_attributes, $show_legacy_id, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesEstimatesKeyAsyncWithHttpInfo
     *
     * Returns a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Estimate (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesEstimatesKeyAsyncWithHttpInfo($key, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        $returnType = '\SageOne\Model\SalesEstimate';
        $request = $this->getSalesEstimatesKeyRequest($key, $nested_attributes, $show_legacy_id, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesEstimatesKey'
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Estimate (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Estimate. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Estimate (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesEstimatesKeyRequest($key, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling getSalesEstimatesKey'
            );
        }

        $resourcePath = '/sales_estimates/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $nested_attributes,
            'nested_attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSalesEstimates
     *
     * Creates a Sales Estimate
     *
     * @param  \SageOne\Model\PostSalesEstimates $sales_estimates sales_estimates (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesEstimate
     */
    public function postSalesEstimates($sales_estimates)
    {
        list($response) = $this->postSalesEstimatesWithHttpInfo($sales_estimates);
        return $response;
    }

    /**
     * Operation postSalesEstimatesWithHttpInfo
     *
     * Creates a Sales Estimate
     *
     * @param  \SageOne\Model\PostSalesEstimates $sales_estimates (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesEstimate, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSalesEstimatesWithHttpInfo($sales_estimates)
    {
        $request = $this->postSalesEstimatesRequest($sales_estimates);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\SageOne\Model\SalesEstimate' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesEstimate' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesEstimate', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesEstimate';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesEstimate',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postSalesEstimatesAsync
     *
     * Creates a Sales Estimate
     *
     * @param  \SageOne\Model\PostSalesEstimates $sales_estimates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalesEstimatesAsync($sales_estimates)
    {
        return $this->postSalesEstimatesAsyncWithHttpInfo($sales_estimates)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSalesEstimatesAsyncWithHttpInfo
     *
     * Creates a Sales Estimate
     *
     * @param  \SageOne\Model\PostSalesEstimates $sales_estimates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalesEstimatesAsyncWithHttpInfo($sales_estimates)
    {
        $returnType = '\SageOne\Model\SalesEstimate';
        $request = $this->postSalesEstimatesRequest($sales_estimates);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSalesEstimates'
     *
     * @param  \SageOne\Model\PostSalesEstimates $sales_estimates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSalesEstimatesRequest($sales_estimates)
    {
        // verify the required parameter 'sales_estimates' is set
        if ($sales_estimates === null || (is_array($sales_estimates) && count($sales_estimates) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_estimates when calling postSalesEstimates'
            );
        }

        $resourcePath = '/sales_estimates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($sales_estimates)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($sales_estimates));
            } else {
                $httpBody = $sales_estimates;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSalesEstimatesKey
     *
     * Updates a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  \SageOne\Model\PutSalesEstimates $sales_estimates sales_estimates (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesEstimate
     */
    public function putSalesEstimatesKey($key, $sales_estimates)
    {
        list($response) = $this->putSalesEstimatesKeyWithHttpInfo($key, $sales_estimates);
        return $response;
    }

    /**
     * Operation putSalesEstimatesKeyWithHttpInfo
     *
     * Updates a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  \SageOne\Model\PutSalesEstimates $sales_estimates (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesEstimate, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSalesEstimatesKeyWithHttpInfo($key, $sales_estimates)
    {
        $request = $this->putSalesEstimatesKeyRequest($key, $sales_estimates);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\SalesEstimate' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesEstimate' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesEstimate', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesEstimate';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesEstimate',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSalesEstimatesKeyAsync
     *
     * Updates a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  \SageOne\Model\PutSalesEstimates $sales_estimates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalesEstimatesKeyAsync($key, $sales_estimates)
    {
        return $this->putSalesEstimatesKeyAsyncWithHttpInfo($key, $sales_estimates)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSalesEstimatesKeyAsyncWithHttpInfo
     *
     * Updates a Sales Estimate
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  \SageOne\Model\PutSalesEstimates $sales_estimates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalesEstimatesKeyAsyncWithHttpInfo($key, $sales_estimates)
    {
        $returnType = '\SageOne\Model\SalesEstimate';
        $request = $this->putSalesEstimatesKeyRequest($key, $sales_estimates);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSalesEstimatesKey'
     *
     * @param  string $key The Sales Estimate Key. (required)
     * @param  \SageOne\Model\PutSalesEstimates $sales_estimates (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSalesEstimatesKeyRequest($key, $sales_estimates)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling putSalesEstimatesKey'
            );
        }
        // verify the required parameter 'sales_estimates' is set
        if ($sales_estimates === null || (is_array($sales_estimates) && count($sales_estimates) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_estimates when calling putSalesEstimatesKey'
            );
        }

        $resourcePath = '/sales_estimates/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($sales_estimates)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($sales_estimates));
            } else {
                $httpBody = $sales_estimates;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
