<?php
/**
 * SalesCorrectiveInvoicesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SageOne\ApiException;
use SageOne\Configuration;
use SageOne\HeaderSelector;
use SageOne\ObjectSerializer;

/**
 * SalesCorrectiveInvoicesApi Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SalesCorrectiveInvoicesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteSalesCorrectiveInvoicesKey
     *
     * Voids a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  string $void_reason The reason the Sales Corrective Invoice is being voided (required unless status is DRAFT). (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesCorrectiveInvoice
     */
    public function deleteSalesCorrectiveInvoicesKey($key, $void_reason = null)
    {
        list($response) = $this->deleteSalesCorrectiveInvoicesKeyWithHttpInfo($key, $void_reason);
        return $response;
    }

    /**
     * Operation deleteSalesCorrectiveInvoicesKeyWithHttpInfo
     *
     * Voids a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  string $void_reason The reason the Sales Corrective Invoice is being voided (required unless status is DRAFT). (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesCorrectiveInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSalesCorrectiveInvoicesKeyWithHttpInfo($key, $void_reason = null)
    {
        $request = $this->deleteSalesCorrectiveInvoicesKeyRequest($key, $void_reason);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\SalesCorrectiveInvoice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesCorrectiveInvoice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesCorrectiveInvoice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesCorrectiveInvoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSalesCorrectiveInvoicesKeyAsync
     *
     * Voids a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  string $void_reason The reason the Sales Corrective Invoice is being voided (required unless status is DRAFT). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesCorrectiveInvoicesKeyAsync($key, $void_reason = null)
    {
        return $this->deleteSalesCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $void_reason)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSalesCorrectiveInvoicesKeyAsyncWithHttpInfo
     *
     * Voids a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  string $void_reason The reason the Sales Corrective Invoice is being voided (required unless status is DRAFT). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $void_reason = null)
    {
        $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
        $request = $this->deleteSalesCorrectiveInvoicesKeyRequest($key, $void_reason);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSalesCorrectiveInvoicesKey'
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  string $void_reason The reason the Sales Corrective Invoice is being voided (required unless status is DRAFT). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSalesCorrectiveInvoicesKeyRequest($key, $void_reason = null)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling deleteSalesCorrectiveInvoicesKey'
            );
        }

        $resourcePath = '/sales_corrective_invoices/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $void_reason,
            'void_reason', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesCorrectiveInvoices
     *
     * Returns all Sales Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Sales Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesCorrectiveInvoice[]
     */
    public function getSalesCorrectiveInvoices($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        list($response) = $this->getSalesCorrectiveInvoicesWithHttpInfo($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
        return $response;
    }

    /**
     * Operation getSalesCorrectiveInvoicesWithHttpInfo
     *
     * Returns all Sales Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Sales Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesCorrectiveInvoice[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesCorrectiveInvoicesWithHttpInfo($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $request = $this->getSalesCorrectiveInvoicesRequest($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\SalesCorrectiveInvoice[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesCorrectiveInvoice[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesCorrectiveInvoice[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesCorrectiveInvoice[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesCorrectiveInvoice[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSalesCorrectiveInvoicesAsync
     *
     * Returns all Sales Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Sales Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesCorrectiveInvoicesAsync($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        return $this->getSalesCorrectiveInvoicesAsyncWithHttpInfo($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesCorrectiveInvoicesAsyncWithHttpInfo
     *
     * Returns all Sales Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Sales Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesCorrectiveInvoicesAsyncWithHttpInfo($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $returnType = '\SageOne\Model\SalesCorrectiveInvoice[]';
        $request = $this->getSalesCorrectiveInvoicesRequest($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesCorrectiveInvoices'
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Sales Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Sales Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Sales Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Sales Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Sales Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesCorrectiveInvoicesRequest($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        if ($items_per_page !== null && $items_per_page > 200) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling SalesCorrectiveInvoicesApi.getSalesCorrectiveInvoices, must be smaller than or equal to 200.');
        }
        if ($items_per_page !== null && $items_per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling SalesCorrectiveInvoicesApi.getSalesCorrectiveInvoices, must be bigger than or equal to 1.');
        }


        $resourcePath = '/sales_corrective_invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_payments_allocations,
            'show_payments_allocations', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $contact_id,
            'contact_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status_id,
            'status_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'from_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'to_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_or_created_since,
            'updated_or_created_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $deleted_since,
            'deleted_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $items_per_page,
            'items_per_page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesCorrectiveInvoicesKey
     *
     * Returns a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $mark_as_sent Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesCorrectiveInvoice
     */
    public function getSalesCorrectiveInvoicesKey($key, $show_payments_allocations = null, $nested_attributes = null, $mark_as_sent = null, $show_legacy_id = null, $attributes = null)
    {
        list($response) = $this->getSalesCorrectiveInvoicesKeyWithHttpInfo($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes);
        return $response;
    }

    /**
     * Operation getSalesCorrectiveInvoicesKeyWithHttpInfo
     *
     * Returns a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $mark_as_sent Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesCorrectiveInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesCorrectiveInvoicesKeyWithHttpInfo($key, $show_payments_allocations = null, $nested_attributes = null, $mark_as_sent = null, $show_legacy_id = null, $attributes = null)
    {
        $request = $this->getSalesCorrectiveInvoicesKeyRequest($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\SalesCorrectiveInvoice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesCorrectiveInvoice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesCorrectiveInvoice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesCorrectiveInvoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSalesCorrectiveInvoicesKeyAsync
     *
     * Returns a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $mark_as_sent Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesCorrectiveInvoicesKeyAsync($key, $show_payments_allocations = null, $nested_attributes = null, $mark_as_sent = null, $show_legacy_id = null, $attributes = null)
    {
        return $this->getSalesCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesCorrectiveInvoicesKeyAsyncWithHttpInfo
     *
     * Returns a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $mark_as_sent Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $show_payments_allocations = null, $nested_attributes = null, $mark_as_sent = null, $show_legacy_id = null, $attributes = null)
    {
        $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
        $request = $this->getSalesCorrectiveInvoicesKeyRequest($key, $show_payments_allocations, $nested_attributes, $mark_as_sent, $show_legacy_id, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesCorrectiveInvoicesKey'
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Sales Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $mark_as_sent Use this to mark/not mark the artefact as sent. Defaulted to &#39;true&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Sales Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Sales Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesCorrectiveInvoicesKeyRequest($key, $show_payments_allocations = null, $nested_attributes = null, $mark_as_sent = null, $show_legacy_id = null, $attributes = null)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling getSalesCorrectiveInvoicesKey'
            );
        }

        $resourcePath = '/sales_corrective_invoices/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_payments_allocations,
            'show_payments_allocations', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $nested_attributes,
            'nested_attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $mark_as_sent,
            'mark_as_sent', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postSalesCorrectiveInvoices
     *
     * Creates a Sales Corrective Invoice
     *
     * @param  \SageOne\Model\PostSalesCorrectiveInvoices $sales_corrective_invoices sales_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesCorrectiveInvoice
     */
    public function postSalesCorrectiveInvoices($sales_corrective_invoices)
    {
        list($response) = $this->postSalesCorrectiveInvoicesWithHttpInfo($sales_corrective_invoices);
        return $response;
    }

    /**
     * Operation postSalesCorrectiveInvoicesWithHttpInfo
     *
     * Creates a Sales Corrective Invoice
     *
     * @param  \SageOne\Model\PostSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesCorrectiveInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function postSalesCorrectiveInvoicesWithHttpInfo($sales_corrective_invoices)
    {
        $request = $this->postSalesCorrectiveInvoicesRequest($sales_corrective_invoices);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\SageOne\Model\SalesCorrectiveInvoice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesCorrectiveInvoice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesCorrectiveInvoice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesCorrectiveInvoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postSalesCorrectiveInvoicesAsync
     *
     * Creates a Sales Corrective Invoice
     *
     * @param  \SageOne\Model\PostSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalesCorrectiveInvoicesAsync($sales_corrective_invoices)
    {
        return $this->postSalesCorrectiveInvoicesAsyncWithHttpInfo($sales_corrective_invoices)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postSalesCorrectiveInvoicesAsyncWithHttpInfo
     *
     * Creates a Sales Corrective Invoice
     *
     * @param  \SageOne\Model\PostSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postSalesCorrectiveInvoicesAsyncWithHttpInfo($sales_corrective_invoices)
    {
        $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
        $request = $this->postSalesCorrectiveInvoicesRequest($sales_corrective_invoices);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postSalesCorrectiveInvoices'
     *
     * @param  \SageOne\Model\PostSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postSalesCorrectiveInvoicesRequest($sales_corrective_invoices)
    {
        // verify the required parameter 'sales_corrective_invoices' is set
        if ($sales_corrective_invoices === null || (is_array($sales_corrective_invoices) && count($sales_corrective_invoices) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_corrective_invoices when calling postSalesCorrectiveInvoices'
            );
        }

        $resourcePath = '/sales_corrective_invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($sales_corrective_invoices)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($sales_corrective_invoices));
            } else {
                $httpBody = $sales_corrective_invoices;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSalesCorrectiveInvoicesKey
     *
     * Updates a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutSalesCorrectiveInvoices $sales_corrective_invoices sales_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\SalesCorrectiveInvoice
     */
    public function putSalesCorrectiveInvoicesKey($key, $sales_corrective_invoices)
    {
        list($response) = $this->putSalesCorrectiveInvoicesKeyWithHttpInfo($key, $sales_corrective_invoices);
        return $response;
    }

    /**
     * Operation putSalesCorrectiveInvoicesKeyWithHttpInfo
     *
     * Updates a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\SalesCorrectiveInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSalesCorrectiveInvoicesKeyWithHttpInfo($key, $sales_corrective_invoices)
    {
        $request = $this->putSalesCorrectiveInvoicesKeyRequest($key, $sales_corrective_invoices);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\SalesCorrectiveInvoice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\SalesCorrectiveInvoice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\SalesCorrectiveInvoice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\SalesCorrectiveInvoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSalesCorrectiveInvoicesKeyAsync
     *
     * Updates a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalesCorrectiveInvoicesKeyAsync($key, $sales_corrective_invoices)
    {
        return $this->putSalesCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $sales_corrective_invoices)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSalesCorrectiveInvoicesKeyAsyncWithHttpInfo
     *
     * Updates a Sales Corrective Invoice
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSalesCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $sales_corrective_invoices)
    {
        $returnType = '\SageOne\Model\SalesCorrectiveInvoice';
        $request = $this->putSalesCorrectiveInvoicesKeyRequest($key, $sales_corrective_invoices);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSalesCorrectiveInvoicesKey'
     *
     * @param  string $key The Sales Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutSalesCorrectiveInvoices $sales_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putSalesCorrectiveInvoicesKeyRequest($key, $sales_corrective_invoices)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling putSalesCorrectiveInvoicesKey'
            );
        }
        // verify the required parameter 'sales_corrective_invoices' is set
        if ($sales_corrective_invoices === null || (is_array($sales_corrective_invoices) && count($sales_corrective_invoices) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_corrective_invoices when calling putSalesCorrectiveInvoicesKey'
            );
        }

        $resourcePath = '/sales_corrective_invoices/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($sales_corrective_invoices)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($sales_corrective_invoices));
            } else {
                $httpBody = $sales_corrective_invoices;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
