<?php
/**
 * PurchaseCorrectiveInvoicesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SageOne\ApiException;
use SageOne\Configuration;
use SageOne\HeaderSelector;
use SageOne\ObjectSerializer;

/**
 * PurchaseCorrectiveInvoicesApi Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PurchaseCorrectiveInvoicesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deletePurchaseCorrectiveInvoicesKey
     *
     * Deletes a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deletePurchaseCorrectiveInvoicesKey($key)
    {
        $this->deletePurchaseCorrectiveInvoicesKeyWithHttpInfo($key);
    }

    /**
     * Operation deletePurchaseCorrectiveInvoicesKeyWithHttpInfo
     *
     * Deletes a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePurchaseCorrectiveInvoicesKeyWithHttpInfo($key)
    {
        $request = $this->deletePurchaseCorrectiveInvoicesKeyRequest($key);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deletePurchaseCorrectiveInvoicesKeyAsync
     *
     * Deletes a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePurchaseCorrectiveInvoicesKeyAsync($key)
    {
        return $this->deletePurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo($key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo
     *
     * Deletes a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo($key)
    {
        $returnType = '';
        $request = $this->deletePurchaseCorrectiveInvoicesKeyRequest($key);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePurchaseCorrectiveInvoicesKey'
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePurchaseCorrectiveInvoicesKeyRequest($key)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling deletePurchaseCorrectiveInvoicesKey'
            );
        }

        $resourcePath = '/purchase_corrective_invoices/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPurchaseCorrectiveInvoices
     *
     * Returns all Purchase Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Purchase Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Purchase Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Purchase Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Purchase Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\PurchaseCorrectiveInvoice[]
     */
    public function getPurchaseCorrectiveInvoices($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        list($response) = $this->getPurchaseCorrectiveInvoicesWithHttpInfo($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);
        return $response;
    }

    /**
     * Operation getPurchaseCorrectiveInvoicesWithHttpInfo
     *
     * Returns all Purchase Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Purchase Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Purchase Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Purchase Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Purchase Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\PurchaseCorrectiveInvoice[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getPurchaseCorrectiveInvoicesWithHttpInfo($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $request = $this->getPurchaseCorrectiveInvoicesRequest($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\PurchaseCorrectiveInvoice[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\PurchaseCorrectiveInvoice[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\PurchaseCorrectiveInvoice[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\PurchaseCorrectiveInvoice[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPurchaseCorrectiveInvoicesAsync
     *
     * Returns all Purchase Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Purchase Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Purchase Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Purchase Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Purchase Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseCorrectiveInvoicesAsync($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        return $this->getPurchaseCorrectiveInvoicesAsyncWithHttpInfo($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPurchaseCorrectiveInvoicesAsyncWithHttpInfo
     *
     * Returns all Purchase Corrective Invoices
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Purchase Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Purchase Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Purchase Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Purchase Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseCorrectiveInvoicesAsyncWithHttpInfo($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice[]';
        $request = $this->getPurchaseCorrectiveInvoicesRequest($show_payments_allocations, $search, $contact_id, $status_id, $from_date, $to_date, $updated_or_created_since, $deleted_since, $show_legacy_id, $items_per_page, $page, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPurchaseCorrectiveInvoices'
     *
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $search Use this to filter by the invoice reference or contact name. (optional)
     * @param  string $contact_id Use this to filter by contact id (optional)
     * @param  string $status_id Use this to filter by status id (optional)
     * @param  \DateTime $from_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $to_date Use this to filter by Purchase Corrective Invoices dates (optional)
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Purchase Corrective Invoices changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  \DateTime $deleted_since Use this to limit the response to Purchase Corrective Invoices deleted since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Not inclusive of the passed timestamp. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoices. (optional)
     * @param  int $items_per_page Returns the given number of Purchase Corrective Invoices per request. (optional, default to 20)
     * @param  int $page Go to specific page of Purchase Corrective Invoices (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoices (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPurchaseCorrectiveInvoicesRequest($show_payments_allocations = null, $search = null, $contact_id = null, $status_id = null, $from_date = null, $to_date = null, $updated_or_created_since = null, $deleted_since = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null)
    {
        if ($items_per_page !== null && $items_per_page > 200) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling PurchaseCorrectiveInvoicesApi.getPurchaseCorrectiveInvoices, must be smaller than or equal to 200.');
        }
        if ($items_per_page !== null && $items_per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling PurchaseCorrectiveInvoicesApi.getPurchaseCorrectiveInvoices, must be bigger than or equal to 1.');
        }


        $resourcePath = '/purchase_corrective_invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_payments_allocations,
            'show_payments_allocations', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $contact_id,
            'contact_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status_id,
            'status_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'from_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'to_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_or_created_since,
            'updated_or_created_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $deleted_since,
            'deleted_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $items_per_page,
            'items_per_page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPurchaseCorrectiveInvoicesKey
     *
     * Returns a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Purchase Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\PurchaseCorrectiveInvoice
     */
    public function getPurchaseCorrectiveInvoicesKey($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        list($response) = $this->getPurchaseCorrectiveInvoicesKeyWithHttpInfo($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);
        return $response;
    }

    /**
     * Operation getPurchaseCorrectiveInvoicesKeyWithHttpInfo
     *
     * Returns a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Purchase Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\PurchaseCorrectiveInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPurchaseCorrectiveInvoicesKeyWithHttpInfo($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        $request = $this->getPurchaseCorrectiveInvoicesKeyRequest($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\PurchaseCorrectiveInvoice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\PurchaseCorrectiveInvoice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\PurchaseCorrectiveInvoice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\PurchaseCorrectiveInvoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPurchaseCorrectiveInvoicesKeyAsync
     *
     * Returns a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Purchase Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseCorrectiveInvoicesKeyAsync($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        return $this->getPurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo
     *
     * Returns a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Purchase Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice';
        $request = $this->getPurchaseCorrectiveInvoicesKeyRequest($key, $show_payments_allocations, $nested_attributes, $show_legacy_id, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPurchaseCorrectiveInvoicesKey'
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  bool $show_payments_allocations Use this to show the artefact&#39;s payments and allocations (optional)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Purchase Corrective Invoice (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Purchase Corrective Invoice. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Purchase Corrective Invoice (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPurchaseCorrectiveInvoicesKeyRequest($key, $show_payments_allocations = null, $nested_attributes = null, $show_legacy_id = null, $attributes = null)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling getPurchaseCorrectiveInvoicesKey'
            );
        }

        $resourcePath = '/purchase_corrective_invoices/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_payments_allocations,
            'show_payments_allocations', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $nested_attributes,
            'nested_attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postPurchaseCorrectiveInvoices
     *
     * Creates a Purchase Corrective Invoice
     *
     * @param  \SageOne\Model\PostPurchaseCorrectiveInvoices $purchase_corrective_invoices purchase_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\PurchaseCorrectiveInvoice
     */
    public function postPurchaseCorrectiveInvoices($purchase_corrective_invoices)
    {
        list($response) = $this->postPurchaseCorrectiveInvoicesWithHttpInfo($purchase_corrective_invoices);
        return $response;
    }

    /**
     * Operation postPurchaseCorrectiveInvoicesWithHttpInfo
     *
     * Creates a Purchase Corrective Invoice
     *
     * @param  \SageOne\Model\PostPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\PurchaseCorrectiveInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function postPurchaseCorrectiveInvoicesWithHttpInfo($purchase_corrective_invoices)
    {
        $request = $this->postPurchaseCorrectiveInvoicesRequest($purchase_corrective_invoices);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\SageOne\Model\PurchaseCorrectiveInvoice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\PurchaseCorrectiveInvoice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\PurchaseCorrectiveInvoice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\PurchaseCorrectiveInvoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postPurchaseCorrectiveInvoicesAsync
     *
     * Creates a Purchase Corrective Invoice
     *
     * @param  \SageOne\Model\PostPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPurchaseCorrectiveInvoicesAsync($purchase_corrective_invoices)
    {
        return $this->postPurchaseCorrectiveInvoicesAsyncWithHttpInfo($purchase_corrective_invoices)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postPurchaseCorrectiveInvoicesAsyncWithHttpInfo
     *
     * Creates a Purchase Corrective Invoice
     *
     * @param  \SageOne\Model\PostPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postPurchaseCorrectiveInvoicesAsyncWithHttpInfo($purchase_corrective_invoices)
    {
        $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice';
        $request = $this->postPurchaseCorrectiveInvoicesRequest($purchase_corrective_invoices);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postPurchaseCorrectiveInvoices'
     *
     * @param  \SageOne\Model\PostPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postPurchaseCorrectiveInvoicesRequest($purchase_corrective_invoices)
    {
        // verify the required parameter 'purchase_corrective_invoices' is set
        if ($purchase_corrective_invoices === null || (is_array($purchase_corrective_invoices) && count($purchase_corrective_invoices) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_corrective_invoices when calling postPurchaseCorrectiveInvoices'
            );
        }

        $resourcePath = '/purchase_corrective_invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($purchase_corrective_invoices)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($purchase_corrective_invoices));
            } else {
                $httpBody = $purchase_corrective_invoices;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putPurchaseCorrectiveInvoicesKey
     *
     * Updates a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutPurchaseCorrectiveInvoices $purchase_corrective_invoices purchase_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\PurchaseCorrectiveInvoice
     */
    public function putPurchaseCorrectiveInvoicesKey($key, $purchase_corrective_invoices)
    {
        list($response) = $this->putPurchaseCorrectiveInvoicesKeyWithHttpInfo($key, $purchase_corrective_invoices);
        return $response;
    }

    /**
     * Operation putPurchaseCorrectiveInvoicesKeyWithHttpInfo
     *
     * Updates a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\PurchaseCorrectiveInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function putPurchaseCorrectiveInvoicesKeyWithHttpInfo($key, $purchase_corrective_invoices)
    {
        $request = $this->putPurchaseCorrectiveInvoicesKeyRequest($key, $purchase_corrective_invoices);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\PurchaseCorrectiveInvoice' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\PurchaseCorrectiveInvoice' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\PurchaseCorrectiveInvoice', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\PurchaseCorrectiveInvoice',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putPurchaseCorrectiveInvoicesKeyAsync
     *
     * Updates a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putPurchaseCorrectiveInvoicesKeyAsync($key, $purchase_corrective_invoices)
    {
        return $this->putPurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $purchase_corrective_invoices)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putPurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo
     *
     * Updates a Purchase Corrective Invoice
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putPurchaseCorrectiveInvoicesKeyAsyncWithHttpInfo($key, $purchase_corrective_invoices)
    {
        $returnType = '\SageOne\Model\PurchaseCorrectiveInvoice';
        $request = $this->putPurchaseCorrectiveInvoicesKeyRequest($key, $purchase_corrective_invoices);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putPurchaseCorrectiveInvoicesKey'
     *
     * @param  string $key The Purchase Corrective Invoice Key. (required)
     * @param  \SageOne\Model\PutPurchaseCorrectiveInvoices $purchase_corrective_invoices (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putPurchaseCorrectiveInvoicesKeyRequest($key, $purchase_corrective_invoices)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling putPurchaseCorrectiveInvoicesKey'
            );
        }
        // verify the required parameter 'purchase_corrective_invoices' is set
        if ($purchase_corrective_invoices === null || (is_array($purchase_corrective_invoices) && count($purchase_corrective_invoices) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $purchase_corrective_invoices when calling putPurchaseCorrectiveInvoicesKey'
            );
        }

        $resourcePath = '/purchase_corrective_invoices/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($purchase_corrective_invoices)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($purchase_corrective_invoices));
            } else {
                $httpBody = $purchase_corrective_invoices;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
