<?php
/**
 * LedgerAccountsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Sage Business Cloud Accounting - Accounts
 *
 * Documentation of the Sage Business Cloud Accounting API.
 *
 * The version of the OpenAPI document: 3.1
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SageOne\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SageOne\ApiException;
use SageOne\Configuration;
use SageOne\HeaderSelector;
use SageOne\ObjectSerializer;

/**
 * LedgerAccountsApi Class Doc Comment
 *
 * @category Class
 * @package  SageOne
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class LedgerAccountsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getLedgerAccounts
     *
     * Returns all Ledger Accounts
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Ledger Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  string $visible_in Use this to limit the response to ledger account types visible in a specific area. Valid values are: banking, sales, expenses, other_payments, other_receipts, journals and reporting (optional)
     * @param  string $ledger_account_classification_id Use this to filter by ledger account classification id (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  string $search Use this to filter by the item code or description (optional)
     * @param  bool $sort_order_from_user_setting Use this to enable ordering ledger accounts according to user settings. Defaulted to &#39;false&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Accounts. (optional)
     * @param  int $items_per_page Returns the given number of Ledger Accounts per request. (optional, default to 20)
     * @param  int $page Go to specific page of Ledger Accounts (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  string $ledger_account_type_id Use this to filter by ledger account type id (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\PagingLedgerAccount
     */
    public function getLedgerAccounts($updated_or_created_since = null, $visible_in = null, $ledger_account_classification_id = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $search = null, $sort_order_from_user_setting = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null, $ledger_account_type_id = null)
    {
        list($response) = $this->getLedgerAccountsWithHttpInfo($updated_or_created_since, $visible_in, $ledger_account_classification_id, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $search, $sort_order_from_user_setting, $show_legacy_id, $items_per_page, $page, $attributes, $ledger_account_type_id);
        return $response;
    }

    /**
     * Operation getLedgerAccountsWithHttpInfo
     *
     * Returns all Ledger Accounts
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Ledger Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  string $visible_in Use this to limit the response to ledger account types visible in a specific area. Valid values are: banking, sales, expenses, other_payments, other_receipts, journals and reporting (optional)
     * @param  string $ledger_account_classification_id Use this to filter by ledger account classification id (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  string $search Use this to filter by the item code or description (optional)
     * @param  bool $sort_order_from_user_setting Use this to enable ordering ledger accounts according to user settings. Defaulted to &#39;false&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Accounts. (optional)
     * @param  int $items_per_page Returns the given number of Ledger Accounts per request. (optional, default to 20)
     * @param  int $page Go to specific page of Ledger Accounts (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  string $ledger_account_type_id Use this to filter by ledger account type id (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\PagingLedgerAccount, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLedgerAccountsWithHttpInfo($updated_or_created_since = null, $visible_in = null, $ledger_account_classification_id = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $search = null, $sort_order_from_user_setting = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null, $ledger_account_type_id = null)
    {
        $request = $this->getLedgerAccountsRequest($updated_or_created_since, $visible_in, $ledger_account_classification_id, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $search, $sort_order_from_user_setting, $show_legacy_id, $items_per_page, $page, $attributes, $ledger_account_type_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\PagingLedgerAccount' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\PagingLedgerAccount' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\PagingLedgerAccount', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\PagingLedgerAccount';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\PagingLedgerAccount',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLedgerAccountsAsync
     *
     * Returns all Ledger Accounts
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Ledger Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  string $visible_in Use this to limit the response to ledger account types visible in a specific area. Valid values are: banking, sales, expenses, other_payments, other_receipts, journals and reporting (optional)
     * @param  string $ledger_account_classification_id Use this to filter by ledger account classification id (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  string $search Use this to filter by the item code or description (optional)
     * @param  bool $sort_order_from_user_setting Use this to enable ordering ledger accounts according to user settings. Defaulted to &#39;false&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Accounts. (optional)
     * @param  int $items_per_page Returns the given number of Ledger Accounts per request. (optional, default to 20)
     * @param  int $page Go to specific page of Ledger Accounts (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  string $ledger_account_type_id Use this to filter by ledger account type id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLedgerAccountsAsync($updated_or_created_since = null, $visible_in = null, $ledger_account_classification_id = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $search = null, $sort_order_from_user_setting = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null, $ledger_account_type_id = null)
    {
        return $this->getLedgerAccountsAsyncWithHttpInfo($updated_or_created_since, $visible_in, $ledger_account_classification_id, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $search, $sort_order_from_user_setting, $show_legacy_id, $items_per_page, $page, $attributes, $ledger_account_type_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLedgerAccountsAsyncWithHttpInfo
     *
     * Returns all Ledger Accounts
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Ledger Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  string $visible_in Use this to limit the response to ledger account types visible in a specific area. Valid values are: banking, sales, expenses, other_payments, other_receipts, journals and reporting (optional)
     * @param  string $ledger_account_classification_id Use this to filter by ledger account classification id (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  string $search Use this to filter by the item code or description (optional)
     * @param  bool $sort_order_from_user_setting Use this to enable ordering ledger accounts according to user settings. Defaulted to &#39;false&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Accounts. (optional)
     * @param  int $items_per_page Returns the given number of Ledger Accounts per request. (optional, default to 20)
     * @param  int $page Go to specific page of Ledger Accounts (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  string $ledger_account_type_id Use this to filter by ledger account type id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLedgerAccountsAsyncWithHttpInfo($updated_or_created_since = null, $visible_in = null, $ledger_account_classification_id = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $search = null, $sort_order_from_user_setting = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null, $ledger_account_type_id = null)
    {
        $returnType = '\SageOne\Model\PagingLedgerAccount';
        $request = $this->getLedgerAccountsRequest($updated_or_created_since, $visible_in, $ledger_account_classification_id, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $search, $sort_order_from_user_setting, $show_legacy_id, $items_per_page, $page, $attributes, $ledger_account_type_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLedgerAccounts'
     *
     * @param  \DateTime $updated_or_created_since Use this to limit the response to Ledger Accounts changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. (optional)
     * @param  string $visible_in Use this to limit the response to ledger account types visible in a specific area. Valid values are: banking, sales, expenses, other_payments, other_receipts, journals and reporting (optional)
     * @param  string $ledger_account_classification_id Use this to filter by ledger account classification id (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  string $search Use this to filter by the item code or description (optional)
     * @param  bool $sort_order_from_user_setting Use this to enable ordering ledger accounts according to user settings. Defaulted to &#39;false&#39;. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Accounts. (optional)
     * @param  int $items_per_page Returns the given number of Ledger Accounts per request. (optional, default to 20)
     * @param  int $page Go to specific page of Ledger Accounts (optional, default to 1)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Accounts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  string $ledger_account_type_id Use this to filter by ledger account type id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLedgerAccountsRequest($updated_or_created_since = null, $visible_in = null, $ledger_account_classification_id = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $search = null, $sort_order_from_user_setting = null, $show_legacy_id = null, $items_per_page = 20, $page = 1, $attributes = null, $ledger_account_type_id = null)
    {
        if ($items_per_page !== null && $items_per_page > 200) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling LedgerAccountsApi.getLedgerAccounts, must be smaller than or equal to 200.');
        }
        if ($items_per_page !== null && $items_per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$items_per_page" when calling LedgerAccountsApi.getLedgerAccounts, must be bigger than or equal to 1.');
        }


        $resourcePath = '/ledger_accounts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $updated_or_created_since,
            'updated_or_created_since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $visible_in,
            'visible_in', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ledger_account_classification_id,
            'ledger_account_classification_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_balance_details,
            'show_balance_details', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_deleted_entries,
            'exclude_deleted_entries', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'from_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'to_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search,
            'search', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_order_from_user_setting,
            'sort_order_from_user_setting', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $items_per_page,
            'items_per_page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ledger_account_type_id,
            'ledger_account_type_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLedgerAccountsKey
     *
     * Returns a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Ledger Account (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Account. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\LedgerAccount
     */
    public function getLedgerAccountsKey($key, $nested_attributes = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $show_legacy_id = null, $attributes = null)
    {
        list($response) = $this->getLedgerAccountsKeyWithHttpInfo($key, $nested_attributes, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $show_legacy_id, $attributes);
        return $response;
    }

    /**
     * Operation getLedgerAccountsKeyWithHttpInfo
     *
     * Returns a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Ledger Account (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Account. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\LedgerAccount, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLedgerAccountsKeyWithHttpInfo($key, $nested_attributes = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $show_legacy_id = null, $attributes = null)
    {
        $request = $this->getLedgerAccountsKeyRequest($key, $nested_attributes, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $show_legacy_id, $attributes);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\LedgerAccount' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\LedgerAccount' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\LedgerAccount', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\LedgerAccount';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\LedgerAccount',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLedgerAccountsKeyAsync
     *
     * Returns a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Ledger Account (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Account. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLedgerAccountsKeyAsync($key, $nested_attributes = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $show_legacy_id = null, $attributes = null)
    {
        return $this->getLedgerAccountsKeyAsyncWithHttpInfo($key, $nested_attributes, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $show_legacy_id, $attributes)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLedgerAccountsKeyAsyncWithHttpInfo
     *
     * Returns a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Ledger Account (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Account. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLedgerAccountsKeyAsyncWithHttpInfo($key, $nested_attributes = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $show_legacy_id = null, $attributes = null)
    {
        $returnType = '\SageOne\Model\LedgerAccount';
        $request = $this->getLedgerAccountsKeyRequest($key, $nested_attributes, $show_balance_details, $exclude_deleted_entries, $from_date, $to_date, $show_legacy_id, $attributes);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLedgerAccountsKey'
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  string $nested_attributes Specify the attributes that you want to expose for nested entities of the Ledger Account (expose all nested attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     * @param  bool $show_balance_details Use this to display the balance details for ledger accounts between a date range (requires from_date and to_date). (optional)
     * @param  bool $exclude_deleted_entries Exclude deleted ledger entries. (optional)
     * @param  \DateTime $from_date Calculate balances from this date. (optional)
     * @param  \DateTime $to_date Calculate balances to this date. (optional)
     * @param  bool $show_legacy_id Display the legacy_id for the Ledger Account. (optional)
     * @param  string $attributes Specify the attributes that you want to expose for the Ledger Account (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLedgerAccountsKeyRequest($key, $nested_attributes = null, $show_balance_details = null, $exclude_deleted_entries = null, $from_date = null, $to_date = null, $show_legacy_id = null, $attributes = null)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling getLedgerAccountsKey'
            );
        }

        $resourcePath = '/ledger_accounts/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $nested_attributes,
            'nested_attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_balance_details,
            'show_balance_details', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_deleted_entries,
            'exclude_deleted_entries', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from_date,
            'from_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to_date,
            'to_date', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_legacy_id,
            'show_legacy_id', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $attributes,
            'attributes', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postLedgerAccounts
     *
     * Creates a Ledger Account
     *
     * @param  \SageOne\Model\PostLedgerAccounts $ledger_accounts ledger_accounts (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\LedgerAccount
     */
    public function postLedgerAccounts($ledger_accounts)
    {
        list($response) = $this->postLedgerAccountsWithHttpInfo($ledger_accounts);
        return $response;
    }

    /**
     * Operation postLedgerAccountsWithHttpInfo
     *
     * Creates a Ledger Account
     *
     * @param  \SageOne\Model\PostLedgerAccounts $ledger_accounts (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\LedgerAccount, HTTP status code, HTTP response headers (array of strings)
     */
    public function postLedgerAccountsWithHttpInfo($ledger_accounts)
    {
        $request = $this->postLedgerAccountsRequest($ledger_accounts);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('\SageOne\Model\LedgerAccount' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\LedgerAccount' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\LedgerAccount', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\LedgerAccount';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\LedgerAccount',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation postLedgerAccountsAsync
     *
     * Creates a Ledger Account
     *
     * @param  \SageOne\Model\PostLedgerAccounts $ledger_accounts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postLedgerAccountsAsync($ledger_accounts)
    {
        return $this->postLedgerAccountsAsyncWithHttpInfo($ledger_accounts)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation postLedgerAccountsAsyncWithHttpInfo
     *
     * Creates a Ledger Account
     *
     * @param  \SageOne\Model\PostLedgerAccounts $ledger_accounts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postLedgerAccountsAsyncWithHttpInfo($ledger_accounts)
    {
        $returnType = '\SageOne\Model\LedgerAccount';
        $request = $this->postLedgerAccountsRequest($ledger_accounts);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postLedgerAccounts'
     *
     * @param  \SageOne\Model\PostLedgerAccounts $ledger_accounts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function postLedgerAccountsRequest($ledger_accounts)
    {
        // verify the required parameter 'ledger_accounts' is set
        if ($ledger_accounts === null || (is_array($ledger_accounts) && count($ledger_accounts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ledger_accounts when calling postLedgerAccounts'
            );
        }

        $resourcePath = '/ledger_accounts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($ledger_accounts)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($ledger_accounts));
            } else {
                $httpBody = $ledger_accounts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putLedgerAccountsKey
     *
     * Updates a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  \SageOne\Model\PutLedgerAccounts $ledger_accounts ledger_accounts (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SageOne\Model\LedgerAccount
     */
    public function putLedgerAccountsKey($key, $ledger_accounts)
    {
        list($response) = $this->putLedgerAccountsKeyWithHttpInfo($key, $ledger_accounts);
        return $response;
    }

    /**
     * Operation putLedgerAccountsKeyWithHttpInfo
     *
     * Updates a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  \SageOne\Model\PutLedgerAccounts $ledger_accounts (required)
     *
     * @throws \SageOne\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SageOne\Model\LedgerAccount, HTTP status code, HTTP response headers (array of strings)
     */
    public function putLedgerAccountsKeyWithHttpInfo($key, $ledger_accounts)
    {
        $request = $this->putLedgerAccountsKeyRequest($key, $ledger_accounts);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SageOne\Model\LedgerAccount' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SageOne\Model\LedgerAccount' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SageOne\Model\LedgerAccount', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SageOne\Model\LedgerAccount';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SageOne\Model\LedgerAccount',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putLedgerAccountsKeyAsync
     *
     * Updates a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  \SageOne\Model\PutLedgerAccounts $ledger_accounts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putLedgerAccountsKeyAsync($key, $ledger_accounts)
    {
        return $this->putLedgerAccountsKeyAsyncWithHttpInfo($key, $ledger_accounts)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putLedgerAccountsKeyAsyncWithHttpInfo
     *
     * Updates a Ledger Account
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  \SageOne\Model\PutLedgerAccounts $ledger_accounts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putLedgerAccountsKeyAsyncWithHttpInfo($key, $ledger_accounts)
    {
        $returnType = '\SageOne\Model\LedgerAccount';
        $request = $this->putLedgerAccountsKeyRequest($key, $ledger_accounts);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putLedgerAccountsKey'
     *
     * @param  string $key The Ledger Account Key. (required)
     * @param  \SageOne\Model\PutLedgerAccounts $ledger_accounts (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function putLedgerAccountsKeyRequest($key, $ledger_accounts)
    {
        // verify the required parameter 'key' is set
        if ($key === null || (is_array($key) && count($key) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key when calling putLedgerAccountsKey'
            );
        }
        // verify the required parameter 'ledger_accounts' is set
        if ($ledger_accounts === null || (is_array($ledger_accounts) && count($ledger_accounts) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ledger_accounts when calling putLedgerAccountsKey'
            );
        }

        $resourcePath = '/ledger_accounts/{key}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($key !== null) {
            $resourcePath = str_replace(
                '{' . 'key' . '}',
                ObjectSerializer::toPathValue($key),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($ledger_accounts)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($ledger_accounts));
            } else {
                $httpBody = $ledger_accounts;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
