# # SalesQuote

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**legacy_id** | **int** | The legacy ID for the item | [optional]
**id** | **string** | The unique identifier for the item | [optional]
**displayed_as** | **string** | The name of the resource | [optional]
**path** | **string** | The API path for the resource | [optional]
**transaction** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**transaction_type** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**created_at** | **\DateTime** | The datetime when the item was created | [optional]
**updated_at** | **\DateTime** | The datetime when the item was last updated | [optional]
**links** | [**\SageOne\Model\Link[]**](Link.md) | Links for the resource | [optional]
**editable** | **bool** | Indicates whether artefact can be edited | [optional]
**tax_calculation_method** | **string** | The tax calculation method, if applicable, for this sales invoice, returns invoice, cash or retailer. | [optional]
**contact** | [**\SageOne\Model\Contact**](Contact.md) |  | [optional]
**quote_number** | **string** | The generated quote number | [optional]
**contact_name** | **string** | The name of the contact when the quote was created | [optional]
**contact_reference** | **string** | The reference of the contact when the quote was created | [optional]
**date** | **\DateTime** | The date of the quote | [optional]
**expiry_date** | **\DateTime** | The expiry date of the quote | [optional]
**reference** | **string** | The reference for the quote | [optional]
**main_address_free_form** | **string** | The free-form main address of the quote | [optional]
**delivery_address_free_form** | **string** | The free-form delivery address of the quote | [optional]
**main_address** | [**\SageOne\Model\SalesArtefactAddress**](SalesArtefactAddress.md) |  | [optional]
**delivery_address** | [**\SageOne\Model\SalesArtefactAddress**](SalesArtefactAddress.md) |  | [optional]
**notes** | **string** | Quote notes | [optional]
**terms_and_conditions** | **string** | Quote terms and conditions | [optional]
**shipping_net_amount** | **double** | The net shipping amount | [optional]
**shipping_tax_rate** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**shipping_tax_amount** | **double** | The tax shipping amount. NOTE: This is not required for POST/PUT requests as the shipping tax is calculated based on the shipping_net_amount and the shipping_tax_rate. | [optional]
**shipping_tax_breakdown** | [**\SageOne\Model\TaxBreakdown[]**](TaxBreakdown.md) | The shipping tax breakdown for the quote | [optional]
**shipping_total_amount** | **double** | The total shipping amount | [optional]
**net_amount** | **double** | The net amount of the quote | [optional]
**tax_amount** | **double** | The tax amount of the quote | [optional]
**total_amount** | **double** | The total amount of the quote | [optional]
**currency** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**exchange_rate** | **double** | The exchange rate for the quote | [optional]
**inverse_exchange_rate** | **double** | The inverse exchange rate for the quote | [optional]
**base_currency_shipping_net_amount** | **double** | The net shipping amount in base currency | [optional]
**base_currency_shipping_tax_amount** | **double** | The tax shipping amount in base currency | [optional]
**base_currency_shipping_tax_breakdown** | [**\SageOne\Model\TaxBreakdown[]**](TaxBreakdown.md) | The shipping tax breakdown for the  quote in base currency | [optional]
**base_currency_shipping_total_amount** | **double** | The total shipping amount in base currency | [optional]
**total_quantity** | **double** | The total quantity of the quote | [optional]
**total_discount_amount** | **double** | The discount amount on the  quote | [optional]
**base_currency_total_discount_amount** | **double** | The discount amount on the  quote in base currency | [optional]
**base_currency_net_amount** | **double** | The net amount of the quote in base currency | [optional]
**base_currency_tax_amount** | **double** | The tax amount of the quote in base currency | [optional]
**base_currency_total_amount** | **double** | The total amount of the quote in base currency | [optional]
**payments_allocations_total_amount** | **double** | The total amount of all payments and allocations | [optional]
**payments_allocations_total_discount** | **double** | The total discount of all payments and allocations | [optional]
**total_paid** | **double** | The total paid amount of the quote including any payments, allocations and discounts | [optional]
**status** | [**\SageOne\Model\QuoteStatus**](QuoteStatus.md) |  | [optional]
**sent** | **bool** | Indicates whether the quote has been sent | [optional]
**sent_by_email** | **bool** | Indicates whether the quote has been emailed | [optional]
**quote_lines** | [**\SageOne\Model\SalesQuoteLineItem[]**](SalesQuoteLineItem.md) | The quote lines of the quote | [optional]
**tax_analysis** | [**\SageOne\Model\ArtefactTaxAnalysis[]**](ArtefactTaxAnalysis.md) | The quote tax analysis | [optional]
**detailed_tax_analysis** | [**\SageOne\Model\ArtefactDetailedTaxAnalysis**](ArtefactDetailedTaxAnalysis.md) |  | [optional]
**tax_address_region** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**withholding_tax_rate** | **double** | IRPF withheld Tax Rate (Spain only) | [optional]
**withholding_tax_amount** | **double** | IRPF withheld Tax Amount (Spain only) | [optional]
**base_currency_withholding_tax_amount** | **double** | IRPF withheld Tax Amount (Spain only) in the base currency | [optional]
**profit_analysis** | [**\SageOne\Model\ProfitAnalysis**](ProfitAnalysis.md) |  | [optional]
**tax_reconciled** | **bool** | Indicates if the quote/estimate is tax reconciled or not. | [optional]
**invoice** | [**\SageOne\Model\Generic**](Generic.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
