# # SalesCreditNote

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**legacy_id** | **int** | The legacy ID for the item | [optional]
**id** | **string** | The unique identifier for the item | [optional]
**displayed_as** | **string** | The name of the resource | [optional]
**path** | **string** | The API path for the resource | [optional]
**transaction** | [**\SageOne\Model\Transaction**](Transaction.md) |  | [optional]
**transaction_type** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**created_at** | **\DateTime** | The datetime when the item was created | [optional]
**updated_at** | **\DateTime** | The datetime when the item was last updated | [optional]
**links** | [**\SageOne\Model\Link[]**](Link.md) | Links for the resource | [optional]
**editable** | **bool** | Indicates whether artefact can be edited | [optional]
**tax_calculation_method** | **string** | The tax calculation method, if applicable, for this sales credit note, returns invoice or cash. | [optional]
**deleted_at** | **\DateTime** | The datetime when the item was deleted | [optional]
**contact** | [**\SageOne\Model\Contact**](Contact.md) |  | [optional]
**credit_note_number** | **string** | The generated credit note number | [optional]
**contact_name** | **string** | The name of the contact when the credit note was created | [optional]
**contact_reference** | **string** | The reference of the contact when the credit note was created | [optional]
**date** | **\DateTime** | The date of the credit note | [optional]
**reference** | **string** | The reference for the credit note | [optional]
**main_address_free_form** | **string** | The free-form main address of the credit note | [optional]
**main_address** | [**\SageOne\Model\SalesArtefactAddress**](SalesArtefactAddress.md) |  | [optional]
**delivery_address_free_form** | **string** | The free-form delivery address of the credit note | [optional]
**delivery_address** | [**\SageOne\Model\SalesArtefactAddress**](SalesArtefactAddress.md) |  | [optional]
**notes** | **string** | credit note notes | [optional]
**terms_and_conditions** | **string** | Credit note terms and conditions | [optional]
**shipping_net_amount** | **double** | The net shipping amount | [optional]
**shipping_tax_rate** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**shipping_tax_amount** | **double** | The tax shipping amount. NOTE: This is not required for POST/PUT requests as the shipping tax is calculated based on the shipping_net_amount and the shipping_tax_rate. | [optional]
**shipping_tax_breakdown** | [**\SageOne\Model\TaxBreakdown[]**](TaxBreakdown.md) | The shipping tax breakdown for the credit note | [optional]
**total_quantity** | **double** | The total quantity of the credit note | [optional]
**shipping_total_amount** | **double** | The total shipping amount | [optional]
**net_amount** | **double** | The net amount of the credit note | [optional]
**tax_amount** | **double** | The tax amount of the credit note | [optional]
**total_amount** | **double** | The total amount of the credit note | [optional]
**payments_allocations_total_amount** | **double** | The total amount of all payments and allocations | [optional]
**payments_allocations_total_discount** | **double** | The total discount of all payments and allocations | [optional]
**total_paid** | **double** | The total paid amount of the credit note including any payments, allocations and discounts | [optional]
**outstanding_amount** | **double** | The outstanding amount of the credit note | [optional]
**currency** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**exchange_rate** | **double** | The exchange rate for the credit note | [optional]
**inverse_exchange_rate** | **double** | The inverse exchange rate for the credit note | [optional]
**base_currency_shipping_net_amount** | **double** | The net shipping amount in base currency | [optional]
**base_currency_shipping_tax_amount** | **double** | The tax shipping amount in base currency | [optional]
**base_currency_shipping_tax_breakdown** | [**\SageOne\Model\TaxBreakdown[]**](TaxBreakdown.md) | The shipping tax breakdown for the credit note in base currency | [optional]
**base_currency_shipping_total_amount** | **double** | The total shipping amount in base currency | [optional]
**total_discount_amount** | **double** | The discount amount on the credit note | [optional]
**base_currency_total_discount_amount** | **double** | The discount amount on the credit note in base currency | [optional]
**base_currency_net_amount** | **double** | The net amount of the credit note in base currency | [optional]
**base_currency_tax_amount** | **double** | The tax amount of the credit note in base currency | [optional]
**base_currency_total_amount** | **double** | The total amount of the credit note in base currency | [optional]
**base_currency_outstanding_amount** | **double** | The outstanding amount of the credit note in base currency | [optional]
**status** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**sent** | **bool** | Indicates whether the credit note has been sent | [optional]
**sent_by_email** | **bool** | Indicates whether the credit note has been emailed | [optional]
**void_reason** | **string** | The reason the credit note was voided | [optional]
**credit_note_lines** | [**\SageOne\Model\SalesCreditNoteLineItem[]**](SalesCreditNoteLineItem.md) | The credit note lines of the credit note | [optional]
**tax_analysis** | [**\SageOne\Model\ArtefactTaxAnalysis[]**](ArtefactTaxAnalysis.md) | The credit note tax analysis | [optional]
**detailed_tax_analysis** | [**\SageOne\Model\ArtefactDetailedTaxAnalysis**](ArtefactDetailedTaxAnalysis.md) |  | [optional]
**payments_allocations** | [**\SageOne\Model\PaymentAllocation[]**](PaymentAllocation.md) | The associated payments and allocations | [optional]
**last_paid** | **\DateTime** | The date of the last payment | [optional]
**tax_address_region** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**tax_reconciled** | **bool** | Indicates if the sales credit note is tax reconciled or not. | [optional]
**migrated** | **bool** | Indicates if the sales credit note was migrated from another system. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
