# # PurchaseInvoice

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**legacy_id** | **int** | The legacy ID for the item | [optional]
**id** | **string** | The unique identifier for the item | [optional]
**displayed_as** | **string** | The name of the resource | [optional]
**path** | **string** | The API path for the resource | [optional]
**transaction** | [**\SageOne\Model\Transaction**](Transaction.md) |  | [optional]
**transaction_type** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**created_at** | **\DateTime** | The datetime when the item was created | [optional]
**updated_at** | **\DateTime** | The datetime when the item was last updated | [optional]
**links** | [**\SageOne\Model\Link[]**](Link.md) | Links for the resource | [optional]
**editable** | **bool** | Indicates whether artefact can be edited | [optional]
**deleted_at** | **\DateTime** | The datetime when the item was deleted | [optional]
**contact** | [**\SageOne\Model\Contact**](Contact.md) |  | [optional]
**contact_name** | **string** | The name of the contact when the invoice was created | [optional]
**contact_reference** | **string** | The reference of the contact when the invoice was created | [optional]
**date** | **\DateTime** | The date of the invoice | [optional]
**due_date** | **\DateTime** | The due date of the invoice | [optional]
**reference** | **string** | The reference for the invoice | [optional]
**vendor_reference** | **string** | The vendor reference for the invoice | [optional]
**notes** | **string** | Invoice notes | [optional]
**total_quantity** | **double** | The total quantity of the invoice | [optional]
**net_amount** | **double** | The net amount of the invoice | [optional]
**tax_amount** | **double** | The tax amount of the invoice | [optional]
**total_amount** | **double** | The total amount of the invoice | [optional]
**payments_allocations_total_amount** | **double** | The total amount of all payments and allocations | [optional]
**payments_allocations_total_discount** | **double** | The total discount of all payments and allocations | [optional]
**total_paid** | **double** | The total paid amount of the invoice including any payments, allocations and discounts | [optional]
**outstanding_amount** | **double** | The outstanding amount of the invoice | [optional]
**currency** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**exchange_rate** | **double** | The exchange rate for the invoice | [optional]
**inverse_exchange_rate** | **double** | The inverse exchange rate for the invoice | [optional]
**base_currency_net_amount** | **double** | The net amount of the invoice in base currency | [optional]
**base_currency_tax_amount** | **double** | The tax amount of the invoice in base currency | [optional]
**base_currency_total_amount** | **double** | The total amount of the invoice in base currency | [optional]
**base_currency_outstanding_amount** | **double** | The outstanding amount of the invoice in base currency | [optional]
**status** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**void_reason** | **string** | The reason the invoice was voided | [optional]
**invoice_lines** | [**\SageOne\Model\PurchaseInvoiceLineItem[]**](PurchaseInvoiceLineItem.md) | The invoice lines of the invoice | [optional]
**tax_analysis** | [**\SageOne\Model\ArtefactTaxAnalysis[]**](ArtefactTaxAnalysis.md) | The invoice tax analysis (Optional for Spain, restricted for all other regions) | [optional]
**detailed_tax_analysis** | [**\SageOne\Model\ArtefactDetailedTaxAnalysis**](ArtefactDetailedTaxAnalysis.md) |  | [optional]
**payments_allocations** | [**\SageOne\Model\PaymentAllocation[]**](PaymentAllocation.md) | The associated payments and allocations | [optional]
**last_paid** | **\DateTime** | The date of the last payment | [optional]
**tax_address_region** | [**\SageOne\Model\Base**](Base.md) |  | [optional]
**withholding_tax_rate** | **double** | IRPF withheld Tax Rate (Spain only) | [optional]
**withholding_tax_amount** | **double** | IRPF withheld Tax Amount (Spain only) | [optional]
**base_currency_withholding_tax_amount** | **double** | IRPF withheld Tax Amount (Spain only) in the base currency | [optional]
**corrections** | [**\SageOne\Model\PurchaseCorrectiveInvoice[]**](PurchaseCorrectiveInvoice.md) | The corrective entries associated with the invoice | [optional]
**tax_reconciled** | **bool** | Indicates if the purchase invoice is tax reconciled or not. | [optional]
**migrated** | **bool** | Indicates if the purchase invoice was migrated from another system. | [optional]
**tax_calculation_method** | **string** | The tax calculation method, if applicable, for this purchase invoice, returns invoice or cash. | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
