# # PostSalesInvoicesSalesInvoice

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**contact_id** | **string** | The contact the sales invoice relates to |
**date** | **\DateTime** | The date of the invoice |
**transaction_type_id** | **string** | The ID of the Transaction Type. | [optional]
**editable** | **bool** | Indicates whether artefact can be edited | [optional]
**tax_calculation_method** | **string** | The tax calculation method, if applicable, for this sales invoice, returns invoice, cash or retailer. | [optional]
**deleted_at** | **\DateTime** | The datetime when the item was deleted | [optional]
**invoice_number** | **string** | The generated invoice number | [optional]
**contact_name** | **string** | The name of the contact when the invoice was created | [optional]
**contact_reference** | **string** | The reference of the contact when the invoice was created | [optional]
**due_date** | **\DateTime** | The due date of the invoice | [optional]
**reference** | **string** | The reference for the invoice | [optional]
**main_address_free_form** | **string** | The free-form main address of the invoice | [optional]
**delivery_address_free_form** | **string** | The free-form delivery address of the invoice | [optional]
**notes** | **string** | Invoice notes | [optional]
**terms_and_conditions** | **string** | Invoice terms and conditions | [optional]
**shipping_net_amount** | **double** | The net shipping amount | [optional]
**shipping_tax_rate_id** | **string** | The ID of the Shipping Tax Rate. | [optional]
**shipping_tax_amount** | **double** | The tax shipping amount. NOTE: This is not required for POST/PUT requests as the shipping tax is calculated based on the shipping_net_amount and the shipping_tax_rate. | [optional]
**shipping_total_amount** | **double** | The total shipping amount | [optional]
**net_amount** | **double** | The net amount of the invoice | [optional]
**tax_amount** | **double** | The tax amount of the invoice | [optional]
**total_amount** | **double** | The total amount of the invoice | [optional]
**payments_allocations_total_amount** | **double** | The total amount of all payments and allocations | [optional]
**payments_allocations_total_discount** | **double** | The total discount of all payments and allocations | [optional]
**total_paid** | **double** | The total paid amount of the invoice including any payments, allocations and discounts | [optional]
**outstanding_amount** | **double** | The outstanding amount of the invoice | [optional]
**currency_id** | **string** | The ID of the Currency. | [optional]
**exchange_rate** | **double** | The exchange rate for the invoice | [optional]
**inverse_exchange_rate** | **double** | The inverse exchange rate for the invoice | [optional]
**base_currency_shipping_net_amount** | **double** | The net shipping amount in base currency | [optional]
**base_currency_shipping_tax_amount** | **double** | The tax shipping amount in base currency | [optional]
**base_currency_shipping_total_amount** | **double** | The total shipping amount in base currency | [optional]
**total_quantity** | **double** | The total quantity of the invoice | [optional]
**total_discount_amount** | **double** | The discount amount on the invoice | [optional]
**base_currency_total_discount_amount** | **double** | The discount amount on the invoice in base currency | [optional]
**base_currency_net_amount** | **double** | The net amount of the invoice in base currency | [optional]
**base_currency_tax_amount** | **double** | The tax amount of the invoice in base currency | [optional]
**base_currency_total_amount** | **double** | The total amount of the invoice in base currency | [optional]
**base_currency_outstanding_amount** | **double** | The outstanding amount of the invoice in base currency | [optional]
**status_id** | **string** | The ID of the Status. | [optional]
**sent** | **bool** | Indicates whether the invoice has been sent | [optional]
**sent_by_email** | **bool** | Indicates whether the invoice has been emailed | [optional]
**void_reason** | **string** | The reason the invoice was voided | [optional]
**last_paid** | **\DateTime** | The date of the last payment | [optional]
**tax_address_region_id** | **string** | The ID of the Tax Address Region. (Canada only) | [optional]
**delivery_performance_date** | **string** | Delivery/Performance Date (Germany only) | [optional]
**withholding_tax_rate** | **double** | IRPF withheld Tax Rate (Spain only) | [optional]
**withholding_tax_amount** | **double** | IRPF withheld Tax Amount (Spain only) | [optional]
**base_currency_withholding_tax_amount** | **double** | IRPF withheld Tax Amount (Spain only) in the base currency | [optional]
**corrections** | **string[]** | The corrective entries associated with the invoice | [optional]
**tax_reconciled** | **bool** | Indicates if the sales invoice is tax reconciled or not. | [optional]
**migrated** | **bool** | Indicates if the sales invoice was migrated from another system. | [optional]
**invoice_lines** | [**\SageOne\Model\PostSalesCreditNotesSalesCreditNoteCreditNoteLinesInner[]**](PostSalesCreditNotesSalesCreditNoteCreditNoteLinesInner.md) |  |
**transaction** | [**\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceTransaction**](PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceTransaction.md) |  | [optional]
**links** | [**\SageOne\Model\PostContactsContactLinksInner[]**](PostContactsContactLinksInner.md) |  | [optional]
**main_address** | [**\SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress**](PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress.md) |  | [optional]
**delivery_address** | [**\SageOne\Model\PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress**](PostSalesCorrectiveInvoicesSalesCorrectiveInvoiceMainAddress.md) |  | [optional]
**shipping_tax_breakdown** | [**\SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]**](PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner.md) |  | [optional]
**base_currency_shipping_tax_breakdown** | [**\SageOne\Model\PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner[]**](PostPurchaseQuickEntriesPurchaseQuickEntryTaxBreakdownInner.md) |  | [optional]
**tax_analysis** | [**\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceTaxAnalysisInner[]**](PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceTaxAnalysisInner.md) |  | [optional]
**detailed_tax_analysis** | [**\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceDetailedTaxAnalysis**](PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceDetailedTaxAnalysis.md) |  | [optional]
**payments_allocations** | [**\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoicePaymentsAllocations**](PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoicePaymentsAllocations.md) |  | [optional]
**original_quote_estimate** | [**\SageOne\Model\PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceOriginalInvoiceIdInner[]**](PostPurchaseCorrectiveInvoicesPurchaseCorrectiveInvoiceOriginalInvoiceIdInner.md) |  | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
