# SageOne\UnallocatedArtefactsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getUnallocatedArtefacts()**](UnallocatedArtefactsApi.md#getUnallocatedArtefacts) | **GET** /unallocated_artefacts | Returns all Unallocated Artefacts
[**getUnallocatedArtefactsKey()**](UnallocatedArtefactsApi.md#getUnallocatedArtefactsKey) | **GET** /unallocated_artefacts/{key} | Returns a Unallocated Artefact


## `getUnallocatedArtefacts()`

```php
getUnallocatedArtefacts($contact_id, $search, $attributes, $items_per_page, $page, $show_legacy_id): \SageOne\Model\UnallocatedArtefact[]
```

Returns all Unallocated Artefacts

Returns all Unallocated Artefacts

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\UnallocatedArtefactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$contact_id = 'contact_id_example'; // string | Use this to filter by contact id
$search = 'search_example'; // string | Use this to filter by the contact identifier.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Base Artefacts (expose all attributes with 'all'). These are in addition to the base attributes (name, path)
$items_per_page = 20; // int | Returns the given number of Base Artefacts per request.
$page = 1; // int | Go to specific page of Base Artefacts
$show_legacy_id = True; // bool | Display the legacy_id for the Base Artefacts.

try {
    $result = $apiInstance->getUnallocatedArtefacts($contact_id, $search, $attributes, $items_per_page, $page, $show_legacy_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UnallocatedArtefactsApi->getUnallocatedArtefacts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contact_id** | **string**| Use this to filter by contact id | [optional]
 **search** | **string**| Use this to filter by the contact identifier. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Base Artefacts (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **items_per_page** | **int**| Returns the given number of Base Artefacts per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Base Artefacts | [optional] [default to 1]
 **show_legacy_id** | **bool**| Display the legacy_id for the Base Artefacts. | [optional]

### Return type

[**\SageOne\Model\UnallocatedArtefact[]**](../Model/UnallocatedArtefact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getUnallocatedArtefactsKey()`

```php
getUnallocatedArtefactsKey($key, $show_legacy_id, $attributes): \SageOne\Model\UnallocatedArtefact
```

Returns a Unallocated Artefact

Returns a Unallocated Artefact

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\UnallocatedArtefactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Unallocated Artefact Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Base Artefact.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Base Artefact (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getUnallocatedArtefactsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UnallocatedArtefactsApi->getUnallocatedArtefactsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Unallocated Artefact Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Base Artefact. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Base Artefact (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\UnallocatedArtefact**](../Model/UnallocatedArtefact.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
