# SageOne\TransactionsApi

All URIs are relative to https://api.accounting.sage.com/v3.1.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getTransactions()**](TransactionsApi.md#getTransactions) | **GET** /transactions | Returns all Transactions
[**getTransactionsKey()**](TransactionsApi.md#getTransactionsKey) | **GET** /transactions/{key} | Returns a Transaction


## `getTransactions()`

```php
getTransactions($updated_or_created_since, $from_date, $to_date, $updated_from_date, $updated_to_date, $show_legacy_id, $items_per_page, $page, $attributes, $transaction_type_id): \SageOne\Model\Transaction[]
```

Returns all Transactions

Returns all Transactions

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$updated_or_created_since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to limit the response to Transactions changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp.
$from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Transactions dates
$to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter by Transactions dates
$updated_from_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter Transactions by the date they were last updated
$updated_to_date = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Use this to filter Transactions by the date they were last updated
$show_legacy_id = True; // bool | Display the legacy_id for the Transactions.
$items_per_page = 20; // int | Returns the given number of Transactions per request.
$page = 1; // int | Go to specific page of Transactions
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Transactions (expose all attributes with 'all'). These are in addition to the base attributes (name, path)
$transaction_type_id = 'transaction_type_id_example'; // string | Use this to filter by transaction type id

try {
    $result = $apiInstance->getTransactions($updated_or_created_since, $from_date, $to_date, $updated_from_date, $updated_to_date, $show_legacy_id, $items_per_page, $page, $attributes, $transaction_type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->getTransactions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **updated_or_created_since** | **\DateTime**| Use this to limit the response to Transactions changed since a given date (format: YYYY-MM-DDT(+|-)hh:mm) or date-time (format: YYYY-MM-DDThh:mm:ss(+|-)hh:mm). Inclusive of the passed timestamp. | [optional]
 **from_date** | **\DateTime**| Use this to filter by Transactions dates | [optional]
 **to_date** | **\DateTime**| Use this to filter by Transactions dates | [optional]
 **updated_from_date** | **\DateTime**| Use this to filter Transactions by the date they were last updated | [optional]
 **updated_to_date** | **\DateTime**| Use this to filter Transactions by the date they were last updated | [optional]
 **show_legacy_id** | **bool**| Display the legacy_id for the Transactions. | [optional]
 **items_per_page** | **int**| Returns the given number of Transactions per request. | [optional] [default to 20]
 **page** | **int**| Go to specific page of Transactions | [optional] [default to 1]
 **attributes** | **string**| Specify the attributes that you want to expose for the Transactions (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]
 **transaction_type_id** | **string**| Use this to filter by transaction type id | [optional]

### Return type

[**\SageOne\Model\Transaction[]**](../Model/Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTransactionsKey()`

```php
getTransactionsKey($key, $show_legacy_id, $attributes): \SageOne\Model\Transaction
```

Returns a Transaction

Returns a Transaction

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new SageOne\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$key = 'key_example'; // string | The Transaction Key.
$show_legacy_id = True; // bool | Display the legacy_id for the Transaction.
$attributes = 'attributes_example'; // string | Specify the attributes that you want to expose for the Transaction (expose all attributes with 'all'). These are in addition to the base attributes (name, path)

try {
    $result = $apiInstance->getTransactionsKey($key, $show_legacy_id, $attributes);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->getTransactionsKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **key** | **string**| The Transaction Key. |
 **show_legacy_id** | **bool**| Display the legacy_id for the Transaction. | [optional]
 **attributes** | **string**| Specify the attributes that you want to expose for the Transaction (expose all attributes with &#39;all&#39;). These are in addition to the base attributes (name, path) | [optional]

### Return type

[**\SageOne\Model\Transaction**](../Model/Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
